//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2004 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC TrueKey ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#if !defined(mfc_tkey_h)
#define mfc_tkey_h

#include "fileio.h"
#include "mfc_que.h"

//===========================================================================
//
//	TrueKey
//
//===========================================================================
class CTKey : public CComponent
{
public:
	// {t@NV
	CTKey(CFrmWnd *pWnd);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL ApplyCfg(const Config *pConfig);
										// ݒKp

	// OAPI
	void FASTCALL Run();
										// Xbhs
	void FASTCALL GetTxQueue(CQueue::LPQUEUEINFO lpqi) const;
										// ML[擾
	void FASTCALL GetRxQueue(CQueue::LPQUEUEINFO lpqi) const;
										// ML[擾

	// L[}bv
	void FASTCALL GetKeyMap(int *pMap);
										// L[}bv擾
	void FASTCALL SetKeyMap(const int *pMap);
										// L[}bvݒ
	LPCTSTR FASTCALL GetKeyID(int nVK);
										// VKL[ID擾

private:
	typedef struct _VKEYID {
		int nVK;						// zL[R[h
		LPCSTR lpszID;					// zL[
	} VKEYID, *PVKEYID;
	enum {
		KeyMax = 0x73					// L[(1<=nKey<=KeyMax)
	};

	BOOL FASTCALL Open();
										// |[gI[v
	void FASTCALL Close();
										// |[gN[Y
	void FASTCALL Ctrl(BOOL bForce);
										// RTS
	void FASTCALL Rx();
										// M
	void FASTCALL Tx();
										// M
	void FASTCALL BufSync();
										// obt@

	// p[^
	int m_nMode;
										// [h(bit0:VM bit1:Win32)
	int m_nCOM;
										// |[gԍ(0ŎgpȂ)
	BOOL m_bRTS;
										// RTS_(M)
	BOOL m_bLine;
										// RTSC

	// nhEXbh
	HANDLE m_hCOM;
										// t@Cnh
	CWinThread *m_pCOM;
										// Xbh
	BOOL m_bReq;
										// XbhIv

	// M
	CQueue m_TxQueue;
										// ML[
	OVERLAPPED m_TxOver;
										// I[o[bv
	BOOL m_bTxValid;
										// MLtO
	BYTE m_TxBuf[0x1000];
										// MI[o[bvobt@

	// M
	CQueue m_RxQueue;
										// ML[
	OVERLAPPED m_RxOver;
										// I[o[bv
	BYTE m_RxBuf[0x1000];
										// MI[o[bvobt@

	// L[}bv
	BOOL m_bKey[KeyMax];
										// L[tO
	BOOL m_bWin[KeyMax];
										// WindowsL[tO
	int m_nKey[KeyMax];
										// L[ϊe[u
	static const int KeyTable[KeyMax];
										// L[ϊe[u(ftHg)
	static const VKEYID KeyIDTable[];
										// VKL[IDe[u

	// IuWFNg
	MFP *m_pMFP;
										// MFP
	Keyboard *m_pKeyboard;
										// L[{[h
	CScheduler *m_pSch;
										// XPW[
};

#endif	// mfc_tkey_h
#endif	// _WIN32
