//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC ⏕c[ ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "fdi.h"
#include "fileio.h"
#include "mfc_frm.h"
#include "mfc_com.h"
#include "mfc_sch.h"
#include "mfc_tool.h"
#include "mfc_res.h"

//===========================================================================
//
//	tbs[fBXNC[W쐬_CAO
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CFDIDlg::CFDIDlg(CWnd *pParent) : CDialog(IDD_FDIDLG, pParent)
{
	// pւ̑Ή
	if (!::IsJapanese()) {
		m_lpszTemplateName = MAKEINTRESOURCE(IDD_US_FDIDLG);
		m_nIDHelp = IDD_US_FDIDLG;
	}

	// _CAOf[^
	m_szFileName[0] = _T('\0');
	m_szDiskName[0] = _T('\0');
	m_dwPhysical = FDI_2HD;
	m_bLogical = TRUE;
	m_nDrive = -1;
}

//---------------------------------------------------------------------------
//
//	bZ[W }bv
//
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CFDIDlg, CDialog)
	ON_BN_CLICKED(IDC_FDI_FILEB, OnBrowse)
	ON_BN_CLICKED(IDC_FDI_2HD, OnPhysical)
	ON_BN_CLICKED(IDC_FDI_2HDA, OnPhysical)
	ON_BN_CLICKED(IDC_FDI_2HS, OnPhysical)
	ON_BN_CLICKED(IDC_FDI_2HC, OnPhysical)
	ON_BN_CLICKED(IDC_FDI_2HDE, OnPhysical)
	ON_BN_CLICKED(IDC_FDI_2HQ, OnPhysical)
	ON_BN_CLICKED(IDC_FDI_2DD, OnPhysical)
	ON_BN_CLICKED(IDC_FDI_OS9, OnPhysical)
END_MESSAGE_MAP()

//---------------------------------------------------------------------------
//
//	_CAO
//
//---------------------------------------------------------------------------
BOOL CFDIDlg::OnInitDialog()
{
	CButton *pButton;
	CEdit *pEdit;

	// {NX
	CDialog::OnInitDialog();

	// t@C𕷂
	if (!GetFile()) {
		EndDialog(IDCANCEL);
		return FALSE;
	}

	// fBXN
	pEdit = (CEdit*)GetDlgItem(IDC_FDI_NAMEE);
	ASSERT(pEdit);
	if (m_dwType == 2) {
		// ŏ̃t@CID68I΂ꂽꍇ̂
		_tcscpy(m_szDiskName, _T("Default"));
	}
	pEdit->SetWindowText(m_szDiskName);
	MaskName();

	// tH[}bg
	SetPhysical();
	MaskPhysical();

	// _tH[}bg
	SetLogical();
	MaskLogical();

	// }Eg
	switch (m_nDrive) {
		// hCu0
		case 0:
			pButton = (CButton*)GetDlgItem(IDC_FDI_DRIVE0);
			break;

		// hCu1
		case 1:
			pButton = (CButton*)GetDlgItem(IDC_FDI_DRIVE1);
			break;

		// }EgȂ
		default:
			pButton = (CButton*)GetDlgItem(IDC_FDI_NOTMOUNT);
			break;
	}
	ASSERT(pButton);
	pButton->SetCheck(1);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	_CAOOK
//
//---------------------------------------------------------------------------
void CFDIDlg::OnOK()
{
	CButton *pButton;
	CEdit *pEdit;

	// fBXN
	pEdit = (CEdit*)GetDlgItem(IDC_FDI_NAMEE);
	ASSERT(pEdit);
	pEdit->GetWindowText(m_szDiskName, sizeof(m_szDiskName));
	if (m_dwType == 2) {
		// D8816܂
		m_szDiskName[16] = _T('\0');
	}
	else {
		// DIM59܂
		m_szDiskName[59] = _T('\0');
	}

	// f[^擾
	GetPhysical();
	GetLogical();

	// }Eg
	m_nDrive = -1;
	pButton = (CButton*)GetDlgItem(IDC_FDI_DRIVE0);
	ASSERT(pButton);
	if (pButton->GetCheck() == 1) {
		m_nDrive = 0;
	}
	pButton = (CButton*)GetDlgItem(IDC_FDI_DRIVE1);
	ASSERT(pButton);
	if (pButton->GetCheck() == 1) {
		m_nDrive = 1;
	}

	// {NX
	CDialog::OnOK();
}

//---------------------------------------------------------------------------
//
//	_CAOLZ
//
//---------------------------------------------------------------------------
void CFDIDlg::OnCancel()
{
	// {NX
	CDialog::OnCancel();
}

//---------------------------------------------------------------------------
//
//	t@CI
//
//---------------------------------------------------------------------------
void CFDIDlg::OnBrowse()
{
	// Tu֐ɔC
	if (!GetFile()) {
		return;
	}

	// UIݒ
	MaskName();
	SetPhysical();
	MaskPhysical();
	SetLogical();
	MaskLogical();
}

//---------------------------------------------------------------------------
//
//	fBXN}XN
//
//---------------------------------------------------------------------------
void FASTCALL CFDIDlg::MaskName()
{
	CEdit *pEdit;
	CStatic *pStatic;
	CString strStatic;

	// X^eBbNeLXg擾
	pStatic = (CStatic*)GetDlgItem(IDC_FDI_NAMEL);
	ASSERT(pStatic);

	// GfBbg{bNX擾
	pEdit = (CEdit*)GetDlgItem(IDC_FDI_NAMEE);
	ASSERT(pEdit);

	// D68(D88)DIM̂݋
	switch (m_dwType) {
		// 2HD,2DD,2HQ
		case 0:
		case 3:
		case 4:
			pEdit->EnableWindow(FALSE);
			break;

		// DIM
		case 1:
			::GetMsg(IDS_FDI_COMMENT, strStatic);
			pStatic->SetWindowText(strStatic);
			pEdit->EnableWindow(TRUE);
			break;

		// D68
		case 2:
			::GetMsg(IDS_FDI_DISKNAME, strStatic);
			pStatic->SetWindowText(strStatic);
			pEdit->EnableWindow(TRUE);
			break;

		// ̑(蓾Ȃ)
		default:
			ASSERT(FALSE);
			break;
	}
}

//---------------------------------------------------------------------------
//
//	tH[}bgNbN
//
//---------------------------------------------------------------------------
void CFDIDlg::OnPhysical()
{
	// _tH[}bg`FbN{bNX̏ԂA^Cɕς
	MaskLogical();
}

//---------------------------------------------------------------------------
//
//	tH[}bgݒ
//
//---------------------------------------------------------------------------
void FASTCALL CFDIDlg::SetPhysical()
{
	int i;
	CButton *pButton;

	// ^CvɂAtH[}bg𐧌
	switch (m_dwType) {
		// 2HD
		case 0:
			// 2HD̂
			m_dwPhysical = FDI_2HD;
			break;

		// 2DD
		case 3:
			// 2DD̂
			m_dwPhysical = FDI_2DD;
			break;

		// 2HQ
		case 4:
			// 2HQ̂
			m_dwPhysical = FDI_2HQ;
			break;
	}

	// ^CvɂAtH[}bg𐧌(DIM)
	if (m_dwType == 1) {
		// DIMC[WOS-9,2DDȊO
		if (m_dwPhysical == FDI_OS9) {
			m_dwPhysical = FDI_2HD;
		}
		if (m_dwPhysical == FDI_2DD) {
			m_dwPhysical = FDI_2HD;
		}
	}

	// tH[}bgɑΉ{^ID擾
	for (i=0; i<8; i++) {
		// tH[}bgvĂ邩
		if (IDTable[i * 2 + 0] == m_dwPhysical) {
			// ̃{^`FbN
			pButton = (CButton*)GetDlgItem(IDTable[i * 2 + 1]);
			ASSERT(pButton);
			pButton->SetCheck(1);
			break;
		}
	}
}

//---------------------------------------------------------------------------
//
//	tH[}bg擾
//
//---------------------------------------------------------------------------
void FASTCALL CFDIDlg::GetPhysical()
{
	int i;
	CButton *pButton;

	for (i=0; i<8; i++) {
		// {^擾
		pButton = (CButton*)GetDlgItem(IDTable[i * 2 + 1]);
		ASSERT(pButton);

		// `FbNĂΒlݒ肵ďI
		if (pButton->GetCheck() == 1) {
			m_dwPhysical = IDTable[i * 2 + 0];
			break;
		}
	}
}

//---------------------------------------------------------------------------
//
//	tH[}bg}XN
//
//---------------------------------------------------------------------------
void FASTCALL CFDIDlg::MaskPhysical()
{
	int i;
	CButton *pButton;

	// WI{^[v
	for (i=0; i<8; i++) {
		// {^擾
		pButton = (CButton*)GetDlgItem(IDTable[i * 2 + 1]);
		ASSERT(pButton);

		// ^Cv
		switch (m_dwType) {
			// 2HD
			case 0:
				// i=0(2HD)̂݋Ȃ֎~
				if (i == 0) {
					pButton->EnableWindow(TRUE);
				}
				else {
					pButton->SetCheck(0);
					pButton->EnableWindow(FALSE);
				}
				break;

			// DIM
			case 1:
				// i=6,7(2DD,OS-9)̂݋֎~Ȃ
				if (i < 6) {
					pButton->EnableWindow(TRUE);
				}
				else {
					pButton->SetCheck(0);
					pButton->EnableWindow(FALSE);
				}
				break;

			// D68
			case 2:
				// ׂċ
				pButton->EnableWindow(TRUE);
				break;

			// 2DD
			case 3:
				// i=6(2DD)̂݋Ȃ֎~
				if (i == 6) {
					pButton->EnableWindow(TRUE);
				}
				else {
					pButton->SetCheck(0);
					pButton->EnableWindow(FALSE);
				}
				break;

			// 2HQ
			case 4:
				// i=5(2HQ)̂݋Ȃ֎~
				if (i == 5) {
					pButton->EnableWindow(TRUE);
				}
				else {
					pButton->SetCheck(0);
					pButton->EnableWindow(FALSE);
				}
				break;

			// ̑(肦Ȃ)
			default:
				ASSERT(FALSE);
				break;
		}
	}
}

//---------------------------------------------------------------------------
//
//	tH[}bge[u
//
//---------------------------------------------------------------------------
const DWORD CFDIDlg::IDTable[] = {
	FDI_2HD,
	IDC_FDI_2HD,
	FDI_2HDA,
	IDC_FDI_2HDA,
	FDI_2HS,
	IDC_FDI_2HS,
	FDI_2HC,
	IDC_FDI_2HC,
	FDI_2HDE,
	IDC_FDI_2HDE,
	FDI_2HQ,
	IDC_FDI_2HQ,
	FDI_2DD,
	IDC_FDI_2DD,
	FDI_OS9,
	IDC_FDI_OS9,
};

//---------------------------------------------------------------------------
//
//	_tH[}bgݒ
//
//---------------------------------------------------------------------------
void FASTCALL CFDIDlg::SetLogical()
{
	CButton *pButton;

	// MS-DOSn̕tH[}bĝݘ_tH[}bg\
	switch (m_dwPhysical) {
		// _tH[}bgłȂ
		case FDI_OS9:
			m_bLogical = FALSE;
			break;

		// _tH[}bgł
		default:
			break;
	}

	// ݒ
	pButton = (CButton*)GetDlgItem(IDC_FDI_LOGC);
	ASSERT(pButton);
	if (m_bLogical) {
		pButton->SetCheck(1);
	}
	else {
		pButton->SetCheck(0);
	}
}

//---------------------------------------------------------------------------
//
//	_tH[}bg擾
//
//---------------------------------------------------------------------------
void FASTCALL CFDIDlg::GetLogical()
{
	CButton *pButton;

	// 擾
	pButton = (CButton*)GetDlgItem(IDC_FDI_LOGC);
	ASSERT(pButton);
	if (pButton->GetCheck() == 1) {
		m_bLogical = TRUE;
	}
	else {
		m_bLogical = FALSE;
	}
}

//---------------------------------------------------------------------------
//
//	_tH[}bg}XN
//
//---------------------------------------------------------------------------
void FASTCALL CFDIDlg::MaskLogical()
{
	BOOL bEnable;
	CButton *pButton;

	// _tH[}bg
	bEnable = TRUE;

	// OS-9͘_tH[}bgłȂ
	pButton = (CButton*)GetDlgItem(IDC_FDI_OS9);
	ASSERT(pButton);
	if (pButton->GetCheck() == 1) {
		bEnable = FALSE;
	}

	// _tH[}bg`FbN{bNX擾
	pButton = (CButton*)GetDlgItem(IDC_FDI_LOGC);
	ASSERT(pButton);

	// \tO`FbN
	if (bEnable) {
		// {^L
		pButton->EnableWindow(TRUE);
	}
	else {
		// _tH[}bgȂ
		m_bLogical = FALSE;

		// `FbNāA{^
		pButton->SetCheck(0);
		pButton->EnableWindow(FALSE);
	}
}

//---------------------------------------------------------------------------
//
//	t@CI
//
//---------------------------------------------------------------------------
BOOL FASTCALL CFDIDlg::GetFile()
{
	TCHAR szDrive[_MAX_DRIVE];
	TCHAR szDir[_MAX_DIR];
	TCHAR szFile[_MAX_FNAME];
	TCHAR szExt[_MAX_EXT];
	CEdit *pEdit;

	// 
	m_szFileName[0] = _T('\0');

	// t@CZ[u_CAO
	if (!::FileSaveDlg(this, m_szFileName, NULL, IDS_FDOPEN)) {
		return FALSE;
	}

	// t@Cݒ
	pEdit = (CEdit*)GetDlgItem(IDC_FDI_FILEE);
	ASSERT(pEdit);
	pEdit->SetWindowText(m_szFileName);

	// pX
	_tsplitpath(m_szFileName, szDrive, szDir, szFile, szExt);

	// gq^Cv
	if (_tcsnicmp(szExt, _T(".DIM"), 4) == 0) {
		m_dwType = 1;
		return TRUE;
	}
	if (_tcsnicmp(szExt, _T(".D68"), 4) == 0) {
		m_dwType = 2;
		return TRUE;
	}
	if (_tcsnicmp(szExt, _T(".D88"), 4) == 0) {
		m_dwType = 2;
		return TRUE;
	}
	if (_tcsnicmp(szExt, _T(".2DD"), 4) == 0) {
		m_dwType = 3;
		return TRUE;
	}
	if (_tcsnicmp(szExt, _T(".2HQ"), 4) == 0) {
		m_dwType = 4;
		return TRUE;
	}

	// łȂ΁A2HD
	m_dwType = 0;
	return TRUE;
}

//===========================================================================
//
//	eʃfBXNC[W쐬_CAO
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CDiskDlg::CDiskDlg(CWnd *pParent) : CDialog(IDD_DISKDLG, pParent)
{
	// pւ̑Ή
	if (!::IsJapanese()) {
		m_lpszTemplateName = MAKEINTRESOURCE(IDD_US_DISKDLG);
		m_nIDHelp = IDD_US_DISKDLG;
	}

	// [N
	m_szPath[0] = _T('\0');
	m_nType = -1;
	m_bSucceed = FALSE;
	m_bCancel = FALSE;
	m_nSize = 0;
	m_nFormat = 0;
	m_bMount = FALSE;
}

//---------------------------------------------------------------------------
//
//	bZ[W }bv
//
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CDiskDlg, CDialog)
	ON_BN_CLICKED(IDC_DISK_FILEB, OnBrowse)
	ON_BN_CLICKED(IDC_DISK_SIZE128, OnMOSize)
	ON_BN_CLICKED(IDC_DISK_SIZE230, OnMOSize)
	ON_BN_CLICKED(IDC_DISK_SIZE540, OnMOSize)
	ON_BN_CLICKED(IDC_DISK_SIZE640, OnMOSize)
	ON_WM_VSCROLL()
END_MESSAGE_MAP()

//---------------------------------------------------------------------------
//
//	_CAO
//
//---------------------------------------------------------------------------
BOOL CDiskDlg::OnInitDialog()
{
	CString strCap;
	CString strText;

	ASSERT(this);
	ASSERT((m_nType >= 0) && (m_nType <= 2));

	// {NX
	CDialog::OnInitDialog();

	// t@C𕷂
	if (!GetFile()) {
		EndDialog(IDCANCEL);
		return FALSE;
	}

	// LvVݒ
	GetWindowText(strCap);
	switch (m_nType) {
		// SASI-HD
		case 0:
			strText = _T("SASI HD");
			break;
		// SCSI-HD
		case 1:
			strText = _T("SCSI HD");
			break;
		// SCSI-MO
		case 2:
			strText = _T("SCSI MO");
			break;
		// ̑(蓾Ȃ)
		default:
			ASSERT(FALSE);
			break;
	}
	strCap = strText + strCap;
	SetWindowText(strCap);

	// Rg[
	switch (m_nType) {
		// SASI-HD
		case 0:
			CtrlSASI();
			break;

		// SCSI-HD
		case 1:
			CtrlSCSI();
			break;

		// SCSI-MO
		case 2:
			CtrlMO();
			break;

		// ̑(蓾Ȃ)
		default:
			ASSERT(FALSE);
			break;
	}

	// I
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	SASI-HD Rg[
//
//---------------------------------------------------------------------------
void FASTCALL CDiskDlg::CtrlSASI()
{
	int i;
	CWnd *pWnd;
	CSpinButtonCtrl *pSpin;
	CButton *pButton;
	CRect rectSrc;
	CRect rectDst;

	ASSERT(this);

	// TCYE_tH[}bgEIvVׂĉB
	for (i=0;; i++) {
		// I`FbN
		if (SASITable[i] == 0) {
			break;
		}

		// 擾
		pWnd = GetDlgItem(SASITable[i]);
		ASSERT(pWnd);

		// B
		pWnd->ShowWindow(SW_HIDE);
	}

	// _tH[}bg`FbN{bNXړA`FbNt
	pWnd = GetDlgItem(IDC_DISK_SIZEE);
	ASSERT(pWnd);
	pWnd->GetWindowRect(&rectDst);
	ScreenToClient(&rectDst);
	pWnd = GetDlgItem(IDC_DISK_LOGC);
	ASSERT(pWnd);
	pWnd->GetWindowRect(&rectSrc);
	ScreenToClient(&rectSrc);
	pWnd->SetWindowPos(&wndTop, rectDst.left, rectSrc.top,
								 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	pButton = (CButton*)pWnd;
	pButton->SetCheck(1);

	// _tH[}bgO[v{bNXk
	pWnd = GetDlgItem(IDC_DISK_SIZEG);
	ASSERT(pWnd);
	pWnd->GetClientRect(&rectDst);
	pWnd = GetDlgItem(IDC_DISK_LOGG);
	ASSERT(pWnd);
	pWnd->GetClientRect(&rectSrc);
	pWnd->SetWindowPos(&wndTop, 0, 0, rectSrc.Width(), rectDst.Height(),
								SWP_NOMOVE | SWP_NOZORDER);

	// TCYXsRg[擾Aݒ(02)
	pSpin = (CSpinButtonCtrl*)GetDlgItem(IDC_DISK_SIZES);
	ASSERT(pSpin);
	pSpin->SetRange(0, 2);
	pSpin->SetPos(2);

	// OnVScroll
	OnVScroll(0, 2, NULL);

	// IDC_DISK_LOGG̃NCAgW擾
	pWnd = GetDlgItem(IDC_DISK_LOGG);
	ASSERT(pWnd);
	pWnd->GetWindowRect(&rectSrc);
	ScreenToClient(&rectSrc);

	// OK{^ړ
	pWnd = GetDlgItem(IDOK);
	ASSERT(pWnd);
	pWnd->GetWindowRect(&rectDst);
	ScreenToClient(&rectDst);
	pWnd->SetWindowPos(&wndTop, rectDst.left, rectSrc.bottom + 10,
						 0, 0, SWP_NOSIZE | SWP_NOZORDER);

	// LZ{^ړ
	pWnd = GetDlgItem(IDCANCEL);
	ASSERT(pWnd);
	pWnd->GetWindowRect(&rectDst);
	ScreenToClient(&rectDst);
	pWnd->SetWindowPos(&wndTop, rectDst.left, rectSrc.bottom + 10,
						0, 0, SWP_NOSIZE | SWP_NOZORDER);

	// ANCAgW擾
	pWnd->GetWindowRect(&rectDst);
	ScreenToClient(&rectDst);

	// EBhES
	GetClientRect(&rectSrc);
	rectSrc.bottom = rectSrc.top + rectDst.bottom + 10;
	AdjustWindowRect(&rectSrc, GetStyle(), FALSE);
	SetWindowPos(&wndTop, 0, 0, rectSrc.Width(), rectSrc.Height(), SWP_NOMOVE);
}

//---------------------------------------------------------------------------
//
//	SCSI-HD Rg[
//
//---------------------------------------------------------------------------
void FASTCALL CDiskDlg::CtrlSCSI()
{
	int i;
	CWnd *pWnd;
	CSpinButtonCtrl *pSpin;
	CRect rectSrc;
	CRect rectDst;

	ASSERT(this);

	// TCYE_tH[}bgEIvVׂĉB
	for (i=0;; i++) {
		// I`FbN
		if (SCSITable[i] == 0) {
			break;
		}

		// 擾
		pWnd = GetDlgItem(SCSITable[i]);
		ASSERT(pWnd);

		// B
		pWnd->ShowWindow(SW_HIDE);
	}

	// TCYXsRg[擾Aݒ(10MB4095MB)
	pSpin = (CSpinButtonCtrl*)GetDlgItem(IDC_DISK_SIZES);
	ASSERT(pSpin);
	pSpin->SetRange(10, 4095);
	pSpin->SetPos(100);

	// OnVScroll
	OnVScroll(0, 100, NULL);

	// IDC_DISK_SIZEG̃NCAgW擾
	pWnd = GetDlgItem(IDC_DISK_SIZEG);
	ASSERT(pWnd);
	pWnd->GetWindowRect(&rectSrc);
	ScreenToClient(&rectSrc);

	// OK{^ړ
	pWnd = GetDlgItem(IDOK);
	ASSERT(pWnd);
	pWnd->GetWindowRect(&rectDst);
	ScreenToClient(&rectDst);
	pWnd->SetWindowPos(&wndTop, rectDst.left, rectSrc.bottom + 10,
						 0, 0, SWP_NOSIZE | SWP_NOZORDER);

	// LZ{^ړ
	pWnd = GetDlgItem(IDCANCEL);
	ASSERT(pWnd);
	pWnd->GetWindowRect(&rectDst);
	ScreenToClient(&rectDst);
	pWnd->SetWindowPos(&wndTop, rectDst.left, rectSrc.bottom + 10,
						0, 0, SWP_NOSIZE | SWP_NOZORDER);

	// ANCAgW擾
	pWnd->GetWindowRect(&rectDst);
	ScreenToClient(&rectDst);

	// EBhES
	GetClientRect(&rectSrc);
	rectSrc.bottom = rectSrc.top + rectDst.bottom + 10;
	AdjustWindowRect(&rectSrc, GetStyle(), FALSE);
	SetWindowPos(&wndTop, 0, 0, rectSrc.Width(), rectSrc.Height(), SWP_NOMOVE);
}

//---------------------------------------------------------------------------
//
//	SCSI-MO Rg[
//
//---------------------------------------------------------------------------
void FASTCALL CDiskDlg::CtrlMO()
{
	int i;
	CWnd *pWnd;
	CButton *pButton;

	ASSERT(this);

	// svȃRg[B
	for (i=0;; i++) {
		// I`FbN
		if (MOTable[i] == 0) {
			break;
		}

		// 擾
		pWnd = GetDlgItem(MOTable[i]);
		ASSERT(pWnd);

		// B
		pWnd->ShowWindow(SW_HIDE);
	}

	// 128MBEIBMtH[}bgɃ`FbN
	pButton = (CButton*)GetDlgItem(IDC_DISK_SIZE128);
	ASSERT(pButton);
	pButton->SetCheck(1);
	pButton = (CButton*)GetDlgItem(IDC_DISK_LOGI);
	ASSERT(pButton);
	pButton->SetCheck(1);
}

//---------------------------------------------------------------------------
//
//	t@CI
//
//---------------------------------------------------------------------------
void CDiskDlg::OnBrowse()
{
	// Tu֐ɔC
	GetFile();
}

//---------------------------------------------------------------------------
//
//	cXN[
//
//---------------------------------------------------------------------------
void CDiskDlg::OnVScroll(UINT /*nSBCode*/, UINT nPos, CScrollBar* /*pBar*/)
{
	UINT nSize;
	CString strText;
	CWnd *pWnd;

	// 
	ASSERT((nPos >= 0) && (nPos < 4096));
	nSize = nPos;

	// SASI-HD͓ʏ
	if (m_nType == 0) {
		switch (nPos) {
			// 10MB
			case 0:
				nSize = 10;
				break;

			// 20MB
			case 1:
				nSize = 20;
				break;

			// 40MB
			case 2:
				nSize = 40;
				break;

			// ̑(蓾Ȃ)
			default:
				ASSERT(FALSE);
				break;
		}
	}

	// eLXg쐬
	strText.Format(_T("%u"), nSize);

	// ofBEBhE֐ݒ
	pWnd = GetDlgItem(IDC_DISK_SIZEE);
	ASSERT(pWnd);
	pWnd->SetWindowText(strText);
}

//---------------------------------------------------------------------------
//
//	MOTCYύX
//	128MB,230MB,540MBIBMtH[}bgSHARPtH[}bgIׂ邪
//	  640MBIBMtH[}bĝݑI\
//
//---------------------------------------------------------------------------
void CDiskDlg::OnMOSize()
{
	BOOL bCheck;
	CButton *pButton;

	// `FbNȂ
	bCheck = FALSE;

	// 640MOWI{^
	pButton = (CButton*)GetDlgItem(IDC_DISK_SIZE640);
	ASSERT(pButton);

	// `FbNĂ邩
	if (pButton->GetCheck() != 0) {
		// SHARPtH[}bg֎~A`FbNĂ΃tH[}bg
		pButton = (CButton*)GetDlgItem(IDC_DISK_LOGS);
		ASSERT(pButton);
		if (pButton->GetCheck() != 0) {
			bCheck = TRUE;
			pButton->SetCheck(0);
		}
		pButton->EnableWindow(FALSE);

		// `FbNĂ΋ύX
		if (bCheck) {
			pButton = (CButton*)GetDlgItem(IDC_DISK_LOGN);
			ASSERT(pButton);
			pButton->SetCheck(1);
		}
	}
	else {
		// 640MOȊOȂ̂ŁASHARPtH[}bg
		pButton = (CButton*)GetDlgItem(IDC_DISK_LOGS);
		ASSERT(pButton);
		pButton->EnableWindow(TRUE);
	}
}

//---------------------------------------------------------------------------
//
//	t@CI
//
//---------------------------------------------------------------------------
BOOL FASTCALL CDiskDlg::GetFile()
{
	BOOL bFlag;
	CEdit *pEdit;

	ASSERT(this);

	// 
	m_szPath[0] = _T('\0');

	// ^Cv
	switch (m_nType) {
		// SASI n[hfBXN
		case 0:
			bFlag = ::FileSaveDlg(this, m_szPath, _T("hdf"), IDS_SASIOPEN);
			break;

		// SCSI n[hfBXN
		case 1:
			bFlag = ::FileSaveDlg(this, m_szPath, _T("hds"), IDS_SCSIOPEN);
			break;

		// SCSI MOfBXN
		case 2:
			bFlag = ::FileSaveDlg(this, m_szPath, _T("mos"), IDS_MOOPEN);
			break;

		// ̑(蓾Ȃ)
		default:
			ASSERT(FALSE);
			bFlag = FALSE;
			break;
	}

	// ʕ]
	if (!bFlag) {
		return FALSE;
	}

	// t@Cݒ
	pEdit = (CEdit*)GetDlgItem(IDC_DISK_FILEE);
	ASSERT(pEdit);
	pEdit->SetWindowText(m_szPath);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	OK
//
//---------------------------------------------------------------------------
void CDiskDlg::OnOK()
{
	Fileio fio;
	CFrmWnd *pFrmWnd;

	// t@CȂΏI
	if (_tcslen(m_szPath) == 0) {
		// {NX
		CDialog::OnOK();
		return;
	}

	// t@C쐬݂
	if (!fio.Open(m_szPath, Fileio::WriteOnly)) {
		// {NX
		CDialog::OnOK();
		return;
	}
	// U
	fio.Close();

	// VM~߂(ԋLэĊJ̓R}hnhōsȂ)
	pFrmWnd = (CFrmWnd*)GetParent();
	pFrmWnd->GetScheduler()->Enable(FALSE);

	// U蕪
	switch (m_nType) {
		// SASI-HD
		case 0:
			CreateSASI();
			break;

		// SCSI-HD
		case 1:
			CreateSCSI();
			break;

		// SCSI-MO
		case 2:
			CreateMO();
			break;

		// ̑(蓾Ȃ)
		default:
			CDialog::OnOK();
			return;
	}

	// {NX
	CDialog::OnOK();
}

//---------------------------------------------------------------------------
//
//	SASI-HD 쐬
//
//---------------------------------------------------------------------------
void FASTCALL CDiskDlg::CreateSASI()
{
	CSASIMakeDlg dlg(this);
	CSpinButtonCtrl *pSpin;
	CButton *pButton;

	ASSERT(this);

	// t@Cݒ
	_tcscpy(dlg.m_szPath, m_szPath);

	// TCYݒ
	pSpin = (CSpinButtonCtrl*)GetDlgItem(IDC_DISK_SIZES);
	switch (LOWORD(pSpin->GetPos())) {
		// 10MB
		case 0:
			dlg.m_dwSize = 0x9f5400;
			break;

		// 20MB
		case 1:
			dlg.m_dwSize = 0x13c9800;
			break;

		// 40MB
		case 2:
			dlg.m_dwSize = 0x2793000;
			break;

		// ̑(蓾Ȃ)
		default:
			ASSERT(FALSE);
			return;
	}

	// _tH[}bgݒ
	pButton = (CButton*)GetDlgItem(IDC_DISK_LOGC);
	ASSERT(pButton);
	if (pButton->GetCheck() == 1) {
		dlg.m_nFormat = 1;
	}
	else {
		dlg.m_nFormat = 0;
	}

	// s
	dlg.DoModal();

	// ʎ擾
	m_bSucceed = dlg.IsSucceeded();
	m_bCancel = dlg.IsCanceled();
}

//---------------------------------------------------------------------------
//
//	SCSI-HD 쐬
//
//---------------------------------------------------------------------------
void FASTCALL CDiskDlg::CreateSCSI()
{
	CSCSIMakeDlg dlg(this);
	CSpinButtonCtrl *pSpin;
	CString strWarn;
	DWORD dwSize;

	ASSERT(this);

	// p[^n
	_tcscpy(dlg.m_szPath, m_szPath);
	pSpin = (CSpinButtonCtrl*)GetDlgItem(IDC_DISK_SIZES);
	ASSERT(pSpin);
	dwSize = (DWORD)(LOWORD(pSpin->GetPos()));
	dwSize <<= 20;
	dlg.m_dwSize = dwSize;

	// dwSize1017ȏȂxbZ[W
	if (dwSize >= 0x3f900000) {
		::GetMsg(IDS_SCHDSIZE, strWarn);
		MessageBox(strWarn, NULL, MB_ICONINFORMATION | MB_OK);
	}

	// s
	dlg.DoModal();

	// ʎ擾
	m_bSucceed = dlg.IsSucceeded();
	m_bCancel = dlg.IsCanceled();
}

//---------------------------------------------------------------------------
//
//	SCSI-MO 쐬
//
//---------------------------------------------------------------------------
void FASTCALL CDiskDlg::CreateMO()
{
	CMOMakeDlg dlg(this);
	CButton *pButton;

	ASSERT(this);

	// }EgIvV擾
	pButton = (CButton*)GetDlgItem(IDC_DISK_MOUNTB);
	ASSERT(pButton);
	m_bMount = (BOOL)pButton->GetCheck();

	// p[^n(pX)
	_tcscpy(dlg.m_szPath, m_szPath);

	// p[^n(fBATCY)
	pButton = (CButton*)GetDlgItem(IDC_DISK_SIZE128);
	ASSERT(pButton);
	if (pButton->GetCheck() == 1) {
		// 128MB
		dlg.m_dwSize = 0x797f400;
	}
	pButton = (CButton*)GetDlgItem(IDC_DISK_SIZE230);
	ASSERT(pButton);
	if (pButton->GetCheck() == 1) {
		// 230MB
		dlg.m_dwSize = 0xd9eea00;
	}
	pButton = (CButton*)GetDlgItem(IDC_DISK_SIZE540);
	ASSERT(pButton);
	if (pButton->GetCheck() == 1) {
		// 540MB
		dlg.m_dwSize = 0x1fc8b800;
	}
	pButton = (CButton*)GetDlgItem(IDC_DISK_SIZE640);
	ASSERT(pButton);
	if (pButton->GetCheck() == 1) {
		// 640MB
		dlg.m_dwSize = 0x25e28000;
	}
	ASSERT(dlg.m_dwSize > 0);

	// p[^n(_tH[}bg)
	dlg.m_nFormat = 0;
	pButton = (CButton*)GetDlgItem(IDC_DISK_LOGI);
	ASSERT(pButton);
	if (pButton->GetCheck() == 1) {
		// IBMtH[}bg
		dlg.m_nFormat = 1;
	}
	pButton = (CButton*)GetDlgItem(IDC_DISK_LOGS);
	ASSERT(pButton);
	if (pButton->GetCheck() == 1) {
		// SHARPtH[}bg
		dlg.m_nFormat = 2;
	}

	// s
	dlg.DoModal();

	// ʎ擾
	m_bSucceed = dlg.IsSucceeded();
	m_bCancel = dlg.IsCanceled();
}

//---------------------------------------------------------------------------
//
//	SASI-HD IDe[u
//
//---------------------------------------------------------------------------
const UINT CDiskDlg::SASITable[] = {
	IDC_DISK_SIZE128,
	IDC_DISK_SIZE230,
	IDC_DISK_SIZE540,
	IDC_DISK_SIZE640,
	IDC_DISK_LOGI,
	IDC_DISK_LOGS,
	IDC_DISK_LOGN,
	IDC_DISK_OPTG,
	IDC_DISK_MOUNTB,
	0
};

//---------------------------------------------------------------------------
//
//	SCSI-HD IDe[u
//
//---------------------------------------------------------------------------
const UINT CDiskDlg::SCSITable[] = {
	IDC_DISK_SIZE128,
	IDC_DISK_SIZE230,
	IDC_DISK_SIZE540,
	IDC_DISK_SIZE640,
	IDC_DISK_LOGG,
	IDC_DISK_LOGI,
	IDC_DISK_LOGS,
	IDC_DISK_LOGN,
	IDC_DISK_LOGC,
	IDC_DISK_OPTG,
	IDC_DISK_MOUNTB,
	0
};

//---------------------------------------------------------------------------
//
//	SCSI-MO IDe[u
//
//---------------------------------------------------------------------------
const UINT CDiskDlg::MOTable[] = {
	IDC_DISK_SIZEE,
	IDC_DISK_SIZES,
	IDC_DISK_SIZEL,
	IDC_DISK_LOGC,
	0
};

//===========================================================================
//
//	fBXNC[W쐬_CAO
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CDiskMakeDlg::CDiskMakeDlg(CWnd *pParent) : CDialog(IDD_DMAKEDLG, pParent)
{
	// pւ̑Ή
	if (!::IsJapanese()) {
		m_lpszTemplateName = MAKEINTRESOURCE(IDD_US_DMAKEDLG);
		m_nIDHelp = IDD_US_DMAKEDLG;
	}

	// [NNA
	m_szPath[0] = _T('\0');
	m_dwSize = 0;
	m_nFormat = 0;
	m_dwCurrent = 0;
	m_pThread = NULL;
	m_bThread = FALSE;
	m_bSucceed = FALSE;
	m_bCancel = FALSE;
	m_pBuffer = NULL;
	m_nTimerID = NULL;
	m_dwParcent = 0;
}

//---------------------------------------------------------------------------
//
//	bZ[W }bv
//
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CDiskMakeDlg, CDialog)
	ON_WM_DESTROY()
	ON_WM_TIMER()
END_MESSAGE_MAP()

//---------------------------------------------------------------------------
//
//	_CAO
//
//---------------------------------------------------------------------------
BOOL CDiskMakeDlg::OnInitDialog()
{
	CProgressCtrl *pProgress;
	CStatic *pStatic;
	CString strParcent;

	ASSERT(this);
	ASSERT(_tcslen(m_szPath) > 0);
	ASSERT(m_dwSize > 0);

	// {NX
	CDialog::OnInitDialog();

	// Rg[
	pProgress = (CProgressCtrl*)GetDlgItem(IDC_DMAKE_PROGRESS);
	ASSERT(pProgress);
	pProgress->SetRange(0, 100);
	pProgress->SetPos(0);
	pStatic = (CStatic*)GetDlgItem(IDC_DMAKE_STATIC);
	if (m_dwSize & 0xfffff) {
		strParcent.Format(_T("0MB / %d.%1dMB (0%%)"),
							m_dwSize >> 20,
							(m_dwSize & 0xfffff) / 104858);
	}
	else {
		strParcent.Format(_T("0MB / %dMB (0%%)"),
							m_dwSize >> 20);
	}
	pStatic->SetWindowText(strParcent);

	// ƃ[Nm
	try {
		m_pBuffer = new BYTE[ 0x100000 ];
	}
	catch (...) {
		EndDialog(IDOK);
		return FALSE;
	}
	if (!m_pBuffer) {
		EndDialog(IDOK);
		return FALSE;
	}

	// ƃ[NNA
	memset(m_pBuffer, 0, 0x100000);

	// Xbh𗧂Ă
	m_pThread = AfxBeginThread(ThreadFunc, this);
	if (!m_pThread) {
		EndDialog(IDOK);
		return FALSE;
	}

	// ^C}CXg[
	m_nTimerID = SetTimer(IDD_DMAKEDLG, 200, NULL);
	if (!m_nTimerID) {
		EndDialog(IDOK);
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	_CAOOK
//
//---------------------------------------------------------------------------
void CDiskMakeDlg::OnOK()
{
	// [ENTER]ɂI}
}

//---------------------------------------------------------------------------
//
//	_CAOLZ
//
//---------------------------------------------------------------------------
void CDiskMakeDlg::OnCancel()
{
	// LZtOグ
	m_bCancel = TRUE;

	// {NX
	CDialog::OnCancel();
}

//---------------------------------------------------------------------------
//
//	_CAO폜
//
//---------------------------------------------------------------------------
void CDiskMakeDlg::OnDestroy()
{
	// XbhI
	if (m_pThread) {
		// tOグAI҂()
		m_bThread = TRUE;
		::WaitForSingleObject(m_pThread->m_hThread, INFINITE);
		m_pThread = NULL;
	}

	// ^C}I
	if (m_nTimerID) {
		// ^C}폜
		KillTimer(m_nTimerID);
		m_nTimerID = NULL;
	}

	// obt@
	if (m_pBuffer) {
		delete[] m_pBuffer;
		m_pBuffer = NULL;
	}

	// {NX
	CDialog::OnDestroy();
}

//---------------------------------------------------------------------------
//
//	^C}
//
//---------------------------------------------------------------------------
void CDiskMakeDlg::OnTimer(UINT /*nTimerID*/)
{
	CString strParcent;
	DWORD dwCurrent;
	DWORD dwParcent;
	DWORD dwTemp;
	CStatic *pStatic;
	CProgressCtrl *pProgress;

	// ^C}
	KillTimer(m_nTimerID);
	m_nTimerID = NULL;

	// ݂̏݃TCY擾(NeBJZNV)
	m_CSection.Lock();
	dwCurrent = m_dwCurrent;
	m_CSection.Unlock();

	// p[Ze[W
	dwTemp = m_dwSize >> 16;
	dwParcent = m_dwCurrent >> 16;
	dwParcent = (dwParcent * 100) / dwTemp;

	// ݂ƈvĂȂ΍XV
	if (m_dwParcent != dwParcent) {
		// [NXV
		m_dwParcent = dwParcent;

		// 
		if (m_dwSize & 0xfffff) {
			strParcent.Format(_T("%dMB / %d.%1dMB (%d%%)"),
							dwCurrent >> 20,
							m_dwSize >> 20,
							(m_dwSize & 0xfffff) / 104858,
							dwParcent);
		}
		else {
			strParcent.Format(_T("%dMB / %dMB (%d%%)"),
							dwCurrent >> 20,
							m_dwSize >> 20,
							dwParcent);
		}

		// X^eBbNXV
		pStatic = (CStatic*)GetDlgItem(IDC_DMAKE_STATIC);
		ASSERT(pStatic);
		pStatic->SetWindowText(strParcent);

		// vOXXV
		pProgress = (CProgressCtrl*)GetDlgItem(IDC_DMAKE_PROGRESS);
		ASSERT(pProgress);
		pProgress->SetPos(dwParcent);
	}

	// ߂ă^C}ݒ
	m_nTimerID = SetTimer(IDD_DMAKEDLG, 200, NULL);

	// XbhȂȂĂ΁A_CAOI
	if (!m_pThread) {
		EndDialog(IDOK);
	}
}

//---------------------------------------------------------------------------
//
//	tH[}bg
//
//---------------------------------------------------------------------------
BOOL FASTCALL CDiskMakeDlg::Format()
{
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	Xbh֐
//
//---------------------------------------------------------------------------
UINT CDiskMakeDlg::ThreadFunc(LPVOID lpParam)
{
	CDiskMakeDlg *pDiskMakeDlg;

	// p[^LXg
	pDiskMakeDlg = (CDiskMakeDlg*)lpParam;

	// RunĂяo
	pDiskMakeDlg->Run();

	return 0;
}

//---------------------------------------------------------------------------
//
//	XbhC
//
//---------------------------------------------------------------------------
void FASTCALL CDiskMakeDlg::Run()
{
	Fileio fio;
	DWORD dwUnit;

	ASSERT(m_szPath[0] != _T('\0'));
	ASSERT(m_dwSize > 0);
	ASSERT(m_dwCurrent == 0);
	ASSERT(m_pBuffer);

	// t@C쐬
	if (!fio.Open(m_szPath, Fileio::WriteOnly)) {
		// Xbh
		m_pThread = NULL;
		return;
	}

	// ݃[v
	while (m_dwCurrent < m_dwSize) {
		// ItOŁAI
		if (m_bThread) {
			// t@CN[Y
			fio.Close();

			// t@C
			::DeleteFile(m_szPath);

			// Xbh
			m_pThread = NULL;
			return;
		}

		// TCY߂āA
		dwUnit = m_dwSize - m_dwCurrent;
		if (dwUnit > 0x100000) {
			dwUnit = 0x100000;
		}
		if (!fio.Write(m_pBuffer, dwUnit)) {
			m_bThread = TRUE;
			continue;
		}

		// TCYXV(NeBJZNV)
		m_CSection.Lock();
		m_dwCurrent += dwUnit;
		m_CSection.Unlock();
	}

	// t@C
	fio.Close();

	// tH[}bg
	if (Format()) {
		// tOグ
		m_bSucceed = TRUE;
	}

	// Xbh
	m_pThread = NULL;
}

//===========================================================================
//
//	SASIfBXNC[W쐬_CAO
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CSASIMakeDlg::CSASIMakeDlg(CWnd *pParent) : CDiskMakeDlg(pParent)
{
}

//---------------------------------------------------------------------------
//
//	tH[}bg
//
//---------------------------------------------------------------------------
BOOL FASTCALL CSASIMakeDlg::Format()
{
	DWORD dwTrack;
	DWORD dwFat;
	DWORD dwLast;
	DWORD dwDPB;
	Fileio fio;
	BYTE header[16];
	BYTE fat[4];

	// gbN
	dwTrack = 0;
	dwFat = 0;
	dwLast = 0;
	dwDPB = 0;
	switch (m_dwCurrent) {
		// 10MB
		case 0x9f5400:
			dwTrack = 0xaf50;
			dwFat = 0x7500;
			dwLast = 0x9f2e;
			dwDPB = 0x27cbf814;
			break;
		// 20MB
		case 0x13c9800:
			dwTrack = 0x15660;
			dwFat = 0xc500;
			dwLast = 0x13c68;
			dwDPB = 0x4f1af828;
			break;
		// 40MB
		case 0x2793000:
			dwTrack = 0x2acc0;
			dwFat = 0x16500;
			dwLast = 0x278f8;
			dwDPB = 0x9e3ef850;
			break;
	}
	ASSERT(dwTrack != 0);
	ASSERT(dwFat != 0);
	ASSERT(dwLast != 0);
	ASSERT(dwDPB != 0);

	// wb_쐬(_tH[}bg̗Lɂ炸A)
	header[ 0] = 0x58;
	header[ 1] = 0x36;
	header[ 2] = 0x38;
	header[ 3] = 0x4b;
	header[ 4] = 0x00;
	header[ 5] = (BYTE)(m_dwCurrent >> 24);
	header[ 6] = (BYTE)(m_dwCurrent >> 16);
	header[ 7] = (BYTE)(m_dwCurrent >> 8);
	header[ 8] = (BYTE)m_dwCurrent;
	header[ 9] = (BYTE)(m_dwCurrent >> 24);
	header[10] = (BYTE)(m_dwCurrent >> 16);
	header[11] = (BYTE)(m_dwCurrent >> 8);
	header[12] = (BYTE)m_dwCurrent;
	header[13] = (BYTE)(dwTrack >> 16);
	header[14] = (BYTE)(dwTrack >> 8);
	header[15] = (BYTE)dwTrack;

	// wb_
	if (!fio.Open(m_szPath, Fileio::ReadWrite)) {
		return FALSE;
	}
	if (!fio.Seek(0x400)) {
		return FALSE;
	}
	if (!fio.Write(header, sizeof(header))) {
		return FALSE;
	}

	// _tH[}bgsȂȂA܂
	if (m_nFormat == 0) {
		fio.Close();
		return TRUE;
	}

	// Nj[
	if (!fio.Seek(0)) {
		return FALSE;
	}
	if (!fio.Write(MENU, 0x3ad)) {
		return FALSE;
	}

	// IPL
	if (!fio.Seek(0x2100)) {
		return FALSE;
	}
	if (!fio.Write(IPL, 0x1f6)) {
		return FALSE;
	}

	// IPLC(DPB̈ꕔ)
	fat[0] = (BYTE)(dwDPB >> 24);
	fat[1] = (BYTE)(dwDPB >> 16);
	fat[2] = (BYTE)(dwDPB >> 8);
	fat[3] = (BYTE)dwDPB;
	if (!fio.Seek(0x211a)) {
		return FALSE;
	}
	if (!fio.Write(fat, sizeof(fat))) {
		return FALSE;
	}

	// p[eBVe[u쐬
	strcpy((char*)header, "Human68k");
	header[ 9] = 0x00;
	header[10] = 0x00;
	header[11] = 0x21;
	header[12] = (BYTE)(dwLast >> 24);
	header[13] = (BYTE)(dwLast >> 16);
	header[14] = (BYTE)(dwLast >> 8);
	header[15] = (BYTE)dwLast;

	// p[eBVe[u
	if (!fio.Seek(0x410)) {
		return FALSE;
	}
	if (!fio.Write(header, sizeof(header))) {
		return FALSE;
	}

	// FAT쐬
	fat[0] = 0xf8;
	fat[1] = 0xff;
	fat[2] = 0xff;
	fat[3] = 0xff;

	// 1FAT
	if (!fio.Seek(0x2500)) {
		return FALSE;
	}
	if (!fio.Write(fat, sizeof(fat))) {
		return FALSE;
	}

	// 2FAT
	if (!fio.Seek(dwFat)) {
		return FALSE;
	}
	if (!fio.Write(fat, sizeof(fat))) {
		return FALSE;
	}

	// N[Y
	fio.Close();

	// 
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	j[
//	Format.x v2.31擾
//
//---------------------------------------------------------------------------
const BYTE CSASIMakeDlg::MENU[] = {
	0x60,0x00,0x00,0xca,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x1a,0x1b,0x5b,0x36,0x3b,0x33,0x32,0x48,
	0x58,0x36,0x38,0x30,0x30,0x30,0x20,0x48,
	0x41,0x52,0x44,0x20,0x44,0x49,0x53,0x4b,
	0x20,0x49,0x50,0x4c,0x20,0x4d,0x45,0x4e,
	0x55,0x1b,0x5b,0x32,0x35,0x3b,0x32,0x32,
	0x48,0x83,0x4a,0x81,0x5b,0x83,0x5c,0x83,
	0x8b,0x83,0x4c,0x81,0x5b,0x82,0xc5,0x91,
	0x49,0x91,0xf0,0x82,0xb5,0x82,0xc4,0x83,
	0x8a,0x83,0x5e,0x81,0x5b,0x83,0x93,0x83,
	0x4c,0x81,0x5b,0x82,0xf0,0x89,0x9f,0x82,
	0xb5,0x82,0xc4,0x82,0xad,0x82,0xbe,0x82,
	0xb3,0x82,0xa2,0x00,0x1b,0x5b,0x32,0x36,
	0x3b,0x32,0x38,0x48,0x91,0x49,0x91,0xf0,
	0x82,0xb5,0x82,0xbd,0x82,0xe0,0x82,0xcc,
	0x82,0xf0,0x8e,0xa9,0x93,0xae,0x8b,0x4e,
	0x93,0xae,0x82,0xc6,0x82,0xb5,0x82,0xc4,
	0x93,0x6f,0x98,0x5e,0x82,0xb5,0x82,0xdc,
	0x82,0xb7,0x00,0x00,0x4f,0xfa,0xff,0x32,
	0x42,0x85,0x20,0x3c,0x00,0x00,0x00,0x8e,
	0x4e,0x4f,0x1e,0x00,0xe1,0x47,0x74,0x04,
	0x26,0x3c,0x00,0x00,0x01,0x00,0x43,0xfa,
	0x02,0xc6,0x61,0x00,0x02,0x32,0x4a,0x00,
	0x66,0x00,0x01,0x6a,0x43,0xfa,0x02,0xb8,
	0x47,0xfa,0xff,0x0a,0x0c,0x91,0x58,0x36,
	0x38,0x4b,0x66,0x00,0x01,0x6c,0x74,0x0e,
	0x42,0x43,0x42,0x44,0x42,0x86,0x43,0xe9,
	0x00,0x10,0x4a,0x11,0x67,0x16,0x52,0x46,
	0x26,0xc9,0x10,0x29,0x00,0x08,0x08,0x00,
	0x00,0x00,0x66,0x08,0x52,0x43,0x4a,0x00,
	0x66,0x02,0x52,0x44,0x51,0xca,0xff,0xe0,
	0x4a,0x43,0x67,0x00,0x01,0x42,0x72,0x0a,
	0x70,0x04,0x4e,0x4f,0x08,0x00,0x00,0x04,
	0x66,0x12,0x4a,0x44,0x67,0x0e,0x53,0x44,
	0x67,0x1c,0x43,0xfa,0xfe,0xf4,0x61,0x00,
	0x01,0xc4,0x60,0x28,0x43,0xfa,0xfe,0xea,
	0x61,0x00,0x01,0xba,0x43,0xfa,0xff,0x3e,
	0x61,0x00,0x01,0xb2,0x60,0x14,0x47,0xfa,
	0xfe,0x9c,0x20,0x5b,0x24,0x28,0x00,0x08,
	0x4a,0x28,0x00,0x08,0x66,0xf4,0x60,0x00,
	0x00,0xbe,0x7a,0x02,0x42,0x43,0x45,0xfa,
	0xfe,0x84,0x22,0x52,0x10,0x29,0x00,0x08,
	0x67,0x0a,0xb0,0x05,0x67,0x06,0x72,0x02,
	0x61,0x00,0x01,0x76,0x61,0x00,0x01,0x16,
	0x58,0x8a,0x52,0x43,0xb6,0x46,0x65,0xe2,
	0x60,0x2a,0x61,0x00,0x01,0x06,0x61,0x00,
	0x00,0xf2,0xb0,0x3c,0x00,0x1d,0x67,0x3a,
	0xb0,0x3c,0x00,0x35,0x67,0x0c,0xb0,0x3c,
	0x00,0x3c,0x67,0x1a,0xb0,0x3c,0x00,0x3e,
	0x66,0xe4,0x61,0x00,0x00,0xe8,0x52,0x43,
	0xb6,0x46,0x65,0x02,0x42,0x43,0x61,0x00,
	0x00,0xb2,0x66,0xf2,0x60,0xcc,0x61,0x00,
	0x00,0xd4,0x53,0x43,0x6a,0x04,0x36,0x06,
	0x53,0x43,0x61,0x00,0x00,0x9e,0x66,0xf2,
	0x60,0xb8,0x47,0xfa,0xfe,0x18,0xe5,0x43,
	0x20,0x73,0x30,0x00,0x24,0x28,0x00,0x08,
	0x4a,0x05,0x67,0x3a,0x43,0xfa,0x01,0xb8,
	0x72,0x0e,0x43,0xe9,0x00,0x10,0x4a,0x29,
	0xff,0xf8,0x67,0x12,0x20,0x11,0x08,0x00,
	0x00,0x18,0x66,0x0a,0x42,0x11,0xb4,0x80,
	0x67,0x04,0x12,0xbc,0x00,0x02,0x51,0xc9,
	0xff,0xe2,0x2f,0x02,0x74,0x04,0x26,0x3c,
	0x00,0x00,0x01,0x00,0x43,0xfa,0x01,0x80,
	0x61,0x00,0x00,0xe8,0x24,0x1f,0xc4,0xbc,
	0x00,0xff,0xff,0xff,0x26,0x3c,0x00,0x00,
	0x04,0x00,0x43,0xfa,0xfd,0xbc,0xd3,0xfc,
	0x00,0x00,0x04,0x00,0x61,0x00,0x00,0xd0,
	0x4a,0x00,0x66,0x08,0x0c,0x11,0x00,0x60,
	0x66,0x22,0x4e,0xd1,0x45,0xfa,0x00,0xda,
	0x43,0xfa,0x00,0xcc,0x61,0x00,0x00,0xae,
	0x22,0x4a,0x61,0x00,0x00,0xa8,0x60,0xfe,
	0x45,0xfa,0x00,0xe3,0x60,0xea,0x45,0xfa,
	0x00,0xfa,0x60,0xe4,0x45,0xfa,0x01,0x11,
	0x60,0xde,0x41,0xfa,0xfd,0x80,0x20,0x03,
	0xe5,0x40,0x20,0x70,0x00,0x00,0x10,0x28,
	0x00,0x08,0xb0,0x05,0x67,0x02,0x4a,0x00,
	0x4e,0x75,0x42,0x80,0x4e,0x4f,0xe0,0x48,
	0xb0,0x3c,0x00,0x4e,0x66,0x02,0x70,0x1d,
	0x4e,0x75,0x61,0x5a,0x43,0xfa,0xfd,0x56,
	0x30,0x03,0xe5,0x40,0x43,0xf1,0x00,0x00,
	0x72,0x24,0x74,0x09,0xd4,0x43,0x70,0x23,
	0x4e,0x4f,0x22,0x51,0x72,0x28,0x61,0x46,
	0x24,0x09,0x41,0xfa,0x00,0xe2,0x94,0x88,
	0xe8,0x8a,0x84,0xfc,0x00,0x0a,0xd4,0xbc,
	0x00,0x30,0x00,0x30,0x72,0x20,0xb4,0x7c,
	0x00,0x30,0x67,0x02,0x32,0x02,0x61,0x26,
	0x48,0x42,0x32,0x02,0x61,0x20,0x72,0x29,
	0x61,0x1c,0x72,0x20,0x61,0x18,0x74,0x07,
	0x42,0x41,0x12,0x19,0x61,0x10,0x51,0xca,
	0xff,0xf8,0x72,0x03,0x60,0x02,0x72,0x0b,
	0x70,0x22,0x4e,0x4f,0x4e,0x75,0x70,0x20,
	0x4e,0x4f,0x4e,0x75,0x70,0x21,0x4e,0x4f,
	0x4e,0x75,0x70,0x45,0x60,0x02,0x70,0x46,
	0x48,0xe7,0x78,0x40,0x32,0x07,0x4e,0x4f,
	0x4c,0xdf,0x02,0x1e,0x4e,0x75,0x1a,0x1b,
	0x5b,0x31,0x36,0x3b,0x33,0x33,0x48,0x00,
	0x20,0x20,0x83,0x6e,0x81,0x5b,0x83,0x68,
	0x83,0x66,0x83,0x42,0x83,0x58,0x83,0x4e,
	0x82,0xaa,0x93,0xc7,0x82,0xdf,0x82,0xdc,
	0x82,0xb9,0x82,0xf1,0x00,0x20,0x20,0x8a,
	0xc7,0x97,0x9d,0x83,0x75,0x83,0x8d,0x83,
	0x62,0x83,0x4e,0x82,0xaa,0x89,0xf3,0x82,
	0xea,0x82,0xc4,0x82,0xa2,0x82,0xdc,0x82,
	0xb7,0x00,0x20,0x20,0x8b,0x4e,0x93,0xae,
	0x89,0xc2,0x94,0x5c,0x82,0xc8,0x97,0xcc,
	0x88,0xe6,0x82,0xaa,0x82,0xa0,0x82,0xe8,
	0x82,0xdc,0x82,0xb9,0x82,0xf1,0x00,0x82,
	0x68,0x82,0x6f,0x82,0x6b,0x83,0x75,0x83,
	0x8d,0x83,0x62,0x83,0x4e,0x82,0xcc,0x93,
	0xe0,0x97,0x65,0x82,0xaa,0x88,0xd9,0x8f,
	0xed,0x82,0xc5,0x82,0xb7
};

//---------------------------------------------------------------------------
//
//	IPL
//	Format.x v2.31擾
//
//---------------------------------------------------------------------------
const BYTE CSASIMakeDlg::IPL[] = {
	0x60,0x20,0x48,0x75,0x64,0x73,0x6f,0x6e,
	0x20,0x73,0x6f,0x66,0x74,0x20,0x32,0x2e,
	0x30,0x30,0x04,0x00,0x01,0x02,0x00,0x01,
	0x02,0x00,0x4f,0x1a,0xf8,0x28,0x00,0x00,
	0x00,0x21,0x4f,0xfa,0xff,0xdc,0x43,0xfa,
	0x01,0x34,0x61,0x00,0x01,0x2a,0x20,0x3c,
	0x00,0x00,0x00,0x8e,0x4e,0x4f,0x12,0x00,
	0xe1,0x41,0x42,0x82,0x14,0x3a,0xff,0xdf,
	0x42,0x80,0x10,0x3a,0xff,0xd1,0xc4,0xc0,
	0x42,0x80,0x30,0x3a,0xff,0xca,0xd4,0x80,
	0xe5,0x82,0xd4,0xba,0xff,0xca,0x26,0x3c,
	0x00,0x00,0x04,0x00,0x43,0xfa,0x01,0x9a,
	0x61,0x00,0x00,0xc8,0x4a,0x00,0x66,0x00,
	0x00,0xd0,0x43,0xfa,0x01,0x8c,0x3c,0x3c,
	0x00,0x1f,0x24,0x49,0x47,0xfa,0x01,0x75,
	0x7e,0x0a,0x10,0x1a,0x80,0x3c,0x00,0x20,
	0xb0,0x1b,0x66,0x06,0x51,0xcf,0xff,0xf4,
	0x60,0x14,0xd3,0xfc,0x00,0x00,0x00,0x20,
	0x51,0xce,0xff,0xe0,0x43,0xfa,0x00,0xc8,
	0x61,0x00,0x00,0xbc,0x60,0xfe,0x42,0x80,
	0x30,0x29,0x00,0x1a,0xe1,0x58,0x55,0x40,
	0x42,0x87,0x1e,0x3a,0xff,0x68,0xc0,0xc7,
	0xe5,0x80,0xd4,0x80,0x42,0x80,0x30,0x3a,
	0xff,0x60,0xeb,0x80,0xd0,0xbc,0x00,0x00,
	0x03,0xff,0xe0,0x88,0xe4,0x88,0xe5,0x80,
	0xd4,0x80,0x48,0xe7,0x60,0x00,0x43,0xfa,
	0x01,0x28,0x26,0x3c,0x00,0x00,0x01,0x00,
	0x61,0x50,0x4c,0xdf,0x00,0x06,0x4a,0x00,
	0x66,0x56,0x43,0xfa,0x01,0x14,0x0c,0x59,
	0x48,0x55,0x66,0x56,0x54,0x89,0x0c,0x99,
	0x00,0x00,0x68,0x00,0x66,0x56,0x2f,0x19,
	0x26,0x19,0xd6,0x99,0x2f,0x03,0x2f,0x19,
	0x22,0x7c,0x00,0x00,0x67,0xc0,0xd6,0xbc,
	0x00,0x00,0x00,0x40,0x61,0x1c,0x22,0x1f,
	0x24,0x1f,0x22,0x5f,0x4a,0x00,0x66,0x20,
	0x41,0xf9,0x00,0x00,0x68,0x00,0xd1,0xc2,
	0x53,0x81,0x65,0x04,0x42,0x18,0x60,0xf8,
	0x4e,0xd1,0x48,0xe7,0x78,0x40,0x70,0x46,
	0x4e,0x4f,0x4c,0xdf,0x02,0x1e,0x4e,0x75,
	0x43,0xfa,0x00,0x48,0x61,0x18,0x60,0x00,
	0xff,0x5c,0x43,0xfa,0x00,0x5d,0x61,0x0e,
	0x60,0x00,0xff,0x52,0x43,0xfa,0x00,0x75,
	0x61,0x04,0x60,0x00,0xff,0x48,0x70,0x21,
	0x4e,0x4f,0x4e,0x75,0x1a,0x00,0x1b,0x5b,
	0x31,0x36,0x3b,0x33,0x35,0x48,0x48,0x75,
	0x6d,0x61,0x6e,0x2e,0x73,0x79,0x73,0x20,
	0x82,0xaa,0x20,0x8c,0xa9,0x82,0xc2,0x82,
	0xa9,0x82,0xe8,0x82,0xdc,0x82,0xb9,0x82,
	0xf1,0x00,0x1b,0x5b,0x31,0x36,0x3b,0x33,
	0x38,0x48,0x83,0x66,0x83,0x42,0x83,0x58,
	0x83,0x4e,0x82,0xaa,0x81,0x40,0x93,0xc7,
	0x82,0xdf,0x82,0xdc,0x82,0xb9,0x82,0xf1,
	0x00,0x1b,0x5b,0x31,0x36,0x3b,0x33,0x36,
	0x48,0x48,0x75,0x6d,0x61,0x6e,0x2e,0x73,
	0x79,0x73,0x20,0x82,0xaa,0x20,0x89,0xf3,
	0x82,0xea,0x82,0xc4,0x82,0xa2,0x82,0xdc,
	0x82,0xb7,0x00,0x1b,0x5b,0x31,0x36,0x3b,
	0x33,0x33,0x48,0x48,0x75,0x6d,0x61,0x6e,
	0x2e,0x73,0x79,0x73,0x20,0x82,0xcc,0x20,
	0x83,0x41,0x83,0x68,0x83,0x8c,0x83,0x58,
	0x82,0xaa,0x88,0xd9,0x8f,0xed,0x82,0xc5,
	0x82,0xb7,0x00,0x68,0x75,0x6d,0x61,0x6e,
	0x20,0x20,0x20,0x73,0x79,0x73
};

//===========================================================================
//
//	SCSIfBXNC[W쐬_CAO
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CSCSIMakeDlg::CSCSIMakeDlg(CWnd *pParent) : CDiskMakeDlg(pParent)
{
}

//===========================================================================
//
//	MOfBXNC[W쐬_CAO
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CMOMakeDlg::CMOMakeDlg(CWnd *pParent) : CDiskMakeDlg(pParent)
{
	// fBA^Cv͖m
	m_nMedia = -1;
}

//---------------------------------------------------------------------------
//
//	tH[}bg
//
//---------------------------------------------------------------------------
BOOL FASTCALL CMOMakeDlg::Format()
{
	ASSERT(this);

	// fBA^Cvݒ
	switch (m_dwSize) {
		// 128MB
		case 0x797f400:
			m_nMedia = 0;
			break;

		// 230MB
		case 0xd9eea00:
			m_nMedia = 1;
			break;

		// 540MB
		case 0x1fc8b800:
			m_nMedia = 2;
			break;

		// 640MB
		case 0x25e28000:
			m_nMedia = 3;
			break;

		// ̑(蓾Ȃ)
		default:
			ASSERT(FALSE);
			return TRUE;
	}

	// tH[}bg
	switch (m_nFormat) {
		// IBMtH[}bg
		case 1:
			return FormatIBM();

		// SHARPtH[}bg
		case 2:
			return FormatSHARP();
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	IBMtH[}bg
//
//---------------------------------------------------------------------------
BOOL FASTCALL CMOMakeDlg::FormatIBM()
{
	int i;
	Fileio fio;
	BYTE bpbData[62];
	BYTE markData[2];
	BYTE fatData[4];
	DWORD dwOffset;

	// BPBf[^쐬
	MakeBPB(bpbData);

	// t@CI[v
	if (!fio.Open(m_szPath, Fileio::ReadWrite)) {
		return FALSE;
	}

	// BPB
	if (!fio.Write(bpbData, sizeof(bpbData))) {
		return FALSE;
	}

	// }[J
	markData[0] = 0x55;
	markData[1] = 0xaa;
	if (!fio.Seek(0x1fe)) {
		fio.Close();
		return FALSE;
	}
	if (!fio.Write(markData, sizeof(markData))) {
		fio.Close();
		return FALSE;
	}

	// FAT݃[v
	fatData[0] = bpbData[21];
	fatData[1] = 0xff;
	fatData[2] = 0xff;
	fatData[3] = 0xff;
	for (i=0; i<bpbData[16]; i++) {
		// ZN^ItZbgvZ(1FATZN^~FATCfbNX+\ZN^)
		dwOffset = bpbData[22];
		dwOffset *= i;
		dwOffset += bpbData[14];

		// oCgItZbgvZ
		if (m_nMedia < 3) {
			ASSERT(m_nMedia >= 0);
			dwOffset <<= 9;
		}
		else {
			ASSERT(m_nMedia == 3);
			dwOffset <<= 11;
		}

		// FAT
		if (!fio.Seek(dwOffset)) {
			fio.Close();
			return FALSE;
		}
		if (!fio.Write(fatData, sizeof(fatData))) {
			fio.Close();
			return FALSE;
		}
	}

	// N[YA
	fio.Close();
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	IBMtH[}bg(BPB쐬)
//
//---------------------------------------------------------------------------
void FASTCALL CMOMakeDlg::MakeBPB(BYTE *pBPB)
{
	DWORD dwMajor;
	DWORD dwMinor;
	DWORD dwSectors;

	ASSERT(this);
	ASSERT(pBPB);

	// u[gւ̃Wv(80x86̖[vƂ)
	pBPB[0] = 0xeb;
	pBPB[1] = 0xfe;
	pBPB[2] = 0x90;

	// OEM"XM6 X.XX"
	pBPB[3] = 0x58;
	pBPB[4] = 0x4d;
	pBPB[5] = 0x36;
	pBPB[6] = 0x20;
	::GetVM()->GetVersion(dwMajor, dwMinor);
	pBPB[7] = (BYTE)(dwMajor + '0');
	pBPB[8] = 0x2e;
	pBPB[9] = (BYTE)((dwMinor >> 4) + '0');
	pBPB[10] = (BYTE)((dwMinor & 0x0f) + '0');

	// 1ZN^̃oCg
	if (m_nMedia < 3) {
		// 512oCg/ZN^
		pBPB[11] = 0x00;
		pBPB[12] = 0x02;
	}
	else {
		// 2048oCg/ZN^
		pBPB[11] = 0x00;
		pBPB[12] = 0x08;
	}

	// 1NX^̃ZN^
	switch (m_nMedia) {
		// 128MB ... 4ZN^/NX^
		case 0:
			pBPB[13] = 0x04;
			break;
		// 230MB ... 8ZN^/NX^
		case 1:
			pBPB[13] = 0x08;
			break;
		// 540MB ... 16ZN^/NX^
		case 2:
			pBPB[13] = 0x10;
			break;
		// 640MB ... 8ZN^/NX^
		case 3:
			pBPB[13] = 0x08;
			break;
	}

	// \ZN^(1ZN^)
	pBPB[14] = 0x01;
	pBPB[15] = 0x00;

	// FAT(1,22)
	pBPB[16] = 0x02;

	// [gfBNg̃Gg(512)
	pBPB[17] = 0x00;
	pBPB[18] = 0x02;

	// _ZN^(32rbgZN^AhbVOȂ̂0)
	pBPB[19] = 0x00;
	pBPB[20] = 0x00;

	// fBAIDoCg(F0)
	pBPB[21] = 0xf0;

	// 1FAT̃ZN^
	switch (m_nMedia) {
		// 128MB ... 243ZN^/FAT
		case 0:
			pBPB[22] = 0xf3;
			break;
		// 230MB ... 218ZN^/FAT
		case 1:
			pBPB[22] = 0xda;
			break;
		// 540MB ... 255ZN^/FAT
		case 2:
			pBPB[22] = 0xff;
			break;
		// 640MB ... 38ZN^/FAT
		case 3:
			pBPB[22] = 0x26;
			break;
	}
	pBPB[23] = 0x00;

	// gbÑZN^
	switch (m_nMedia) {
		// 128MB ... 25ZN^/gbN
		case 0:
			pBPB[24] = 0x19;
			break;
		// 230MB ... 32ZN^/gbN
		case 1:
			pBPB[24] = 0x20;
			break;
		// 540MB ... 32ZN^/gbN
		case 2:
			pBPB[24] = 0x20;
			break;
		// 640MB ... 32ZN^/gbN
		case 3:
			pBPB[24] = 0x20;
			break;
	}
	pBPB[25] = 0x00;

	// wbh(1)
	pBPB[26] = 0x01;
	pBPB[27] = 0x00;

	// BZN^(0)
	pBPB[28] = 0x00;
	pBPB[29] = 0x00;
	pBPB[30] = 0x00;
	pBPB[31] = 0x00;

	// _ZN^(128MB248826-1ZN^A230MB446325-1ZN^)
	dwSectors = m_dwSize;
	if (m_nMedia < 3) {
		dwSectors >>= 9;
	}
	else {
		dwSectors >>= 11;
	}
	dwSectors--;
	pBPB[32] = (BYTE)dwSectors;
	pBPB[33] = (BYTE)(dwSectors >> 8);
	pBPB[34] = (BYTE)(dwSectors >> 16);
	pBPB[35] = 0x00;

	// INT 13hCuԍ(C:0x80)
	pBPB[36] = 0x80;

	// \
	pBPB[37] = 0x00;

	// gu[gʃR[h(0x29)
	pBPB[38] = 0x29;

	// {[VAԍ(+39, 40, 41, 42)
	MakeSerial(&pBPB[39]);

	// {[xAt@CVXe
	strcpy((char*)(pBPB + 43), "NO NAME    FAT16  ");
	pBPB[61] = 0x20;
}

//---------------------------------------------------------------------------
//
//	{[VA쐬
//
//---------------------------------------------------------------------------
void FASTCALL CMOMakeDlg::MakeSerial(BYTE *pSerial)
{
	SYSTEMTIME st;

	ASSERT(this);
	ASSERT(pSerial);

	// ݎԂ擾
	::GetLocalTime(&st);

	// ItZbg3 - ̕b
	pSerial[3] = (BYTE)st.wSecond;

	// ItZbg2 - t̓
	pSerial[2] = (BYTE)st.wDay;

	// ItZbg1 - ̏ʃoCg{
	pSerial[1] = (BYTE)((st.wYear >> 8) + st.wHour);

	// ItZbg0 - ̉ʃoCg{
	pSerial[0] = (BYTE)((st.wYear & 0xff) + st.wMinute);
}

//---------------------------------------------------------------------------
//
//	SHARPtH[}bg
//
//---------------------------------------------------------------------------
BOOL FASTCALL CMOMakeDlg::FormatSHARP()
{
	Fileio fio;
	BYTE buf[0x21];
	DWORD dwMajor;
	DWORD dwMinor;
	DWORD dwSectors;
	DWORD dwOffset;

	ASSERT(this);
	ASSERT(m_nMedia < 3);

	// obt@
	memset(buf, 0, sizeof(buf));

	// SCSIwb_"X68SCSI1"
	strcpy((char*)buf, "X68SCSI1");
	buf[8] = 0x02;
	dwSectors = m_dwSize;
	dwSectors >>= 9;
	dwSectors--;
	buf[11] = (BYTE)(dwSectors >> 16);
	buf[12] = (BYTE)(dwSectors >> 8);
	buf[13] = (BYTE)dwSectors;
	buf[14] = 0x01;
	buf[15] = 0x02;

	// tH[}b^}[J"XM6 version X.XX"
	::GetVM()->GetVersion(dwMajor, dwMinor);
	strcpy((char*)&buf[0x10], "XM6 version ");
	buf[28] = (BYTE)(dwMajor + '0');
	buf[29] = 0x2e;
	buf[30] = (BYTE)((dwMinor >> 4) + '0');
	buf[31] = (BYTE)((dwMinor & 0x0f) + '0');

	// t@CI[v
	if (!fio.Open(m_szPath, Fileio::ReadWrite)) {
		return FALSE;
	}

	// SCSIwb_+tH[}b^}[J
	if (!fio.Write(buf, 0x20)) {
		fio.Close();
		return FALSE;
	}

	// SCSIj[
	if (!fio.Seek(0x400)) {
		fio.Close();
		return FALSE;
	}
	if (!fio.Write(SCSIMENU, 0x3e3)) {
		fio.Close();
		return FALSE;
	}

	// p[eBVe[u
	switch (m_nMedia) {
		// 128MB
		case 0:
			memcpy(buf, PartTable128, 0x20);
			break;
		// 230MB
		case 1:
			memcpy(buf, PartTable230, 0x20);
			break;
		// 540MB
		case 2:
			memcpy(buf, PartTable540, 0x20);
			break;
	}
	if (!fio.Seek(0x800)) {
		fio.Close();
		return FALSE;
	}
	if (!fio.Write(buf, 0x20)) {
		fio.Close();
		return FALSE;
	}

	// p[eBV擪
	switch (m_nMedia) {
		// 128MB
		case 0:
			memcpy(buf, PartTop128, 0x10);
			break;
		// 230MB
		case 1:
			memcpy(buf, PartTop230, 0x10);
			break;
		// 540MB
		case 2:
			memcpy(buf, PartTop540, 0x10);
			break;
	}
	if (!fio.Seek(0x900)) {
		fio.Close();
		return FALSE;
	}
	if (!fio.Write(buf, 0x10)) {
		fio.Close();
		return FALSE;
	}

	// SCHDISK
	if (!fio.Seek(0xc00)) {
		fio.Close();
		return FALSE;
	}
	if (!fio.Write(SCHDISK, 0xe3a)) {
		fio.Close();
		return FALSE;
	}

	// SCSIIOCS
	if (!fio.Seek(0x2820)) {
		fio.Close();
		return FALSE;
	}
	if (!fio.Write(SCSIIOCS, 0x1735)) {
		fio.Close();
		return FALSE;
	}

	// IPLpb`(eʂɂႤ)
	memcpy(buf, IPL, 0x21);
	switch (m_nMedia) {
		// 128MB
		case 0:
			buf[0x14] = 0x02;
			buf[0x1d] = 0x7a;
			buf[0x1f] = 0x01;
			buf[0x20] = 0xe4;
			break;
		// 230MB
		case 1:
			buf[0x14] = 0x04;
			buf[0x1d] = 0x6e;
			buf[0x1f] = 0x03;
			buf[0x20] = 0x64;
			break;
		// 540MB
		case 2:
			buf[0x14] = 0x08;
			buf[0x1d] = 0x80;
			buf[0x1f] = 0x07;
			buf[0x20] = 0xf0;
			break;
	}
	if (!fio.Seek(0x8000)) {
		fio.Close();
		return FALSE;
	}
	if (!fio.Write(buf, 0x21)) {
		fio.Close();
		return FALSE;
	}

	// IPLc
	if (!fio.Write(&IPL[0x21], (0x2c5 - 0x21))) {
		fio.Close();
		return FALSE;
	}

	// FAT쐬
	buf[0] = 0xf6;
	buf[1] = 0xff;
	buf[2] = 0xff;
	buf[3] = 0xff;

	// 1FAT
	if (!fio.Seek(0x8400)) {
		fio.Close();
		return FALSE;
	}
	if (!fio.Write(buf, 4)) {
		fio.Close();
		return FALSE;
	}

	// 2FAT
	dwOffset = (DWORD)buf[0x1d];
	dwOffset <<= 10;
	dwOffset += 0x8400;
	if (!fio.Seek(dwOffset)) {
		fio.Close();
		return FALSE;
	}
	if (!fio.Write(buf, 4)) {
		fio.Close();
		return FALSE;
	}

	// 
	fio.Close();
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	p[eBVe[u(SHARPtH[}bgA128MB)
//
//---------------------------------------------------------------------------
const BYTE CMOMakeDlg::PartTable128[] = {
	0x58, 0x36, 0x38, 0x4b, 0x00, 0x01, 0xe4, 0x20,
	0x00, 0x01, 0xe5, 0xfc, 0x00, 0x01, 0xe5, 0xfc,
	0x48, 0x75, 0x6d, 0x61, 0x6e, 0x36, 0x38, 0x6b,
	0x00, 0x00, 0x00, 0x20, 0x00, 0x01, 0xe4, 0x00
};

//---------------------------------------------------------------------------
//
//	p[eBVe[u(SHARPtH[}bgA230MB)
//
//---------------------------------------------------------------------------
const BYTE CMOMakeDlg::PartTable230[] = {
	0x58, 0x36, 0x38, 0x4b, 0x00, 0x03, 0x64, 0x20,
	0x00, 0x03, 0x67, 0xba, 0x00, 0x03, 0x67, 0xba,
	0x48, 0x75, 0x6d, 0x61, 0x6e, 0x36, 0x38, 0x6b,
	0x00, 0x00, 0x00, 0x20, 0x00, 0x03, 0x64, 0x00
};

//---------------------------------------------------------------------------
//
//	p[eBVe[u(SHARPtH[}bgA540MB)
//
//---------------------------------------------------------------------------
const BYTE CMOMakeDlg::PartTable540[] = {
	0x58, 0x36, 0x38, 0x4b, 0x00, 0x07, 0xf0, 0x20,
	0x00, 0x07, 0xf2, 0x2d, 0x00, 0x07, 0xf2, 0x2d,
	0x48, 0x75, 0x6d, 0x61, 0x6e, 0x36, 0x38, 0x6b,
	0x00, 0x00, 0x00, 0x20, 0x00, 0x07, 0xf0, 0x00
};

//---------------------------------------------------------------------------
//
//	p[eBV擪(SHARPtH[}bgA128MB)
//
//---------------------------------------------------------------------------
const BYTE CMOMakeDlg::PartTop128[] = {
	0x58, 0x36, 0x38, 0x4b, 0x00, 0x00, 0x00, 0x20,
	0x00, 0x01, 0xe5, 0xfc, 0x00, 0x01, 0xe5, 0xfc
};

//---------------------------------------------------------------------------
//
//	p[eBV擪(SHARPtH[}bgA230MB)
//
//---------------------------------------------------------------------------
const BYTE CMOMakeDlg::PartTop230[] = {
	0x58, 0x36, 0x38, 0x4b, 0x00, 0x00, 0x00, 0x20,
	0x00, 0x03, 0x67, 0xba, 0x00, 0x03, 0x67, 0xba
};

//---------------------------------------------------------------------------
//
//	p[eBV擪(SHARPtH[}bgA540MB)
//
//---------------------------------------------------------------------------
const BYTE CMOMakeDlg::PartTop540[] = {
	0x58, 0x36, 0x38, 0x4b, 0x00, 0x00, 0x00, 0x20,
	0x00, 0x07, 0xf2, 0x2d, 0x00, 0x07, 0xf2, 0x2d
};

//---------------------------------------------------------------------------
//
//	SCSINj[
//	Format.x v2.31擾
//
//---------------------------------------------------------------------------
const BYTE CMOMakeDlg::SCSIMENU[] = {
	0x60,0x00,0x00,0xca,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x1a,0x1b,0x5b,0x36,0x3b,0x33,0x32,0x48,
	0x58,0x36,0x38,0x30,0x30,0x30,0x20,0x53,
	0x43,0x53,0x49,0x20,0x44,0x49,0x53,0x4b,
	0x20,0x49,0x50,0x4c,0x20,0x4d,0x45,0x4e,
	0x55,0x1b,0x5b,0x32,0x35,0x3b,0x32,0x32,
	0x48,0x83,0x4a,0x81,0x5b,0x83,0x5c,0x83,
	0x8b,0x83,0x4c,0x81,0x5b,0x82,0xc5,0x91,
	0x49,0x91,0xf0,0x82,0xb5,0x82,0xc4,0x83,
	0x8a,0x83,0x5e,0x81,0x5b,0x83,0x93,0x83,
	0x4c,0x81,0x5b,0x82,0xf0,0x89,0x9f,0x82,
	0xb5,0x82,0xc4,0x82,0xad,0x82,0xbe,0x82,
	0xb3,0x82,0xa2,0x00,0x1b,0x5b,0x32,0x36,
	0x3b,0x32,0x38,0x48,0x91,0x49,0x91,0xf0,
	0x82,0xb5,0x82,0xbd,0x82,0xe0,0x82,0xcc,
	0x82,0xf0,0x8e,0xa9,0x93,0xae,0x8b,0x4e,
	0x93,0xae,0x82,0xc6,0x82,0xb5,0x82,0xc4,
	0x93,0x6f,0x98,0x5e,0x82,0xb5,0x82,0xdc,
	0x82,0xb7,0x00,0x00,0x72,0x00,0x70,0x04,
	0x4e,0x4f,0x08,0x00,0x00,0x01,0x67,0x02,
	0x4e,0x75,0x4f,0xfa,0xff,0x24,0x42,0x85,
	0x70,0xf5,0x72,0x25,0x43,0xfa,0x03,0x02,
	0x4e,0x4f,0x4a,0x00,0x66,0x00,0x01,0x92,
	0x22,0x29,0x00,0x04,0xe0,0x89,0xe2,0x89,
	0x43,0xfa,0x02,0xea,0x22,0x81,0x74,0x02,
	0x26,0x3c,0x00,0x00,0x04,0x00,0x43,0xfa,
	0x02,0xe0,0x61,0x00,0x02,0x3a,0x4a,0x00,
	0x66,0x00,0x01,0x6e,0x43,0xfa,0x02,0xd2,
	0x47,0xfa,0xfe,0xea,0x0c,0x91,0x58,0x36,
	0x38,0x4b,0x66,0x00,0x01,0x70,0x74,0x0e,
	0x42,0x43,0x42,0x47,0x42,0x86,0x43,0xe9,
	0x00,0x10,0x4a,0x11,0x67,0x16,0x52,0x46,
	0x26,0xc9,0x10,0x29,0x00,0x08,0x08,0x00,
	0x00,0x00,0x66,0x08,0x52,0x43,0x4a,0x00,
	0x66,0x02,0x52,0x47,0x51,0xca,0xff,0xe0,
	0x4a,0x43,0x67,0x00,0x01,0x46,0x72,0x0a,
	0x70,0x04,0x4e,0x4f,0x08,0x00,0x00,0x04,
	0x66,0x12,0x4a,0x47,0x67,0x0e,0x53,0x47,
	0x67,0x1c,0x43,0xfa,0xfe,0xd4,0x61,0x00,
	0x01,0xc8,0x60,0x28,0x43,0xfa,0xfe,0xca,
	0x61,0x00,0x01,0xbe,0x43,0xfa,0xff,0x1e,
	0x61,0x00,0x01,0xb6,0x60,0x14,0x47,0xfa,
	0xfe,0x7c,0x20,0x5b,0x24,0x28,0x00,0x08,
	0x4a,0x28,0x00,0x08,0x66,0xf4,0x60,0x00,
	0x00,0xc2,0x7a,0x02,0x42,0x43,0x45,0xfa,
	0xfe,0x64,0x22,0x52,0x10,0x29,0x00,0x08,
	0x67,0x0a,0xb0,0x05,0x67,0x06,0x72,0x02,
	0x61,0x00,0x01,0x7a,0x61,0x00,0x01,0x1a,
	0x58,0x8a,0x52,0x43,0xb6,0x46,0x65,0xe2,
	0x60,0x2a,0x61,0x00,0x01,0x0a,0x61,0x00,
	0x00,0xf6,0xb0,0x3c,0x00,0x1d,0x67,0x3a,
	0xb0,0x3c,0x00,0x35,0x67,0x0c,0xb0,0x3c,
	0x00,0x3c,0x67,0x1a,0xb0,0x3c,0x00,0x3e,
	0x66,0xe4,0x61,0x00,0x00,0xec,0x52,0x43,
	0xb6,0x46,0x65,0x02,0x42,0x43,0x61,0x00,
	0x00,0xb6,0x66,0xf2,0x60,0xcc,0x61,0x00,
	0x00,0xd8,0x53,0x43,0x6a,0x04,0x36,0x06,
	0x53,0x43,0x61,0x00,0x00,0xa2,0x66,0xf2,
	0x60,0xb8,0x47,0xfa,0xfd,0xf8,0xe5,0x43,
	0x20,0x73,0x30,0x00,0x24,0x28,0x00,0x08,
	0x4a,0x05,0x67,0x3e,0x43,0xfa,0x01,0xd2,
	0x72,0x0e,0x43,0xe9,0x00,0x10,0x4a,0x29,
	0xff,0xf8,0x67,0x12,0x20,0x11,0x08,0x00,
	0x00,0x18,0x66,0x0a,0x42,0x11,0xb4,0x80,
	0x67,0x04,0x12,0xbc,0x00,0x02,0x51,0xc9,
	0xff,0xe2,0x2f,0x02,0x74,0x02,0x26,0x3c,
	0x00,0x00,0x04,0x00,0x43,0xfa,0x01,0x9a,
	0x61,0x00,0x00,0xec,0x24,0x1f,0x4a,0x00,
	0x66,0x26,0xc4,0xbc,0x00,0xff,0xff,0xff,
	0x26,0x3c,0x00,0x00,0x04,0x00,0x43,0xfa,
	0xfd,0x98,0xd3,0xfc,0x00,0x00,0x04,0x00,
	0x61,0x00,0x00,0xd4,0x4a,0x00,0x66,0x08,
	0x0c,0x11,0x00,0x60,0x66,0x22,0x4e,0xd1,
	0x45,0xfa,0x00,0xea,0x43,0xfa,0x00,0xdc,
	0x61,0x00,0x00,0xae,0x22,0x4a,0x61,0x00,
	0x00,0xa8,0x60,0xfe,0x45,0xfa,0x00,0xf5,
	0x60,0xea,0x45,0xfa,0x01,0x0c,0x60,0xe4,
	0x45,0xfa,0x01,0x23,0x60,0xde,0x41,0xfa,
	0xfd,0x5c,0x20,0x03,0xe5,0x40,0x20,0x70,
	0x00,0x00,0x10,0x28,0x00,0x08,0xb0,0x05,
	0x67,0x02,0x4a,0x00,0x4e,0x75,0x42,0x80,
	0x4e,0x4f,0xe0,0x48,0xb0,0x3c,0x00,0x4e,
	0x66,0x02,0x70,0x1d,0x4e,0x75,0x61,0x5a,
	0x43,0xfa,0xfd,0x32,0x30,0x03,0xe5,0x40,
	0x43,0xf1,0x00,0x00,0x22,0x51,0x72,0x24,
	0x74,0x09,0xd4,0x43,0x70,0x23,0x4e,0x4f,
	0x72,0x28,0x61,0x46,0x24,0x09,0x41,0xfa,
	0x00,0xf8,0x94,0x88,0xe8,0x8a,0x84,0xfc,
	0x00,0x0a,0xd4,0xbc,0x00,0x30,0x00,0x30,
	0x72,0x20,0xb4,0x7c,0x00,0x30,0x67,0x02,
	0x32,0x02,0x61,0x26,0x48,0x42,0x32,0x02,
	0x61,0x20,0x72,0x29,0x61,0x1c,0x72,0x20,
	0x61,0x18,0x74,0x07,0x42,0x41,0x12,0x19,
	0x61,0x10,0x51,0xca,0xff,0xf8,0x72,0x03,
	0x60,0x02,0x72,0x0b,0x70,0x22,0x4e,0x4f,
	0x4e,0x75,0x70,0x20,0x4e,0x4f,0x4e,0x75,
	0x70,0x21,0x4e,0x4f,0x4e,0x75,0x48,0xe7,
	0x7c,0x00,0x72,0x22,0x60,0x06,0x48,0xe7,
	0x7c,0x00,0x72,0x21,0x2a,0x3a,0x00,0x96,
	0xe0,0x8b,0xea,0xab,0xe5,0x8a,0xea,0xaa,
	0x70,0xf5,0x4e,0x4f,0x4c,0xdf,0x00,0x3e,
	0x4e,0x75,0x1a,0x1b,0x5b,0x31,0x36,0x3b,
	0x33,0x33,0x48,0x00,0x20,0x20,0x82,0x72,
	0x82,0x62,0x82,0x72,0x82,0x68,0x83,0x66,
	0x83,0x42,0x83,0x58,0x83,0x4e,0x82,0xaa,
	0x93,0xc7,0x82,0xdf,0x82,0xdc,0x82,0xb9,
	0x82,0xf1,0x00,0x20,0x20,0x8a,0xc7,0x97,
	0x9d,0x83,0x75,0x83,0x8d,0x83,0x62,0x83,
	0x4e,0x82,0xaa,0x89,0xf3,0x82,0xea,0x82,
	0xc4,0x82,0xa2,0x82,0xdc,0x82,0xb7,0x00,
	0x20,0x20,0x8b,0x4e,0x93,0xae,0x89,0xc2,
	0x94,0x5c,0x82,0xc8,0x97,0xcc,0x88,0xe6,
	0x82,0xaa,0x82,0xa0,0x82,0xe8,0x82,0xdc,
	0x82,0xb9,0x82,0xf1,0x00,0x82,0x68,0x82,
	0x6f,0x82,0x6b,0x83,0x75,0x83,0x8d,0x83,
	0x62,0x83,0x4e,0x82,0xcc,0x93,0xe0,0x97,
	0x65,0x82,0xaa,0x88,0xd9,0x8f,0xed,0x82,
	0xc5,0x82,0xb7
};

//---------------------------------------------------------------------------
//
//	SCSIfBXNhCo(SCHDISK) 1.04
//	Format.x v2.31擾
//
//---------------------------------------------------------------------------
const BYTE CMOMakeDlg::SCHDISK[] = {
	0xff,0xff,0xff,0xff,0x40,0x00,0x00,0x00,
	0x00,0x6e,0x00,0x00,0x00,0x80,0x01,0x53,
	0x43,0x48,0x44,0x49,0x53,0x4b,0x00,0x00,
	0x00,0x00,0x00,0x00,0x01,0x46,0x00,0x00,
	0x03,0x46,0x00,0x00,0x0d,0x0c,0x00,0x00,
	0x00,0xf8,0x00,0x00,0x07,0x9e,0x00,0x00,
	0x03,0xb0,0x00,0x00,0x00,0xb8,0x00,0x00,
	0x00,0xb8,0x00,0x00,0x08,0x14,0x00,0x00,
	0x08,0x06,0x00,0x00,0x00,0xb8,0x00,0x00,
	0x00,0xb8,0x00,0x00,0x01,0x2c,0x00,0x00,
	0x00,0x01,0x70,0x02,0x70,0x07,0x70,0x0c,
	0x70,0x08,0x00,0x01,0x70,0x0d,0x70,0x0c,
	0x70,0x0c,0x70,0x0c,0x70,0x0c,0x70,0x0c,
	0x70,0x0c,0x70,0x0c,0x70,0x0c,0x48,0xe7,
	0x00,0x02,0x4d,0xfa,0x0d,0xc8,0x2d,0x4d,
	0x00,0x00,0x4c,0xdf,0x40,0x00,0x4e,0x75,
	0x48,0xe7,0x7f,0xfe,0x4d,0xfa,0x0d,0xb6,
	0x2a,0x6e,0x00,0x00,0x70,0x00,0x10,0x2d,
	0x00,0x02,0x0c,0x00,0x00,0x0c,0x62,0x1a,
	0x22,0x6d,0x00,0x0e,0x41,0xfa,0xff,0x7c,
	0xd0,0x40,0xd0,0x40,0xd1,0xc0,0x20,0x50,
	0x20,0x08,0x41,0xfa,0xff,0x54,0xd1,0xc0,
	0x4e,0xd0,0x30,0x3c,0x70,0x0c,0x60,0x02,
	0x42,0x40,0x32,0x00,0x1b,0x41,0x00,0x03,
	0xe0,0x49,0x1b,0x41,0x00,0x04,0x4a,0x40,
	0x67,0x12,0x4a,0x6e,0x05,0xac,0x66,0x06,
	0x4a,0x6e,0x05,0xae,0x67,0x06,0x3d,0x7c,
	0xff,0xff,0x05,0xb2,0x4c,0xdf,0x7f,0xfe,
	0x4e,0x75,0x4a,0xae,0x05,0xca,0x67,0xca,
	0x22,0x6e,0x05,0xca,0x70,0x80,0x22,0x3c,
	0x00,0x00,0x01,0xf5,0x4e,0x4f,0x60,0xba,
	0x20,0x6d,0x00,0x0e,0x20,0x2d,0x00,0x12,
	0x0c,0x80,0x00,0x00,0x00,0x08,0x67,0x14,
	0x0c,0x80,0x00,0x00,0x00,0x04,0x66,0xa8,
	0x30,0xee,0x05,0xc4,0x20,0x2e,0x05,0xa8,
	0x30,0x80,0x60,0x9c,0x30,0xee,0x05,0xc4,
	0x20,0x2e,0x05,0xa8,0x30,0xc0,0x20,0xae,
	0x05,0xc6,0x60,0x8c,0x20,0x6d,0x00,0x0e,
	0x20,0x2d,0x00,0x12,0x0c,0x80,0x00,0x00,
	0x00,0x02,0x66,0x00,0xff,0x7c,0x3d,0x50,
	0x05,0xc4,0x60,0x00,0xff,0x74,0x0c,0x2d,
	0x00,0x17,0x00,0x16,0x64,0x00,0xff,0x64,
	0x53,0x82,0x02,0x82,0x00,0x00,0x00,0x0f,
	0x2d,0x42,0x05,0xa8,0x05,0x39,0x00,0x00,
	0x0c,0xec,0x66,0x00,0xff,0x4e,0x61,0x00,
	0x1a,0xb8,0x2d,0x40,0x05,0xca,0x20,0x3c,
	0x00,0x00,0x00,0xf5,0x72,0x24,0x28,0x2e,
	0x05,0xa8,0x4e,0x4f,0xb0,0xbc,0x00,0x00,
	0x00,0x00,0x67,0x64,0xb0,0xbc,0xff,0xff,
	0xff,0xff,0x67,0x00,0xff,0x56,0xb0,0xbc,
	0x00,0x00,0x00,0x08,0x67,0x50,0xb0,0xbc,
	0x00,0x00,0x00,0x02,0x66,0x00,0xff,0x44,
	0x20,0x3c,0x00,0x00,0x00,0xf5,0x72,0x2c,
	0x76,0x0e,0x28,0x2e,0x05,0xa8,0x43,0xee,
	0x05,0xd2,0x4e,0x4f,0xb0,0xbc,0x00,0x00,
	0x00,0x00,0x66,0x00,0xff,0x26,0x43,0xee,
	0x05,0xd2,0x10,0x11,0x02,0x00,0x00,0x70,
	0x0c,0x00,0x00,0x70,0x66,0x00,0xff,0x14,
	0x10,0x29,0x00,0x02,0x67,0x10,0xb0,0x3c,
	0x00,0x01,0x67,0x0a,0xb0,0x3c,0x00,0x06,
	0x67,0x04,0x60,0x00,0xfe,0xfe,0x60,0x86,
	0x70,0xf5,0x72,0x2b,0x28,0x2e,0x05,0xa8,
	0x4e,0x4f,0x4a,0x80,0x66,0x00,0xfe,0xec,
	0x70,0xf5,0x72,0x25,0x28,0x2e,0x05,0xa8,
	0x43,0xee,0x05,0xd2,0x4e,0x4f,0x4a,0x80,
	0x66,0x00,0xfe,0xd8,0x43,0xee,0x05,0xd2,
	0x22,0x29,0x00,0x04,0xb2,0xbc,0x00,0x00,
	0x04,0x00,0x67,0x18,0xb2,0xbc,0x00,0x00,
	0x02,0x00,0x67,0x08,0x3d,0x7c,0x00,0x02,
	0x05,0xa0,0x60,0x0e,0x3d,0x7c,0x00,0x01,
	0x05,0xa0,0x60,0x06,0x3d,0x7c,0x00,0x00,
	0x05,0xa0,0xe0,0x89,0xe2,0x89,0x2d,0x41,
	0x05,0xa4,0x43,0xee,0x05,0xd2,0x2a,0x2e,
	0x05,0xa4,0x74,0x00,0xe5,0x8a,0xea,0xaa,
	0x76,0x01,0xe5,0x8b,0xea,0xab,0x28,0x2e,
	0x05,0xa8,0x70,0xf5,0x72,0x21,0x4e,0x4f,
	0x4a,0x80,0x66,0x00,0xfe,0x7e,0x0c,0x91,
	0x58,0x36,0x38,0x53,0x66,0x00,0xfe,0x74,
	0x0c,0xa9,0x43,0x53,0x49,0x31,0x00,0x04,
	0x66,0x00,0xfe,0x68,0x1d,0x69,0x00,0x0e,
	0x05,0xb0,0x3d,0x7c,0x00,0x00,0x05,0xac,
	0x3d,0x7c,0x00,0x00,0x05,0xae,0x0c,0x29,
	0x00,0x01,0x00,0x0f,0x67,0x10,0x0c,0x29,
	0x00,0x02,0x00,0x0f,0x66,0x0e,0x3d,0x7c,
	0xff,0xff,0x05,0xae,0x60,0x06,0x3d,0x7c,
	0xff,0xff,0x05,0xac,0x61,0x00,0x03,0xb6,
	0x4a,0x80,0x66,0x00,0xfe,0x2e,0x4a,0x46,
	0x67,0x00,0xfe,0x28,0x3d,0x7c,0x00,0x00,
	0x05,0xb2,0x3d,0x46,0x05,0xb4,0x4a,0xae,
	0x05,0xca,0x67,0x06,0x41,0xfa,0x30,0x8a,
	0x60,0x04,0x41,0xfa,0x19,0x4c,0x2d,0x48,
	0x05,0xce,0xd1,0xfc,0x00,0x00,0x10,0x00,
	0x2b,0x48,0x00,0x0e,0x10,0x2d,0x00,0x16,
	0xd0,0x06,0x04,0x00,0x00,0x17,0x65,0x02,
	0x9c,0x00,0x1b,0x46,0x00,0x0d,0x41,0xee,
	0x05,0x44,0x2b,0x48,0x00,0x12,0x43,0xee,
	0x04,0x04,0x70,0x0e,0x20,0xc9,0x43,0xe9,
	0x00,0x14,0x51,0xc8,0xff,0xf8,0x1b,0x7a,
	0xfd,0x06,0x00,0x16,0x70,0x0f,0x41,0xee,
	0x05,0x84,0x10,0xfc,0xff,0xff,0x51,0xc8,
	0xff,0xfa,0x24,0x2e,0x05,0xa8,0x05,0xf9,
	0x00,0x00,0x0c,0xec,0x70,0x00,0x3d,0x40,
	0x05,0xc4,0x2d,0x40,0x05,0xc6,0x2d,0x40,
	0x0d,0xd2,0x2d,0x40,0x0d,0xd6,0x61,0x00,
	0x02,0xa6,0x60,0x00,0xfd,0x74,0x4a,0x6e,
	0x05,0xac,0x66,0x22,0x4a,0x6e,0x05,0xae,
	0x66,0x1c,0x72,0x09,0x70,0xf5,0x4e,0x4f,
	0x02,0x00,0x00,0xc0,0x67,0x06,0x72,0x00,
	0x70,0xf5,0x4e,0x4f,0x1b,0x7c,0x00,0x01,
	0x00,0x0e,0x60,0x00,0xfd,0x4c,0x61,0x00,
	0x01,0xea,0x4a,0x80,0x67,0x02,0x60,0x1c,
	0x70,0x00,0x10,0x2d,0x00,0x01,0x41,0xee,
	0x05,0x84,0x41,0xf0,0x00,0x00,0x4a,0x10,
	0x66,0x0a,0x1b,0x7c,0x00,0x01,0x00,0x0e,
	0x60,0x00,0xfd,0x26,0x70,0x00,0x10,0x2d,
	0x00,0x01,0x41,0xee,0x05,0x84,0x41,0xf0,
	0x00,0x00,0x10,0xbc,0x00,0x00,0x1b,0x7c,
	0xff,0xff,0x00,0x0e,0x60,0x00,0xfd,0x0a,
	0x4a,0x6e,0x05,0xac,0x66,0x40,0x4a,0x6e,
	0x05,0xae,0x66,0x3a,0x72,0x09,0x70,0xf5,
	0x4e,0x4f,0x02,0x00,0x00,0xc0,0x67,0x06,
	0x72,0x00,0x70,0xf5,0x4e,0x4f,0x0c,0x2d,
	0x00,0x08,0x00,0x0d,0x64,0x16,0x1b,0x7c,
	0x00,0x42,0x00,0x0d,0x4a,0x6e,0x05,0xc4,
	0x67,0x06,0x08,0xed,0x00,0x03,0x00,0x0d,
	0x60,0x00,0xfc,0xce,0x1b,0x7c,0xff,0xff,
	0x00,0x0d,0x60,0x00,0xfc,0xc4,0x10,0x2d,
	0x00,0x0d,0x67,0x2c,0xb0,0x3c,0x00,0x01,
	0x67,0x62,0xb0,0x3c,0x00,0x02,0x67,0x6e,
	0xb0,0x3c,0x00,0x03,0x67,0x00,0x00,0x88,
	0xb0,0x3c,0x00,0x06,0x67,0x70,0xb0,0x3c,
	0x00,0x07,0x67,0x00,0x00,0x90,0x1b,0x7c,
	0xff,0xff,0x00,0x0d,0x60,0x00,0xfc,0x92,
	0x61,0x00,0x01,0x30,0x4a,0x80,0x67,0x10,
	0x0c,0x40,0x00,0x01,0x67,0x0a,0x0c,0x40,
	0x70,0x02,0x67,0x1e,0x60,0x00,0xfc,0x7c,
	0x4a,0x6e,0x0d,0xda,0x66,0x0a,0x1b,0x7c,
	0x00,0x02,0x00,0x0d,0x60,0x00,0x00,0xa2,
	0x1b,0x7c,0x00,0x0a,0x00,0x0d,0x60,0x00,
	0x00,0x98,0x1b,0x7c,0x00,0x04,0x00,0x0d,
	0x60,0x00,0x00,0x8e,0x4a,0xae,0x05,0xba,
	0x66,0xbe,0x4a,0xae,0x05,0xb6,0x66,0xb8,
	0x61,0x00,0x00,0xa6,0x60,0xe4,0x2d,0x7c,
	0xff,0xff,0xff,0xff,0x05,0xb6,0x4a,0xae,
	0x05,0xba,0x67,0x56,0x60,0xba,0x2d,0x7c,
	0xff,0xff,0xff,0xff,0x05,0xba,0x4a,0xae,
	0x05,0xb6,0x67,0x46,0x60,0xaa,0x4a,0xae,
	0x05,0xb6,0x67,0xa4,0x2d,0x7c,0x00,0x00,
	0x00,0x00,0x05,0xb6,0x4a,0xae,0x05,0xba,
	0x67,0x1a,0x60,0x94,0x4a,0xae,0x05,0xba,
	0x67,0x8e,0x2d,0x7c,0x00,0x00,0x00,0x00,
	0x05,0xba,0x4a,0xae,0x05,0xb6,0x67,0x04,
	0x60,0x00,0xff,0x7e,0x70,0xf5,0x72,0x32,
	0x28,0x2e,0x05,0xa8,0x76,0x00,0x4e,0x4f,
	0x4a,0x80,0x66,0x00,0xff,0x54,0x60,0x00,
	0xff,0x68,0x70,0xf5,0x72,0x32,0x28,0x2e,
	0x05,0xa8,0x76,0x01,0x4e,0x4f,0x4a,0x80,
	0x66,0x00,0xff,0x3e,0x60,0x00,0xff,0x52,
	0x4a,0x6e,0x05,0xc4,0x67,0x06,0x08,0xed,
	0x00,0x03,0x00,0x0d,0x4a,0xae,0x05,0xb6,
	0x67,0x06,0x08,0xed,0x00,0x04,0x00,0x0d,
	0x4a,0xae,0x05,0xba,0x67,0x06,0x08,0xed,
	0x00,0x06,0x00,0x0d,0x60,0x00,0xfb,0xa2,
	0x4a,0x6e,0x05,0xac,0x66,0x08,0x4a,0x6e,
	0x05,0xae,0x66,0x28,0x4e,0x75,0x70,0x02,
	0x4e,0x4f,0x08,0x00,0x00,0x03,0x66,0x0e,
	0x70,0xf5,0x72,0x30,0x28,0x2e,0x05,0xa8,
	0x76,0x00,0x4e,0x4f,0x4e,0x75,0x70,0xf5,
	0x72,0x30,0x28,0x2e,0x05,0xa8,0x76,0x01,
	0x4e,0x4f,0x4e,0x75,0x70,0xf5,0x72,0x2f,
	0x28,0x2e,0x05,0xa8,0x76,0x02,0x4e,0x4f,
	0x4e,0x75,0x48,0xe7,0x70,0xc0,0x70,0x7f,
	0x4e,0x4f,0xb2,0xae,0x0d,0xd6,0x66,0x12,
	0x24,0x2e,0x0d,0xd2,0x26,0x00,0x96,0x82,
	0x0c,0x83,0x00,0x00,0x00,0x64,0x65,0x00,
	0x00,0xe2,0x2d,0x40,0x0d,0xd2,0x2d,0x41,
	0x0d,0xd6,0x72,0x09,0x70,0xf5,0x4e,0x4f,
	0x02,0x00,0x00,0xc0,0x67,0x06,0x72,0x00,
	0x70,0xf5,0x4e,0x4f,0x20,0x3c,0x00,0x00,
	0x00,0xf5,0x72,0x24,0x28,0x2e,0x05,0xa8,
	0x4e,0x4f,0x4a,0x80,0x67,0x00,0x00,0x92,
	0xb0,0xbc,0x00,0x00,0x00,0x08,0x67,0xd2,
	0xb0,0xbc,0x00,0x00,0x00,0x02,0x66,0x00,
	0x00,0x8a,0x61,0x00,0x07,0x16,0x4a,0x40,
	0x67,0xc0,0xb0,0x7c,0x00,0x01,0x66,0x70,
	0x70,0x0f,0x41,0xee,0x05,0x84,0x10,0xfc,
	0xff,0xff,0x51,0xc8,0xff,0xfa,0x61,0x00,
	0x01,0x26,0x4a,0x80,0x67,0x0c,0x3d,0x7c,
	0xff,0xff,0x05,0xb2,0x60,0x5c,0x48,0xe7,
	0x70,0xc0,0x28,0x2e,0x05,0xa8,0x76,0x04,
	0x43,0xee,0x05,0xd2,0x74,0x3f,0x72,0x29,
	0x70,0xf5,0x4e,0x4f,0x4a,0x80,0x67,0x20,
	0x0c,0x80,0x00,0x00,0x00,0x08,0x67,0xe2,
	0x0c,0x80,0x00,0x00,0x00,0x02,0x66,0x32,
	0x61,0x00,0x06,0xc0,0x4a,0x40,0x67,0xd2,
	0xb0,0x7c,0x00,0x01,0x66,0x1a,0x60,0xa8,
	0x08,0x29,0x00,0x07,0x00,0x02,0x67,0x08,
	0x3d,0x7c,0xff,0xff,0x0d,0xda,0x60,0x06,
	0x3d,0x7c,0x00,0x00,0x0d,0xda,0x70,0x01,
	0x2d,0x40,0x0d,0xdc,0x4c,0xdf,0x03,0x0e,
	0x4e,0x75,0x2d,0x7c,0x00,0x00,0x00,0x00,
	0x0d,0xd2,0x2d,0x7c,0x00,0x00,0x00,0x00,
	0x0d,0xd6,0x70,0xff,0x4c,0xdf,0x03,0x0e,
	0x4e,0x75,0x20,0x2e,0x0d,0xdc,0x4c,0xdf,
	0x03,0x0e,0x4e,0x75,0x43,0xee,0x05,0xd2,
	0x2a,0x2e,0x05,0xa4,0x74,0x02,0xe5,0x8a,
	0xea,0xaa,0x76,0x01,0xe5,0x8b,0xea,0xab,
	0x28,0x2e,0x05,0xa8,0x70,0xf5,0x72,0x21,
	0x4e,0x4f,0x4a,0x80,0x66,0x76,0x0c,0x91,
	0x58,0x36,0x38,0x4b,0x66,0x6c,0x26,0x49,
	0x45,0xee,0x04,0x04,0x7c,0x00,0x7e,0x0e,
	0x47,0xeb,0x00,0x10,0x4a,0x13,0x67,0x52,
	0x0c,0x93,0x48,0x75,0x6d,0x61,0x66,0x4a,
	0x0c,0xab,0x6e,0x36,0x38,0x6b,0x00,0x04,
	0x66,0x40,0x10,0x2b,0x00,0x08,0x08,0x00,
	0x00,0x00,0x66,0x36,0x24,0x2b,0x00,0x08,
	0x43,0xee,0x00,0x04,0x2a,0x2e,0x05,0xa4,
	0xe5,0x8a,0xea,0xaa,0x76,0x01,0xe5,0x8b,
	0xea,0xab,0x28,0x2e,0x05,0xa8,0x70,0xf5,
	0x72,0x21,0x4e,0x4f,0x4a,0x80,0x66,0x1c,
	0x43,0xe9,0x00,0x12,0x4a,0x51,0x67,0x0a,
	0x72,0x04,0x24,0xd9,0x51,0xc9,0xff,0xfc,
	0x52,0x46,0x51,0xcf,0xff,0xa4,0x70,0x00,
	0x4e,0x75,0x70,0xff,0x4e,0x75,0x43,0xee,
	0x05,0xd2,0x2a,0x2e,0x05,0xa4,0x74,0x02,
	0xe5,0x8a,0xea,0xaa,0x76,0x01,0xe5,0x8b,
	0xea,0xab,0x28,0x2e,0x05,0xa8,0x70,0xf5,
	0x72,0x21,0x4e,0x4f,0x4a,0x80,0x66,0xdc,
	0x0c,0x91,0x58,0x36,0x38,0x4b,0x66,0xd2,
	0x26,0x49,0x45,0xee,0x04,0x04,0x7c,0x00,
	0x7e,0x0e,0x47,0xeb,0x00,0x10,0x4a,0x13,
	0x67,0x54,0x0c,0x93,0x48,0x75,0x6d,0x61,
	0x66,0x4c,0x0c,0xab,0x6e,0x36,0x38,0x6b,
	0x00,0x04,0x66,0x42,0x10,0x2b,0x00,0x08,
	0x08,0x00,0x00,0x00,0x66,0x38,0x24,0x2b,
	0x00,0x08,0x43,0xee,0x00,0x04,0x2a,0x2e,
	0x05,0xa4,0xea,0xaa,0xe5,0x8a,0x76,0x01,
	0xe5,0x8b,0xea,0xab,0x28,0x2e,0x05,0xa8,
	0x70,0xf5,0x72,0x21,0x4e,0x4f,0x4a,0x80,
	0x66,0x82,0x43,0xe9,0x00,0x12,0x72,0x04,
	0x20,0x19,0xb0,0x9a,0x66,0x00,0xff,0x74,
	0x51,0xc9,0xff,0xf6,0x52,0x46,0x51,0xcf,
	0xff,0xa2,0xbc,0x6e,0x05,0xb4,0x66,0x00,
	0xff,0x62,0x70,0x00,0x4e,0x75,0x3d,0x7c,
	0x00,0x08,0x05,0xc2,0x3d,0x7c,0x00,0x00,
	0x05,0xc0,0x4a,0x6e,0x05,0xb2,0x67,0x44,
	0x61,0x00,0xff,0x4c,0x4a,0x80,0x67,0x2c,
	0x0c,0x80,0xff,0xff,0xff,0xff,0x67,0x2c,
	0x0c,0x80,0x00,0x00,0x00,0x08,0x67,0xe8,
	0x0c,0x80,0x00,0x00,0x00,0x02,0x66,0x00,
	0xf8,0xe2,0x61,0x00,0x04,0xfe,0x4a,0x40,
	0x67,0x0a,0x0c,0x40,0x00,0x01,0x67,0xd0,
	0x60,0x00,0xf8,0xd8,0x3d,0x7c,0x00,0x00,
	0x05,0xb2,0x67,0x08,0x30,0x3c,0x70,0x07,
	0x60,0x00,0xf8,0xc8,0x4a,0x2e,0x05,0xb0,
	0x66,0x06,0x72,0x21,0x60,0x00,0x00,0x8a,
	0x72,0x26,0x60,0x00,0x01,0xec,0x3d,0x7c,
	0x00,0x08,0x05,0xc2,0x3d,0x7c,0xff,0xff,
	0x05,0xc0,0x60,0x0c,0x3d,0x7c,0x00,0x08,
	0x05,0xc2,0x3d,0x7c,0x00,0x00,0x05,0xc0,
	0x4a,0x6e,0x05,0xc4,0x67,0x08,0x30,0x3c,
	0x70,0x0d,0x60,0x00,0xf8,0x8e,0x4a,0x6e,
	0x05,0xb2,0x67,0x44,0x61,0x00,0xfe,0xc8,
	0x4a,0x80,0x67,0x2c,0x0c,0x80,0xff,0xff,
	0xff,0xff,0x67,0x2c,0x0c,0x80,0x00,0x00,
	0x00,0x08,0x67,0xe8,0x0c,0x80,0x00,0x00,
	0x00,0x02,0x66,0x00,0xf8,0x5e,0x61,0x00,
	0x04,0x7a,0x4a,0x40,0x67,0x0a,0xb0,0x7c,
	0x00,0x01,0x67,0xd0,0x60,0x00,0xf8,0x54,
	0x3d,0x7c,0x00,0x00,0x05,0xb2,0x67,0x08,
	0x30,0x3c,0x70,0x07,0x60,0x00,0xf8,0x44,
	0x4a,0x2e,0x05,0xb0,0x66,0x04,0x72,0x22,
	0x60,0x06,0x72,0x27,0x60,0x00,0x01,0x6a,
	0x2d,0x6d,0x00,0x0e,0x05,0x94,0x2d,0x6d,
	0x00,0x12,0x05,0x9c,0x70,0x00,0x10,0x2d,
	0x00,0x01,0xe5,0x88,0x41,0xee,0x05,0x44,
	0xd1,0xc0,0x20,0x50,0x20,0x2d,0x00,0x16,
	0xd0,0xa8,0x00,0x10,0x2d,0x40,0x05,0x98,
	0x3c,0x2e,0x05,0xa0,0x24,0x2e,0x05,0x98,
	0xed,0xaa,0x2e,0x2e,0x05,0x9c,0xed,0xaf,
	0x22,0x6e,0x05,0x94,0x26,0x07,0xb6,0xbc,
	0x00,0x00,0x01,0x00,0x63,0x06,0x26,0x3c,
	0x00,0x00,0x01,0x00,0x70,0xf5,0x28,0x2e,
	0x05,0xa8,0x2a,0x2e,0x05,0xa4,0x4e,0x4f,
	0x4a,0x80,0x67,0x00,0x00,0xd2,0xb0,0xbc,
	0xff,0xff,0xff,0xff,0x67,0x00,0x00,0xea,
	0xb0,0xbc,0xff,0xff,0xff,0xfe,0x67,0x00,
	0x00,0xaa,0xb0,0xbc,0x00,0x00,0x00,0x08,
	0x67,0x86,0xb0,0xbc,0x00,0x00,0x00,0x02,
	0x66,0x00,0xf7,0xa8,0x61,0x00,0x03,0xc4,
	0x4a,0x40,0x67,0x00,0xff,0x74,0xb0,0x7c,
	0x00,0x01,0x67,0x00,0xff,0x6c,0x0c,0x40,
	0x70,0x07,0x66,0x00,0xf7,0x96,0x0c,0x81,
	0x00,0x00,0x00,0x22,0x66,0x00,0xf7,0x8c,
	0x43,0xee,0x05,0xd2,0x08,0x11,0x00,0x07,
	0x67,0x00,0xf7,0x80,0x43,0xe9,0x00,0x03,
	0x10,0x19,0xe1,0x88,0x10,0x19,0xe1,0x88,
	0x10,0x19,0xe1,0x88,0x10,0x19,0x2d,0x40,
	0x0d,0xe0,0x61,0x00,0x03,0x5a,0x4a,0x80,
	0x67,0x00,0xff,0x2e,0xb0,0xbc,0xff,0xff,
	0xff,0xff,0x67,0x74,0xb0,0xbc,0xff,0xff,
	0xff,0xfe,0x67,0x36,0xb0,0xbc,0x00,0x00,
	0x00,0x08,0x67,0xde,0xb0,0xbc,0x00,0x00,
	0x00,0x02,0x66,0x00,0xf7,0x36,0x61,0x00,
	0x03,0x52,0x4a,0x40,0x67,0x00,0xff,0x02,
	0xb0,0x7c,0x00,0x01,0x67,0xc4,0x67,0x00,
	0xf7,0x2a,0x52,0xae,0x05,0xc6,0x53,0x6e,
	0x05,0xc2,0x66,0x00,0xfe,0xec,0x60,0x00,
	0xf7,0x1a,0x52,0xae,0x05,0xc6,0x53,0x6e,
	0x05,0xc2,0x66,0x00,0xfe,0xdc,0x30,0x3c,
	0x70,0x0c,0x60,0x00,0xf7,0x06,0x20,0x03,
	0xe1,0x88,0xeb,0xa8,0xd3,0xc0,0xd4,0x83,
	0x9e,0x83,0x62,0x00,0xff,0x00,0x4a,0x6e,
	0x05,0xc0,0x66,0x00,0x01,0x68,0x3d,0x7c,
	0x00,0x00,0x05,0xbe,0x60,0x00,0xf6,0xe2,
	0x4a,0x6e,0x05,0xbe,0x66,0x00,0xf6,0xd4,
	0x72,0x00,0x70,0xf5,0x4e,0x4f,0x3d,0x7c,
	0xff,0xff,0x05,0xbe,0x60,0x00,0xfe,0x9a,
	0x2d,0x6d,0x00,0x0e,0x05,0x94,0x2d,0x6d,
	0x00,0x12,0x05,0x9c,0x70,0x00,0x10,0x2d,
	0x00,0x01,0xe5,0x88,0x41,0xee,0x05,0x44,
	0xd1,0xc0,0x20,0x50,0x20,0x2d,0x00,0x16,
	0xd0,0xa8,0x00,0x10,0x2d,0x40,0x05,0x98,
	0x3c,0x2e,0x05,0xa0,0x24,0x2e,0x05,0x98,
	0xed,0xaa,0x26,0x2e,0x05,0x9c,0xed,0xab,
	0x22,0x6e,0x05,0x94,0x70,0xf5,0x28,0x2e,
	0x05,0xa8,0x2a,0x2e,0x05,0xa4,0x4e,0x4f,
	0x4a,0x80,0x67,0x00,0x00,0xd0,0xb0,0xbc,
	0xff,0xff,0xff,0xff,0x67,0x00,0x00,0xd6,
	0xb0,0xbc,0xff,0xff,0xff,0xfe,0x67,0x00,
	0x00,0xa8,0xb0,0xbc,0x00,0x00,0x00,0x08,
	0x67,0x96,0xb0,0xbc,0x00,0x00,0x00,0x02,
	0x66,0x00,0xf6,0x50,0x61,0x00,0x02,0x6c,
	0x4a,0x40,0x67,0x84,0xb0,0x7c,0x00,0x01,
	0x67,0x00,0xff,0x7e,0x0c,0x40,0x70,0x07,
	0x66,0x00,0xf6,0x40,0x0c,0x81,0x00,0x00,
	0x00,0x27,0x66,0x00,0xf6,0x36,0x43,0xee,
	0x05,0xd2,0x08,0x11,0x00,0x07,0x67,0x00,
	0xf6,0x2a,0x43,0xe9,0x00,0x03,0x10,0x19,
	0xe1,0x88,0x10,0x19,0xe1,0x88,0x10,0x19,
	0xe1,0x88,0x10,0x19,0x2d,0x40,0x0d,0xe0,
	0x61,0x00,0x02,0x04,0x4a,0x80,0x67,0x00,
	0xff,0x40,0xb0,0xbc,0xff,0xff,0xff,0xff,
	0x67,0x62,0xb0,0xbc,0xff,0xff,0xff,0xfe,
	0x67,0x36,0xb0,0xbc,0x00,0x00,0x00,0x08,
	0x67,0xde,0xb0,0xbc,0x00,0x00,0x00,0x02,
	0x66,0x00,0xf5,0xe0,0x61,0x00,0x01,0xfc,
	0x4a,0x40,0x67,0x00,0xff,0x14,0xb0,0x7c,
	0x00,0x01,0x67,0xc4,0x60,0x00,0xf5,0xd4,
	0x52,0xae,0x05,0xc6,0x53,0x6e,0x05,0xc2,
	0x66,0x00,0xfe,0xfe,0x60,0x00,0xf5,0xc4,
	0x52,0xae,0x05,0xc6,0x53,0x6e,0x05,0xc2,
	0x66,0x00,0xfd,0x86,0x30,0x3c,0x70,0x0c,
	0x60,0x00,0xf5,0xb0,0x3d,0x7c,0x00,0x00,
	0x05,0xbe,0x4a,0x6e,0x05,0xc0,0x66,0x1c,
	0x60,0x00,0xf5,0x9e,0x4a,0x6e,0x05,0xbe,
	0x66,0x00,0xf5,0x90,0x72,0x00,0x70,0xf5,
	0x4e,0x4f,0x3d,0x7c,0xff,0xff,0x05,0xbe,
	0x60,0x00,0xfe,0xbe,0x3d,0x7c,0x00,0x08,
	0x05,0xc2,0x2d,0x6d,0x00,0x0e,0x05,0x94,
	0x2d,0x6d,0x00,0x12,0x05,0x9c,0x70,0x00,
	0x10,0x2d,0x00,0x01,0xe5,0x88,0x41,0xee,
	0x05,0x44,0xd1,0xc0,0x20,0x50,0x20,0x2d,
	0x00,0x16,0xd0,0xa8,0x00,0x10,0x2d,0x40,
	0x05,0x98,0x3a,0x2e,0x05,0xa0,0x24,0x2e,
	0x05,0x98,0xeb,0xaa,0x2e,0x2e,0x05,0x9c,
	0xeb,0xaf,0x7c,0x04,0xeb,0xae,0x28,0x2e,
	0x05,0xa8,0x2a,0x2e,0x05,0xa4,0x24,0x6e,
	0x05,0x94,0xbe,0x86,0x64,0x04,0x26,0x07,
	0x60,0x02,0x26,0x06,0x22,0x6e,0x05,0xce,
	0x72,0x21,0x70,0xf5,0x4e,0x4f,0x4a,0x80,
	0x67,0x00,0x00,0xc8,0xb0,0xbc,0xff,0xff,
	0xff,0xff,0x67,0x00,0x00,0xe4,0xb0,0xbc,
	0xff,0xff,0xff,0xfe,0x67,0x00,0x00,0xa0,
	0xb0,0xbc,0x00,0x00,0x00,0x08,0x67,0x00,
	0xff,0x7c,0xb0,0xbc,0x00,0x00,0x00,0x02,
	0x66,0x00,0xf4,0xf0,0x61,0x00,0x01,0x0c,
	0x4a,0x40,0x67,0x00,0xff,0x68,0xb0,0x7c,
	0x00,0x01,0x67,0x00,0xff,0x60,0x0c,0x40,
	0x70,0x07,0x66,0x00,0xf4,0xde,0x43,0xee,
	0x05,0xd2,0x08,0x11,0x00,0x07,0x67,0x00,
	0xf4,0xd2,0x43,0xe9,0x00,0x03,0x10,0x19,
	0xe1,0x88,0x10,0x19,0xe1,0x88,0x10,0x19,
	0xe1,0x88,0x10,0x19,0x2d,0x40,0x0d,0xe0,
	0x61,0x00,0x00,0xac,0x4a,0x80,0x67,0x00,
	0xfc,0x70,0xb0,0xbc,0xff,0xff,0xff,0xff,
	0x67,0x76,0xb0,0xbc,0xff,0xff,0xff,0xfe,
	0x67,0x34,0xb0,0xbc,0x00,0x00,0x00,0x08,
	0x67,0xde,0xb0,0xbc,0x00,0x00,0x00,0x02,
	0x66,0x00,0xf4,0x88,0x61,0x00,0x00,0xa4,
	0x4a,0x40,0x67,0xcc,0xb0,0x7c,0x00,0x01,
	0x67,0xc6,0x60,0x00,0xf4,0x7e,0x52,0xae,
	0x05,0xc6,0x53,0x6e,0x05,0xc2,0x66,0x00,
	0xfe,0xec,0x60,0x00,0xf4,0x6e,0x52,0xae,
	0x05,0xc6,0x53,0x6e,0x05,0xc2,0x66,0x00,
	0xfc,0x30,0x30,0x3c,0x70,0x0c,0x60,0x00,
	0xf4,0x5a,0x20,0x03,0xe1,0x88,0xeb,0xa8,
	0x32,0x00,0x53,0x41,0xb5,0x09,0x66,0x30,
	0x51,0xc9,0xff,0xfa,0xd3,0xc0,0xd4,0x83,
	0x9e,0x83,0x62,0x00,0xff,0x06,0x3d,0x7c,
	0x00,0x00,0x05,0xbe,0x60,0x00,0xf4,0x32,
	0x4a,0x6e,0x05,0xbe,0x66,0x00,0xf4,0x24,
	0x72,0x00,0x70,0xf5,0x4e,0x4f,0x3d,0x7c,
	0xff,0xff,0x05,0xbe,0x60,0x00,0xfe,0x96,
	0x3d,0x7c,0x00,0x00,0x05,0xbe,0x30,0x3c,
	0x70,0x0b,0x60,0x00,0xf4,0x0e,0x48,0xe7,
	0x10,0x40,0x20,0x2e,0x0d,0xe0,0x43,0xee,
	0x05,0xd2,0x32,0xfc,0x00,0x00,0x32,0xfc,
	0x00,0x04,0x22,0xc0,0x43,0xee,0x05,0xd2,
	0x76,0x08,0x61,0x64,0x4c,0xdf,0x02,0x08,
	0x4e,0x75,0x48,0xe7,0x40,0x40,0x70,0xf5,
	0x72,0x2c,0x28,0x2e,0x05,0xa8,0x76,0x0e,
	0x43,0xee,0x05,0xd2,0x4e,0x4f,0x4a,0x80,
	0x66,0x18,0x42,0x41,0x12,0x29,0x00,0x02,
	0xe3,0x49,0x43,0xfa,0xf3,0x5a,0x70,0x00,
	0x30,0x31,0x10,0x00,0x4c,0xdf,0x02,0x02,
	0x4e,0x75,0x30,0x3c,0x70,0x0c,0x4c,0xdf,
	0x02,0x02,0x4e,0x75,0x70,0x00,0x10,0x2d,
	0x00,0x01,0xe5,0x88,0x41,0xee,0x05,0x44,
	0xd1,0xc0,0x2b,0x48,0x00,0x12,0x20,0x50,
	0x1b,0x68,0x00,0x0a,0x00,0x0d,0x60,0x00,
	0xf3,0x90,0x07,0x00,0x00,0x00,0x00,0x00,
	0x4e,0x55,0xff,0xf0,0x48,0xe7,0x52,0x70,
	0x26,0x49,0x45,0xfa,0xff,0xee,0x43,0xed,
	0xff,0xf0,0x72,0x05,0x12,0xda,0x51,0xc9,
	0xff,0xfc,0x43,0xed,0xff,0xf0,0x61,0x28,
	0x4a,0x80,0x66,0x1a,0x22,0x4b,0x72,0x05,
	0x70,0xf5,0x4e,0x4f,0x0c,0x80,0xff,0xff,
	0xff,0xff,0x67,0x0a,0x61,0x4c,0x4c,0xdf,
	0x0e,0x4a,0x4e,0x5d,0x4e,0x75,0x70,0xff,
	0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,0x4e,0x75,
	0x48,0xe7,0x68,0x00,0x32,0x3c,0x00,0x01,
	0x72,0x01,0x70,0xf5,0x4e,0x4f,0x4a,0x80,
	0x67,0x06,0x51,0xca,0xff,0xf4,0x60,0x1a,
	0x48,0x44,0xeb,0x0c,0x89,0x29,0x00,0x01,
	0x72,0x03,0x70,0xf5,0x4e,0x4f,0x4a,0x80,
	0x66,0x08,0x70,0x00,0x4c,0xdf,0x00,0x16,
	0x4e,0x75,0x70,0xff,0x4c,0xdf,0x00,0x16,
	0x4e,0x75,0x43,0xed,0xff,0xff,0x72,0x06,
	0x70,0xf5,0x4e,0x4f,0x4a,0x80,0x66,0x1a,
	0x43,0xed,0xff,0xfe,0x72,0x07,0x70,0xf5,
	0x4e,0x4f,0x4a,0x80,0x66,0x0c,0x10,0x2d,
	0xff,0xfe,0x48,0x40,0x10,0x2d,0xff,0xff,
	0x4e,0x75,0x70,0xff,0x4e,0x75,0x0d,0x0a,
	0x53,0x43,0x53,0x49,0x20,0x44,0x49,0x53,
	0x4b,0x20,0x44,0x52,0x49,0x56,0x45,0x52,
	0x20,0x66,0x6f,0x72,0x20,0x58,0x36,0x38,
	0x30,0x30,0x30,0x20,0x76,0x65,0x72,0x73,
	0x69,0x6f,0x6e,0x20,0x31,0x2e,0x30,0x34,
	0x0d,0x0a,0x43,0x6f,0x70,0x79,0x72,0x69,
	0x67,0x68,0x74,0x20,0x31,0x39,0x39,0x30,
	0x2d,0x39,0x32,0x20,0x53,0x48,0x41,0x52,
	0x50,0x2f,0x46,0x69,0x72,0x73,0x74,0x20,
	0x43,0x6c,0x61,0x73,0x73,0x20,0x54,0x65,
	0x63,0x68,0x6e,0x6f,0x6c,0x6f,0x67,0x79,
	0x0d,0x0a
};

//---------------------------------------------------------------------------
//
//	SCSIIOCS ⏕hCo
//	Format.x v2.31擾
//
//---------------------------------------------------------------------------
const BYTE CMOMakeDlg::SCSIIOCS[] = {
	0x48,0xe7,0x08,0x00,0x70,0xf5,0x72,0x0a,
	0x4e,0x4f,0x0c,0x80,0x00,0x00,0x00,0x04,
	0x64,0x36,0x61,0x00,0x00,0xce,0x41,0xfa,
	0x01,0x1c,0x08,0x04,0x00,0x00,0x67,0x08,
	0x20,0xbc,0x00,0xe9,0x60,0x20,0x60,0x0c,
	0x08,0x04,0x00,0x01,0x67,0x1a,0x20,0xbc,
	0x00,0xea,0x00,0x00,0x70,0x80,0x22,0x3c,
	0x00,0x00,0x01,0xf5,0x43,0xfa,0x00,0xfa,
	0x4e,0x4f,0x4c,0xdf,0x00,0x10,0x4e,0x75,
	0x70,0x00,0x4c,0xdf,0x00,0x10,0x4e,0x75,
	0x48,0xe7,0x00,0xa2,0x78,0x00,0x41,0xf9,
	0x00,0xfc,0x00,0x00,0x61,0x00,0x00,0x9e,
	0x4a,0x80,0x66,0x16,0x0c,0xa8,0x53,0x43,
	0x53,0x49,0x00,0x24,0x66,0x0c,0x0c,0x68,
	0x49,0x4e,0x00,0x28,0x66,0x04,0x08,0xc4,
	0x00,0x00,0x41,0xf9,0x00,0xea,0x00,0x20,
	0x61,0x7a,0x4a,0x80,0x66,0x16,0x0c,0xa8,
	0x53,0x43,0x53,0x49,0x00,0x24,0x66,0x0c,
	0x0c,0x68,0x45,0x58,0x00,0x28,0x66,0x04,
	0x08,0xc4,0x00,0x01,0x13,0xfc,0x00,0x31,
	0x00,0xe8,0xe0,0x0d,0x0c,0x39,0x00,0x56,
	0x00,0xed,0x00,0x6f,0x67,0x18,0x13,0xfc,
	0x00,0x56,0x00,0xed,0x00,0x6f,0x13,0xfc,
	0x00,0x07,0x00,0xed,0x00,0x70,0x13,0xfc,
	0x00,0x00,0x00,0xed,0x00,0x71,0x08,0x04,
	0x00,0x00,0x66,0x08,0x08,0xf9,0x00,0x03,
	0x00,0xed,0x00,0x70,0x13,0xfc,0x00,0x00,
	0x00,0xe8,0xe0,0x0d,0x4c,0xdf,0x45,0x00,
	0x4e,0x75,0x61,0x00,0xff,0x6c,0x08,0x39,
	0x00,0x03,0x00,0xed,0x00,0x70,0x66,0x06,
	0x08,0x84,0x00,0x01,0x4e,0x75,0x08,0x84,
	0x00,0x00,0x4e,0x75,0x2c,0x4f,0x43,0xfa,
	0x00,0x28,0x24,0x79,0x00,0x00,0x00,0x08,
	0x23,0xc9,0x00,0x00,0x00,0x08,0x20,0x10,
	0x08,0x00,0x00,0x00,0x66,0x12,0xb0,0xbc,
	0x00,0x20,0x00,0x00,0x65,0x0a,0x23,0xca,
	0x00,0x00,0x00,0x08,0x70,0x00,0x4e,0x75,
	0x2e,0x4e,0x23,0xca,0x00,0x00,0x00,0x08,
	0x70,0xff,0x4e,0x75,0x00,0xe9,0x60,0x20,
	0x48,0xe7,0x50,0x62,0xb2,0xbc,0x00,0x00,
	0x00,0x10,0x65,0x18,0xb2,0xbc,0x00,0x00,
	0x00,0x20,0x65,0x40,0xb2,0xbc,0x00,0x00,
	0x00,0x40,0x65,0x0e,0xb2,0xbc,0x00,0x00,
	0x00,0x20,0x65,0x30,0x45,0xfa,0x00,0x3a,
	0x60,0x16,0x92,0xbc,0x00,0x00,0x00,0x20,
	0x45,0xfa,0x00,0x6e,0x60,0x0a,0x92,0xbc,
	0x00,0x00,0x00,0x40,0x45,0xfa,0x00,0xe2,
	0xe5,0x89,0x2c,0x7a,0xff,0xb8,0x22,0x32,
	0x10,0x00,0xd5,0xc1,0x4e,0x92,0x4c,0xdf,
	0x46,0x0a,0x4e,0x75,0x70,0xff,0x4c,0xdf,
	0x46,0x0a,0x4e,0x75,0x70,0xff,0x4e,0x75,
	0x00,0x00,0x0a,0x08,0x00,0x00,0x0b,0x08,
	0x00,0x00,0x0a,0xe8,0x00,0x00,0x0c,0x16,
	0x00,0x00,0x01,0x56,0x00,0x00,0x01,0x00,
	0x00,0x00,0x0d,0x18,0x00,0x00,0x0d,0x64,
	0x00,0x00,0x0d,0xb0,0x00,0x00,0x0d,0xfa,
	0x00,0x00,0x0e,0x0e,0x00,0x00,0x0c,0xce,
	0x00,0x00,0x0c,0x84,0xff,0xff,0xff,0xfc,
	0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0xfc,
	0x00,0x00,0x01,0x76,0x00,0x00,0x03,0x00,
	0x00,0x00,0x03,0x6e,0x00,0x00,0x04,0xde,
	0x00,0x00,0x0f,0x4e,0x00,0x00,0x10,0x0a,
	0x00,0x00,0x03,0xe0,0x00,0x00,0x04,0x4c,
	0x00,0x00,0x04,0xca,0x00,0x00,0x02,0x12,
	0x00,0x00,0x02,0x64,0x00,0x00,0x0f,0x6c,
	0x00,0x00,0x01,0xc4,0x00,0x00,0x05,0xe2,
	0x00,0x00,0x0f,0x8a,0x00,0x00,0x05,0x60,
	0x00,0x00,0x05,0xa0,0x00,0x00,0x02,0xb6,
	0x00,0x00,0x05,0x20,0xff,0xff,0xff,0xbc,
	0xff,0xff,0xff,0xbc,0xff,0xff,0xff,0xbc,
	0x00,0x00,0x06,0x2c,0x00,0x00,0x06,0x80,
	0x00,0x00,0x06,0xce,0x00,0x00,0x07,0x1a,
	0xff,0xff,0xff,0xbc,0xff,0xff,0xff,0xbc,
	0xff,0xff,0xff,0xbc,0xff,0xff,0xff,0xbc,
	0xff,0xff,0xff,0xbc,0xff,0xff,0xff,0xbc,
	0xff,0xff,0xff,0x3c,0xff,0xff,0xff,0x3c,
	0xff,0xff,0xff,0x3c,0xff,0xff,0xff,0x3c,
	0xff,0xff,0xff,0x3c,0xff,0xff,0xff,0x3c,
	0xff,0xff,0xff,0x3c,0xff,0xff,0xff,0x3c,
	0xff,0xff,0xff,0x3c,0xff,0xff,0xff,0x3c,
	0xff,0xff,0xff,0x3c,0xff,0xff,0xff,0x3c,
	0xff,0xff,0xff,0x3c,0xff,0xff,0xff,0x3c,
	0xff,0xff,0xff,0x3c,0xff,0xff,0xff,0x3c,
	0x48,0xe7,0x00,0x02,0x2c,0x7a,0xfe,0x96,
	0x10,0x2e,0x00,0x09,0x08,0x00,0x00,0x05,
	0x66,0x38,0x10,0x2e,0x00,0x0b,0x08,0x00,
	0x00,0x07,0x67,0xec,0x02,0x00,0x00,0x07,
	0xb0,0x3c,0x00,0x00,0x66,0x1a,0x61,0x00,
	0x06,0x94,0x48,0x40,0x66,0x06,0x4c,0xdf,
	0x40,0x00,0x4e,0x75,0x4a,0x40,0x67,0x08,
	0x48,0x40,0x4c,0xdf,0x40,0x00,0x4e,0x75,
	0x10,0x2e,0x00,0x0b,0x4c,0xdf,0x40,0x00,
	0x4e,0x75,0x61,0x00,0x08,0xbc,0x70,0xff,
	0x4c,0xdf,0x40,0x00,0x4e,0x75,0x48,0xe7,
	0x00,0x02,0x2c,0x7a,0xfe,0x40,0x10,0x2e,
	0x00,0x09,0x08,0x00,0x00,0x05,0x66,0x3c,
	0x10,0x2e,0x00,0x0b,0x08,0x00,0x00,0x07,
	0x67,0xec,0x02,0x00,0x00,0x07,0x02,0x00,
	0x00,0x07,0xb0,0x3c,0x00,0x01,0x66,0x1a,
	0x61,0x00,0x06,0x46,0x48,0x40,0x66,0x06,
	0x4c,0xdf,0x40,0x00,0x4e,0x75,0x4a,0x40,
	0x67,0x08,0x48,0x40,0x4c,0xdf,0x40,0x00,
	0x4e,0x75,0x10,0x2e,0x00,0x0b,0x4c,0xdf,
	0x40,0x00,0x4e,0x75,0x61,0x00,0x08,0x62,
	0x70,0xff,0x4c,0xdf,0x40,0x00,0x4e,0x75,
	0x12,0x00,0x00,0x00,0x00,0x00,0x4e,0x55,
	0xff,0xf0,0x48,0xe7,0x52,0x70,0x26,0x49,
	0x45,0xfa,0xff,0xee,0x43,0xed,0xff,0xf0,
	0x72,0x05,0x12,0xda,0x51,0xc9,0xff,0xfc,
	0x43,0xed,0xff,0xf0,0x13,0x43,0x00,0x04,
	0x61,0x00,0x0e,0xb8,0x4a,0x80,0x66,0x00,
	0x05,0xd2,0x22,0x4b,0x61,0x00,0x0a,0xe8,
	0x0c,0x80,0xff,0xff,0xff,0xff,0x67,0x00,
	0x05,0xc2,0x61,0x00,0x0e,0xea,0x4c,0xdf,
	0x0e,0x4a,0x4e,0x5d,0x4e,0x75,0x03,0x00,
	0x00,0x00,0x00,0x00,0x4e,0x55,0xff,0xf0,
	0x48,0xe7,0x52,0x70,0x26,0x49,0x45,0xfa,
	0xff,0xee,0x43,0xed,0xff,0xf0,0x72,0x05,
	0x12,0xda,0x51,0xc9,0xff,0xfc,0x43,0xed,
	0xff,0xf0,0x13,0x43,0x00,0x04,0x61,0x00,
	0x0e,0x6a,0x4a,0x80,0x66,0x00,0x05,0x84,
	0x22,0x4b,0x61,0x00,0x0a,0x9a,0x0c,0x80,
	0xff,0xff,0xff,0xff,0x67,0x00,0x05,0x74,
	0x61,0x00,0x0e,0x9c,0x4c,0xdf,0x0e,0x4a,
	0x4e,0x5d,0x4e,0x75,0x1a,0x00,0x00,0x00,
	0x00,0x00,0x4e,0x55,0xff,0xf0,0x48,0xe7,
	0x52,0x70,0x26,0x49,0x45,0xfa,0xff,0xee,
	0x43,0xed,0xff,0xf0,0x72,0x05,0x12,0xda,
	0x51,0xc9,0xff,0xfc,0x43,0xed,0xff,0xf0,
	0x13,0x43,0x00,0x04,0x13,0x42,0x00,0x02,
	0x61,0x00,0x0e,0x18,0x4a,0x80,0x66,0x00,
	0x05,0x32,0x22,0x4b,0x61,0x00,0x0a,0x48,
	0x0c,0x80,0xff,0xff,0xff,0xff,0x67,0x00,
	0x05,0x22,0x61,0x00,0x0e,0x4a,0x4c,0xdf,
	0x0e,0x4a,0x4e,0x5d,0x4e,0x75,0x15,0x00,
	0x00,0x00,0x00,0x00,0x4e,0x55,0xff,0xf0,
	0x48,0xe7,0x52,0x70,0x26,0x49,0x45,0xfa,
	0xff,0xee,0x43,0xed,0xff,0xf0,0x72,0x05,
	0x12,0xda,0x51,0xc9,0xff,0xfc,0x43,0xed,
	0xff,0xf0,0x13,0x43,0x00,0x04,0x13,0x42,
	0x00,0x01,0x61,0x00,0x0d,0xc6,0x4a,0x80,
	0x66,0x00,0x04,0xe0,0x22,0x4b,0x61,0x00,
	0x09,0xac,0x0c,0x80,0xff,0xff,0xff,0xff,
	0x67,0x00,0x04,0xd0,0x61,0x00,0x0d,0xf8,
	0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,0x4e,0x75,
	0x07,0x00,0x00,0x00,0x00,0x00,0x4e,0x55,
	0xff,0xf0,0x48,0xe7,0x52,0x70,0x26,0x49,
	0x45,0xfa,0xff,0xee,0x43,0xed,0xff,0xf0,
	0x72,0x05,0x12,0xda,0x51,0xc9,0xff,0xfc,
	0x43,0xed,0xff,0xf0,0x61,0x00,0x0d,0x7c,
	0x4a,0x80,0x66,0x00,0x04,0x96,0x22,0x4b,
	0x61,0x00,0x09,0x62,0x0c,0x80,0xff,0xff,
	0xff,0xff,0x67,0x00,0x04,0x86,0x61,0x00,
	0x0d,0xae,0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,
	0x4e,0x75,0x08,0x00,0x00,0x00,0x00,0x00,
	0x4e,0x55,0xff,0xf0,0x48,0xe7,0x52,0x70,
	0x26,0x49,0x45,0xfa,0xff,0xee,0x43,0xed,
	0xff,0xf0,0x72,0x05,0x12,0xda,0x51,0xc9,
	0xff,0xfc,0x2c,0x02,0x43,0xed,0xff,0xf0,
	0x13,0x46,0x00,0x03,0xe0,0x8e,0x13,0x46,
	0x00,0x02,0xe0,0x8e,0x13,0x46,0x00,0x01,
	0x13,0x43,0x00,0x04,0x61,0x00,0x0d,0x1c,
	0x4a,0x80,0x66,0x00,0x04,0x36,0xe1,0x8b,
	0xeb,0xab,0x22,0x4b,0x61,0x00,0xfd,0xd0,
	0x0c,0x80,0xff,0xff,0xff,0xff,0x67,0x00,
	0x04,0x22,0x0c,0x80,0xff,0xff,0xff,0xfe,
	0x67,0x00,0x01,0x54,0x61,0x00,0x0d,0x40,
	0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,0x4e,0x75,
	0x0a,0x00,0x00,0x00,0x00,0x00,0x4e,0x55,
	0xff,0xf0,0x48,0xe7,0x52,0x70,0x26,0x49,
	0x45,0xfa,0xff,0xee,0x43,0xed,0xff,0xf0,
	0x72,0x05,0x12,0xda,0x51,0xc9,0xff,0xfc,
	0x2c,0x02,0x43,0xed,0xff,0xf0,0x13,0x46,
	0x00,0x03,0xe0,0x8e,0x13,0x46,0x00,0x02,
	0xe0,0x8e,0x13,0x46,0x00,0x01,0x13,0x43,
	0x00,0x04,0x61,0x00,0x0c,0xae,0x4a,0x80,
	0x66,0x00,0x03,0xc8,0xe1,0x8b,0xeb,0xab,
	0x22,0x4b,0x61,0x00,0xfd,0x0c,0x0c,0x80,
	0xff,0xff,0xff,0xff,0x67,0x00,0x03,0xb4,
	0x0c,0x80,0xff,0xff,0xff,0xfe,0x67,0x00,
	0x00,0xe6,0x61,0x00,0x0c,0xd2,0x4c,0xdf,
	0x0e,0x4a,0x4e,0x5d,0x4e,0x75,0x28,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x4e,0x55,0xff,0xf0,0x48,0xe7,0x52,0x70,
	0x26,0x49,0x43,0xed,0xff,0xf0,0x45,0xfa,
	0xff,0xe6,0x72,0x09,0x12,0xda,0x51,0xc9,
	0xff,0xfc,0x2c,0x03,0x43,0xed,0xff,0xf0,
	0x23,0x42,0x00,0x02,0x13,0x43,0x00,0x08,
	0xe0,0x8b,0x13,0x43,0x00,0x07,0x61,0x00,
	0x0c,0x42,0x4a,0x80,0x66,0x00,0x03,0x5c,
	0x26,0x06,0xe1,0x8b,0xeb,0xab,0x22,0x4b,
	0x61,0x00,0xfc,0xf4,0x0c,0x80,0xff,0xff,
	0xff,0xff,0x67,0x00,0x03,0x46,0x0c,0x80,
	0xff,0xff,0xff,0xfe,0x67,0x78,0x61,0x00,
	0x0c,0x66,0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,
	0x4e,0x75,0x2a,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x4e,0x55,0xff,0xf0,
	0x48,0xe7,0x52,0x70,0x45,0xfa,0xff,0xec,
	0x26,0x49,0x43,0xed,0xff,0xf0,0x72,0x09,
	0x12,0xda,0x51,0xc9,0xff,0xfc,0x2c,0x03,
	0x43,0xed,0xff,0xf0,0x23,0x42,0x00,0x02,
	0x13,0x43,0x00,0x08,0xe0,0x8b,0x13,0x43,
	0x00,0x07,0x61,0x00,0x0b,0xd6,0x4a,0x80,
	0x66,0x00,0x02,0xf0,0x26,0x06,0xe1,0x8b,
	0xeb,0xab,0x22,0x4b,0x61,0x00,0xfc,0x32,
	0x0c,0x80,0xff,0xff,0xff,0xff,0x67,0x00,
	0x02,0xda,0x0c,0x80,0xff,0xff,0xff,0xfe,
	0x67,0x0c,0x61,0x00,0x0b,0xfa,0x4c,0xdf,
	0x0e,0x4a,0x4e,0x5d,0x4e,0x75,0x61,0x00,
	0x0b,0xee,0x4a,0x80,0x66,0x02,0x70,0xfe,
	0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,0x4e,0x75,
	0x2f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x4e,0x55,0xff,0xf0,0x48,0xe7,
	0x52,0x70,0x45,0xfa,0xff,0xec,0x60,0x80,
	0x04,0x00,0x00,0x00,0x00,0x00,0x4e,0x55,
	0xff,0xf0,0x48,0xe7,0x52,0x70,0x45,0xfa,
	0xff,0xf0,0x43,0xed,0xff,0xf0,0x72,0x05,
	0x12,0xda,0x51,0xc9,0xff,0xfc,0x43,0xed,
	0xff,0xf0,0x13,0x43,0x00,0x04,0xe0,0x8b,
	0x13,0x43,0x00,0x03,0x61,0x00,0x0b,0x4c,
	0x4a,0x80,0x66,0x00,0x02,0x66,0x61,0x00,
	0x0b,0x8e,0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,
	0x4e,0x75,0x1e,0x00,0x00,0x00,0x00,0x00,
	0x4e,0x55,0xff,0xf0,0x48,0xe7,0x52,0x70,
	0x45,0xfa,0xff,0xf0,0x43,0xed,0xff,0xf0,
	0x72,0x05,0x12,0xda,0x51,0xc9,0xff,0xfc,
	0x43,0xed,0xff,0xf0,0x02,0x03,0x00,0x01,
	0x13,0x43,0x00,0x04,0x61,0x00,0x0b,0x0c,
	0x4a,0x80,0x66,0x00,0x02,0x26,0x61,0x00,
	0x0b,0x4e,0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,
	0x4e,0x75,0x1b,0x00,0x00,0x00,0x00,0x00,
	0x4e,0x55,0xff,0xf0,0x48,0xe7,0x52,0x70,
	0x45,0xfa,0xff,0xf0,0x43,0xed,0xff,0xf0,
	0x72,0x05,0x12,0xda,0x51,0xc9,0xff,0xfc,
	0x43,0xed,0xff,0xf0,0x02,0x03,0x00,0x03,
	0x13,0x43,0x00,0x04,0x61,0x00,0x0a,0xcc,
	0x4a,0x80,0x66,0x00,0x01,0xe6,0x61,0x00,
	0x0b,0x0e,0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,
	0x4e,0x75,0xc1,0x00,0x00,0x00,0x00,0x00,
	0x4e,0x55,0xff,0xf0,0x48,0xe7,0x52,0x70,
	0x45,0xfa,0xff,0xf0,0x43,0xed,0xff,0xf0,
	0x72,0x05,0x12,0xda,0x51,0xc9,0xff,0xfc,
	0x43,0xed,0xff,0xf0,0x02,0x03,0x00,0x01,
	0x13,0x43,0x00,0x04,0x76,0x06,0x61,0x00,
	0x0a,0x8a,0x4a,0x80,0x66,0x00,0x01,0xa4,
	0x61,0x00,0x0a,0xcc,0x4c,0xdf,0x0e,0x4a,
	0x4e,0x5d,0x4e,0x75,0x0b,0x00,0x00,0x00,
	0x00,0x00,0x4e,0x55,0xff,0xf0,0x48,0xe7,
	0x52,0x70,0x45,0xfa,0xff,0xf0,0x43,0xed,
	0xff,0xf0,0x72,0x05,0x12,0xda,0x51,0xc9,
	0xff,0xfc,0x2c,0x02,0x43,0xed,0xff,0xf0,
	0x13,0x46,0x00,0x03,0xe0,0x8e,0x13,0x46,
	0x00,0x02,0xe0,0x8e,0x13,0x46,0x00,0x01,
	0x61,0x00,0x0a,0x40,0x4a,0x80,0x66,0x00,
	0x01,0x5a,0x61,0x00,0x0a,0x82,0x4c,0xdf,
	0x0e,0x4a,0x4e,0x5d,0x4e,0x75,0xc2,0x00,
	0x00,0x00,0x00,0x00,0x4e,0x55,0xff,0xf0,
	0x48,0xe7,0x52,0x70,0x26,0x49,0x45,0xfa,
	0xff,0xee,0x43,0xed,0xff,0xf0,0x72,0x05,
	0x12,0xda,0x51,0xc9,0xff,0xfc,0x22,0x03,
	0x43,0xed,0xff,0xf0,0x13,0x41,0x00,0x05,
	0x76,0x06,0x61,0x00,0x09,0xfe,0x4a,0x80,
	0x66,0x00,0x01,0x18,0x26,0x01,0x22,0x4b,
	0x61,0x00,0x05,0xe2,0x0c,0x80,0xff,0xff,
	0xff,0xff,0x67,0x00,0x01,0x06,0x61,0x00,
	0x0a,0x2e,0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,
	0x4e,0x75,0x06,0x00,0x00,0x00,0x00,0x00,
	0x4e,0x55,0xff,0xf0,0x48,0xe7,0x52,0x70,
	0x45,0xfa,0xff,0xf0,0x43,0xed,0xff,0xf0,
	0x72,0x05,0x12,0xda,0x51,0xc9,0xff,0xfc,
	0x43,0xed,0xff,0xf0,0x2c,0x02,0x13,0x46,
	0x00,0x03,0xe0,0x8e,0x13,0x46,0x00,0x02,
	0xe0,0x8e,0x13,0x46,0x00,0x01,0x13,0x43,
	0x00,0x04,0x61,0x00,0x09,0x9e,0x4a,0x80,
	0x66,0x00,0x00,0xb8,0x61,0x00,0x09,0xe0,
	0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,0x4e,0x75,
	0x07,0x00,0x00,0x00,0x00,0x00,0x4e,0x55,
	0xff,0xf0,0x48,0xe7,0x52,0x70,0x45,0xfa,
	0xff,0xf0,0x43,0xed,0xff,0xf0,0x72,0x05,
	0x12,0xda,0x51,0xc9,0xff,0xfc,0x43,0xed,
	0xff,0xf0,0x2c,0x02,0x13,0x46,0x00,0x03,
	0xe0,0x8e,0x13,0x46,0x00,0x02,0xe0,0x8e,
	0x13,0x46,0x00,0x01,0x13,0x43,0x00,0x04,
	0x61,0x00,0x09,0x50,0x4a,0x80,0x66,0x6a,
	0x61,0x00,0x09,0x94,0x4c,0xdf,0x0e,0x4a,
	0x4e,0x5d,0x4e,0x75,0x0e,0x00,0x00,0x00,
	0x00,0x00,0x4e,0x55,0xff,0xf0,0x48,0xe7,
	0x52,0x70,0x26,0x49,0x45,0xfa,0xff,0xee,
	0x43,0xed,0xff,0xf0,0x72,0x05,0x12,0xda,
	0x51,0xc9,0xff,0xfc,0x43,0xed,0xff,0xf0,
	0x2c,0x02,0x13,0x46,0x00,0x03,0xe0,0x8e,
	0x13,0x46,0x00,0x02,0xe0,0x8e,0x13,0x46,
	0x00,0x01,0x13,0x43,0x00,0x04,0x61,0x00,
	0x09,0x02,0x4a,0x80,0x66,0x1c,0x76,0x04,
	0x22,0x4b,0x61,0x00,0x04,0xe8,0x0c,0x80,
	0xff,0xff,0xff,0xff,0x67,0x0c,0x61,0x00,
	0x09,0x36,0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,
	0x4e,0x75,0x70,0xff,0x4c,0xdf,0x0e,0x4a,
	0x4e,0x5d,0x4e,0x75,0x2f,0x0b,0x47,0xfa,
	0x00,0xd8,0x61,0x38,0x26,0x5f,0x4e,0x75,
	0x2f,0x0b,0x47,0xfa,0x01,0xa8,0x61,0x2c,
	0x48,0xe7,0xc0,0x00,0x10,0x39,0x00,0xe8,
	0xe0,0x0b,0xe8,0x08,0x0c,0x00,0x00,0x0e,
	0x64,0x12,0x4e,0x7a,0x00,0x02,0x22,0x00,
	0x08,0xc0,0x00,0x0b,0x4e,0x7b,0x00,0x02,
	0x4e,0x7b,0x10,0x02,0x4c,0xdf,0x00,0x03,
	0x26,0x5f,0x4e,0x75,0x48,0xe7,0x00,0x60,
	0x10,0x2e,0x00,0x0b,0x02,0x00,0x00,0x07,
	0x1d,0x40,0x00,0x11,0x20,0x03,0x1d,0x40,
	0x00,0x1d,0xe0,0x88,0x1d,0x40,0x00,0x1b,
	0xe0,0x88,0x1d,0x40,0x00,0x19,0x10,0x2e,
	0x00,0x0b,0x08,0x00,0x00,0x07,0x67,0xf6,
	0x45,0xf9,0x00,0xe8,0x40,0x40,0x15,0x7c,
	0x00,0xff,0x00,0x00,0x35,0x7c,0x00,0x00,
	0x00,0x1a,0x15,0x7c,0x00,0x80,0x00,0x04,
	0x15,0x7c,0x00,0x04,0x00,0x06,0x41,0xee,
	0x00,0x15,0x25,0x48,0x00,0x14,0x10,0x2e,
	0x00,0x0b,0x08,0x00,0x00,0x07,0x67,0xf6,
	0x1d,0x7c,0x00,0x80,0x00,0x05,0x4e,0x93,
	0x4a,0x80,0x66,0x26,0x08,0x2e,0x00,0x03,
	0x00,0x09,0x66,0x12,0x08,0x2e,0x00,0x04,
	0x00,0x09,0x67,0xf0,0x08,0xee,0x00,0x04,
	0x00,0x09,0x70,0x00,0x60,0x0c,0x08,0xee,
	0x00,0x03,0x00,0x09,0x70,0xfd,0x60,0x02,
	0x70,0xff,0x25,0x7c,0x00,0xe9,0x60,0x01,
	0x00,0x14,0x4c,0xdf,0x06,0x00,0x4e,0x75,
	0x48,0xe7,0x7c,0x40,0x15,0x7c,0x00,0x31,
	0x00,0x05,0x28,0x03,0xb6,0xbc,0x00,0x00,
	0x01,0x00,0x63,0x08,0x2a,0x3c,0x00,0x00,
	0x01,0x00,0x60,0x02,0x2a,0x03,0x25,0x49,
	0x00,0x0c,0x35,0x45,0x00,0x0a,0x08,0x2e,
	0x00,0x03,0x00,0x09,0x66,0x00,0x00,0x98,
	0x08,0x2e,0x00,0x00,0x00,0x0d,0x67,0xee,
	0x08,0x2e,0x00,0x03,0x00,0x09,0x66,0x00,
	0x00,0x86,0x10,0x2e,0x00,0x0b,0x08,0x00,
	0x00,0x07,0x67,0xec,0x70,0x00,0x10,0x2e,
	0x00,0x19,0xe1,0x88,0x10,0x2e,0x00,0x1b,
	0xe1,0x88,0x10,0x2e,0x00,0x1d,0x22,0x04,
	0x92,0x80,0x70,0x00,0x30,0x2a,0x00,0x0a,
	0x24,0x05,0x94,0x80,0x92,0x82,0x67,0x08,
	0xd3,0xaa,0x00,0x0c,0x93,0x6a,0x00,0x0a,
	0x14,0xbc,0xff,0xff,0x15,0x7c,0x00,0x80,
	0x00,0x07,0x4e,0x71,0x4e,0x71,0x4e,0x71,
	0x4e,0x71,0x4e,0x71,0x08,0x2e,0x00,0x03,
	0x00,0x09,0x66,0x32,0x08,0x2e,0x00,0x04,
	0x00,0x09,0x66,0x06,0x08,0x12,0x00,0x07,
	0x67,0xea,0x08,0x2a,0x00,0x01,0x00,0x01,
	0x66,0x00,0xff,0x7c,0x4a,0x2a,0x00,0x01,
	0x66,0x18,0x4a,0x6a,0x00,0x0a,0x66,0x12,
	0xd3,0xc5,0x98,0x85,0x96,0x85,0x66,0x00,
	0xff,0x4c,0x70,0x00,0x60,0x10,0x70,0xfd,
	0x60,0x06,0x70,0xfe,0x60,0x02,0x70,0xff,
	0x15,0x7c,0x00,0x10,0x00,0x07,0x4c,0xdf,
	0x02,0x3e,0x4e,0x75,0x48,0xe7,0x7c,0x40,
	0x15,0x7c,0x00,0xb1,0x00,0x05,0xb6,0xbc,
	0x00,0x00,0x01,0x00,0x63,0x08,0x2a,0x3c,
	0x00,0x00,0x01,0x00,0x60,0x02,0x2a,0x03,
	0x25,0x49,0x00,0x0c,0x35,0x45,0x00,0x0a,
	0x08,0x2e,0x00,0x03,0x00,0x09,0x66,0x52,
	0x08,0x2e,0x00,0x00,0x00,0x0d,0x66,0xf0,
	0x14,0xbc,0xff,0xff,0x15,0x7c,0x00,0x80,
	0x00,0x07,0x4e,0x71,0x4e,0x71,0x4e,0x71,
	0x4e,0x71,0x4e,0x71,0x08,0x2e,0x00,0x03,
	0x00,0x09,0x66,0x2e,0x08,0x2e,0x00,0x04,
	0x00,0x09,0x66,0x06,0x08,0x12,0x00,0x07,
	0x67,0xea,0x08,0x2a,0x00,0x01,0x00,0x01,
	0x66,0xbe,0x4a,0x2a,0x00,0x01,0x66,0x16,
	0x4a,0x6a,0x00,0x0a,0x66,0x10,0xd3,0xc5,
	0x98,0x85,0x96,0x85,0x66,0x90,0x70,0x00,
	0x60,0x10,0x70,0xfd,0x60,0x06,0x70,0xfe,
	0x60,0x02,0x70,0xff,0x15,0x7c,0x00,0x10,
	0x00,0x07,0x4c,0xdf,0x02,0x3e,0x4e,0x75,
	0x48,0xe7,0x40,0x42,0x2c,0x7a,0xf5,0x8e,
	0x1d,0x7c,0x00,0x90,0x00,0x03,0x10,0x39,
	0x00,0xed,0x00,0x6f,0x0c,0x00,0x00,0x56,
	0x67,0x3a,0x13,0xfc,0x00,0x31,0x00,0xe8,
	0xe0,0x0d,0xbd,0xfc,0x00,0xe9,0x60,0x20,
	0x66,0x0a,0x13,0xfc,0x00,0x07,0x00,0xed,
	0x00,0x70,0x60,0x08,0x13,0xfc,0x00,0x0f,
	0x00,0xed,0x00,0x70,0x13,0xfc,0x00,0x00,
	0x00,0xed,0x00,0x71,0x13,0xfc,0x00,0x56,
	0x00,0xed,0x00,0x6f,0x13,0xfc,0x00,0x00,
	0x00,0xe8,0xe0,0x0d,0x10,0x39,0x00,0xed,
	0x00,0x70,0x02,0x00,0x00,0x07,0x1d,0x40,
	0x00,0x01,0x70,0x00,0x1d,0x40,0x00,0x05,
	0x1d,0x40,0x00,0x11,0x1d,0x40,0x00,0x19,
	0x1d,0x40,0x00,0x1b,0x1d,0x40,0x00,0x1d,
	0x1d,0x40,0x00,0x17,0x70,0x80,0xbd,0xfc,
	0x00,0xe9,0x60,0x20,0x66,0x04,0x72,0x6c,
	0x60,0x06,0x22,0x3c,0x00,0x00,0x00,0xf6,
	0x43,0xfa,0x00,0x38,0x4e,0x4f,0x1d,0x7c,
	0x00,0x10,0x00,0x03,0x1d,0x7c,0x00,0x00,
	0x00,0x0b,0x70,0x02,0x61,0x00,0x06,0x58,
	0x1d,0x7c,0x00,0x10,0x00,0x05,0x70,0x05,
	0x61,0x00,0x06,0x4c,0x1d,0x7c,0x00,0x00,
	0x00,0x05,0x20,0x3c,0x00,0x00,0x9c,0x40,
	0x61,0x00,0x06,0x3c,0x4c,0xdf,0x42,0x02,
	0x4e,0x75,0x48,0xe7,0xc0,0x02,0x2c,0x7a,
	0xf4,0xc4,0x10,0x2e,0x00,0x09,0x1d,0x40,
	0x00,0x09,0x4c,0xdf,0x40,0x03,0x4e,0x73,
	0x48,0xe7,0x09,0x02,0x2c,0x7a,0xf4,0xae,
	0x1d,0x7c,0x00,0x00,0x00,0x11,0x10,0x2e,
	0x00,0x0d,0x02,0x00,0x00,0xf8,0x66,0xf6,
	0x1d,0x7c,0x00,0x60,0x00,0x05,0x60,0x18,
	0x48,0xe7,0x09,0x02,0x2c,0x7a,0xf4,0x8e,
	0x1d,0x7c,0x00,0x00,0x00,0x11,0x10,0x2e,
	0x00,0x0d,0x02,0x00,0x00,0xf8,0x66,0xf6,
	0x02,0x44,0x00,0x07,0x10,0x3c,0x00,0x01,
	0xe9,0x28,0x09,0x39,0x00,0xed,0x00,0x71,
	0x66,0x0c,0x80,0x2e,0x00,0x01,0x1d,0x7c,
	0x00,0x10,0x00,0x03,0x60,0x06,0x1d,0x7c,
	0x00,0x00,0x00,0x03,0x1d,0x40,0x00,0x17,
	0x30,0x3c,0x09,0xc4,0x1d,0x40,0x00,0x1b,
	0xe0,0x48,0x1d,0x40,0x00,0x19,0x1d,0x7c,
	0x00,0x03,0x00,0x1d,0x1d,0x6e,0x00,0x09,
	0x00,0x09,0x1d,0x7c,0x00,0x20,0x00,0x05,
	0x70,0x01,0x61,0x00,0x05,0x9a,0x10,0x2e,
	0x00,0x09,0x66,0x08,0x1d,0x7c,0x00,0x05,
	0x00,0x0d,0x66,0xf2,0x10,0x2e,0x00,0x0d,
	0x08,0x00,0x00,0x07,0x67,0x9a,0x10,0x2e,
	0x00,0x09,0x67,0xf0,0xb0,0x3c,0x00,0x04,
	0x67,0x26,0x1d,0x40,0x00,0x09,0xb0,0x3c,
	0x00,0x10,0x67,0x0c,0x48,0x40,0x10,0x2e,
	0x00,0x0b,0x4c,0xdf,0x40,0x90,0x4e,0x75,
	0x70,0x00,0x4c,0xdf,0x40,0x90,0x4e,0x75,
	0x70,0xff,0x4c,0xdf,0x40,0x90,0x4e,0x75,
	0x70,0x01,0x61,0x00,0x05,0x4a,0x1d,0x7c,
	0x00,0x00,0x00,0x17,0x20,0x3c,0x00,0x00,
	0x02,0x58,0x1d,0x40,0x00,0x1d,0xe0,0x88,
	0x1d,0x40,0x00,0x1b,0xe0,0x88,0x1d,0x40,
	0x00,0x19,0x1d,0x7c,0x00,0x04,0x00,0x09,
	0x70,0x02,0x61,0x00,0x05,0x22,0x10,0x2e,
	0x00,0x09,0x67,0xfa,0x1d,0x40,0x00,0x09,
	0xb0,0x3c,0x00,0x04,0x67,0x08,0xb0,0x3c,
	0x00,0x10,0x67,0xac,0x60,0x9e,0x08,0x2e,
	0x00,0x05,0x00,0x0d,0x66,0xf8,0x1d,0x6e,
	0x00,0x09,0x00,0x09,0x08,0x2e,0x00,0x07,
	0x00,0x0d,0x66,0x94,0x60,0x86,0x48,0xe7,
	0x10,0x02,0x2c,0x7a,0xf3,0x80,0x10,0x11,
	0x02,0x00,0x00,0xe0,0x0c,0x00,0x00,0x00,
	0x67,0x0e,0xb0,0x3c,0x00,0x20,0x67,0x0c,
	0xb0,0x3c,0x00,0xa0,0x67,0x0a,0x60,0x0a,
	0x76,0x06,0x60,0x06,0x76,0x0a,0x60,0x02,
	0x76,0x0c,0x10,0x2e,0x00,0x09,0x08,0x00,
	0x00,0x05,0x66,0x2c,0x10,0x2e,0x00,0x0b,
	0x08,0x00,0x00,0x07,0x67,0xec,0x02,0x00,
	0x00,0x07,0x0c,0x00,0x00,0x02,0x66,0x0e,
	0x61,0x00,0x02,0xa6,0x48,0x40,0x66,0x06,
	0x4c,0xdf,0x40,0x08,0x4e,0x75,0x10,0x2e,
	0x00,0x0b,0x4c,0xdf,0x40,0x08,0x4e,0x75,
	0x61,0x00,0xfd,0x8e,0x70,0xff,0x4c,0xdf,
	0x40,0x08,0x4e,0x75,0x48,0xe7,0x00,0x02,
	0x2c,0x7a,0xf3,0x12,0x10,0x2e,0x00,0x09,
	0x08,0x00,0x00,0x05,0x66,0x2c,0x10,0x2e,
	0x00,0x0b,0x08,0x00,0x00,0x07,0x67,0xec,
	0x02,0x00,0x00,0x07,0xb0,0x3c,0x00,0x00,
	0x66,0x0e,0x61,0x00,0x01,0x66,0x48,0x40,
	0x66,0x06,0x4c,0xdf,0x40,0x00,0x4e,0x75,
	0x10,0x2e,0x00,0x0b,0x4c,0xdf,0x40,0x00,
	0x4e,0x75,0x61,0x00,0xfd,0x44,0x70,0xff,
	0x4c,0xdf,0x40,0x00,0x4e,0x75,0x48,0xe7,
	0x00,0x02,0x2c,0x7a,0xf2,0xc8,0x10,0x2e,
	0x00,0x09,0x08,0x00,0x00,0x05,0x66,0x2c,
	0x10,0x2e,0x00,0x0b,0x08,0x00,0x00,0x07,
	0x67,0xec,0x02,0x00,0x00,0x07,0xb0,0x3c,
	0x00,0x01,0x66,0x0e,0x61,0x00,0x01,0x9c,
	0x48,0x40,0x66,0x06,0x4c,0xdf,0x40,0x00,
	0x4e,0x75,0x10,0x2e,0x00,0x0b,0x4c,0xdf,
	0x40,0x00,0x4e,0x75,0x61,0x00,0xfc,0xfa,
	0x70,0xff,0x4c,0xdf,0x40,0x00,0x4e,0x75,
	0x48,0xe7,0x10,0x02,0x2c,0x7a,0xf2,0x7e,
	0x10,0x2e,0x00,0x09,0x08,0x00,0x00,0x05,
	0x66,0x2e,0x10,0x2e,0x00,0x0b,0x08,0x00,
	0x00,0x07,0x67,0xec,0x02,0x00,0x00,0x07,
	0xb0,0x3c,0x00,0x03,0x66,0x10,0x76,0x01,
	0x61,0x00,0x02,0x06,0x48,0x40,0x66,0x06,
	0x4c,0xdf,0x40,0x08,0x4e,0x75,0x10,0x2e,
	0x00,0x0b,0x4c,0xdf,0x40,0x08,0x4e,0x75,
	0x61,0x00,0xfc,0xae,0x70,0xff,0x4c,0xdf,
	0x40,0x08,0x4e,0x75,0x48,0xe7,0x10,0x02,
	0x2c,0x7a,0xf2,0x32,0x10,0x2e,0x00,0x09,
	0x08,0x00,0x00,0x05,0x66,0x2e,0x10,0x2e,
	0x00,0x0b,0x08,0x00,0x00,0x07,0x67,0xec,
	0x02,0x00,0x00,0x07,0xb0,0x3c,0x00,0x07,
	0x66,0x10,0x76,0x01,0x61,0x00,0x01,0xba,
	0x48,0x40,0x66,0x06,0x4c,0xdf,0x40,0x08,
	0x4e,0x75,0x10,0x2e,0x00,0x0b,0x4c,0xdf,
	0x40,0x08,0x4e,0x75,0x61,0x00,0xfc,0x62,
	0x70,0xff,0x4c,0xdf,0x40,0x08,0x4e,0x75,
	0x48,0xe7,0x10,0x02,0x2c,0x7a,0xf1,0xe6,
	0x10,0x2e,0x00,0x09,0x08,0x00,0x00,0x05,
	0x66,0x2c,0x10,0x2e,0x00,0x0b,0x08,0x00,
	0x00,0x07,0x67,0xec,0x02,0x00,0x00,0x07,
	0xb0,0x3c,0x00,0x06,0x66,0x0e,0x76,0x01,
	0x61,0x38,0x48,0x40,0x66,0x06,0x4c,0xdf,
	0x40,0x08,0x4e,0x75,0x10,0x2e,0x00,0x0b,
	0x4c,0xdf,0x40,0x08,0x4e,0x75,0x61,0x00,
	0xfc,0x18,0x70,0xff,0x4c,0xdf,0x40,0x08,
	0x4e,0x75,0x48,0xe7,0x00,0x02,0x2c,0x7a,
	0xf1,0x9c,0x70,0x00,0x10,0x2e,0x00,0x0b,
	0x4c,0xdf,0x40,0x00,0x4e,0x75,0x70,0x04,
	0x4e,0x75,0x48,0xe7,0x10,0x40,0x20,0x03,
	0x1d,0x40,0x00,0x1d,0xe0,0x88,0x1d,0x40,
	0x00,0x1b,0xe0,0x88,0x1d,0x40,0x00,0x19,
	0x10,0x2e,0x00,0x0b,0x02,0x00,0x00,0x07,
	0x1d,0x40,0x00,0x11,0x10,0x2e,0x00,0x0b,
	0x08,0x00,0x00,0x07,0x67,0xf6,0x1d,0x6e,
	0x00,0x09,0x00,0x09,0x1d,0x7c,0x00,0x80,
	0x00,0x05,0x10,0x2e,0x00,0x0d,0x02,0x00,
	0x00,0xf0,0xb0,0x3c,0x00,0x70,0x67,0x06,
	0xb0,0x3c,0x00,0xb0,0x66,0xec,0x4a,0x2e,
	0x00,0x09,0x66,0x10,0x08,0x2e,0x00,0x01,
	0x00,0x0d,0x66,0xf2,0x1d,0x59,0x00,0x15,
	0x53,0x83,0x66,0xea,0x10,0x2e,0x00,0x09,
	0x67,0xfa,0x1d,0x40,0x00,0x09,0xb0,0x3c,
	0x00,0x10,0x67,0x06,0x4c,0xdf,0x02,0x08,
	0x4e,0x75,0x70,0x00,0x4c,0xdf,0x02,0x08,
	0x4e,0x75,0x48,0xe7,0x10,0x40,0x10,0x2e,
	0x00,0x0b,0x02,0x00,0x00,0x07,0x1d,0x40,
	0x00,0x11,0x20,0x03,0x1d,0x40,0x00,0x1d,
	0xe0,0x88,0x1d,0x40,0x00,0x1b,0xe0,0x88,
	0x1d,0x40,0x00,0x19,0x1d,0x6e,0x00,0x09,
	0x00,0x09,0x1d,0x7c,0x00,0x80,0x00,0x05,
	0x10,0x2e,0x00,0x0d,0x02,0x00,0x00,0xf0,
	0xb0,0x3c,0x00,0x70,0x67,0x06,0xb0,0x3c,
	0x00,0xb0,0x66,0xec,0x4a,0x2e,0x00,0x09,
	0x66,0x10,0x08,0x2e,0x00,0x00,0x00,0x0d,
	0x66,0xf2,0x12,0xee,0x00,0x15,0x53,0x83,
	0x66,0xea,0x10,0x2e,0x00,0x09,0x67,0xfa,
	0x1d,0x40,0x00,0x09,0xb0,0x3c,0x00,0x10,
	0x67,0x06,0x4c,0xdf,0x02,0x08,0x4e,0x75,
	0x70,0x00,0x4c,0xdf,0x02,0x08,0x4e,0x75,
	0x48,0xe7,0x10,0x40,0x10,0x2e,0x00,0x0b,
	0x02,0x00,0x00,0x07,0x1d,0x40,0x00,0x11,
	0x10,0x2e,0x00,0x0b,0x08,0x00,0x00,0x07,
	0x67,0xf6,0x1d,0x59,0x00,0x17,0x1d,0x7c,
	0x00,0xec,0x00,0x05,0x10,0x2e,0x00,0x0b,
	0x08,0x00,0x00,0x07,0x66,0xf6,0x1d,0x7c,
	0x00,0xcc,0x00,0x05,0x53,0x83,0x66,0xcc,
	0x70,0x00,0x4c,0xdf,0x02,0x08,0x4e,0x75,
	0x48,0xe7,0x10,0x40,0x10,0x2e,0x00,0x0b,
	0x02,0x00,0x00,0x07,0x1d,0x40,0x00,0x11,
	0x10,0x2e,0x00,0x0b,0x08,0x00,0x00,0x07,
	0x67,0xf6,0x1d,0x7c,0x00,0xec,0x00,0x05,
	0x10,0x2e,0x00,0x0b,0x08,0x00,0x00,0x07,
	0x66,0xf6,0x12,0xee,0x00,0x17,0x1d,0x7c,
	0x00,0xcc,0x00,0x05,0x53,0x83,0x66,0xcc,
	0x70,0x00,0x4c,0xdf,0x02,0x08,0x4e,0x75,
	0x00,0x00,0x00,0x00,0x00,0x00,0x4e,0x55,
	0xff,0xf0,0x48,0xe7,0x52,0x70,0x45,0xfa,
	0xff,0xf0,0x61,0x00,0x01,0x2c,0x4c,0xdf,
	0x0e,0x4a,0x4e,0x5d,0x4e,0x75,0x01,0x00,
	0x00,0x00,0x00,0x00,0x4e,0x55,0xff,0xf0,
	0x48,0xe7,0x52,0x70,0x45,0xfa,0xff,0xf0,
	0x61,0x00,0x01,0x0e,0x4c,0xdf,0x0e,0x4a,
	0x4e,0x5d,0x4e,0x75,0x08,0x00,0x00,0x00,
	0x00,0x00,0x4e,0x55,0xff,0xf0,0x48,0xe7,
	0x52,0x70,0x26,0x49,0x45,0xfa,0xff,0xee,
	0x43,0xed,0xff,0xf0,0x72,0x05,0x12,0xda,
	0x51,0xc9,0xff,0xfc,0x2c,0x02,0x43,0xed,
	0xff,0xf0,0x13,0x46,0x00,0x03,0xe0,0x8e,
	0x13,0x46,0x00,0x02,0xe0,0x8e,0x13,0x46,
	0x00,0x01,0x13,0x43,0x00,0x04,0x61,0x00,
	0x00,0x92,0x4a,0x80,0x66,0x00,0x00,0x82,
	0xe1,0x8b,0xeb,0xab,0x22,0x4b,0x61,0x00,
	0xf1,0x46,0x0c,0x80,0xff,0xff,0xff,0xff,
	0x67,0x6e,0x0c,0x80,0xff,0xff,0xff,0xfe,
	0x67,0x0c,0x61,0x00,0x00,0xba,0x4c,0xdf,
	0x0e,0x4a,0x4e,0x5d,0x4e,0x75,0x61,0x00,
	0x00,0xae,0x4a,0x80,0x66,0x02,0x70,0xfe,
	0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,0x4e,0x75,
	0x25,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x4e,0x55,0xff,0xf0,0x48,0xe7,
	0x52,0x70,0x26,0x49,0x43,0xed,0xff,0xf0,
	0x45,0xfa,0xff,0xe6,0x72,0x09,0x12,0xda,
	0x51,0xc9,0xff,0xfc,0x43,0xed,0xff,0xf0,
	0x61,0x28,0x4a,0x80,0x66,0x1a,0x22,0x4b,
	0x76,0x08,0x61,0x00,0xfc,0x5a,0x0c,0x80,
	0xff,0xff,0xff,0xff,0x67,0x0a,0x61,0x5e,
	0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,0x4e,0x75,
	0x70,0xff,0x4c,0xdf,0x0e,0x4a,0x4e,0x5d,
	0x4e,0x75,0x48,0xe7,0x48,0x00,0x32,0x3c,
	0x00,0x01,0x61,0x00,0xfa,0x6c,0x4a,0x80,
	0x67,0x06,0x51,0xc9,0xff,0xf6,0x60,0x18,
	0x48,0x44,0xeb,0x0c,0x89,0x29,0x00,0x01,
	0x61,0x00,0xfb,0x64,0x4a,0x80,0x66,0x08,
	0x70,0x00,0x4c,0xdf,0x00,0x12,0x4e,0x75,
	0x70,0xff,0x4c,0xdf,0x00,0x12,0x4e,0x75,
	0x43,0xed,0xff,0xf0,0x72,0x05,0x12,0xda,
	0x51,0xc9,0xff,0xfc,0x43,0xed,0xff,0xf0,
	0x61,0xb8,0x4a,0x80,0x66,0x24,0x43,0xed,
	0xff,0xff,0x61,0x00,0xfc,0x34,0x4a,0x80,
	0x66,0x18,0x43,0xed,0xff,0xfe,0x61,0x00,
	0xfc,0x74,0x4a,0x80,0x66,0x0c,0x10,0x2d,
	0xff,0xfe,0x48,0x40,0x10,0x2d,0xff,0xff,
	0x4e,0x75,0x70,0xff,0x4e,0x75,0x48,0xe7,
	0xe0,0x80,0x41,0xf9,0x00,0xe8,0x80,0x23,
	0x72,0x00,0x12,0x10,0x12,0x10,0x74,0x00,
	0x14,0x10,0xb4,0x10,0x65,0xf8,0x92,0x42,
	0x64,0x04,0xd2,0x7c,0x00,0xc8,0xc3,0x42,
	0x90,0x82,0x62,0xea,0x4c,0xdf,0x01,0x07,
	0x4e,0x75,0x48,0xe7,0xf8,0x42,0x70,0x80,
	0x32,0x3c,0x01,0x40,0x43,0xfa,0x00,0xc6,
	0x4e,0x4f,0x21,0xc0,0x0c,0xc0,0x70,0x80,
	0x32,0x3c,0x01,0x41,0x43,0xfa,0x02,0x92,
	0x4e,0x4f,0x21,0xc0,0x0c,0xc4,0x70,0x80,
	0x32,0x3c,0x01,0x43,0x43,0xfa,0x03,0x04,
	0x4e,0x4f,0x21,0xc0,0x0c,0xc8,0x70,0x80,
	0x32,0x3c,0x01,0x44,0x43,0xfa,0x00,0xdc,
	0x4e,0x4f,0x21,0xc0,0x0c,0xcc,0x70,0x80,
	0x32,0x3c,0x01,0x45,0x43,0xfa,0x01,0xdc,
	0x4e,0x4f,0x21,0xc0,0x0c,0xd0,0x70,0x80,
	0x32,0x3c,0x01,0x46,0x43,0xfa,0x01,0xbe,
	0x4e,0x4f,0x21,0xc0,0x0c,0xd4,0x70,0x80,
	0x32,0x3c,0x01,0x47,0x43,0xfa,0x00,0x74,
	0x4e,0x4f,0x21,0xc0,0x0c,0xd8,0x70,0x80,
	0x32,0x3c,0x01,0x48,0x43,0xfa,0x00,0x72,
	0x4e,0x4f,0x21,0xc0,0x0c,0xdc,0x70,0x80,
	0x32,0x3c,0x01,0x4b,0x43,0xfa,0x00,0x70,
	0x4e,0x4f,0x21,0xc0,0x0c,0xe0,0x70,0x80,
	0x32,0x3c,0x01,0x4d,0x43,0xfa,0x00,0x6e,
	0x4e,0x4f,0x21,0xc0,0x0c,0xe4,0x70,0x80,
	0x32,0x3c,0x01,0x4f,0x43,0xfa,0x00,0xca,
	0x4e,0x4f,0x21,0xc0,0x0c,0xe8,0x32,0x3c,
	0x80,0x00,0x74,0x0f,0x22,0x7c,0x00,0x00,
	0x00,0x00,0x61,0x00,0x02,0x6e,0xd2,0x7c,
	0x01,0x00,0x51,0xca,0xff,0xf0,0x4c,0xdf,
	0x42,0x1f,0x4e,0x75,0x2f,0x38,0x0c,0xc0,
	0x48,0xe7,0x48,0x04,0x4b,0xfa,0xf4,0x14,
	0x60,0x48,0x2f,0x38,0x0c,0xd8,0x48,0xe7,
	0x48,0x04,0x4b,0xfa,0xfd,0x90,0x60,0x3a,
	0x2f,0x38,0x0c,0xdc,0x48,0xe7,0x48,0x04,
	0x4b,0xfa,0xf5,0x30,0x60,0x2c,0x2f,0x38,
	0x0c,0xe0,0x48,0xe7,0x48,0x04,0x4b,0xfa,
	0xf4,0xd6,0x60,0x1e,0x2f,0x38,0x0c,0xe4,
	0x48,0xe7,0x48,0x04,0x4b,0xfa,0xf4,0x7a,
	0x60,0x10,0x2f,0x38,0x0c,0xcc,0x48,0xe7,
	0x48,0x04,0x4b,0xfa,0xfd,0x3a,0x60,0x00,
	0x00,0x02,0x78,0x00,0x38,0x01,0x02,0x41,
	0xf0,0x00,0xb2,0x7c,0x80,0x00,0x66,0x3a,
	0xe0,0x4c,0xe2,0x4c,0x64,0x04,0x08,0xc4,
	0x00,0x10,0x02,0x44,0x00,0x07,0x09,0x39,
	0x00,0xed,0x00,0x71,0x67,0x24,0x4e,0x95,
	0x02,0x80,0xff,0xff,0xff,0x1e,0x4a,0x80,
	0x66,0x0a,0x70,0x00,0x4c,0xdf,0x20,0x12,
	0x58,0x8f,0x4e,0x75,0x00,0x80,0xff,0xff,
	0xff,0x00,0x4c,0xdf,0x20,0x12,0x58,0x8f,
	0x4e,0x75,0x4c,0xdf,0x20,0x12,0x4e,0x75,
	0x2f,0x38,0x0c,0xe8,0x48,0xe7,0x7f,0x48,
	0x78,0x00,0x38,0x01,0x02,0x41,0xf0,0x00,
	0xb2,0x7c,0x80,0x00,0x66,0x6e,0x22,0x04,
	0xe0,0x4c,0xe2,0x4c,0x64,0x04,0x08,0xc4,
	0x00,0x10,0x02,0x44,0x00,0x07,0x09,0x39,
	0x00,0xed,0x00,0x71,0x67,0x4e,0x49,0xf9,
	0x00,0x00,0x09,0xfe,0x20,0x01,0xe0,0x58,
	0xc0,0xbc,0x00,0x00,0x00,0x0f,0xd9,0xc0,
	0x10,0x14,0x08,0x00,0x00,0x07,0x66,0x34,
	0xc0,0x3c,0x00,0x7f,0x67,0x2e,0x24,0x3c,
	0x00,0x01,0x56,0x60,0x43,0xfa,0x02,0x84,
	0xb0,0x3c,0x00,0x14,0x67,0x1a,0x24,0x3c,
	0x00,0x02,0xac,0xc0,0x43,0xfa,0x02,0x88,
	0xb0,0x3c,0x00,0x28,0x67,0x0a,0x24,0x3c,
	0x00,0x00,0xaf,0x50,0x43,0xfa,0x02,0x50,
	0x61,0x00,0xf3,0x00,0x4c,0xdf,0x12,0xfe,
	0x58,0x8f,0x4e,0x75,0x4c,0xdf,0x12,0xfe,
	0x4e,0x75,0x02,0x41,0xf0,0x00,0xb2,0x7c,
	0x80,0x00,0x66,0x0a,0x4c,0xdf,0x00,0x02,
	0x58,0x8f,0x70,0x00,0x4e,0x75,0x4c,0xdf,
	0x00,0x02,0x4e,0x75,0x2f,0x38,0x0c,0xd4,
	0x48,0xe7,0x7e,0x64,0x4b,0xfa,0xef,0xea,
	0x60,0x10,0x2f,0x38,0x0c,0xd0,0x48,0xe7,
	0x7e,0x64,0x4b,0xfa,0xf0,0x4a,0x60,0x00,
	0x00,0x02,0x78,0x00,0x38,0x01,0x02,0x41,
	0xf0,0x00,0xb2,0x7c,0x80,0x00,0x66,0x62,
	0xe0,0x4c,0xe2,0x4c,0x64,0x04,0x08,0xc4,
	0x00,0x10,0x02,0x44,0x00,0x07,0x09,0x39,
	0x00,0xed,0x00,0x71,0x67,0x4c,0x2c,0x03,
	0x26,0x06,0xd6,0xbc,0x00,0x00,0x00,0xff,
	0xe0,0x8b,0xb6,0xbc,0x00,0x00,0x01,0x00,
	0x63,0x06,0x26,0x3c,0x00,0x00,0x01,0x00,
	0x7a,0x00,0x4e,0x95,0x02,0x80,0xff,0xff,
	0xff,0x1e,0x4a,0x80,0x66,0x16,0xd4,0x83,
	0x22,0x03,0xe1,0x89,0xd3,0xc1,0x9c,0x81,
	0x62,0xce,0x4c,0xdf,0x26,0x7e,0x58,0x8f,
	0x70,0x00,0x4e,0x75,0x4c,0xdf,0x26,0x7e,
	0x58,0x8f,0x00,0x80,0xff,0xff,0xff,0x00,
	0x4e,0x75,0x4c,0xdf,0x26,0x7e,0x4e,0x75,
	0x4e,0x54,0xff,0x00,0x48,0xe7,0x7e,0x60,
	0x78,0x00,0x38,0x01,0x02,0x41,0xf0,0x00,
	0xb2,0x7c,0x80,0x00,0x66,0x60,0x22,0x04,
	0xe0,0x4c,0xe2,0x4c,0x64,0x04,0x08,0xc4,
	0x00,0x10,0x02,0x44,0x00,0x07,0x09,0x39,
	0x00,0xed,0x00,0x71,0x67,0x48,0x24,0x49,
	0x2c,0x03,0x26,0x06,0xb6,0xbc,0x00,0x00,
	0x01,0x00,0x65,0x06,0x26,0x3c,0x00,0x00,
	0x01,0x00,0x43,0xec,0xff,0x00,0x61,0x00,
	0xff,0x24,0x2a,0x03,0x53,0x85,0xb5,0x09,
	0x66,0x14,0x51,0xcd,0xff,0xfa,0x52,0x82,
	0x9c,0x83,0x62,0xd6,0x4c,0xdf,0x06,0x7e,
	0x4e,0x5c,0x70,0x00,0x4e,0x75,0x70,0xfe,
	0x4c,0xdf,0x06,0x7e,0x4e,0x5c,0x00,0x80,
	0xff,0xff,0xff,0x00,0x4e,0x75,0x4c,0xdf,
	0x06,0x7e,0x4e,0x5c,0x2f,0x38,0x0c,0xc4,
	0x4e,0x75,0x4e,0x54,0xff,0x00,0x48,0xe7,
	0x78,0x44,0x78,0x00,0x38,0x01,0x02,0x41,
	0xf0,0x00,0xb2,0x7c,0x80,0x00,0x66,0x46,
	0xe0,0x4c,0xe2,0x4c,0x64,0x04,0x08,0xc4,
	0x00,0x10,0x02,0x44,0x00,0x07,0x09,0x39,
	0x00,0xed,0x00,0x71,0x67,0x30,0x20,0x09,
	0x67,0x38,0x76,0x0a,0x61,0x00,0xf1,0xd6,
	0x02,0x80,0xff,0xff,0xff,0x1e,0x4a,0x80,
	0x66,0x0e,0x61,0x00,0x00,0x8c,0x70,0x00,
	0x4c,0xdf,0x22,0x1e,0x4e,0x5c,0x4e,0x75,
	0x00,0x80,0xff,0xff,0xff,0x00,0x4c,0xdf,
	0x22,0x1e,0x4e,0x5c,0x4e,0x75,0x4c,0xdf,
	0x22,0x1e,0x4e,0x5c,0x2f,0x38,0x0c,0xc8,
	0x4e,0x75,0x76,0x0a,0x43,0xfa,0x00,0xb4,
	0x61,0x00,0xf1,0x9a,0x02,0x80,0xff,0xff,
	0xff,0x1e,0x4a,0x80,0x66,0xd2,0x43,0xec,
	0xff,0x00,0x74,0x04,0x76,0x01,0x7a,0x00,
	0x61,0x00,0xee,0x56,0x02,0x80,0xff,0xff,
	0xff,0x1e,0x4a,0x80,0x66,0xba,0x45,0xec,
	0xff,0x00,0x43,0xfa,0x00,0x68,0x0c,0xaa,
	0x58,0x36,0x38,0x4b,0x00,0x00,0x66,0xa8,
	0x43,0xfa,0x00,0x5a,0x20,0x2a,0x00,0x04,
	0xb0,0xbc,0x00,0x00,0x9f,0xd9,0x65,0x00,
	0xff,0x7a,0x43,0xe9,0x00,0x14,0xb0,0xbc,
	0x00,0x01,0x3d,0x1d,0x65,0x00,0xff,0x6c,
	0x43,0xe9,0x00,0x14,0x60,0x00,0xff,0x64,
	0x4b,0xf9,0x00,0x00,0x09,0xfe,0x20,0x01,
	0xe0,0x58,0xc0,0xbc,0x00,0x00,0x00,0x0f,
	0xdb,0xc0,0x10,0x3c,0x00,0x28,0x0c,0x29,
	0x00,0x07,0x00,0x03,0x67,0x10,0x10,0x3c,
	0x00,0x14,0x0c,0x29,0x00,0x02,0x00,0x04,
	0x67,0x04,0x10,0x3c,0x00,0x0a,0x1a,0x80,
	0x42,0x80,0x4e,0x75,0x01,0x01,0x00,0x03,
	0x01,0x35,0x80,0x00,0x00,0x00,0x01,0x01,
	0x00,0x03,0x01,0x54,0x80,0x00,0x00,0x00,
	0x01,0x01,0x00,0x03,0x02,0x66,0x80,0x00,
	0x00,0x00,0x01,0x01,0x00,0x03,0x02,0x98,
	0x80,0x00,0x00,0x00,0x01,0x01,0x00,0x07,
	0x02,0x66,0x80,0x00,0x00,0x00,0x01,0x01,
	0x00,0x07,0x02,0x98,0x80
};

//---------------------------------------------------------------------------
//
//	IPL
//	Format.x v2.31擾
//
//---------------------------------------------------------------------------
const BYTE CMOMakeDlg::IPL[] = {
	0x60,0x24,0x53,0x48,0x41,0x52,0x50,0x2f,
	0x4b,0x47,0x20,0x20,0x20,0x20,0x31,0x2e,
	0x30,0x30,0x04,0x00,0x04,0x02,0x00,0x01,
	0x02,0x00,0x00,0x00,0xf6,0x6e,0x00,0x03,
	0x64,0x00,0x00,0x00,0x00,0x20,0x4f,0xfa,
	0xff,0xd8,0x4e,0x56,0xff,0xfc,0x70,0xf5,
	0x72,0x25,0x43,0xfa,0x02,0x92,0x4e,0x4f,
	0x22,0x29,0x00,0x04,0xe0,0x89,0xe2,0x89,
	0x2d,0x41,0xff,0xfc,0x74,0x01,0xd4,0xba,
	0xff,0xda,0x26,0x3c,0x00,0x00,0x04,0x00,
	0x43,0xfa,0x02,0x74,0x61,0x00,0x00,0xf2,
	0xb0,0xbc,0x00,0x00,0x00,0x00,0x66,0x00,
	0x01,0x0a,0x42,0x81,0x12,0x3a,0xff,0xaf,
	0x42,0x82,0x34,0x3a,0xff,0xaa,0x42,0x83,
	0x16,0x3a,0xff,0xab,0x42,0x85,0x3a,0x3a,
	0xff,0xa0,0xc2,0xc3,0xd4,0x81,0xd4,0xba,
	0xff,0xa2,0x43,0xfa,0x02,0x42,0x26,0x3c,
	0x00,0x00,0x04,0x00,0x61,0x00,0x00,0xba,
	0x4a,0x80,0x66,0x00,0x00,0xd6,0x3c,0x3c,
	0x00,0x1f,0x24,0x49,0x47,0xfa,0x02,0x06,
	0x7e,0x0a,0x10,0x1a,0x80,0x3c,0x00,0x20,
	0xb0,0x1b,0x66,0x06,0x51,0xcf,0xff,0xf4,
	0x60,0x22,0xd3,0xfc,0x00,0x00,0x00,0x20,
	0x51,0xce,0xff,0xe0,0x43,0xfa,0x01,0x59,
	0x2f,0x09,0x43,0xfa,0x00,0xe3,0x61,0x00,
	0x00,0xba,0x22,0x5f,0x61,0x00,0x00,0xb4,
	0x70,0xfe,0x4e,0x4f,0xea,0x8d,0xd4,0x85,
	0x7a,0x00,0x3a,0x29,0x00,0x1a,0xe0,0x5d,
	0x55,0x85,0x10,0x3a,0xff,0x30,0xca,0xc0,
	0xd4,0x85,0x48,0xe7,0x70,0x00,0x43,0xfa,
	0x01,0xd6,0x26,0x3c,0x00,0x00,0x04,0x00,
	0x61,0x4e,0x4c,0xdf,0x00,0x0e,0x43,0xfa,
	0x01,0xc6,0x0c,0x59,0x48,0x55,0x66,0x6a,
	0x54,0x89,0x0c,0x99,0x00,0x00,0x68,0x00,
	0x66,0x68,0x2f,0x19,0x26,0x19,0xd6,0x99,
	0x2f,0x03,0x2f,0x19,0x22,0x7c,0x00,0x00,
	0x67,0xc0,0xd6,0xbc,0x00,0x00,0x00,0x40,
	0x61,0x1e,0x22,0x1f,0x24,0x1f,0x22,0x5f,
	0x4a,0x80,0x66,0x36,0x41,0xf9,0x00,0x00,
	0x68,0x00,0xd1,0xc2,0x53,0x81,0x65,0x04,
	0x42,0x18,0x60,0xf8,0x4e,0x5e,0x4e,0xd1,
	0x48,0xe7,0x3c,0x00,0x2a,0x2e,0xff,0xfc,
	0xd6,0xbc,0x00,0x00,0x03,0xff,0xe0,0x8b,
	0xea,0xab,0xe5,0x8a,0xea,0xaa,0x70,0xf5,
	0x72,0x21,0x4e,0x4f,0x4c,0xdf,0x00,0x3c,
	0x4e,0x75,0x43,0xfa,0x00,0xcf,0x60,0x00,
	0xff,0x50,0x43,0xfa,0x00,0xe6,0x60,0x00,
	0xff,0x48,0x43,0xfa,0x01,0x00,0x60,0x00,
	0xff,0x40,0x70,0x21,0x4e,0x4f,0x4e,0x75,
	0x1a,0x53,0x43,0x53,0x49,0x20,0x49,0x50,
	0x4c,0x20,0x43,0x6f,0x70,0x79,0x72,0x69,
	0x67,0x68,0x74,0x20,0x31,0x39,0x39,0x30,
	0x20,0x53,0x48,0x41,0x52,0x50,0x00,0x1b,
	0x5b,0x34,0x37,0x6d,0x1b,0x5b,0x31,0x33,
	0x3b,0x32,0x36,0x48,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x1b,0x5b,0x31,0x34,0x3b,0x32,0x36,
	0x48,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x1b,
	0x5b,0x31,0x34,0x3b,0x33,0x35,0x48,0x48,
	0x75,0x6d,0x61,0x6e,0x2e,0x73,0x79,0x73,
	0x20,0x82,0xaa,0x20,0x8c,0xa9,0x82,0xc2,
	0x82,0xa9,0x82,0xe8,0x82,0xdc,0x82,0xb9,
	0x82,0xf1,0x00,0x1b,0x5b,0x31,0x34,0x3b,
	0x33,0x38,0x48,0x83,0x66,0x83,0x42,0x83,
	0x58,0x83,0x4e,0x82,0xaa,0x81,0x40,0x93,
	0xc7,0x82,0xdf,0x82,0xdc,0x82,0xb9,0x82,
	0xf1,0x00,0x1b,0x5b,0x31,0x34,0x3b,0x33,
	0x36,0x48,0x48,0x75,0x6d,0x61,0x6e,0x2e,
	0x73,0x79,0x73,0x20,0x82,0xaa,0x20,0x89,
	0xf3,0x82,0xea,0x82,0xc4,0x82,0xa2,0x82,
	0xdc,0x82,0xb7,0x00,0x1b,0x5b,0x31,0x34,
	0x3b,0x33,0x33,0x48,0x48,0x75,0x6d,0x61,
	0x6e,0x2e,0x73,0x79,0x73,0x20,0x82,0xcc,
	0x20,0x83,0x41,0x83,0x68,0x83,0x8c,0x83,
	0x58,0x82,0xaa,0x88,0xd9,0x8f,0xed,0x82,
	0xc5,0x82,0xb7,0x00,0x68,0x75,0x6d,0x61,
	0x6e,0x20,0x20,0x20,0x73,0x79,0x73,0x00,
	0x53,0x43,0x53,0x49,0x20,0x49,0x50,0x4c,
	0x20,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,
	0x20,0x31,0x2e,0x30,0x31
};

//===========================================================================
//
//	trap #0_CAO
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CTrapDlg::CTrapDlg(CWnd *pParent) : CDialog(IDD_TRAPDLG, pParent)
{
	// pւ̑Ή
	if (!::IsJapanese()) {
		m_lpszTemplateName = MAKEINTRESOURCE(IDD_US_TRAPDLG);
		m_nIDHelp = IDD_US_TRAPDLG;
	}

	// R[h
	m_dwCode = 0;
}

//---------------------------------------------------------------------------
//
//	bZ[W }bv
//
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CTrapDlg, CDialog)
	ON_WM_VSCROLL()
END_MESSAGE_MAP()

//---------------------------------------------------------------------------
//
//	_CAO
//
//---------------------------------------------------------------------------
BOOL CTrapDlg::OnInitDialog()
{
	CSpinButtonCtrl *pSpin;

	// {NX
	CDialog::OnInitDialog();

	// XsRg[
	pSpin = (CSpinButtonCtrl*)GetDlgItem(IDC_TRAP_D0S);
	ASSERT(pSpin);
	pSpin->SetRange(0, 255);
	pSpin->SetPos(m_dwCode & 0xff);

	// GfBbg
	OnVScroll(0, m_dwCode & 0xff, NULL);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	cXN[
//
//---------------------------------------------------------------------------
void CTrapDlg::OnVScroll(UINT /*nSBCode*/, UINT nPos, CScrollBar* /*pBar*/)
{
	CString strText;
	CEdit *pEdit;

	// GfBbgRg[擾
	pEdit = (CEdit*)GetDlgItem(IDC_TRAP_D0E);
	ASSERT(pEdit);

	// tH[}bgAݒ
	strText.Format(_T("$%02X"), nPos);
	pEdit->SetWindowText(strText);
}

//---------------------------------------------------------------------------
//
//	_CAOOK
//
//---------------------------------------------------------------------------
void CTrapDlg::OnOK()
{
	CSpinButtonCtrl *pSpin;

	// R[hXV
	pSpin = (CSpinButtonCtrl*)GetDlgItem(IDC_TRAP_D0S);
	ASSERT(pSpin);
	m_dwCode = (DWORD)(LOWORD(pSpin->GetPos()));

	// {NX
	CDialog::OnOK();
}

#endif	// _WIN32
