//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2004 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC ⏕c[ ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#if !defined (mfc_tool_h)
#define mfc_tool_h

//===========================================================================
//
//	tbs[fBXNC[W쐬_CAO
//
//===========================================================================
class CFDIDlg : public CDialog
{
public:
	CFDIDlg(CWnd *pParent);
										// RXgN^
	BOOL OnInitDialog();
										// _CAO
	void OnOK();
										// _CAOOK
	void OnCancel();
										// _CAOLZ

	TCHAR m_szFileName[_MAX_PATH];
										// t@C
	TCHAR m_szDiskName[60];
										// fBXN
	DWORD m_dwType;
										// t@C`(2HD,DIM,D68)
	DWORD m_dwPhysical;
										// tH[}bg
	BOOL m_bLogical;
										// _tH[}bg
	int m_nDrive;
										// }EghCu(-1Ń}EgȂ)

protected:
	afx_msg void OnBrowse();
										// t@CI
	afx_msg void OnPhysical();
										// tH[}bgNbN

private:
	void FASTCALL MaskName();
										// fBXÑ}XN
	void FASTCALL SetPhysical();
										// tH[}bgݒ
	void FASTCALL GetPhysical();
										// tH[}bg擾
	void FASTCALL MaskPhysical();
										// tH[}bg}XN
	void FASTCALL SetLogical();
										// _tH[}bgݒ
	void FASTCALL GetLogical();
										// _tH[}bg擾
	void FASTCALL MaskLogical();
										// _tH[}bg}XN
	static const DWORD IDTable[16];
										// tH[}bgIDe[u
	BOOL FASTCALL GetFile();
	 									// t@C擾

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	eʃfBXNC[W쐬_CAO
//
//===========================================================================
class CDiskDlg : public CDialog
{
public:
	CDiskDlg(CWnd *pParent);
										// RXgN^
	BOOL OnInitDialog();
										// _CAO
	void OnOK();
										// _CAOOK
	BOOL FASTCALL IsSucceeded() const	{ return m_bSucceed; }
										// 쐬ɐ
	BOOL FASTCALL IsCanceled() const	{ return m_bCancel; }
										// LZ
	LPCTSTR FASTCALL GetPath() const	{ return m_szPath; }
										// pX擾
	int m_nType;
										// (0:SASI-HD 1:SCSI-HD 2:SCSI-MO)
	BOOL m_bMount;
										// }EgtO(SCSI-MÔ)

protected:
	afx_msg void OnBrowse();
										// t@CI
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pBar);
										// cXN[
	afx_msg void OnMOSize();
										// MOTCYύX

private:
	void FASTCALL CtrlSASI();
										// SASI-HD Rg[
	void FASTCALL CtrlSCSI();
										// SCSI-HD Rg[
	void FASTCALL CtrlMO();
										// SCSI-MO Rg[
	BOOL FASTCALL GetFile();
										// t@CI
	void FASTCALL CreateSASI();
										// SASI-HD fBXN쐬
	void FASTCALL CreateSCSI();
										// SCSI-HD fBXN쐬
	void FASTCALL CreateMO();
										// SCSI-MO fBXN쐬

	TCHAR m_szPath[_MAX_PATH];
										// pX
	BOOL m_bSucceed;
										// 쐬ɐ
	BOOL m_bCancel;
										// LZ
	UINT m_nSize;
										// fBXNTCY(MB)
	UINT m_nFormat;
										// _tH[}bg
	static const UINT SASITable[];
										// SASI-HD IDe[u
	static const UINT SCSITable[];
										// SCSI-HD IDe[u
	static const UINT MOTable[];
										// SCSI-MO IDe[u

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	fBXNC[W쐬_CAO
//
//===========================================================================
class CDiskMakeDlg : public CDialog
{
public:
	// {t@NV
	CDiskMakeDlg(CWnd *pParent);
										// RXgN^
	BOOL OnInitDialog();
										// _CAO
	void OnOK();
										// _CAOOK
	void OnCancel();
										// _CAOLZ

	// API
	BOOL FASTCALL IsSucceeded() const	{ return m_bSucceed; }
										// 쐬ɐ
	BOOL FASTCALL IsCanceled() const	{ return m_bCancel; }
										// LZ
	static UINT ThreadFunc(LPVOID lpParam);
										// Xbh֐
	void FASTCALL Run();
										// XbhC

	// p[^
	DWORD m_dwSize;
										// fBXNTCY
	TCHAR m_szPath[_MAX_PATH];
										// pX
	int m_nFormat;
										// _tH[}bg

protected:
#if _MFC_VER >= 0x700
	afx_msg void OnTimer(UINT_PTR nTimerID);
#else
	afx_msg void OnTimer(UINT nTimerID);
#endif
										// ^C}
	afx_msg void OnDestroy();
										// _CAO폜
	virtual BOOL FASTCALL Format();
										// _tH[}bg
	DWORD m_dwCurrent;
										// 쐬Ǘ

private:
	CWinThread *m_pThread;
										// 쐬Xbh
	BOOL m_bThread;
										// XbhItO
	CCriticalSection m_CSection;
										// NeBJZNV
	BYTE *m_pBuffer;
										// obt@
#if _MFC_VER >= 0x700
	UINT_PTR m_nTimerID;
#else
	UINT m_nTimerID;
#endif
										// ^C}ID
	DWORD m_dwParcent;
										// isp[Zg
	BOOL m_bSucceed;
										// tO
	BOOL m_bCancel;
										// LZtO

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	SASIfBXNC[W쐬_CAO
//
//===========================================================================
class CSASIMakeDlg : public CDiskMakeDlg
{
public:
	CSASIMakeDlg(CWnd *pParent);
										// RXgN^

protected:
	BOOL FASTCALL Format();
										// tH[}bg

private:
	static const BYTE MENU[];
										// j[
	static const BYTE IPL[];
										// IPL
};

//===========================================================================
//
//	SCSIfBXNC[W쐬_CAO
//
//===========================================================================
class CSCSIMakeDlg : public CDiskMakeDlg
{
public:
	CSCSIMakeDlg(CWnd *pParent);
										// RXgN^
};

//===========================================================================
//
//	MOfBXNC[W쐬_CAO
//
//===========================================================================
class CMOMakeDlg : public CDiskMakeDlg
{
public:
	CMOMakeDlg(CWnd *pParent);
										// RXgN^

protected:
	BOOL FASTCALL Format();
										// tH[}bg

private:
	int m_nMedia;
										// fBA^Cv(0:128MB...3:640MB)
	BOOL FASTCALL FormatIBM();
										// IBMtH[}bg
	void FASTCALL MakeBPB(BYTE *pBPB);
										// IBMtH[}bgBPB쐬
	void FASTCALL MakeSerial(BYTE *pSerial);
										// {[VA쐬
	BOOL FASTCALL FormatSHARP();
										// SHARPtH[}bg
	static const BYTE PartTable128[];
										// p[eBVe[u(128MB)
	static const BYTE PartTable230[];
										// p[eBVe[u(230MB)
	static const BYTE PartTable540[];
										// p[eBVe[u(540MB)
	static const BYTE PartTop128[];
										// 1p[eBV(128MB)
	static const BYTE PartTop230[];
										// 1p[eBV(230MB)
	static const BYTE PartTop540[];
										// 1p[eBV(540MB)
	static const BYTE SCSIMENU[];
										// SCSIp[eBVIj[
	static const BYTE SCHDISK[];
										// SCSIfBXNhCo
	static const BYTE SCSIIOCS[];
										// SCSIIOCS⏕hCo
	static const BYTE IPL[];
										// Human68k IPL
};

//===========================================================================
//
//	trap #0_CAO
//
//===========================================================================
class CTrapDlg : public CDialog
{
public:
	CTrapDlg(CWnd *pParent);
										// RXgN^
	BOOL OnInitDialog();
										// _CAO
	void OnOK();
										// _CAOOK
	DWORD m_dwCode;
										// R[hl

protected:
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar *pBar);
										// cXN[

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

#endif	// mfc_tool_h
#endif	// _WIN32
