//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2005 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC TuEBhE(rfI) ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#if !defined(mfc_vid_h)
#define mfc_vid_h

#include "mfc_sub.h"

//===========================================================================
//
//	TurfIEBhE
//
//===========================================================================
class CSubVideoWnd : public CSubWnd
{
public:
	CSubVideoWnd();
										// RXgN^
	BOOL PreCreateWindow(CREATESTRUCT& cs);
										// EBhE쐬
	void FASTCALL Refresh();
										// tbV
	void FASTCALL Update();
										// bZ[WXbh̍XV
#if !defined(NDEBUG)
	void AssertValid() const;
										// ff
#endif	// NDEBUG

protected:
	// bZ[W nh
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
										// EBhE쐬
	afx_msg void OnSizing(UINT nSide, LPRECT lpRect);
										// TCYύX
	afx_msg void OnSize(UINT nType, int cx, int cy);
										// TCYύX

	// XV
	virtual void FASTCALL Setup(CRect& rect, BYTE *pBits) = 0;
										// ZbgAbv

	// qEBhE
	CSubBMPWnd *m_pBMPWnd;
										// rbg}bvEBhE
	CStatusBar m_StatusBar;
										// Xe[^Xo[
	int m_nScrlWidth;
										// zʕ(hbgP)
	int m_nScrlHeight;
										// zʍ(hbgP)
	int m_nPane;
										// Xe[^Xo[yC

	// 
	DWORD FASTCALL GetColor(DWORD dwColor) const;
										// J[쐬 (16bit)
	DWORD FASTCALL GetPalette(DWORD dwPalette) const;
										// J[쐬 (pbgCfbNX)
	CRTC *m_pCRTC;
										// CRTC
	VC *m_pVC;
										// VC
	BOOL m_bScroll;
										// XN[l
	BOOL m_bPalette;
										// pbgl
	BOOL m_bContrast;
										// RgXgl

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};


//===========================================================================
//
//	eLXgʃEBhE
//
//===========================================================================
class CTVRAMWnd : public CSubVideoWnd
{
public:
	CTVRAMWnd();
										// RXgN^
	void FASTCALL Setup(CRect& rect, BYTE *pBits);
										// ZbgAbv
	void FASTCALL Update();
										// bZ[WXbh̍XV

private:
	TVRAM *m_pTVRAM;
										// TVRAM
};

//===========================================================================
//
//	OtBbN(1024~1024)EBhE
//
//===========================================================================
class CG1024Wnd : public CSubBitmapWnd
{
public:
	CG1024Wnd();
										// RXgN^
	void FASTCALL Setup(int x, int y, int width, int height, BYTE *ptr);
										// ZbgAbv
	void FASTCALL Update();
										// bZ[WXbh̍XV

private:
	const WORD *m_pPalette;
										// VCpbgAhX
	WORD m_WndPalette[16];
										// EBhEێpbg
	DWORD m_WndColor[16];
										// EBhEJ[e[u
	const BYTE *m_pGVRAM;
										// GVRAMAhX
};

//===========================================================================
//
//	OtBbN(16F)EBhE
//
//===========================================================================
class CG16Wnd : public CSubBitmapWnd
{
public:
	CG16Wnd(int nPage);
										// RXgN^
	void FASTCALL Setup(int x, int y, int width, int height, BYTE *ptr);
										// ZbgAbv
	void FASTCALL Update();
										// bZ[WXbh̍XV

private:
	int m_nPage;
										// y[Wԍ
	const WORD *m_pPalette;
										// VCpbgAhX
	WORD m_WndPalette[16];
										// EBhEێpbg
	DWORD m_WndColor[16];
										// EBhEJ[e[u
	const BYTE *m_pGVRAM;
										// GVRAMAhX
};

//===========================================================================
//
//	OtBbN(256F)EBhE
//
//===========================================================================
class CG256Wnd : public CSubBitmapWnd
{
public:
	CG256Wnd(int nPage);
										// RXgN^
	void FASTCALL Setup(int x, int y, int width, int height, BYTE *ptr);
										// ZbgAbv
	void FASTCALL Update();
										// bZ[WXbh̍XV

private:
	int m_nPage;
										// y[Wԍ
	const WORD *m_pPalette;
										// VCpbgAhX
	WORD m_WndPalette[256];
										// EBhEێpbg
	DWORD m_WndColor[256];
										// EBhEJ[e[u
	const BYTE *m_pGVRAM;
										// GVRAMAhX
};

//===========================================================================
//
//	OtBbN(65536F)EBhE
//
//===========================================================================
class CG64KWnd : public CSubBitmapWnd
{
public:
	CG64KWnd();
										// RXgN^
	void FASTCALL Setup(int x, int y, int width, int height, BYTE *ptr);
										// ZbgAbv
	void FASTCALL Update();
										// bZ[WXbh̍XV

private:
	void FASTCALL Palette();
										// pbgĐݒ
	const WORD *m_pPalette;
										// VCpbgAhX
	WORD m_WndPalette[256];
										// EBhEێpbg
	DWORD m_WndColor[0x10000];
										// EBhEJ[e[u
	const BYTE *m_pGVRAM;
										// GVRAMAhX
};

//===========================================================================
//
//	PCGEBhE
//
//===========================================================================
class CPCGWnd : public CSubBitmapWnd
{
public:
	CPCGWnd();
										// RXgN^
	void FASTCALL Setup(int x, int y, int width, int height, BYTE *ptr);
										// ZbgAbv
	void FASTCALL Update();
										// bZ[WXbh̍XV
	afx_msg void OnParentNotify(UINT message, LPARAM lParam);
										// eEChE֒ʒm
	afx_msg void OnContextMenu(CWnd *pWnd, CPoint point);
										// ReLXgj[
	afx_msg void OnPalette(UINT uID);
										// pbgύX

private:
	const WORD *m_pPalette;
										// VCpbgAhX
	WORD m_WndPalette[256];
										// EBhEێpbg
	DWORD m_WndColor[256];
										// EBhEJ[e[u
	const BYTE *m_pPCG;
										// PCGAhX
	int m_nColor;
										// J[ubN

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	BGEBhE
//
//===========================================================================
class CBGWnd : public CSubBitmapWnd
{
public:
	CBGWnd(int nPage);
										// RXgN^
	void FASTCALL Setup(int x, int y, int width, int height, BYTE *ptr);
										// ZbgAbv
	void FASTCALL Update();
										// bZ[WXbh̍XV

private:
	const WORD *m_pPalette;
										// VCpbgAhX
	WORD m_WndPalette[256];
										// EBhEێpbg
	DWORD m_WndColor[256];
										// EBhEJ[e[u
	int m_nPage;
										// y[W
	Sprite *m_pSprite;
										// XvCgRg[
};

//===========================================================================
//
//	pbgEBhE
//
//===========================================================================
class CPaletteWnd : public CSubBitmapWnd
{
public:
	CPaletteWnd(BOOL bRend);
										// RXgN^
	void FASTCALL Setup(int x, int y, int width, int height, BYTE *ptr);
										// ZbgAbv
	void FASTCALL Update();
										// bZ[WXbh̍XV

private:
	void FASTCALL SetupRend(DWORD *buf, int no);
										// ZbgAbv(_)
	void FASTCALL SetupVC(DWORD *buf, int no);
										// ZbgAbv(VC)
	BOOL m_bRend;
										// _tO
	Render *m_pRender;
										// _
	const WORD *m_pVCPal;
										// VCpbg
};

#endif	// mfc_vid_h
#endif	// _WIN32
