//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2005 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC TuEBhE(Win32) ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#if !defined(mfc_w32_h)
#define mfc_w32_h

#include "keyboard.h"
#include "mfc_sub.h"
#include "mfc_midi.h"

//===========================================================================
//
//	R|[lgEBhE
//
//===========================================================================
class CComponentWnd : public CSubTextWnd
{
public:
	CComponentWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	CComponent *m_pComponent;
										// ŏ̃R|[lg
};

//===========================================================================
//
//	OSEBhE
//
//===========================================================================
class COSInfoWnd : public CSubTextWnd
{
public:
	COSInfoWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv
};

//===========================================================================
//
//	TEhEBhE
//
//===========================================================================
class CSoundWnd : public CSubTextWnd
{
public:
	CSoundWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	Scheduler *m_pScheduler;
										// XPW[
	OPMIF *m_pOPMIF;
										// OPM
	ADPCM *m_pADPCM;
										// ADPCM
	CSound *m_pSound;
										// TEhR|[lg
};

//===========================================================================
//
//	CvbgEBhE
//
//===========================================================================
class CInputWnd : public CSubTextWnd
{
public:
	CInputWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	void FASTCALL SetupInput(int x, int y);
										// ZbgAbv(͌nS)
	void FASTCALL SetupMouse(int x, int y);
										// ZbgAbv(}EX)
	void FASTCALL SetupKey(int x, int y);
										// ZbgAbv(L[{[h)
	void FASTCALL SetupJoy(int x, int y, int nJoy);
										// ZbgAbv(WCXeBbN)
	CInput *m_pInput;
										// CvbgR|[lg
};

//===========================================================================
//
//	|[gEBhE
//
//===========================================================================
class CPortWnd : public CSubTextWnd
{
public:
	CPortWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	CPort *m_pPort;
										// |[gR|[lg
};

//===========================================================================
//
//	rbg}bvEBhE
//
//===========================================================================
class CBitmapWnd : public CSubTextWnd
{
public:
	CBitmapWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	CDrawView *m_pView;
										// `EBhE
};

//===========================================================================
//
//	MIDIhCoEBhE
//
//===========================================================================
class CMIDIDrvWnd : public CSubTextWnd
{
public:
	CMIDIDrvWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	void FASTCALL SetupInfo(int x, int y, CMIDI::LPMIDIINFO pInfo);
										// ZbgAbv(Tu)
	void FASTCALL SetupExCnt(int x, int y, DWORD dwStart, DWORD dwEnd);
										// ZbgAbv(GNXN[VuJE^)
	static LPCTSTR DescTable[];
										// e[u
	MIDI *m_pMIDI;
										// MIDI
	CMIDI *m_pMIDIDrv;
										// MIDIhCo
};

//===========================================================================
//
//	L[{[hfBXvCEBhE
//
//===========================================================================
class CKeyDispWnd : public CWnd
{
public:
	CKeyDispWnd();
										// RXgN^
	void PostNcDestroy();
										// EBhE폜
	void FASTCALL SetShiftMode(UINT nMode);
										// Vtg[hݒ
	void FASTCALL Refresh(const BOOL *m_pKeyBuf);
										// L[XV
	void FASTCALL SetKey(const BOOL *m_pKeyBuf);
										// L[ꊇݒ

protected:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
										// EBhE쐬
	afx_msg void OnDestroy(void);
										// EBhE폜
	afx_msg void OnSize(UINT nType, int cx, int cy);
										// EBhETCYύX
	afx_msg BOOL OnEraseBkgnd(CDC *pDC);
										// wi`
	afx_msg void OnPaint();
										// EBhEĕ`
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
										// {^
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
										// {^
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
										// E{^
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
										// E{^
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
										// }EXړ
	afx_msg UINT OnGetDlgCode();
										// _CAOR[h擾

private:
	void FASTCALL SetupBitmap();
										// rbg}bv
	void FASTCALL OnDraw(CDC *pDC);
										// EBhE`
	LPCTSTR FASTCALL GetKeyString(int nKey);
										// L[擾
	int FASTCALL PtInKey(CPoint& point);
										// `L[R[h擾
	void FASTCALL DrawKey(int nKey, BOOL bDown);
										// L[\
	void FASTCALL DrawBox(int nColorOut, int nColorIn, RECT& rect);
										// L[{bNX`
	void FASTCALL DrawCRBox(int nColorOut, int nColorIn, RECT& rect);
										// CRL[{bNX`
	void FASTCALL DrawChar(int x, int y, int nColor, DWORD dwChar);
										// LN^`
	void FASTCALL DrawCRChar(int x, int y, int nColor);
										// CRLN^`
	int FASTCALL CalcCGAddr(DWORD dwChar);
										// SpCGROMAhXZo
	UINT m_nMode;
										// SHIFT[h
	UINT m_nKey[0x80];
										// L[(\)
	BOOL m_bKey[0x80];
										// L[(ŏI)
	int m_nPoint;
										// }EXړ|Cg
	const BYTE* m_pCG;
										// CGROM
	HBITMAP m_hBitmap;
										// rbg}bvnh
	BYTE *m_pBits;
										// rbg}bvrbg
	UINT m_nBMPWidth;
										// rbg}bv
	UINT m_nBMPHeight;
										// rbg}bv
	UINT m_nBMPMul;
										// rbg}bvZ
	static RGBQUAD PalTable[0x10];
										// pbge[u
	static const RECT RectTable[0x75];
										// `e[u
	static LPCTSTR NormalTable[];
										// e[u
	static LPCTSTR KanaTable[];
										// e[u
	static LPCTSTR KanaShiftTable[];
										// e[u
	static LPCTSTR MarkTable[];
										// e[u
	static LPCTSTR AnotherTable[];
										// e[u

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	\tgEFAL[{[hEBhE
//
//===========================================================================
class CSoftKeyWnd : public CSubWnd
{
public:
	CSoftKeyWnd();
										// RXgN^
	void FASTCALL Refresh();
										// tbV

protected:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
										// EBhE쐬
	afx_msg void OnDestroy();
										// EBhE폜
	afx_msg void OnActivate(UINT nState, CWnd *pWnd, BOOL bMinimized);
										// ANeBx[g
	afx_msg LONG OnApp(UINT uParam, LONG lParam);
										// [U(ʃEBhE̒ʒm)

private:
	void FASTCALL Analyze(Keyboard::keyboard_t *pKbd);
										// L[{[hf[^
	Keyboard *m_pKeyboard;
										// L[{[h
	CInput *m_pInput;
										// Cvbg
	CStatusBar m_StatusBar;
										// Xe[^Xo[
	CKeyDispWnd *m_pDispWnd;
										// L[fBXvCEBhE
	UINT m_nSoftKey;
										// \tg̃L[

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

#endif	// mfc_w32_h
#endif	// _WIN32
