//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ ADPCM(MSM6258V) ]
//
//---------------------------------------------------------------------------

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "log.h"
#include "schedule.h"
#include "dmac.h"
#include "fileio.h"
#include "config.h"
#include "adpcm.h"

//===========================================================================
//
//	ADPCM
//
//===========================================================================
//#define ADPCM_LOG

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
ADPCM::ADPCM(VM *p) : MemDevice(p)
{
	// foCXID
	dev.id = MAKEID('A', 'P', 'C', 'M');
	dev.desc = "ADPCM (MSM6258V)";

	// JnAhXAIAhX
	memdev.first = 0xe92000;
	memdev.last = 0xe93fff;

	// ̑ARXgN^ŏׂ[N
	memset(&adpcm, 0, sizeof(adpcm));
	adpcm.sync_rate = 882;
	adpcm.sync_step = 0x9c4000 / 882;
	adpcm.vol = 0;
	adpcm.enable = FALSE;
	adpcm.sound = TRUE;
	dmac = NULL;
	adpcmbuf = NULL;
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL ADPCM::Init()
{
	ASSERT(this);

	// {NX
	if (!MemDevice::Init()) {
		return FALSE;
	}

	// DMAC擾
	ASSERT(!dmac);
	dmac = (DMAC*)vm->SearchDevice(MAKEID('D', 'M', 'A', 'C'));
	ASSERT(dmac);

	// obt@m
	try {
		adpcmbuf = new DWORD[ BufMax * 2 ];
	}
	catch (...) {
		return FALSE;
	}
	if (!adpcmbuf) {
		return FALSE;
	}
	memset(adpcmbuf, 0, sizeof(DWORD) * (BufMax * 2));

	// Cxg쐬
	event.SetDevice(this);
	event.SetDesc("Sampling");
	event.SetUser(0);
	event.SetTime(0);
	scheduler->AddEvent(&event);

	// `ԃp[^
	adpcm.interp = FALSE;

	// ZbgOPMIFCT邽߁AŏĂ
	adpcm.ratio = 0;
	adpcm.speed = 0x400;
	adpcm.clock = 8;

	// e[u쐬Aʐݒ
	MakeTable();
	SetVolume(52);

	// obt@
	InitBuf(adpcm.sync_rate * 50);

	// x
	CalcSpeed();

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::Cleanup()
{
	ASSERT(this);

	// obt@폜
	if (adpcmbuf) {
		delete[] adpcmbuf;
		adpcmbuf = NULL;
	}

	// {NX
	MemDevice::Cleanup();
}

//---------------------------------------------------------------------------
//
//	Zbg
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::Reset()
{
	ASSERT(this);
	ASSERT_DIAG();

	LOG0(Log::Normal, "Zbg");

	// [N
	adpcm.play = FALSE;
	adpcm.rec = FALSE;
	adpcm.active = FALSE;
	adpcm.started = FALSE;
	adpcm.panpot = 0;
	adpcm.ratio = 0;
	adpcm.speed = 0x400;
	adpcm.data = 0;
	adpcm.offset = 0;
	adpcm.out = 0;
	adpcm.sample = 0;
	adpcm.clock = 8;
	CalcSpeed();

	// obt@
	InitBuf(adpcm.sync_rate * 50);

	// Cxg~߂
	event.SetUser(0);
	event.SetTime(0);
	event.SetDesc("Sampling");
}

//---------------------------------------------------------------------------
//
//	Z[u
//
//---------------------------------------------------------------------------
BOOL FASTCALL ADPCM::Save(Fileio *fio, int ver)
{
	size_t sz;

	ASSERT(this);
	ASSERT(fio);
	ASSERT_DIAG();

	LOG0(Log::Normal, "Z[u");

	// TCYZ[u
	sz = sizeof(adpcm_t);
	if (!fio->Write(&sz, sizeof(sz))) {
		return FALSE;
	}

	// ̂Z[u
	if (!fio->Write(&adpcm, (int)sz)) {
		return FALSE;
	}

	// CxgZ[u
	if (!event.Save(fio, ver)) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
BOOL FASTCALL ADPCM::Load(Fileio *fio, int ver)
{
	size_t sz;

	ASSERT(this);
	ASSERT(fio);
	ASSERT_DIAG();

	LOG0(Log::Normal, "[h");

	// TCY[hAƍ
	if (!fio->Read(&sz, sizeof(sz))) {
		return FALSE;
	}
	if (sz != sizeof(adpcm_t)) {
		return FALSE;
	}

	// ̂[h
	if (!fio->Read(&adpcm, (int)sz)) {
		return FALSE;
	}

	// Cxg[h
	if (!event.Load(fio, ver)) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::ApplyCfg(const Config *config)
{
	ASSERT(this);
	ASSERT(config);
	ASSERT_DIAG();

	LOG0(Log::Normal, "ݒKp");

	// `
	adpcm.interp = config->adpcm_interp;
}

#if !defined(NDEBUG)
//---------------------------------------------------------------------------
//
//	ff
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::AssertDiag() const
{
	// {NX
	MemDevice::AssertDiag();

	ASSERT(this);
	ASSERT(GetID() == MAKEID('A', 'P', 'C', 'M'));
	ASSERT(memdev.first == 0xe92000);
	ASSERT(memdev.last == 0xe93fff);
	ASSERT(dmac);
	ASSERT(dmac->GetID() == MAKEID('D', 'M', 'A', 'C'));
	ASSERT((adpcm.panpot >= 0) && (adpcm.panpot <= 3));
	ASSERT((adpcm.play == TRUE) || (adpcm.play == FALSE));
	ASSERT((adpcm.rec == TRUE) || (adpcm.rec == FALSE));
	ASSERT((adpcm.active == TRUE) || (adpcm.active == FALSE));
	ASSERT((adpcm.started == TRUE) || (adpcm.started == FALSE));
	ASSERT((adpcm.clock == 4) || (adpcm.clock == 8));
	ASSERT((adpcm.ratio == 0) || (adpcm.ratio == 1) || (adpcm.ratio == 2));
	ASSERT((adpcm.speed & 0x007f) == 0);
	ASSERT((adpcm.speed >= 0x0100) && (adpcm.speed <= 0x400));
	ASSERT(adpcm.data < 0x100);
	ASSERT((adpcm.offset >= 0) && (adpcm.offset <= 48));
	ASSERT((adpcm.enable == TRUE) || (adpcm.enable == FALSE));
	ASSERT((adpcm.sound == TRUE) || (adpcm.sound == FALSE));
	ASSERT(adpcm.readpoint < BufMax);
	ASSERT(adpcm.writepoint < BufMax);
	ASSERT(adpcm.number <= BufMax);
	ASSERT(adpcm.sync_cnt < 0x4000);
	ASSERT((adpcm.interp == TRUE)  || (adpcm.interp == FALSE));
	ASSERT(adpcmbuf);
}
#endif	// NDEBUG

//---------------------------------------------------------------------------
//
//	oCgǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL ADPCM::ReadByte(DWORD addr)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));
	ASSERT_DIAG();

	// AhX̂݃fR[hĂ
	if ((addr & 1) != 0) {
		// 4oCgPʂŃ[v
		addr &= 3;

		// EFCg
		scheduler->Wait(1);

		// AhXU蕪
		if (addr == 3) {
			// f[^WX^
			if (adpcm.rec && adpcm.active) {
				// ^f[^Ƃ0x80Ԃ
				return 0x80;
			}
			return adpcm.data;
		}

		// Xe[^XWX^
		if (adpcm.play) {
			// ĐA܂͍Đ
			return 0x7f;
		}
		else {
			// ^[hA܂͍ĐwȂ
			return 0xff;
		}
	}

	// AhX̓fR[hĂȂ
	return 0xff;
}

//---------------------------------------------------------------------------
//
//	[hǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL ADPCM::ReadWord(DWORD addr)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));
	ASSERT((addr & 1) == 0);
	ASSERT_DIAG();

	return (0xff00 | ReadByte(addr + 1));
}

//---------------------------------------------------------------------------
//
//	oCg
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::WriteByte(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));
	ASSERT(data < 0x100);
	ASSERT_DIAG();

	// AhX̂݃fR[hĂ
	if ((addr & 1) != 0) {
		// 4oCgPʂŃ[v
		addr &= 3;

		// EFCg
		scheduler->Wait(1);

		// AhXU蕪
		if (addr == 3) {
			// f[^WX^
			adpcm.data = data;
			return;
		}

#if defined(ADPCM_LOG)
		LOG1(Log::Normal, "ADPCMR}h $%02X", data);
#endif	// ADPCM_LOG

		// R}hWX^
		if (data & 1) {
			// ~
			Stop();
		}
		if (data & 2) {
			// ĐX^[g
			adpcm.play = TRUE;
			Start(0);
			return;
		}
		if (data & 4) {
			// ^X^[g
			adpcm.rec = TRUE;
			Start(1);
			return;
		}
		return;
	}

	// AhX̓fR[hĂȂ
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::WriteWord(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));
	ASSERT((addr & 1) == 0);
	ASSERT(data < 0x10000);
	ASSERT_DIAG();

	WriteByte(addr + 1, (BYTE)data);
}

//---------------------------------------------------------------------------
//
//	ǂݍ݂̂
//
//---------------------------------------------------------------------------
DWORD FASTCALL ADPCM::ReadOnly(DWORD addr) const
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));
	ASSERT_DIAG();

	// AhX̂݃fR[hĂ
	if (addr & 1) {
		// 4oCgPʂŃ[v
		addr &= 3;

		// AhXU蕪
		if (addr == 3) {
			// f[^WX^
			if (adpcm.rec && adpcm.active) {
				return 0x80;
			}
			return adpcm.data;
		}

		// Xe[^XWX^
		if (adpcm.play) {
			// ĐA܂͍Đ
			return 0x7f;
		}
		else {
			// ^[hA܂͍ĐwȂ
			return 0xff;
		}
	}

	return 0xff;
}

//---------------------------------------------------------------------------
//
//	f[^擾
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::GetADPCM(adpcm_t *buffer)
{
	ASSERT(this);
	ASSERT(buffer);
	ASSERT_DIAG();

	// f[^Rs[
	*buffer = adpcm;
}

//---------------------------------------------------------------------------
//
//	CxgR[obN
//
//---------------------------------------------------------------------------
BOOL FASTCALL ADPCM::Callback(Event *ev)
{
	BOOL valid;
	DWORD num;
	char string[64];

	ASSERT(this);
	ASSERT(ev);
	ASSERT_DIAG();

	// EFCg΍A̎Ԃ܂ň΂
	if (adpcm.wait <= 0) {
		while (adpcm.wait <= 0) {
			// CANeBu܂ReqDMAs̏ꍇA80Ƃ
			adpcm.data = 0x80;
			valid = FALSE;

			// 1̃Cxg1oCg(2Tv)̏s
			if (adpcm.active) {
				if (dmac->ReqDMA(3)) {
					// DMA]
					valid = TRUE;
				}
			}

			// Đ
			if (ev->GetUser() == 0) {
				// 0x88,0x80,0x00ȊO̓X^[gtOON
				if ((adpcm.data != 0x88) && (adpcm.data != 0x80) && (adpcm.data != 0x00)) {
#if defined(ADPCM_LOG)
					if (!adpcm.started) {
						LOG0(Log::Normal, "Lf[^o");
					}
#endif	// ADPCM_LOG
					adpcm.started = TRUE;
				}

				// ADPCMPCMϊAobt@փXgA
				num = adpcm.speed;
				num >>= 7;
				ASSERT((num >= 2) && (num <= 16));

				Decode((int)adpcm.data, num, valid);
				Decode((int)(adpcm.data >> 4), num, valid);
			}
			adpcm.wait++;
		}

		// EFCgZbg
		adpcm.wait = 0;

		// xύXɑΉ
		if (ev->GetTime() == adpcm.speed) {
			return TRUE;
		}
		sprintf(string, "Sampling %dHz", (2 * 1000 * 1000) / adpcm.speed);
		ev->SetDesc(string);
		ev->SetTime(adpcm.speed);
		return TRUE;
	}

	// EFCg炷
	adpcm.wait--;

	// xύXɑΉ
	if (ev->GetTime() == adpcm.speed) {
		return TRUE;
	}
	sprintf(string, "Sampling %dHz", (2 * 1000 * 1000) / adpcm.speed);
	ev->SetDesc(string);
	ev->SetTime(adpcm.speed);
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	NbNw
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::SetClock(DWORD clk)
{
	ASSERT(this);
	ASSERT((clk == 4) || (clk == 8));
	ASSERT_DIAG();

#if defined(ADPCM_LOG)
	LOG1(Log::Normal, "NbN %dMHz", clk);
#endif	// ADPCM_LOG

	// xČvZ
	adpcm.clock = clk;
	CalcSpeed();
}

//---------------------------------------------------------------------------
//
//	NbN䗦w
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::SetRatio(DWORD ratio)
{
	ASSERT(this);
	ASSERT((ratio >= 0) || (ratio <= 3));
	ASSERT_DIAG();

#if defined(ADPCM_LOG)
	LOG1(Log::Normal, "x䗦 %d", ratio);
#endif	// ADPCM_LOG

	// ratio=32Ƃ݂Ȃ
	if (ratio == 3) {
		LOG0(Log::Warning, "`[gw $03");
		ratio = 2;
	}

	// xČvZ
	if (adpcm.ratio != ratio) {
		adpcm.ratio = ratio;
		CalcSpeed();
	}
}

//---------------------------------------------------------------------------
//
//	p|bgw
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::SetPanpot(DWORD panpot)
{
	ASSERT(this);
	ASSERT((panpot >= 0) || (panpot <= 3));
	ASSERT_DIAG();

#if defined(ADPCM_LOG)
	LOG1(Log::Normal, "p|bgw %d", panpot);
#endif	// ADPCM_LOG

	adpcm.panpot = panpot;
}

//---------------------------------------------------------------------------
//
//	xČvZ
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::CalcSpeed()
{
	ASSERT(this);

	// 珇ɁA2, 3, 4
	adpcm.speed = 2 - adpcm.ratio;
	ASSERT(adpcm.speed <= 2);
	adpcm.speed += 2;

	// NbN4MHzȂ256A8MHzȂ128悸
	adpcm.speed <<= 7;
	if (adpcm.clock == 4) {
		adpcm.speed <<= 1;
	}
}

//---------------------------------------------------------------------------
//
//	^EĐJn
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::Start(int type)
{
	char string[64];

	ASSERT(this);
	ASSERT((type == 0) || (type == 1));
	ASSERT_DIAG();

#if defined(ADPCM_LOG)
	LOG1(Log::Normal, "ĐJn %d", type);
#endif	// ADPCM_LOG

	// ANeButOグ
	adpcm.active = TRUE;

	// f[^
	adpcm.offset = 0;

	// Cxgݒ
	event.SetUser(type);

	// ŕKԐݒ(@Ƃ͈قȂ\邪AFMƂ̓D)
	sprintf(string, "Sampling %dHz", (2 * 1000 * 1000) / adpcm.speed);
	event.SetDesc(string);
	event.SetTime(adpcm.speed);

	// ̃CxgŎs(FMƂ̓Ƃʑ[u)
	Callback(&event);
}

//---------------------------------------------------------------------------
//
//	^EĐ~
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::Stop()
{
	ASSERT(this);
	ASSERT_DIAG();

#if defined(ADPCM_LOG)
	LOG0(Log::Normal, "~");
#endif	// ADPCM_LOG

	// tO~낷
	adpcm.active = FALSE;
	adpcm.play = FALSE;
	adpcm.rec = FALSE;
}

//---------------------------------------------------------------------------
//
//	ψʃe[u
//
//---------------------------------------------------------------------------
const int ADPCM::NextTable[] = {
	-1, -1, -1, -1, 2, 4, 6, 8,
	-1, -1, -1, -1, 2, 4, 6, 8
};

//---------------------------------------------------------------------------
//
//	ItZbge[u
//
//---------------------------------------------------------------------------
const int ADPCM::OffsetTable[] = {
	 0,
	 0,  1,  2,  3,  4,  5,  6,  7,
	 8,  9, 10, 11, 12, 13, 14, 15,
	16, 17, 18, 19, 20, 21, 22, 23,
	24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39,
	40, 41, 42, 43, 44, 45, 46, 47,
	48, 48, 48, 48, 48, 48, 48, 48,
	48
};

//---------------------------------------------------------------------------
//
//	fR[h
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::Decode(int data, int num, BOOL valid)
{
	int i;
	int store;
	int sample;
	int diff;
	int base;

	ASSERT(this);
	ASSERT((data >= 0) && (data < 0x100));
	ASSERT(num >= 2);
	ASSERT_DIAG();

	// fBZ[uȂ牽Ȃ
	if (!adpcm.enable) {
		return;
	}

	// f[^}XN
	data &= 0x0f;

	// e[u瓾
	i = adpcm.offset << 4;
	i |= data;
	sample = DiffTable[i];

	// ̃ItZbg߂Ă
	adpcm.offset += NextTable[data];
	adpcm.offset = OffsetTable[adpcm.offset + 1];

	// XgAf[^Z
	store = (sample << 8) + (adpcm.sample * 245);
	store >>= 8;

	// ʏ{lL
	base = adpcm.sample;
	base *= adpcm.vol;
	base >>= 9;
	adpcm.sample = store;
	store *= adpcm.vol;
	store >>= 9;
	adpcm.out = store;

	// Lȃf[^ĂȂȂATvグ
	if (!valid) {
		if (adpcm.sample < 0) {
			adpcm.sample++;
		}
		if (adpcm.sample > 0) {
			adpcm.sample--;
		}
	}

	// us[v̏
	if ((adpcm.sample == 0) || (adpcm.sample == -1) || (adpcm.sample == 1)) {
		store = 0;
	}

	// 𓾂
	diff = store - base;

	// ʂlāAnumTvXgA
	switch (adpcm.panpot) {
		// EƂo
		case 0:
			for (i=0; i<num; i++) {
				store = base + (diff * (i + 1)) / num;
				adpcmbuf[adpcm.writepoint++] = store;
				adpcmbuf[adpcm.writepoint++] = store;
				adpcm.writepoint &= (BufMax - 1);
			}
			break;

		// ̂ݏo
		case 1:
			for (i=0; i<num; i++) {
				store = base + (diff * (i + 1)) / num;
				adpcmbuf[adpcm.writepoint++] = store;
				adpcmbuf[adpcm.writepoint++] = 0;
				adpcm.writepoint &= (BufMax - 1);
			}
			break;

		// Êݏo
		case 2:
			for (i=0; i<num; i++) {
				store = base + (diff * (i + 1)) / num;
				adpcmbuf[adpcm.writepoint++] = 0;
				adpcmbuf[adpcm.writepoint++] = store;
				adpcm.writepoint &= (BufMax - 1);
			}
			break;

		// It
		case 3:
			for (i=0; i<num; i++) {
				adpcmbuf[adpcm.writepoint++] = 0;
				adpcmbuf[adpcm.writepoint++] = 0;
				adpcm.writepoint &= (BufMax - 1);
			}
			break;

		// ʏA蓾Ȃ
		default:
			ASSERT(FALSE);
	}

	// XV
	adpcm.number += (num << 1);
	if (adpcm.number >= BufMax) {
#if defined(ADPCM_LOG)
		LOG0(Log::Warning, "ADPCMobt@ I[o[");
#endif	// ADPCM_LOG
		adpcm.number = BufMax;
		adpcm.readpoint = adpcm.writepoint;
	}
}

//---------------------------------------------------------------------------
//
//	Cl[u
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::Enable(BOOL enable)
{
	ASSERT(this);
	ASSERT_DIAG();

	adpcm.enable = enable;
}

//---------------------------------------------------------------------------
//
//	obt@
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::InitBuf(DWORD rate)
{
	ASSERT(this);
	ASSERT(rate > 0);
	ASSERT((rate % 100) == 0);

#if defined(ADPCM_LOG)
	LOG0(Log::Normal, "obt@");
#endif	// ADPCM_LOG

	// JE^A|C^
	adpcm.number = 0;
	adpcm.readpoint = 0;
	adpcm.writepoint = 0;
	adpcm.wait = 0;
	adpcm.sync_cnt = 0;
	adpcm.sync_rate = rate / 50;
	adpcm.sync_step = 0x9c4000 / adpcm.sync_rate;

	// ŏ̃f[^0Zbg
	if (adpcmbuf) {
		adpcmbuf[0] = 0;
		adpcmbuf[1] = 0;
	}
}

//---------------------------------------------------------------------------
//
//	obt@f[^擾
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::GetBuf(DWORD *buffer, int samples)
{
	int i;
	int j;
	int l;
	int r;
	int *ptr;
	DWORD point;

	ASSERT(this);
	ASSERT(buffer);
	ASSERT(samples >= 0);
	ASSERT_DIAG();

	// A܂̓`lJbg̏ꍇ́Aobt@NA
	if (!adpcm.enable || !adpcm.sound) {
		ASSERT(adpcm.sync_rate != 0);
		InitBuf(adpcm.sync_rate * 50);
		return;
	}

	// 
	ptr = (int*)buffer;

	// obt@ɉȂƂ́AŌ̃f[^𑱂ē
	if (adpcm.number <= 2) {
		l = adpcmbuf[adpcm.readpoint];
		r = adpcmbuf[adpcm.readpoint + 1];
		for (i=samples; i>0; i--) {
			*ptr += l;
			ptr++;
			*ptr += r;
			ptr++;
		}
		return;
	}

	// `Ԃ̗Lŕ
	if (adpcm.interp) {

		// Ԃ
		for (i=samples; i>0; i--) {
			// XebvUp
			adpcm.sync_cnt += adpcm.sync_step;
			if (adpcm.sync_cnt >= 0x4000) {
				// 
				adpcm.sync_cnt &= 0x3fff;

				// 
				if (adpcm.number >= 4) {
					adpcm.readpoint += 2;
					adpcm.readpoint &= (BufMax - 1);
					adpcm.number -= 2;
				}
			}

			// ̃f[^邩
			if (adpcm.number < 4 ) {
				// ̃f[^Ȃ̂ŁÃf[^̂܂ܓ
				*ptr += adpcmbuf[adpcm.readpoint];
				ptr++;
				*ptr += adpcmbuf[adpcm.readpoint + 1];
				ptr++;
			}
			else {
				// ̃|Cg炤
				point = adpcm.readpoint + 2;
				point &= (BufMax - 1);

				// f[^Ǝ̃f[^ŕ[L]
				l = adpcmbuf[point] * (int)adpcm.sync_cnt;
				r = adpcmbuf[adpcm.readpoint + 0] * (int)(0x4000 - adpcm.sync_cnt);
				*ptr += ((l + r) >> 14);
				ptr++;

				// f[^Ǝ̃f[^ŕ[R]
				l = adpcmbuf[point + 1] * (int)adpcm.sync_cnt;
				r = adpcmbuf[adpcm.readpoint + 1] * (int)(0x4000 - adpcm.sync_cnt);
				*ptr += ((l + r) >> 14);
				ptr++;
			}
		}
	}
	else {
		// ԂȂ
		for (i=samples; i>0; i--) {
			// ݂̈ʒuf[^i[
			*buffer += adpcmbuf[adpcm.readpoint];
			buffer++;
			*buffer += adpcmbuf[adpcm.readpoint + 1];
			buffer++;

			// sync_stepZ
			adpcm.sync_cnt += adpcm.sync_step;

			// 0x4000Ɠ
			if (adpcm.sync_cnt < 0x4000) {
				continue;
			}
			adpcm.sync_cnt &= 0x3fff;

			// ADPCMTvֈړ
			if (adpcm.number <= 2) {
				// Ō̃f[^𑱂ē
				l = adpcmbuf[adpcm.readpoint];
				r = adpcmbuf[adpcm.readpoint + 1];
				for (j=i-1; j>0; j--) {
					*buffer += l;
					buffer++;
					*buffer += r;
					buffer++;
					adpcm.sync_cnt += adpcm.sync_step;
				}
				adpcm.sync_cnt &= 0x3fff;
				return;
			}
			adpcm.readpoint += 2;
			adpcm.readpoint &= (BufMax - 1);
			adpcm.number -= 2;
		}
	}
}

//---------------------------------------------------------------------------
//
//	EFCg
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::Wait(int num)
{
	int i;

	ASSERT(this);
	ASSERT_DIAG();

	// CxgJnĂȂ0
	if (event.GetTime() == 0) {
		adpcm.wait = 0;
		return;
	}

	// ȂOPM̕Ă
	if ((int)adpcm.number <= num) {
		// B1/4EFCgƂ
		num -= (adpcm.number);
		num >>= 2;

		// vŹƓlB]
		i = adpcm.speed >> 6;
		i *= adpcm.sync_rate;
		adpcm.wait = -((625 * num) / i);

#if defined(ADPCM_LOG)
		if (adpcm.wait != 0) {
			LOG1(Log::Normal, "EFCgݒ %d", adpcm.wait);
		}
#endif	// ADPCM_LOG
		return;
	}

	// B1/4EFCgƂ
	num = adpcm.number - num;
	num >>= 2;

	// 44.1k,48k etc.ł̗]TvxƂ
	// EFCg񐔂 (625 * x) / (adpcm.sync_rate * (adpcm.speed >> 6))
	i = adpcm.speed >> 6;
	i *= adpcm.sync_rate;
	adpcm.wait = (625 * num) / i;

#if defined(ADPCM_LOG)
	if (adpcm.wait != 0) {
		LOG1(Log::Normal, "EFCgݒ %d", adpcm.wait);
	}
#endif	// ADPCM_LOG
}

//---------------------------------------------------------------------------
//
//	e[u쐬
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::MakeTable()
{
	int i;
	int j;
	int base;
	int diff;
	int *p;

	ASSERT(this);

	// e[u쐬(floorŊۂ߂panicŗǂʂ)
	p = DiffTable;
	for (i=0; i<49; i++) {
		base = (int)floor(16.0 * pow(1.1, i));

		// Zׂintōs
		for (j=0; j<16; j++) {
			diff = 0;
			if (j & 4) {
				diff += base;
			}
			if (j & 2) {
				diff += (base >> 1);
			}
			if (j & 1) {
				diff += (base >> 2);
			}
			diff += (base >> 3);
			if (j & 8) {
				diff = -diff;
			}

			*p++ = diff;
		}
	}
}

//---------------------------------------------------------------------------
//
//	ʐݒ
//
//---------------------------------------------------------------------------
void FASTCALL ADPCM::SetVolume(int volume)
{
	double offset;
	double vol;

	ASSERT(this);
	ASSERT((volume >= 0) && (volume < 100));

	// 16384 * 10^((volume-140) / 200)ZoAZbg
	offset = (double)(volume - 140);
	offset /= (double)200.0;
	vol = pow((double)10.0, offset);
	vol *= (double)16384.0;
	adpcm.vol = int(vol);
}
