//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ ADPCM(MSM6258V) ]
//
//---------------------------------------------------------------------------

#if !defined(adpcm_h)
#define adpcm_h

#include "device.h"
#include "event.h"

//===========================================================================
//
//	ADPCM
//
//===========================================================================
class ADPCM : public MemDevice
{
public:
	// f[^`
	typedef struct {
		DWORD panpot;					// p|bg
		BOOL play;						// Đ[h
		BOOL rec;						// ^[h
		BOOL active;					// ANeButO
		BOOL started;					// ĐLׂȃf[^o
		DWORD clock;					// NbN(4 or 8)
		DWORD ratio;					// NbN䗦 (0 or 1 or 2)
		DWORD speed;					// isx(128,192,256,384,512)
		DWORD data;						// Tvf[^(4bit * 2sample)

		int offset;						// ItZbg (0-48)
		int sample;						// Tvf[^
		int out;						// o̓f[^
		int vol;						// 

		BOOL enable;					// Cl[utO
		BOOL sound;						// ADPCMo͗LtO
		DWORD readpoint;				// obt@ǂݍ݃|Cg
		DWORD writepoint;				// obt@݃|Cg
		DWORD number;					// obt@Lf[^
		int wait;						// EFCg
		DWORD sync_cnt;					// JE^
		DWORD sync_rate;				// [g(882,960,etc...)
		DWORD sync_step;				// Xebv(`ԑΉ)
		BOOL interp;					// ԃtO
	} adpcm_t;

public:
	// {t@NV
	ADPCM(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp
#if !defined(NDEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// NDEBUG

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL GetADPCM(adpcm_t *buffer);
										// f[^擾
	BOOL FASTCALL Callback(Event *ev);
										// CxgR[obN
	void FASTCALL SetClock(DWORD clk);
										// NbNw
	void FASTCALL SetRatio(DWORD ratio);
										// NbN䗦w
	void FASTCALL SetPanpot(DWORD pan);
										// p|bgw
	void FASTCALL Enable(BOOL enable);
										// Cl[u
	void FASTCALL InitBuf(DWORD rate);
										// obt@
	void FASTCALL GetBuf(DWORD *buffer, int samples);
										// obt@擾
	void FASTCALL Wait(int num);
										// EFCgw
	void FASTCALL EnableADPCM(BOOL flag) { adpcm.sound = flag; }
										// ĐL
	void FASTCALL SetVolume(int volume);
										// ʐݒ
	void FASTCALL ClrStarted()			{ adpcm.started = FALSE; }
										// X^[gtONA
	BOOL FASTCALL IsStarted() const		{ return adpcm.started; }
										// X^[gtO擾

private:
	enum {
		BufMax = 0x10000				// obt@TCY
	};
	void FASTCALL MakeTable();
										// e[u쐬
	void FASTCALL CalcSpeed();
										// xČvZ
	void FASTCALL Start(int type);
										// ^EĐX^[g
	void FASTCALL Stop();
										// ^EĐXgbv
	void FASTCALL Decode(int data, int num, BOOL valid);
										// 4bitfR[h
	Event event;
										// ^C}[Cxg
	adpcm_t adpcm;
										// f[^
	DMAC *dmac;
										// DMAC
	DWORD *adpcmbuf;
										// obt@
	int DiffTable[49 * 16];
										// e[u
	static const int NextTable[16];
										// ψʃe[u
	static const int OffsetTable[58];
										// ItZbge[u
};

#endif	// adpcm_h
