//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2005 ohD(ytanaka@ipc-tokai.or.jp)
//	[ GAZbg ]
//
//---------------------------------------------------------------------------

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "cpu.h"
#include "log.h"
#include "fileio.h"
#include "memory.h"
#include "areaset.h"

//===========================================================================
//
//	GAZbg
//
//===========================================================================
//#define AREASET_LOG

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
AreaSet::AreaSet(VM *p) : MemDevice(p)
{
	// foCXID
	dev.id = MAKEID('A', 'R', 'E', 'A');
	dev.desc = "Area Set";

	// JnAhXAIAhX
	memdev.first = 0xe86000;
	memdev.last = 0xe87fff;

	// IuWFNg
	memory = NULL;
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL AreaSet::Init()
{
	ASSERT(this);

	// {NX
	if (!MemDevice::Init()) {
		return FALSE;
	}

	// 擾
	memory = (Memory*)vm->SearchDevice(MAKEID('M', 'E', 'M', ' '));
	ASSERT(memory);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL AreaSet::Cleanup()
{
	ASSERT(this);

	// {NX
	MemDevice::Cleanup();
}

//---------------------------------------------------------------------------
//
//	Zbg
//	K̏łȂAMemory::MakeContextĂ΂
//
//---------------------------------------------------------------------------
void FASTCALL AreaSet::Reset()
{
	ASSERT(this);
	LOG0(Log::Normal, "Zbg");

#if defined(AREASET_LOG)
	LOG0(Log::Normal, "GAZbgݒ $00");
#endif	// AREASET_LOG

	// GAw菉
	area = 0;
}

//---------------------------------------------------------------------------
//
//	Z[u
//
//---------------------------------------------------------------------------
BOOL FASTCALL AreaSet::Save(Fileio *fio, int /*ver*/)
{
	size_t sz;

	ASSERT(this);
	LOG0(Log::Normal, "Z[u");

	// TCYZ[u
	sz = sizeof(area);
	if (!fio->Write(&sz, (int)sizeof(sz))) {
		return FALSE;
	}

	// GAZ[u
	if (!fio->Write(&area, (int)sizeof(area))) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
BOOL FASTCALL AreaSet::Load(Fileio *fio, int /*ver*/)
{
	size_t sz;

	ASSERT(this);
	LOG0(Log::Normal, "[h");

	// TCY[h
	if (!fio->Read(&sz, (int)sizeof(sz))) {
		return FALSE;
	}

	// TCYr
	if (sz != sizeof(area)) {
		return FALSE;
	}

	// GA[h
	if (!fio->Read(&area, (int)sizeof(area))) {
		return FALSE;
	}

	// Kp
	memory->MakeContext(FALSE);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL AreaSet::ApplyCfg(const Config* /*config*/)
{
	ASSERT(this);
	LOG0(Log::Normal, "ݒKp");
}

//---------------------------------------------------------------------------
//
//	oCgǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL AreaSet::ReadByte(DWORD addr)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));

	// ɃoXG[
	cpu->BusErr(addr, TRUE);
	return 0xff;
}

//---------------------------------------------------------------------------
//
//	oCg
//
//---------------------------------------------------------------------------
void FASTCALL AreaSet::WriteByte(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));

	// 2oCgɃ}bv
	addr &= 1;

	// AhX̓GAZbg
	if (addr & 1) {
		LOG1(Log::Detail, "GAZbgݒ $%02X", data);

		// f[^L
		area = data;

		// }bvč\z
		memory->MakeContext(FALSE);
		return;
	}

	// AhX̓fR[hĂȂ
}

//---------------------------------------------------------------------------
//
//	ǂݍ݂̂
//
//---------------------------------------------------------------------------
DWORD FASTCALL AreaSet::ReadOnly(DWORD addr) const
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));

	// EVEN0xffAODD͐ݒlԂ
	if (addr & 1) {
		return area;
	}
	return 0xff;
}

//---------------------------------------------------------------------------
//
//	GAZbg擾
//
//---------------------------------------------------------------------------
DWORD FASTCALL AreaSet::GetArea() const
{
	ASSERT(this);
	return area;
}
