//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ RtBM[V ]
//
//---------------------------------------------------------------------------

#if !defined(config_h)
#define config_h

#include "filepath.h"

//===========================================================================
//
//	RtBM[V(version2.00`version2.01)
//
//===========================================================================
class Config200
{
public:
	// VXe
	int system_clock;					// VXeNbN(0`5)
	int ram_size;						// CRAMTCY(0`5)
	BOOL ram_sramsync;					// XCb`XV

	// XPW[
	BOOL mpu_fullspeed;					// MPUtXs[h
	BOOL vm_fullspeed;					// VMtXs[h

	// TEh
	int sound_device;					// TEhfoCX(0`15)
	int sample_rate;					// TvO[g(0`4)
	int primary_buffer;					// obt@TCY(2`100)
	int polling_buffer;					// |[OԊu(0`99)
	BOOL adpcm_interp;					// ADPCM`Ԃ

	// `
	BOOL aspect_stretch;				// AXyNgɂ킹g

	// 
	int master_volume;					// }X^(0`100)
	BOOL fm_enable;						// FML
	int fm_volume;						// FM(0`100)
	BOOL adpcm_enable;					// ADPCML
	int adpcm_volume;					// ADPCM(0`100)

	// L[{[h
	BOOL kbd_connect;					// ڑ

	// }EX
	int mouse_speed;					// Xs[h
	int mouse_port;						// ڑ|[g
	BOOL mouse_swap;					// {^Xbv
	BOOL mouse_mid;						// {^Cl[u
	BOOL mouse_trackb;					// gbN{[[h

	// WCXeBbN
	int joy_type[2];					// WCXeBbN^Cv
	int joy_dev[2];						// WCXeBbNfoCX
	int joy_button0[12];				// WCXeBbN{^(foCXA)
	int joy_button1[12];				// WCXeBbN{^(foCXB)

	// SASI
	int sasi_drives;					// SASIhCu
	BOOL sasi_sramsync;					// SASIXCb`XV
	TCHAR sasi_file[16][FILEPATH_MAX];	// SASIC[Wt@C

	// SxSI
	int sxsi_drives;					// SxSIhCu
	BOOL sxsi_mofirst;					// MOhCuD抄蓖
	TCHAR sxsi_file[6][FILEPATH_MAX];	// SxSIC[Wt@C

	// |[g
	int port_com;						// COMx|[g
	TCHAR port_recvlog[FILEPATH_MAX];	// VAMO
	BOOL port_384;						// VA38400bpsŒ
	int port_lpt;						// LPTx|[g
	TCHAR port_sendlog[FILEPATH_MAX];	// pMO

	// MIDI
	int midi_bid;						// MIDI{[hID
	int midi_ilevel;					// MIDI荞݃x
	int midi_reset;						// MIDIZbgR}h
	int midiin_device;					// MIDI INfoCX
	int midiin_delay;					// MIDI INfBC(ms)
	int midiout_device;					// MIDI OUTfoCX
	int midiout_delay;					// MIDI OUTfBC(ms)

	// 
	BOOL sram_64k;						// 64KB SRAM
	BOOL scc_clkup;						// SCCNbNAbv
	BOOL power_led;						// FdLED
	BOOL dual_fdd;						// 2DD/2HDpFDD
	BOOL sasi_parity;					// SASIoXpeB

	// TrueKey
	int tkey_mode;						// TrueKey[h(bit0:VM bit1:WinApp)
	int tkey_com;						// L[{[hCOM|[g
	BOOL tkey_rts;						// RTS][h

	// ̑
	BOOL floppy_speed;					// tbs[fBXN
	BOOL floppy_led;					// tbs[fBXNLED[h
	BOOL popup_swnd;					// |bvAbvTuEBhE
	BOOL auto_mouse;					// }EX[h
	BOOL power_off;						// dOFFŊJn
};

//===========================================================================
//
//	RtBM[V(version2.02`version2.03)
//
//===========================================================================
class Config202 : public Config200
{
public:
	// VXe
	int mem_type;						// }bv

	// SCSI
	int scsi_ilevel;					// SCSI荞݃x
	int scsi_drives;					// SCSIhCu
	BOOL scsi_sramsync;					// SCSIXCb`XV
	BOOL scsi_mofirst;					// MOhCuD抄蓖
	TCHAR scsi_file[5][FILEPATH_MAX];	// SCSIC[Wt@C
};

//===========================================================================
//
//	RtBM[V(version2.04`version2.05)
//
//===========================================================================
class Config204 : public Config202
{
public:
	// W[
	BOOL resume_fd;						// FDW[
	BOOL resume_fdi[2];					// FD}tO
	BOOL resume_fdw[2];					// FD݋֎~
	int resume_fdm[2];					// FDfBANo.
	BOOL resume_mo;						// MOW[
	BOOL resume_mos;					// MO}tO
	BOOL resume_mow;					// MO݋֎~
	BOOL resume_cd;						// CDW[
	BOOL resume_iso;					// CD}tO
	BOOL resume_state;					// Xe[gW[
	BOOL resume_xm6;					// Xe[gLtO
	BOOL resume_screen;					// ʃ[hW[
	BOOL resume_dir;					// ftHgfBNgW[
	TCHAR resume_path[FILEPATH_MAX];	// ftHgfBNg

	// `
	BOOL caption_info;					// LvV\

	// fBXvC
	BOOL caption;						// LvV
	BOOL menu_bar;						// j[o[
	BOOL status_bar;					// Xe[^Xo[
	int window_left;					// EBhE`
	int window_top;						// EBhE`
	BOOL window_full;					// tXN[
	int window_mode;					// ChXN[

	// WINDRVW[
	DWORD windrv_enable;				// WindrvT|[g 0: 1:WindrvXM (2:Windrv݊)

	// zXgt@CVXe
	DWORD host_option;					// tO (class CHostFilename Q)
	BOOL host_resume;					// x[XpXԕL FALSEƖXL
	DWORD host_drives;					// LȃhCu
	DWORD host_flag[10];				// tO (class CWinFileDrv Q)
	TCHAR host_path[10][_MAX_PATH];		// x[XpX
};

//===========================================================================
//
//	RtBM[V
//
//===========================================================================
class Config : public Config204
{
public:
	// `
	int rend_thres;						// _Ol
	BOOL rend_refresh;					// _O`

	// ROMx
	BOOL rom_ipl;						// IPL-ROMx
	BOOL rom_cg;						// CG-ROMx
	BOOL rom_scsi;						// SCSI-ROMx

	// WritefBXNLbV
	BOOL cache_fd;						// tbs[fBXN WBLbV
	BOOL cache_disk;					// n[hfBXNorMO WBLbV

	// ̑
	BOOL update_boot;					// XM6ISRAMNJE^+1
};

#endif	// config_h
