;
; X68000 EMULATOR "XM6"
;
; Copyright (C) 2001-2005 ohD(ytanaka@ipc-tokai.or.jp)
; [ z}VRA AZuTu ]
;

;
; Visual C++̊OAZu[`ł
; ebx, esi, edi, ebpۑ邱
;

;
; O錾
;
		section	.text align=16
		bits	32

		global	_MemInitDecode
		global	_MemDecodeTable
		global	_ReadByteC
		global	_ReadWordC
		global	_WriteByteC
		global	_WriteWordC
		global	_ReadErrC
		global	_WriteErrC

		extern	_ReadBusErr
		extern	_WriteBusErr

		global	_NotifyEvent
		global	_GetMinEvent
		global	_SubExecEvent

		align	16

;
; fR[_
; Wve[u쐬
;
; void MemInitDecode(DWORD *mem, MemDevice *list[])
;
_MemInitDecode:
		push	ebp
		mov	ebp,esp
		push	eax
		push	ebx
		push	ecx
		push	edx
		push	esi
		push	edi
; MemoryNXL
		mov	eax,[ebp+8]
		mov	[Memory],eax
; foCXɐݒ
		mov	ebx,_MemDecodeTable
		mov	ecx,384
		mov	edx,MemDecodeData
		mov	esi,[ebp+12]
; [v
.Loop:
; foCXԍ(0:Memory 1:GVRAM .... SRAM)擾
		mov	eax,[edx]
		add	edx,byte 4
; list[]gāÃCX^X̃|C^XgA
		mov	edi,[esi+eax*4]
		mov	[ebx],edi
		add	ebx,byte 4
; 
		dec	ecx
		jnz	.Loop
; I
		pop	edi
		pop	esi
		pop	edx
		pop	ecx
		pop	ebx
		pop	eax
		pop	ebp
		ret

		align	16

;
; oCgǂݍ
;
; EAX	DWORD߂l
; ECX	this
; EDX	AhX
;
_ReadByteC:
; Wve[uɏ]ăWv(8KB)
		mov	eax,edx
		sub	eax,0C00000h
		jc	.Memory
		shr	eax,13
		mov	ecx,[_MemDecodeTable+eax*4]
		mov	eax,[ecx]
		jmp	[eax+32]
; Ă
.Memory:
		mov	ecx,[Memory]
		mov	eax,[ecx]
		jmp	[eax+32]

		align	16

;
; [hǂݍ
;
; EAX	DWORD߂l
; ECX	this
; EDX	AhX
;
_ReadWordC:
; Wve[uɏ]ăWv(8KB)
		mov	eax,edx
		sub	eax,0C00000h
		jc	.Memory
		shr	eax,13
		mov	ecx,[_MemDecodeTable+eax*4]
		mov	eax,[ecx]
		jmp	[eax+36]
; Ă
.Memory:
		mov	ecx,[Memory]
		mov	eax,[ecx]
		jmp	[eax+36]

		align	16

;
; oCg
;
; EBX	f[^
; ECX	this
; EDX	AhX
;
_WriteByteC:
; Wve[uɏ]ăWv(8KB)
		mov	eax,edx
		sub	eax,0C00000h
		jc	.Memory
		shr	eax,13
		mov	ecx,[_MemDecodeTable+eax*4]
		mov	eax,[ecx]
		push	ebx
		call	[eax+40]
		ret
; Ă
.Memory:
		mov	ecx,[Memory]
		mov	eax,[ecx]
		push	ebx
		call	[eax+40]
		ret

		align	16

;
; [h
;
; EBX	f[^
; ECX	this
; EDX	AhX
;
_WriteWordC:
; Wve[uɏ]ăWv(8KB)
		mov	eax,edx
		sub	eax,0C00000h
		jc	.Memory
		shr	eax,13
		mov	ecx,[_MemDecodeTable+eax*4]
		mov	eax,[ecx]
		push	ebx
		call	[eax+44]
		ret
; Ă
.Memory:
		mov	ecx,[Memory]
		mov	eax,[ecx]
		push	ebx
		call	[eax+44]
		ret

		align	16

;
; oXG[ǂݍ
;
; EDX	AhX
;
_ReadErrC:
		push	edx
		call	_ReadBusErr
		add	esp,4
		ret

		align	16

;
; oXG[
;
; EDX	AhX
; EBX	f[^
;
_WriteErrC:
		push	edx
		call	_WriteBusErr
		add	esp,4
		ret

		align	16

;
; CxgύXʒm
; őCxg31܂(SubExecEvent̍ŌŃ_~[[h邽)
;
; void NotifyEvent(Event *first)
;
_NotifyEvent:
		push	ebp
		mov	ebp,esp
		push	eax
		push	ecx
		push	esi
		push	edi
; p[^󂯎ƃJE^NA
		mov	esi,[ebp+8]
		xor	ecx,ecx
		mov	edi,EventTable
; [v
.loop:
		or	esi,esi
		jz	.exit
; Zbg
		mov	[edi],esi
		inc	ecx
; 擾
		mov	esi,[esi+24]
		add	edi,byte 4
		jmp	.loop
; L^
.exit:
		mov	[EventNum],ecx
; I
		pop	edi
		pop	esi
		pop	ecx
		pop	eax
		pop	ebp
		ret

		align	16

;
; ŏ̃CxgT
; CMOVgp
;
; void GetMinEvent(DWORD hus)
;
_GetMinEvent:
		push	ebp
		mov	ebp,esp
		push	esi
		push	edi
; p[^󂯎
		mov	eax,[ebp+8]
		mov	esi,EventTable
		mov	ecx,[EventNum]
; [v
.loop:
		mov	edi,[esi]
		add	esi,byte 4
; GetRemain()Ăяo
		mov	edx,[edi+4]
		or	edx,edx
; [Ȃ炱̃Cxg͍lȂ
		cmovz	edx,eax
; r
		cmp	edx,eax
; ŏƂ
		cmovc	eax,edx
; 
.next:
		dec	ecx
		jnz	.loop
;
		pop	edi
		pop	esi
		pop	ebp
		ret

		align	16

;
; CxgԌƎs
;
; DWORD SubExecEvent(DWORD hus)
;
_SubExecEvent:
		push	ebp
		mov	ebp,esp
		push	esi
		push	edi
; p[^󂯎
		mov	edi,[ebp+8]
		mov	esi,EventTable
		mov	ecx,[EventNum]
; EventIuWFNg擾
		mov	ebp,[esi]
; Cxg[v
.loop:
; ԖݒȂAȂ
		mov	eax,[ebp+8]
		add	esi,byte 4
		or	eax,eax
		jz	.next
; ԂB0}CiXȂCxgs
		sub	[ebp+4],edi
		jna	.exec
; 
.next:
		dec	ecx
		mov	ebp,[esi]
		jnz	.loop
; I
		pop	edi
		pop	esi
		pop	ebp
		ret
; s
.exec:
; ԂZbg
		mov	[ebp+4],eax
; Cxgs(Device::CallbackĂяo)
		push	ecx
		mov	ecx,[ebp+16]
		mov	eax,[ecx]
		mov	edx,ebp
		call	[eax+28]
		pop	ecx
; ʂ0ȂAFALSÊߖ
		or	eax,eax
		jz	.disable
; ̃Cxg
		dec	ecx
		mov	ebp,[esi]
		jnz	.loop
; I
		pop	edi
		pop	esi
		pop	ebp
		ret
; (timeremain0NA)
.disable:
		mov	[ebp+8],eax
		mov	[ebp+4],eax
; ̃Cxg
		dec	ecx
		mov	ebp,[esi]
		jnz	.loop
; I
		pop	edi
		pop	esi
		pop	ebp
		ret

;
; f[^GA (8KBP)
;
; 0	MEMORY
; 1	GVRAM
; 2	TVRAM
; 3	CRTC
; 4	VC
; 5	DMAC
; 6	AREA
; 7	MFP
; 8	RTC
; 9	PRN
; 10	SYSPORT
; 11	OPM
; 12	ADPCM
; 13	FDC
; 14	SASI
; 15	SCC
; 16	PPI
; 17	IOSC
; 18	WINDRV
; 19	SCSI
; 20	MIDI
; 21	SPR
; 22	MERCURY
; 23	NEPTUNE
; 24	SRAM
;
		section	.data align=16
		bits	32
MemDecodeData:
; $C00000 (GVRAM)
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		dd	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
; $E00000 (TVRAM)
		dd	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
		dd	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
		dd	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
		dd	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
; $E80000 (CRTC - IOSC)
		dd	3,4,5,6,7,8,9,10,11,12,13,14,15,16,17
; $E9E000 (WINDRV)
		dd	18
; $EA0000 (SCSI)
		dd	19
; $EA2000 (RESERVE)
		dd	0,0,0,0,0,0
; $EAE000 (MIDI)
		dd	20
; $EB0000 (SPRITE)
		dd	21,21,21,21,21,21,21,21
; $EC0000 (USER)
		dd	0,0,0,0,0,0
; $ECC000 (MERCURY)
		dd	22
; $ECE000 (NEPTUNE)
		dd	23
; $ED0000 (SRAM)
		dd	24,24,24,24,24,24,24,24
; $EE0000 (RESERVE)
		dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

;
; BSSGA
;
		section	.bss align=16
		bits	32
Memory:
		resb	4
EventNum:
		resb	4
; _~[(align 16)
		resb	8

_MemDecodeTable:
		resb	384*4
EventTable:
		resb	32*4

;
; vOI
;
		end
