//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ CPU(MC68000) ]
//
//---------------------------------------------------------------------------

#if !defined(cpu_h)
#define cpu_h

#include "device.h"
#include "starcpu.h"

//---------------------------------------------------------------------------
//
//	O`
//
//---------------------------------------------------------------------------
#if defined(__cplusplus)
extern "C" {
#endif	// __cplusplus

extern DWORD s68000getcounter();
										// NbNJE^擾
extern void s68000setcounter(DWORD c);
										// NbNJE^ݒ

#if defined(__cplusplus)
}
#endif	// __cplusplus

//===========================================================================
//
//	CPU
//
//===========================================================================
class CPU : public Device
{
public:
	// f[^`
	typedef struct {
		DWORD dreg[8];					// f[^WX^
		DWORD areg[8];					// AhXWX^
		DWORD sp;						// X^bN\(USP or SSP)
		DWORD pc;						// vOJE^
		DWORD intr[8];					// 荞ݏ
		DWORD sr;						// Xe[^XWX^
		DWORD intreq[8];				// 荞ݗv
		DWORD intack[8];				// 荞ݎ󗝉
		DWORD odd;						// sJE^
	} cpu_t;

	typedef struct {
		DWORD erraddr;					// G[AhX
		DWORD errtime;					// G[̉z
		DWORD intreq[8];				// 荞ݗv
		DWORD intack[8];				// 荞ݎ󗝉
	} cpusub_t;

public:
	// {t@NV
	CPU(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

public:
	// OAPI
	void FASTCALL GetCPU(cpu_t *buffer) const;
										// CPUWX^擾
	void FASTCALL SetCPU(const cpu_t *buffer);
										// CPUWX^ݒ
	DWORD FASTCALL Exec(int cycle) {
		DWORD result;

		if (::s68000exec(cycle) <= 0x80000000) {
			result = ::s68000context.odometer;
			::s68000context.odometer = 0;
			return result;
		}

		result = ::s68000context.odometer;
		result |= 0x80000000;
		::s68000context.odometer = 0;
		return result;
	}
										// s
	BOOL FASTCALL Interrupt(int level, int vector);
										// 荞
	void FASTCALL IntAck(int level);
										// 荞ACK
	void FASTCALL IntCancel(int level);
										// 荞݃LZ
	DWORD FASTCALL GetCycle() const		{ return ::s68000readOdometer(); }
										// TCN擾
	DWORD FASTCALL GetPC() const		{ return ::s68000readPC(); }
										// vOJE^擾
	void FASTCALL ResetInst();
										// RESET
	DWORD FASTCALL GetIOCycle()	const	{ return ::s68000getcounter(); }
										// I/OTCN擾
	void FASTCALL SetIOCycle(DWORD c)	{ ::s68000setcounter(c); }
										// I/OTCNݒ
	void FASTCALL Release()				{ ::s68000releaseTimeslice(); }
										// CPUs߂ŋI
	void FASTCALL BusErr(DWORD addr, BOOL read);
										// oXG[
	void FASTCALL AddrErr(DWORD addr, BOOL read);
										// AhXG[
	void FASTCALL BusErrLog(DWORD addr, DWORD stat);
										// oXG[L^
	void FASTCALL AddrErrLog(DWORD addr, DWORD stat);
										// AhXG[L^

private:
	cpusub_t sub;
										// f[^
	Memory *memory;
										// 
	DMAC *dmac;
										// DMAC
	MFP *mfp;
										// MFP
	IOSC *iosc;
										// IOSC
	SCC *scc;
										// SCC
	MIDI *midi;
										// MIDI
	SCSI *scsi;
										// SCSI
	Scheduler *scheduler;
										// XPW[
};

#endif	// cpu_h
