//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2003 ohD(ytanaka@ipc-tokai.or.jp)
//	[ CRTC(VICON) ]
//
//---------------------------------------------------------------------------

#if !defined(crtc_h)
#define crtc_h

#include "device.h"
#include "event.h"

//===========================================================================
//
//	CRTC
//
//===========================================================================
class CRTC : public MemDevice
{
public:
	// f[^`
	typedef struct {
		BYTE reg[24 * 2];				// CRTCWX^
		BOOL hrl;						// HRL(VXe|[g)
		BOOL lowres;					// 15kHz[h
		BOOL textres;					// 768~512[h
		BOOL changed;					// 𑜓xύXtO

		int h_sync;						// 
		int h_pulse;					// pX
		int h_back;						// obN|[`
		int h_front;					// tg|[`
		int h_dots;						// hbg
		int h_mul;						// {
		int hd;							// 256,512,768,`

		int v_sync;						// (HP)
		int v_pulse;					// pX(HP)
		int v_back;						// obN|[`(HP)
		int v_front;					// tg|[`(HP)
		int v_dots;						// hbg
		int v_mul;						// {(0:interlace)
		int vd;							// 256,512,`,`

		DWORD ns;						// nsJE^
		DWORD hus;						// husJE^
		DWORD v_synccnt;				// V-SYNCJE^
		DWORD v_blankcnt;				// V-BLANKJE^
		BOOL h_disp;					// \tO
		BOOL v_disp;					// V-DISPtO
		BOOL v_blank;					// V-BLANKtO
		DWORD v_count;					// V-DISPJE^
		int v_scan;						// XLC

		// ȉȂ
		int h_synctime;					// (hus)
		int h_disptime;					// \(hus)
		int v_cycletime;				// (hus)
		int v_blanktime;				// uN(hus)
		int v_synctime;					// (hus)
		int v_backtime;					// obN|[`(hus)

		BOOL tmem;						// eLXgVRAM\
		BOOL gmem;						// OtBbNVRAM\
		DWORD siz;						// OtBbNVRAM1024~1024[h
		DWORD col;						// OtBbNVRAMF[h

		DWORD text_scrlx;				// eLXgXN[X
		DWORD text_scrly;				// eLXgXN[Y
		DWORD grp_scrlx[4];				// OtBbNXN[X
		DWORD grp_scrly[4];				// OtBbNXN[Y

		int raster_count;				// X^JE^
		int raster_int;					// X^荞݈ʒu
		BOOL raster_copy;				// X^Rs[tO
		BOOL raster_exec;				// X^Rs[stO
		DWORD fast_clr;					// OtBbNNA
	} crtc_t;

public:
	// {t@NV
	CRTC(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL GetCRTC(crtc_t *buffer) const;
										// f[^擾
	BOOL FASTCALL Callback(Event *ev);
										// CxgR[obN
	void FASTCALL SetHRL(BOOL h);
										// HRLݒ
	BOOL FASTCALL GetHRL() const;
										// HRL擾
	void FASTCALL GetHVHz(DWORD *h, DWORD *v) const;
										// \g擾
	DWORD FASTCALL GetDispCount() const	{ return crtc.v_count; }
										// \JE^擾
	const crtc_t* FASTCALL GetWorkAddr() const { return &crtc; }
										// [NAhX擾

private:
	void FASTCALL ReCalc();
										// ČvZ
	void FASTCALL HSync();
										// H-SYNCJn
	void FASTCALL HDisp();
										// H-DISPJn
	void FASTCALL VSync();
										// V-SYNCJn
	void FASTCALL VBlank();
										// V-BLANKJn
	int FASTCALL Ns2Hus(int ns)			{ return ns / 500; }
										// ns0.5usZ
	int FASTCALL Hus2Ns(int hus)		{ return hus * 500; }
										// 0.5usnsZ
	void FASTCALL CheckRaster();
										// X^荞݃`FbN
	void FASTCALL TextVRAM();
										// eLXgVRAM
	int FASTCALL Get8DotClock() const;
										// 8hbgNbN𓾂
	static const int DotClockTable[16];
										// 8hbgNbNe[u
	static const BYTE ResetTable[26];
										// RESETWX^e[u
	crtc_t crtc;
										// CRTCf[^
	Event event;
										// Cxg
	TVRAM *tvram;
										// eLXgVRAM
	GVRAM *gvram;
										// OtBbNVRAM
	Sprite *sprite;
										// XvCgRg[
	MFP *mfp;
										// MFP
	Render *render;
										// _
	Printer *printer;
										// v^
};

#endif	// crtc_h
