//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2005 ohD(ytanaka@ipc-tokai.or.jp)
//	[ foCX ]
//
//---------------------------------------------------------------------------

#if !defined(device_h)
#define device_h

//===========================================================================
//
//	foCX
//
//===========================================================================
class Device
{
public:
	// f[^`
	typedef struct {
		DWORD id;						// ID
		const char *desc;				// 
		Device* next;					// ̃foCX
	} device_t;

public:
	// {t@NV
	Device(VM *p);
										// RXgN^
	virtual ~Device();
										// fXgN^
	virtual BOOL FASTCALL Init();
										// 
	virtual void FASTCALL Cleanup();
										// N[Abv
	virtual void FASTCALL Reset();
										// Zbg
	virtual BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	virtual BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	virtual void FASTCALL ApplyCfg(const Config *config);
										// ݒKp
#if !defined(NDEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// NDEBUG

	// OAPI
	Device* FASTCALL GetNextDevice() const { return dev.next; }
										// ̃foCX擾
	void FASTCALL SetNextDevice(Device *p) { dev.next = p; }
										// ̃foCXݒ
	DWORD FASTCALL GetID() const		{ return dev.id; }
										// foCXID擾
	const char* FASTCALL GetDesc() const { return dev.desc; }
										// foCX̎擾
	VM* FASTCALL GetVM() const			{ return vm; }
										// VM擾
	virtual BOOL FASTCALL Callback(Event *ev);
										// CxgR[obN

protected:
	Log* FASTCALL GetLog() const		{ return log; }
										// O擾
	device_t dev;
										// f[^
	VM *vm;
										// z}V{
	Log *log;
										// O
};

//===========================================================================
//
//	}bvhfoCX
//
//===========================================================================
class MemDevice : public Device
{
public:
	// f[^`
	typedef struct {
		DWORD first;					// JnAhX
		DWORD last;						// ŏIAhX
	} memdev_t;

public:
	// {t@NV
	MemDevice(VM *p);
										// RXgN^
	virtual BOOL FASTCALL Init();
										// 

	// foCX
	virtual DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	virtual DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	virtual void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	virtual void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	virtual DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂
#if !defined(NDEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// NDEBUG

	// OAPI
	DWORD FASTCALL GetFirstAddr() const	{ return memdev.first; }
										// ŏ̃AhX擾
	DWORD FASTCALL GetLastAddr() const	{ return memdev.last; }
										// Ō̃AhX擾

protected:
	memdev_t memdev;
										// f[^
	CPU *cpu;
										// CPU
	Scheduler *scheduler;
										// XPW[
};

#endif	// device_h
