//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ fBXN ]
//
//---------------------------------------------------------------------------

#if !defined(disk_h)
#define disk_h

//---------------------------------------------------------------------------
//
//	NXs`
//
//---------------------------------------------------------------------------
class DiskTrack;
class DiskCache;
class Disk;
class SASIHD;
class SCSIHD;
class SCSIMO;
class SCSICDTrack;
class SCSICD;

//---------------------------------------------------------------------------
//
//	G[`(REQUEST SENSEŕԂZXR[h)
//
//	MSB		\(0x00)
//			ZXL[
//			gZXR[h(ASC)
//	LSB		gZXR[hNHt@CA(ASCQ)
//
//---------------------------------------------------------------------------
#define DISK_NOERROR		0x00000000	// NO ADDITIONAL SENSE INFO.
#define DISK_DEVRESET		0x00062900	// POWER ON OR RESET OCCURED
#define DISK_NOTREADY		0x00023a00	// MEDIUM NOT PRESENT
#define DISK_ATTENTION		0x00062800	// MEDIUIM MAY HAVE CHANGED
#define DISK_PREVENT		0x00045302	// MEDIUM REMOVAL PREVENTED
#define DISK_READFAULT		0x00031100	// UNRECOVERED READ ERROR
#define DISK_WRITEFAULT		0x00030300	// PERIPHERAL DEVICE WRITE FAULT
#define DISK_WRITEPROTECT	0x00042700	// WRITE PROTECTED
#define DISK_MISCOMPARE		0x000e1d00	// MISCOMPARE DURING VERIFY
#define DISK_INVALIDCMD		0x00052000	// INVALID COMMAND OPERATION CODE
#define DISK_INVALIDLBA		0x00052100	// LOGICAL BLOCK ADDR. OUT OF RANGE
#define DISK_INVALIDCDB		0x00052400	// INVALID FIELD IN CDB
#define DISK_INVALIDLUN		0x00052500	// LOGICAL UNIT NOT SUPPORTED
#define DISK_INVALIDPRM		0x00052600	// INVALID FIELD IN PARAMETER LIST
#define DISK_INVALIDMSG		0x00054900	// INVALID MESSAGE ERROR
#define DISK_PARAMLEN		0x00051a00	// PARAMETERS LIST LENGTH ERROR
#define DISK_PARAMNOT		0x00052601	// PARAMETERS NOT SUPPORTED
#define DISK_PARAMVALUE		0x00052602	// PARAMETERS VALUE INVALID
#define DISK_PARAMSAVE		0x00053900	// SAVING PARAMETERS NOT SUPPORTED

#if 0
#define DISK_AUDIOPROGRESS	0x00??0011	// AUDIO PLAY IN PROGRESS
#define DISK_AUDIOPAUSED	0x00??0012	// AUDIO PLAY PAUSED
#define DISK_AUDIOSTOPPED	0x00??0014	// AUDIO PLAY STOPPED DUE TO ERROR
#define DISK_AUDIOCOMPLETE	0x00??0013	// AUDIO PLAY SUCCESSFULLY COMPLETED
#endif

//===========================================================================
//
//	fBXNgbN
//
//===========================================================================
class DiskTrack
{
public:
	// f[^`
	typedef struct {
		int track;						// gbNio[
		int size;						// ZN^TCY(8 or 9)
		int sectors;					// ZN^(<=0x100)
		BYTE *buffer;					// f[^obt@
		BOOL init;						// [hς݂
		BOOL changed;					// ύXς݃tO
		BOOL *changemap;				// ύXς݃}bv
		BOOL raw;						// RAW[h
	} disktrk_t;

public:
	// {t@NV
	DiskTrack(int track, int size, int sectors, BOOL raw = FALSE);
										// RXgN^
	virtual ~DiskTrack();
										// fXgN^
	BOOL FASTCALL Load(const Filepath& path);
										// [h
	BOOL FASTCALL Save(const Filepath& path);
										// Z[u

	// [hECg
	BOOL FASTCALL Read(BYTE *buf, int sec) const;
										// ZN^[h
	BOOL FASTCALL Write(const BYTE *buf, int sec);
										// ZN^Cg

	// ̑
	int FASTCALL GetTrack() const		{ return dt.track; }
										// gbN擾
	BOOL FASTCALL IsChanged() const		{ return dt.changed; }
										// ύXtO`FbN

private:
	// f[^
	disktrk_t dt;
										// f[^
};

//===========================================================================
//
//	fBXNLbV
//
//===========================================================================
class DiskCache
{
public:
	// f[^`
	typedef struct {
		DiskTrack *disktrk;				// 蓖ăgbN
		DWORD serial;					// ŏIVA
	} cache_t;

	// LbV
	enum {
		CacheMax = 16					// LbVgbN
	};

public:
	// {t@NV
	DiskCache(const Filepath& path, int size, int blocks);
										// RXgN^
	virtual ~DiskCache();
										// fXgN^
	void FASTCALL SetRawMode(BOOL raw);
										// CD-ROM raw[hݒ

	// ANZX
	BOOL FASTCALL Save();
										// SZ[u
	BOOL FASTCALL Read(BYTE *buf, int block);
										// ZN^[h
	BOOL FASTCALL Write(const BYTE *buf, int block);
										// ZN^Cg
	BOOL FASTCALL GetCache(int index, int& track, DWORD& serial) const;
										// LbV擾

private:
	// Ǘ
	void FASTCALL Clear();
										// gbNׂăNA
	DiskTrack* FASTCALL Assign(int track);
										// gbÑ[h
	BOOL FASTCALL Load(int index, int track);
										// gbÑ[h
	void FASTCALL Update();
										// VAԍXV

	// f[^
	cache_t cache[CacheMax];
										// LbVǗ
	DWORD serial;
										// ŏIANZXVAio
	Filepath sec_path;
										// pX
	int sec_size;
										// ZN^TCY(8 or 9 or 11)
	int sec_blocks;
										// ZN^ubN
	BOOL cd_raw;
										// CD-ROM RAW[h
};

//===========================================================================
//
//	fBXN
//
//===========================================================================
class Disk
{
public:
	// [N
	typedef struct {
		DWORD id;						// fBAID
		BOOL ready;						// LȃfBXN
		BOOL writep;					// ݋֎~
		BOOL readonly;					// ǂݍݐp
		BOOL removable;					// O
		BOOL lock;						// bN
		BOOL attn;						// AeV
		BOOL reset;						// Zbg
		int size;						// ZN^TCY
		int blocks;						// ZN^
		DWORD lun;						// LUN
		DWORD code;						// Xe[^XR[h
		DiskCache *dcache;				// fBXNLbV
	} disk_t;

public:
	// {t@NV
	Disk(Device *dev);
										// RXgN^
	virtual ~Disk();
										// fXgN^
	virtual void FASTCALL Reset();
										// foCXZbg
	virtual BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	virtual BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h

	// ID
	DWORD FASTCALL GetID() const		{ return disk.id; }
										// fBAID擾
	BOOL FASTCALL IsNULL() const;
										// NULL`FbN
	BOOL FASTCALL IsSASI() const;
										// SASI`FbN

	// fBA
	virtual BOOL FASTCALL Open(const Filepath& path);
										// I[v
	void FASTCALL GetPath(Filepath& path) const;
										// pX擾
	void FASTCALL Eject(BOOL force);
										// CWFNg
	BOOL FASTCALL IsReady() const		{ return disk.ready; }
										// Ready`FbN
	void FASTCALL WriteP(BOOL flag);
										// ݋֎~
	BOOL FASTCALL IsWriteP() const		{ return disk.writep; }
										// ݋֎~`FbN
	BOOL FASTCALL IsReadOnly() const	{ return disk.readonly; }
										// Read Only`FbN
	BOOL FASTCALL IsRemovable() const	{ return disk.removable; }
										// [ou`FbN
	BOOL FASTCALL IsLocked() const		{ return disk.lock; }
										// bN`FbN
	BOOL FASTCALL IsAttn() const		{ return disk.attn; }
										// `FbN
	BOOL FASTCALL Flush();
										// LbVtbV
	void FASTCALL GetDisk(disk_t *buffer) const;
										// [N擾

	// vpeB
	void FASTCALL SetLUN(DWORD lun)		{ disk.lun = lun; }
										// LUNZbg
	DWORD FASTCALL GetLUN()				{ return disk.lun; }
										// LUN擾

	// R}h
	virtual int FASTCALL Inquiry(const DWORD *cdb, BYTE *buf);
										// INQUIRYR}h
	virtual int FASTCALL RequestSense(const DWORD *cdb, BYTE *buf);
										// REQUEST SENSER}h
	int FASTCALL SelectCheck(const DWORD *cdb);
										// SELECT`FbN
	BOOL FASTCALL ModeSelect(const BYTE *buf, int size);
										// MODE SELECTR}h
	int FASTCALL ModeSense(const DWORD *cdb, BYTE *buf);
										// MODE SENSER}h
	BOOL FASTCALL TestUnitReady(const DWORD *cdb);
										// TEST UNIT READYR}h
	BOOL FASTCALL Rezero(const DWORD *cdb);
										// REZEROR}h
	BOOL FASTCALL Format(const DWORD *cdb);
										// FORMAT UNITR}h
	BOOL FASTCALL Reassign(const DWORD *cdb);
										// REASSIGN UNITR}h
	virtual int FASTCALL Read(BYTE *buf, int block);
										// READR}h
	int FASTCALL WriteCheck(int block);
										// WRITE`FbN
	BOOL FASTCALL Write(const BYTE *buf, int block);
										// WRITER}h
	BOOL FASTCALL Seek(const DWORD *cdb);
										// SEEKR}h
	BOOL FASTCALL StartStop(const DWORD *cdb);
										// START STOP UNITR}h
	BOOL FASTCALL SendDiag(const DWORD *cdb);
										// SEND DIAGNOSTICR}h
	BOOL FASTCALL Removal(const DWORD *cdb);
										// PREVENT/ALLOW MEDIUM REMOVALR}h
	int FASTCALL ReadCapacity(const DWORD *cdb, BYTE *buf);
										// READ CAPACITYR}h
	BOOL FASTCALL Verify(const DWORD *cdb);
										// VERIFYR}h
	virtual int FASTCALL ReadToc(const DWORD *cdb, BYTE *buf);
										// READ TOCR}h
	virtual BOOL FASTCALL PlayAudio(const DWORD *cdb);
										// PLAY AUDIOR}h
	virtual BOOL FASTCALL PlayAudioMSF(const DWORD *cdb);
										// PLAY AUDIO MSFR}h
	virtual BOOL FASTCALL PlayAudioTrack(const DWORD *cdb);
										// PLAY AUDIO TRACKR}h
	void FASTCALL InvalidCmd()			{ disk.code = DISK_INVALIDCMD; }
										// T|[gĂȂR}h

protected:
	// Tu
	int FASTCALL AddError(BOOL change, BYTE *buf);
										// G[y[Wǉ
	int FASTCALL AddFormat(BOOL change, BYTE *buf);
										// tH[}bgy[Wǉ
	int FASTCALL AddOpt(BOOL change, BYTE *buf);
										// IveBJy[Wǉ
	int FASTCALL AddCache(BOOL change, BYTE *buf);
										// LbVy[Wǉ
	int FASTCALL AddCDROM(BOOL change, BYTE *buf);
										// CD-ROMy[Wǉ
	int FASTCALL AddCDDA(BOOL change, BYTE *buf);
										// CD-DAy[Wǉ
	BOOL FASTCALL CheckReady();
										// fB`FbN

	// f[^
	disk_t disk;
										// fBXNf[^
	Device *ctrl;
										// Rg[foCX
	Filepath diskpath;
										// pX(GetPathp)
};

//===========================================================================
//
//	SASI n[hfBXN
//
//===========================================================================
class SASIHD : public Disk
{
public:
	// {t@NV
	SASIHD(Device *dev);
										// RXgN^
	BOOL FASTCALL Open(const Filepath& path);
										// I[v

	// fBA
	void FASTCALL Reset();
										// foCXZbg

	// R}h
	int FASTCALL RequestSense(const DWORD *cdb, BYTE *buf);
										// REQUEST SENSER}h
};

//===========================================================================
//
//	SCSI n[hfBXN
//
//===========================================================================
class SCSIHD : public Disk
{
public:
	// {t@NV
	SCSIHD(Device *dev);
										// RXgN^
	BOOL FASTCALL Open(const Filepath& path);
										// I[v

	// R}h
	int FASTCALL Inquiry(const DWORD *cdb, BYTE *buf);
										// INQUIRYR}h
};

//===========================================================================
//
//	SCSI CfBXN
//
//===========================================================================
class SCSIMO : public Disk
{
public:
	// {t@NV
	SCSIMO(Device *dev);
										// RXgN^
	BOOL FASTCALL Open(const Filepath& path, BOOL attn = TRUE);
										// I[v
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h

	// R}h
	int FASTCALL Inquiry(const DWORD *cdb, BYTE *buf);
										// INQUIRYR}h
};

//===========================================================================
//
//	CD-ROM gbN
//
//===========================================================================
class CDTrack
{
public:
	// {t@NV
	CDTrack(SCSICD *scsicd);
										// RXgN^
	virtual ~CDTrack();
										// fXgN^
	BOOL FASTCALL Init(int track, DWORD first, DWORD last);
										// 

	// vpeB
	void FASTCALL SetPath(BOOL cdda, const Filepath& path);
										// pXݒ
	void FASTCALL GetPath(Filepath& path) const;
										// pX擾
	void FASTCALL AddIndex(int index, DWORD lba);
										// CfbNXǉ
	DWORD FASTCALL GetFirst() const;
										// JnLBA擾
	DWORD FASTCALL GetLast() const;
										// I[LBA擾
	DWORD FASTCALL GetBlocks() const;
										// ubN擾
	int FASTCALL GetTrackNo() const;
										// gbNԍ擾
	BOOL FASTCALL IsValid(DWORD lba) const;
										// LLBA
	BOOL FASTCALL IsAudio() const;
										// I[fBIgbN

private:
	SCSICD *cdrom;
										// efoCX
	BOOL valid;
										// LȃgbN
	int track_no;
										// gbNԍ
	DWORD first_lba;
										// JnLBA
	DWORD last_lba;
										// ILBA
	BOOL audio;
										// I[fBIgbNtO
	BOOL raw;
										// RAWf[^tO
	Filepath imgpath;
										// C[Wt@CpX
};

//===========================================================================
//
//	CD-DA obt@
//
//===========================================================================
class CDDABuf
{
public:
	// {t@NV
	CDDABuf();
										// RXgN^
	virtual ~CDDABuf();
										// fXgN^
#if 0
	BOOL Init();
										// 
	BOOL FASTCALL Load(const Filepath& path);
										// [h
	BOOL FASTCALL Save(const Filepath& path);
										// Z[u

	// API
	void FASTCALL Clear();
										// obt@NA
	BOOL FASTCALL Open(Filepath& path);
										// t@Cw
	BOOL FASTCALL GetBuf(DWORD *buffer, int frames);
										// obt@擾
	BOOL FASTCALL IsValid();
										// L`FbN
	BOOL FASTCALL ReadReq();
										// ǂݍݗv
	BOOL FASTCALL IsEnd() const;
										// I`FbN

private:
	Filepath wavepath;
										// WavepX
	BOOL valid;
										// I[v
	DWORD *buf;
										// f[^obt@
	DWORD read;
										// Read|C^
	DWORD write;
										// Write|C^
	DWORD num;
										// f[^L
	DWORD rest;
										// t@CcTCY
#endif
};

//===========================================================================
//
//	SCSI CD-ROM
//
//===========================================================================
class SCSICD : public Disk
{
public:
	// gbN
	enum {
		TrackMax = 96					// gbNő吔
	};

public:
	// {t@NV
	SCSICD(Device *dev);
										// RXgN^
	virtual ~SCSICD();
										// fXgN^
	BOOL FASTCALL Open(const Filepath& path, BOOL attn = TRUE);
										// I[v
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h

	// R}h
	int FASTCALL Inquiry(const DWORD *cdb, BYTE *buf);
										// INQUIRYR}h
	int FASTCALL Read(BYTE *buf, int block);
										// READR}h
	int FASTCALL ReadToc(const DWORD *cdb, BYTE *buf);
										// READ TOCR}h
	BOOL FASTCALL PlayAudio(const DWORD *cdb);
										// PLAY AUDIOR}h
	BOOL FASTCALL PlayAudioMSF(const DWORD *cdb);
										// PLAY AUDIO MSFR}h
	BOOL FASTCALL PlayAudioTrack(const DWORD *cdb);
										// PLAY AUDIO TRACKR}h

	// CD-DA
	BOOL FASTCALL NextFrame();
										// t[ʒm
	void FASTCALL GetBuf(DWORD *buffer, int samples, DWORD rate);
										// CD-DAobt@擾

	// LBA-MSFϊ
	void FASTCALL LBAtoMSF(DWORD lba, BYTE *msf) const;
										// LBAMSFϊ
	DWORD FASTCALL MSFtoLBA(const BYTE *msf) const;
										// MSFLBAϊ

private:
	// I[v
	BOOL FASTCALL OpenCue(const Filepath& path);
										// I[v(CUE)
	BOOL FASTCALL OpenIso(const Filepath& path);
										// I[v(ISO)
	BOOL rawfile;
										// RAWtO

	// gbNǗ
	void FASTCALL ClearTrack();
										// gbNNA
	int FASTCALL SearchTrack(DWORD lba) const;
										// gbN
	CDTrack* track[TrackMax];
										// gbNIuWFNg
	int tracks;
										// gbNIuWFNgL
	int dataindex;
										// ݂̃f[^gbN
	int audioindex;
										// ݂̃I[fBIgbN

	int frame;
										// t[ԍ

#if 0
	CDDABuf da_buf;
										// CD-DAobt@
	int da_num;
										// CD-DAgbN
	int da_cur;
										// CD-DAJggbN
	int da_next;
										// CD-DAlNXggbN
	BOOL da_req;
										// CD-DAf[^v
#endif
};

#endif	// disk_h
