//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ DMAC(HD63450) ]
//
//---------------------------------------------------------------------------

#if !defined(dmac_h)
#define dmac_h

#include "device.h"

//===========================================================================
//
//	DMAC
//
//===========================================================================
class DMAC : public MemDevice
{
public:
	// f[^`(`l)
	typedef struct {
		// {p[^
		DWORD xrm;						// NGXg[h
		DWORD dtyp;						// foCX^Cv
		BOOL dps;						// |[gTCY (TRUE16bit)
		DWORD pcl;						// PCLZN^
		BOOL dir;						//  (TRUEDAR)
		BOOL btd;						// DONEŎubN
		DWORD size;						// IyhTCY
		DWORD chain;					// `FC
		DWORD reqg;						// REQ[h
		DWORD mac;						// AhXXV[h
		DWORD dac;						// foCXAhXXV[h

		// tO
		BOOL str;						// X^[gtO
		BOOL cnt;						// ReBj[tO
		BOOL hlt;						// HALTtO
		BOOL sab;						// \tgEFAA{[gtO
		BOOL intr;						// 荞݉\tO
		BOOL coc;						// `l슮tO
		BOOL boc;						// ubN슮tO
		BOOL ndt;						// ItO
		BOOL err;						// G[tO
		BOOL act;						// ANeButO
		BOOL dit;						// DONE̓tO
		BOOL pct;						// PCL negedgeotO
		BOOL pcs;						// PCL̏ (TRUEHx)
		DWORD ecode;					// G[R[h

		// AhXAOX
		DWORD mar;						// AhXJE^
		DWORD dar;						// foCXAhXWX^
		DWORD bar;						// x[XAhXWX^
		DWORD mtc;						// gXt@JE^
		DWORD btc;						// x[XgXt@JE^
		DWORD mfc;						// t@NVR[h
		DWORD dfc;						// foCXt@NVR[h
		DWORD bfc;						// x[Xt@NVR[h
		DWORD niv;						// m[}C^vgxN^
		DWORD eiv;						// G[C^vgxN^

		// o[Xg]
		DWORD cp;						// vCIeB
		DWORD bt;						// o[Xg]^C
		DWORD br;						// oh
		int type;						// ]^Cv

		// JE^(fobO)
		DWORD startcnt;					// X^[gJE^
		DWORD errorcnt;					// G[JE^
	} dma_t;

	// f[^`(O[o)
	typedef struct {
		int transfer;					// ]tO(`lp)
		int load;						// `FC[htO(`lp)
		BOOL exec;						// I[gNGXgLtO
		int current_ch;					// I[gNGXg`l
		int cpu_cycle;					// CPUTCNJE^
		int vector;						// 荞ݗvxN^
	} dmactrl_t;

public:
	// {t@NV
	DMAC(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [hǂݍ
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL GetDMA(int ch, dma_t *buffer) const;
										// DMA擾
	void FASTCALL GetDMACtrl(dmactrl_t *buffer) const;
										// DMA擾
	BOOL FASTCALL ReqDMA(int ch);
										// DMA]v
	DWORD FASTCALL AutoDMA(DWORD cycle);
										// DMAI[gNGXg
	BOOL FASTCALL IsDMA() const;
										// DMA]₢킹
	void FASTCALL BusErr(DWORD addr, BOOL read);
										// oXG[
	void FASTCALL AddrErr(DWORD addr, BOOL read);
										// AhXG[
	DWORD FASTCALL GetVector(int type) const;
										// xN^擾
	void FASTCALL IntAck();
										// 荞ACK
	BOOL FASTCALL IsAct(int ch) const;
										// DMA]\₢킹

private:
	// `lANZX
	DWORD FASTCALL ReadDMA(int ch, DWORD addr) const;
										// DMAǂݍ
	void FASTCALL WriteDMA(int ch, DWORD addr, DWORD data);
										// DMA
	void FASTCALL SetDCR(int ch, DWORD data);
										// DCRZbg
	DWORD FASTCALL GetDCR(int ch) const;
										// DCR擾
	void FASTCALL SetOCR(int ch, DWORD data);
										// OCRZbg
	DWORD FASTCALL GetOCR(int ch) const;
										// OCR擾
	void FASTCALL SetSCR(int ch, DWORD data);
										// SCRZbg
	DWORD FASTCALL GetSCR(int ch) const;
										// SCR擾
	void FASTCALL SetCCR(int ch, DWORD data);
										// CCRZbg
	DWORD FASTCALL GetCCR(int ch) const;
										// CCR擾
	void FASTCALL SetCSR(int ch, DWORD data);
										// CSRZbg
	DWORD FASTCALL GetCSR(int ch) const;
										// CSR擾
	void FASTCALL SetGCR(DWORD data);
										// GCRZbg

	// `lIy[V
	void FASTCALL ResetDMA(int ch);
										// DMAZbg
	void FASTCALL StartDMA(int ch);
										// DMAX^[g
	void FASTCALL ContDMA(int ch);
										// DMAReBj[
	void FASTCALL AbortDMA(int ch);
										// DMA\tgEFAA{[g
	void FASTCALL LoadDMA(int ch);
										// DMAubN[h
	void FASTCALL ErrorDMA(int ch, DWORD code);
										// G[
	void FASTCALL Interrupt();
										// 荞
	BOOL FASTCALL TransDMA(int ch);
										// DMA1]

	// e[uA[N
	static const int MemDiffTable[8][4];
										// XVe[u
	static const int DevDiffTable[8][4];
										// foCXXVe[u
	Memory *memory;
										// 
	FDC *fdc;
										// FDC
	dma_t dma[4];
										// [N(`l)
	dmactrl_t dmactrl;
										// [N(O[o)
};

#endif	// dmac_h
