//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ Cxg ]
//
//---------------------------------------------------------------------------

#if !defined(event_h)
#define event_h

//===========================================================================
//
//	Cxg
//
//===========================================================================
class Event
{
public:
	// f[^`
#if defined(_WIN32)
#pragma pack(push, 8)
#endif	// _WIN32
	typedef struct {
		DWORD remain;					// c莞
		DWORD time;						// g[^
		DWORD user;						// [U`f[^
		Device *device;					// efoCX
		Scheduler *scheduler;			// XPW[
		Event *next;					// ̃Cxg
		char desc[0x20];				// 
	} event_t;
#if defined(_WIN32)
#pragma pack(pop)
#endif	// _WIN32

public:
	// {t@NV
	Event();
										// RXgN^
	virtual ~Event();
										// fXgN^
#if !defined(NDEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// NDEBUG

	// [hEZ[u
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h

	// vpeB
	void FASTCALL SetDevice(Device *p);
										// efoCXݒ
	Device* FASTCALL GetDevice() const	{ return ev.device; }
										// efoCX擾
	void FASTCALL SetDesc(const char *desc);
										// ̐ݒ
	const char* FASTCALL GetDesc() const;
										// ̎擾
	void FASTCALL SetUser(DWORD data)	{ ev.user = data; }
										// [U`f[^ݒ
	DWORD FASTCALL GetUser() const		{ return ev.user; }
										// [U`f[^擾

	// ԊǗ
	void FASTCALL SetTime(DWORD hus);
										// Ԏݒ
	DWORD FASTCALL GetTime() const		{ return ev.time; }
										// Ԏ擾
	DWORD FASTCALL GetRemain() const	{ return ev.remain; }
										// c莞Ԏ擾
	void FASTCALL Exec(DWORD hus);
										// Ԃi߂

	// NݒE폜
	void FASTCALL SetNextEvent(Event *p) { ev.next = p; }
										// ̃Cxgݒ
	Event* FASTCALL GetNextEvent() const { return ev.next; }
										// ̃Cxg擾

private:
	// f[^`(Ver2.01܂ŁBenable)
	typedef struct {
		Device *device;					// efoCX
		Scheduler *scheduler;			// XPW[
		Event *next;					// ̃Cxg
		char desc[0x20];				// 
		DWORD user;						// [U`f[^
		BOOL enable;					// Cl[u
		DWORD time;						// g[^
		DWORD remain;					// c莞
	} event201_t;

	BOOL FASTCALL Load201(Fileio *fio);
										// [h(version 2.01ȑO)
	event_t ev;
										// [N
};

#endif	// event_h
