//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2005 ohD(ytanaka@ipc-tokai.or.jp)
//	[ FDC(uPD72065) ]
//
//---------------------------------------------------------------------------

#if !defined(fdc_h)
#define fdc_h

#include "device.h"
#include "event.h"

//===========================================================================
//
//	FDC
//
//===========================================================================
class FDC : public MemDevice
{
public:
	// tF[Y`
	enum fdcphase {
		idle,							// AChtF[Y
		command,						// R}htF[Y
		execute,						// stF[Y(ʏ)
		read,							// stF[Y(Read)
		write,							// stF[Y(Write)
		result							// UgtF[Y
	};

	// Xe[^XWX^`
	enum {
		sr_rqm = 0x80,					// Request For Master
		sr_dio = 0x40,					// Data Input / Output
		sr_ndm = 0x20,					// Non-DMA Mode
		sr_cb = 0x10,					// FDC Busy
		sr_d3b = 0x08,					// Drive3 Seek
		sr_d2b = 0x04,					// Drive2 Seek
		sr_d1b = 0x02,					// Drive1 Seek
		sr_d0b = 0x01					// Drive0 Seek
	};

	// R}h`
	enum fdccmd {
		read_data,						// READ DATA
		read_del_data,					// READ DELETED DATA
		read_id,						// READ ID
		write_id,						// WRITE ID
		write_data,						// WRITE DATA
		write_del_data,					// WRITE DELETED DATA
		read_diag,						// READ DIAGNOSTIC
		scan_eq,						// SCAN EQUAL
		scan_lo_eq,						// SCAN LOW OR EQUAL
		scan_hi_eq, 					// SCAN HIGH OR EQUAL
		seek,							// SEEK
		recalibrate,					// RECALIBRATE
		sense_int_stat,					// SENSE INTERRUPT STATUS
		sense_dev_stat,					// SENSE DEVICE STATUS
		specify,						// SPECIFY
		set_stdby,						// SET STANDBY
		reset_stdby,					// RESET STANDBY
		fdc_reset,						// SOFTWARE RESET
		invalid,						// INVALID
		no_cmd							// (NO COMMAND)
	};

	// [N`
	typedef struct {
		fdcphase phase;					// tF[Y
		fdccmd cmd;						// R}h

		int in_len;						// ̓OX
		int in_cnt;						// ̓JEg
		DWORD in_pkt[0x10];				// ̓pPbg
		int out_len;					// o̓OX
		int out_cnt;					// o̓JEg
		DWORD out_pkt[0x10];			// o̓pPbg

		DWORD dcr;						// hCuRg[WX^
		DWORD dsr;						// hCuZNgWX^
		DWORD sr;						// Xe[^XWX^
		DWORD dr;						// f[^WX^
		DWORD st[4];					// ST0-ST3

		DWORD srt;						// SRT
		DWORD hut;						// HUT
		DWORD hlt;						// HLT
		DWORD hd;						// HD
		DWORD us;						// US
		DWORD cyl[4];					// gbN
		DWORD chrn[4];					// vꂽC,H,R,N

		DWORD eot;						// EOT
		DWORD gsl;						// GSL
		DWORD dtl;						// DTL
		DWORD sc; 						// SC
		DWORD gpl;						// GAP3
		DWORD d;						// tH[}bgf[^
		DWORD err;						// G[R[h
		BOOL seek;						// V[Nn荞ݗv
		BOOL ndm;						// Non-DMA[h
		BOOL mfm;						// MFM[h
		BOOL mt;						// }`gbN
		BOOL sk;						// Skip DDAM
		BOOL tc;						// TC
		BOOL load;						// wbh[h

		int offset;						// obt@ItZbg
		int len;						// c背OX
		BYTE buffer[0x4000];			// f[^obt@

		BOOL fast;						// [h
		BOOL dual;						// fAhCu
	} fdc_t;

public:
	// {t@NV
	FDC(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	BOOL FASTCALL Callback(Event *ev);
										// CxgR[obN
	const fdc_t* FASTCALL GetWork() const;
										// [NAhX擾
	void FASTCALL CompleteSeek(int drive, BOOL result);
										// V[N
	void FASTCALL SetTC();
										// TCAT[g

private:
	void FASTCALL Idle();
										// AChtF[Y
	void FASTCALL Command(DWORD data);
										// R}htF[Y
	void FASTCALL CommandRW(fdccmd cmd, DWORD data);
										// R}htF[Y(R/Wn)
	void FASTCALL Execute();
										// stF[Y
	void FASTCALL ReadID();
										// stF[Y(Read ID)
	void FASTCALL ExecuteRW();
										// stF[Y(R/Wn)
	BYTE FASTCALL Read();
										// stF[Y(Read)
	void FASTCALL Write(DWORD data);
										// stF[Y(Write)
	void FASTCALL Compare(DWORD data);
										// stF[Y(Compare)
	void FASTCALL Result();
										// UgtF[Y
	void FASTCALL ResultRW();
										// UgtF[Y(R/Wn)
	void FASTCALL Interrupt(BOOL flag);
										// 荞
	void FASTCALL SoftReset();
										// \tgEFAZbg
	void FASTCALL MakeST3();
										// ST3쐬
	BOOL FASTCALL ReadData();
										// READ (DELETED) DATAR}h
	BOOL FASTCALL WriteData();
										// WRITE (DELETED) DATAR}h
	BOOL FASTCALL ReadDiag();
										// READ DIAGNOSTICR}h
	BOOL FASTCALL WriteID();
										// WRITE IDR}h
	BOOL FASTCALL Scan();
										// SCANnR}h
	void FASTCALL EventRW();
										// Cxg(R/W)
	void FASTCALL EventErr(DWORD hus);
										// Cxg(G[)
	void FASTCALL WriteBack();
										// ݊
	BOOL FASTCALL NextSector();
										// }`ZN^
	IOSC *iosc;
										// IOSC
	DMAC *dmac;
										// DMAC
	FDD *fdd;
										// FDD
	Event event;
										// Cxg
	fdc_t fdc;
										// FDCf[^
};

#endif	// fdc_h
