//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ FDD(FD55GFR) ]
//
//---------------------------------------------------------------------------

#if !defined(fdd_h)
#define fdd_h

#include "device.h"
#include "event.h"
#include "filepath.h"

//---------------------------------------------------------------------------
//
//	G[`
//	ST1, ST2, 󂫃rbgꕔgp
//
//---------------------------------------------------------------------------
#define FDD_NOERROR			0x0000		// G[
#define FDD_EOT				0x8000		// EOTI[o[
#define FDD_DDAM			0x4000		// DDAMZN^
#define FDD_DATAERR			0x2000		// IDCRC܂̓f[^CRC(ReadID)
#define FDD_OVERRUN			0x1000		// I[o[(Xgf[^)
#define FDD_IDCRC			0x0800		// IDtB[hCRC
#define FDD_NODATA			0x0400		// LȃZN^Ȃ
#define FDD_NOTWRITE		0x0200		// ݋֎~Mo
#define FDD_MAM				0x0100		// AhX}[NȂ
#define FDD_NOTREADY		0x0080		// mbgfB
#define FDD_CM				0x0040		// DDAM܂DAMo
#define FDD_DATACRC			0x0020		// f[^CRC
#define FDD_NOCYL			0x0010		// V_قȂ
#define FDD_SCANEQ			0x0008		// SCANňv
#define FDD_SCANNOT			0x0004		// SCANňv̂Ȃ
#define FDD_BADCYL			0x0002		// V_s
#define FDD_MDAM			0x0001		// DAMȂ

//---------------------------------------------------------------------------
//
//	hCuXe[^X`
//
//---------------------------------------------------------------------------
#define FDST_INSERT			0x80		// }(}܂)
#define FDST_INVALID		0x40		// }
#define FDST_EJECT			0x20		// CWFNgł
#define FDST_BLINK			0x10		// _ŏ
#define FDST_CURRENT		0x08		// _ł̂ǂ炩̏Ԃ
#define FDST_MOTOR			0x04		// [^]
#define FDST_SELECT			0x02		// ZNg
#define FDST_ACCESS			0x01		// ANZX

//===========================================================================
//
//	FDD
//
//===========================================================================
class FDD : public Device
{
public:
	// hCuf[^`
	typedef struct {
		FDI *fdi;						// tbs[fBXNC[W
		FDI *next;						// ɑ}C[W
		BOOL seeking;					// V[N
		int cylinder;					// V_
		BOOL insert;					// }
		BOOL invalid;					// }
		BOOL eject;						// CWFNgł
		BOOL blink;						// }ĂȂΓ_
		BOOL access;					// ANZX
	} drv_t;

	// f[^`
	typedef struct {
		BOOL motor;						// [^tO
		BOOL settle;					// ZgO
		BOOL force;						// fBtO
		int selected;					// ZNghCu
		BOOL first;						// [^ON̏V[N
		BOOL hd;						// HDtO

		BOOL fast;						// [h
	} fdd_t;

public:
	// {t@NV
	FDD(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// OAPI
	void FASTCALL GetDrive(int drive, drv_t *buffer) const;
										// hCu[N擾
	void FASTCALL GetFDD(fdd_t *buffer) const;
										// [N擾
	FDI* FASTCALL GetFDI(int drive);
										// FDI擾
	BOOL FASTCALL Callback(Event *ev);
										// CxgR[obN
	void FASTCALL ForceReady(BOOL flag);
										// fB
	DWORD FASTCALL GetRotationPos() const;
										// ]ʒu擾
	DWORD FASTCALL GetRotationTime() const;
										// ]Ԏ擾
	DWORD FASTCALL GetSearch();
										// Ԏ擾
	void FASTCALL SetHD(BOOL hd);
										// HDtOݒ
	BOOL FASTCALL IsHD() const;
										// HDtO擾
	void FASTCALL Access(BOOL flag);
										// ANZXLEDݒ

	// hCu
	BOOL FASTCALL Open(int drive, const Filepath& path, int media = 0);
										// C[WI[v
	void FASTCALL Insert(int drive);
										// CT[g
	void FASTCALL Eject(int drive, BOOL force);
										// CWFNg
	void FASTCALL Invalid(int drive);
										// }
	void FASTCALL Control(int drive, DWORD func);
										// hCuRg[
	BOOL FASTCALL IsReady(int drive, BOOL fdc = TRUE) const;
										// fB`FbN
	BOOL FASTCALL IsWriteP(int drive) const;
										// ݋֎~`FbN
	BOOL FASTCALL IsReadOnly(int drive) const;
										// Read Only`FbN
	void FASTCALL WriteP(int drive, BOOL flag);
										// ݋֎~ݒ
	int FASTCALL GetStatus(int drive) const;
										// hCuXe[^X擾
	void FASTCALL SetMotor(int drive, BOOL flag);
										// [^ݒ{hCuZNg
	int FASTCALL GetCylinder(int drive) const;
										// V_擾
	void FASTCALL GetName(int drive, char *buf, int media = -1) const;
										// fBXN擾
	void FASTCALL GetPath(int drive, Filepath& path) const;
										// pX擾
	int FASTCALL GetDisks(int drive) const;
										// C[WfBXN擾
	int FASTCALL GetMedia(int drive) const;
										// C[WJgfBA擾

	// V[N
	void FASTCALL Recalibrate(DWORD srt);
										// Lu[g
	void FASTCALL StepIn(int step, DWORD srt);
										// XebvC
	void FASTCALL StepOut(int step, DWORD srt);
										// XebvAEg

	// ǂݍ݁E
	int FASTCALL ReadID(DWORD *buf, BOOL mfm, int hd);
										// [hID
	int FASTCALL ReadSector(BYTE *buf, int *len, BOOL mfm, DWORD *chrn, int hd);
										// [hZN^
	int FASTCALL WriteSector(const BYTE *buf, int *len, BOOL mfm, DWORD *chrn, int hd, BOOL deleted);
										// CgZN^
	int FASTCALL ReadDiag(BYTE *buf, int *len, BOOL mfm, DWORD *chrn, int hd);
										// [h_CAO
	int FASTCALL WriteID(const BYTE *buf, DWORD d, int sc, BOOL mfm, int hd, int gpl);
										// CgID

private:
	void FASTCALL SeekInOut(int cylinder, DWORD srt);
										// V[N
	void FASTCALL Rotation();
										// [^]
	FDC *fdc;
										// FDC
	IOSC *iosc;
										// IOSC
	RTC *rtc;
										// RTC
	drv_t drv[4];
										// hCuf[^
	fdd_t fdd;
										// f[^
	Event eject;
										// CWFNgCxg
	Event seek;
										// V[NCxg
	Event rotation;
										// ]Cxg
	BOOL cache_wb;
										// LbV[h
};

#endif	// fdd_h
