//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ tbs[fBXNC[W ]
//
//---------------------------------------------------------------------------

#if !defined(fdi_h)
#define fdi_h

#include "filepath.h"

//---------------------------------------------------------------------------
//
//	NXs`
//
//---------------------------------------------------------------------------
class FDI;
class FDIDisk;
class FDITrack;
class FDISector;

class FDIDisk2HD;
class FDITrack2HD;
class FDIDiskDIM;
class FDITrackDIM;
class FDIDiskD68;
class FDITrackD68;
class FDIDiskBAD;
class FDITrackBAD;
class FDIDisk2DD;
class FDITrack2DD;
class FDIDisk2HQ;
class FDITrack2HQ;

//---------------------------------------------------------------------------
//
//	tH[}bg`
//
//---------------------------------------------------------------------------
#define FDI_2HD			0x00			// 2HD
#define FDI_2HDA		0x01			// 2HDA
#define FDI_2HS			0x02			// 2HS
#define FDI_2HC			0x03			// 2HC
#define FDI_2HDE		0x04			// 2HDE
#define FDI_2HQ			0x05			// 2HQ
#define FDI_N88B		0x06			// N88-BASIC
#define FDI_OS9			0x07			// OS-9/68000
#define FDI_2DD			0x08			// 2DD

//===========================================================================
//
//	FDIZN^
//
//===========================================================================
class FDISector
{
public:
	// f[^`
	typedef struct {
		DWORD chrn[4];					// CHRN
		BOOL mfm;						// MFMtO
		int error;						// G[R[h
		int length;						// f[^
		int gap3;						// GAP3
		BYTE *buffer;					// f[^obt@
		DWORD pos;						// |WV
		BOOL changed;					// ύXς݃tO
		FDISector *next;				// ̃ZN^
	} sector_t;

public:
	// {t@NV
	FDISector(BOOL mfm, const DWORD *chrn);
										// RXgN^
	virtual ~FDISector();
										// fXgN^
	void FASTCALL Load(const BYTE *buf, int len, int gap, int err);
										// [h

	// [hECg
	BOOL FASTCALL IsMatch(BOOL mfm, const DWORD *chrn) const;
										// ZN^}b`邩
	void FASTCALL GetCHRN(DWORD *chrn)	const;
										// CHRN擾
	BOOL FASTCALL IsMFM() const			{ return sec.mfm; }
										// MFM
	int FASTCALL Read(BYTE *buf) const;
										// [h
	int FASTCALL Write(const BYTE *buf, BOOL deleted);
										// Cg
	int FASTCALL Fill(DWORD d);
										// tB

	// vpeB
	const BYTE* FASTCALL GetSector() const	{ return sec.buffer; }
										// ZN^f[^擾
	int FASTCALL GetLength() const		{ return sec.length; }
										// f[^擾
	int FASTCALL GetError() const		{ return sec.error; }
										// G[R[h擾
	int FASTCALL GetGAP3() const		{ return sec.gap3; }
										// GAP3oCg擾

	// |WV
	void FASTCALL SetPos(DWORD pos)		{  sec.pos = pos; }
										// |WVݒ
	DWORD FASTCALL GetPos() const		{ return sec.pos; }
										// |WV擾

	// ύXtO
	BOOL FASTCALL IsChanged() const		{ return sec.changed; }
										// ύXtO`FbN
	void FASTCALL ClrChanged()			{ sec.changed = FALSE; }
										// ύXtO𗎂Ƃ
	void FASTCALL ForceChanged()		{ sec.changed = TRUE; }
										// ύXtOグ

	// CfbNXEN
	void FASTCALL SetNext(FDISector *next)	{ sec.next = next; }
										// ̃ZN^ݒ
	FDISector* FASTCALL GetNext() const	{ return sec.next; }
										// ̃ZN^擾

private:
	// f[^
	sector_t sec;
										// ZN^f[^
};

//===========================================================================
//
//	FDIgbN
//
//===========================================================================
class FDITrack
{
public:
	// [N
	typedef struct {
		FDIDisk *disk;					// efBXN
		int track;						// gbN
		BOOL init;						// [hς݂
		int sectors[3];					// LZN^(ALL/FM/MFM)
		BOOL hd;						// xtO
		BOOL mfm;						// 擪ZN^MFMtO
		FDISector *first;				// ŏ̃ZN^
		FDITrack *next;					// ̃gbN
	} track_t;

public:
	// {t@NV
	FDITrack(FDIDisk *disk, int track, BOOL hd = TRUE);
										// RXgN^
	virtual ~FDITrack();
										// fXgN^
	virtual BOOL FASTCALL Save(Fileio *fio, DWORD offset);
										// Z[u
	virtual BOOL FASTCALL Save(const Filepath& path, DWORD offset);
										// Z[u
	void FASTCALL Create(DWORD phyfmt);
										// tH[}bg
	BOOL FASTCALL IsHD() const			{ return trk.hd; }
										// HDtO擾

	// [hECg
	int FASTCALL ReadID(DWORD *buf, BOOL mfm);
										// [hID
	int FASTCALL ReadSector(BYTE *buf, int *len, BOOL mfm, const DWORD *chrn);
										// [hZN^
	int FASTCALL WriteSector(const BYTE *buf, int *len, BOOL mfm, const DWORD *chrn, BOOL deleted);
										// CgZN^
	int FASTCALL ReadDiag(BYTE *buf, int *len, BOOL mfm, const DWORD *chrn);
										// [h_CAO
	virtual int FASTCALL WriteID(const BYTE *buf, DWORD d, int sc, BOOL mfm, int gpl);
										// CgID

	// CfbNXEN
	int FASTCALL GetTrack() const		{ return trk.track; }
										// ̃gbN擾
	void FASTCALL SetNext(FDITrack *p)	{ trk.next = p; }
										// ̃gbNݒ
	FDITrack* FASTCALL GetNext() const	{ return trk.next; }
										// ̃gbN擾

	// ZN^
	BOOL FASTCALL IsChanged() const;
										// ύXtO`FbN
	DWORD FASTCALL GetTotalLength() const;
										// ZN^OX݌vZo
	void FASTCALL ForceChanged();
										// ύX
	FDISector* FASTCALL Search(BOOL mfm, const DWORD *chrn);
										// ɍZN^T[`
	FDISector* FASTCALL GetFirst() const{ return trk.first; }
										// ŏ̃ZN^擾

protected:
	// tH[}bg
	void FASTCALL Create2HD(int lim);
										// tH[}bg(2HD)
	void FASTCALL Create2HS();
										// tH[}bg(2HS)
	void FASTCALL Create2HC();
										// tH[}bg(2HC)
	void FASTCALL Create2HDE();
										// tH[}bg(2HDE)
	void FASTCALL Create2HQ();
										// tH[}bg(2HQ)
	void FASTCALL CreateN88B();
										// tH[}bg(N88-BASIC)
	void FASTCALL CreateOS9();
										// tH[}bg(OS-9)
	void FASTCALL Create2DD();
										// tH[}bg(2DD)

	// fBXNA]Ǘ
	FDIDisk* FASTCALL GetDisk() const	{ return trk.disk; }
										// fBXN擾
	BOOL FASTCALL IsMFM() const			{ return trk.mfm; }
										// 擪ZN^MFM
	int FASTCALL GetGAP1() const;
										// GAP1擾
	int FASTCALL GetTotal() const;
										// g[^擾
	void FASTCALL CalcPos();
										// ZN^擪̈ʒuZo
	DWORD FASTCALL GetSize(FDISector *sector) const;
										// ZN^̃TCY(ID,GAP3܂)擾
	FDISector* FASTCALL GetCurSector() const;
										// Jgʒuȍ~̍ŏ̃ZN^擾

	// gbN
	BOOL IsInit() const					{ return trk.init; }

	// ZN^
	void FASTCALL AddSector(FDISector *sector);
										// ZN^ǉ
	void FASTCALL ClrSector();
										// ZN^S폜
	int FASTCALL GetAllSectors() const	{ return trk. sectors[0]; }
										// ZN^擾(All)
	int FASTCALL GetMFMSectors() const	{ return trk.sectors[1]; }
										// ZN^擾(MFM)
	int FASTCALL GetFMSectors() const	{ return trk.sectors[2]; }
										// ZN^擾(FM)

	// _CAO
	int FASTCALL MakeGAP1(BYTE *buf, int offset) const;
										// GAP1쐬
	int FASTCALL MakeSector(BYTE *buf, int offset, FDISector *sector) const;
										// ZN^f[^쐬
	int FASTCALL MakeGAP4(BYTE *buf, int offset) const;
										// GAP4쐬
	int FASTCALL MakeData(BYTE *buf, int offset, BYTE data, int length) const;
										// Diagf[^쐬
	WORD FASTCALL CalcCRC(BYTE *buf, int length) const;
										// CRCZo
	static const WORD CRCTable[0x100];
										// CRCZoe[u

	// f[^
	track_t trk;
										// gbNf[^
};

//===========================================================================
//
//	FDIfBXN
//
//===========================================================================
class FDIDisk
{
public:
	// VKIvV`
	typedef struct {
		DWORD phyfmt;					// tH[}bg
		BOOL logfmt;					// _tH[}bgL
		char name[60];					// Rg(DIM)/fBXN(D68)
	} option_t;

	// f[^`
	typedef struct {
		int index;						// CfbNX
		FDI *fdi;						// eFDI
		DWORD id;						// ID
		BOOL writep;					// ݋֎~
		BOOL readonly;					// ǂݍݐp
		char name[60];					// fBXN
		Filepath path;					// pX
		DWORD offset;					// t@C̃ItZbg
		FDITrack *first;				// ŏ̃gbN
		FDITrack *head[2];				// wbhɑΉgbN
		int search;						// (P=0x10000)
		FDIDisk *next;					// ̃fBXN
	} disk_t;

public:
	FDIDisk(int index, FDI *fdi);
										// RXgN^
	virtual ~FDIDisk();
										// fXgN^
	DWORD FASTCALL GetID() const		{ return disk.id; }
										// ID擾

	// fBA
	virtual BOOL FASTCALL Create(const Filepath& path, const option_t *opt);
										// VKfBXN쐬
	virtual BOOL FASTCALL Open(const Filepath& path, DWORD offset = 0);
										// I[v
	void FASTCALL GetName(char *buf) const;
										// fBXN擾
	void FASTCALL GetPath(Filepath& path) const;
										// pX擾
	BOOL FASTCALL IsWriteP() const		{ return disk.writep; }
										// CgveNg
	BOOL FASTCALL IsReadOnly() const	{ return disk.readonly; }
										// Read OnlyfBXNC[W
	void FASTCALL WriteP(BOOL flag);
										// ݋֎~Zbg
	virtual BOOL FASTCALL Flush();
										// obt@tbV

	// ANZX
	virtual void FASTCALL Seek(int c);
										// V[N
	int FASTCALL ReadID(DWORD *buf, BOOL mfm, int hd);
										// [hID
	int FASTCALL ReadSector(BYTE *buf, int *len, BOOL mfm, const DWORD *chrn, int hd);
										// [hZN^
	int FASTCALL WriteSector(const BYTE *buf, int *len, BOOL mfm, const DWORD *chrn, int hd, BOOL deleted);
										// CgZN^
	int FASTCALL ReadDiag(BYTE *buf, int *len, BOOL mfm, const DWORD *chrn, int hd);
										// [h_CAO
	int FASTCALL WriteID(const BYTE *buf, DWORD d, int sc, BOOL mfm, int hd, int gpl);
										// CgID

	// ]Ǘ
	DWORD FASTCALL GetRotationPos() const;
										// ]ʒu擾
	DWORD FASTCALL GetRotationTime() const;
										// ]Ԏ擾
	DWORD FASTCALL GetSearch() const	{ return disk.search; }
										// 擾
	void FASTCALL SetSearch(DWORD len)	{ disk.search = len; }
										// ݒ
	void FASTCALL CalcSearch(DWORD pos);
										// Zo
	BOOL FASTCALL IsHD() const;
										// hCuHDԎ擾
	FDITrack* FASTCALL Search(int track) const;
										// gbNT[`

	// CfbNXEN
	int FASTCALL GetIndex() const		{ return disk.index; }
										// CfbNX擾
	void FASTCALL SetNext(FDIDisk *p)	{ disk.next = p; }
										// ̃gbNݒ
	FDIDisk* FASTCALL GetNext() const	{ return disk.next; }
										// ̃gbN擾

protected:
	// _tH[}bg
	void FASTCALL Create2HD(BOOL flag2hd);
										// _tH[}bg(2HD, 2HDA)
	static const BYTE IPL2HD[0x200];
										// IPL(2HD, 2HDA)
	void FASTCALL Create2HS();
										// _tH[}bg(2HS)
	static const BYTE IPL2HS[0x800];
										// IPL(2HS)
	void FASTCALL Create2HC();
										// _tH[}bg(2HC)
	static const BYTE IPL2HC[0x200];
										// IPL(2HC)
	void FASTCALL Create2HDE();
										// _tH[}bg(2HDE)
	static const BYTE IPL2HDE[0x800];
										// IPL(2HDE)
	void FASTCALL Create2HQ();
										// _tH[}bg(2HQ)
	static const BYTE IPL2HQ[0x200];
										// IPL(2HQ)
	void FASTCALL Create2DD();
										// _tH[}bg(2DD)

	// C[W
	FDI* FASTCALL GetFDI() const		{ return disk.fdi; }
										// eC[W擾

	// gbN
	void FASTCALL AddTrack(FDITrack *track);
										// gbNǉ
	void FASTCALL ClrTrack();
										// gbNS폜
	FDITrack* FASTCALL GetFirst() const	{ return disk.first; }
										// ŏ̃gbN擾
	FDITrack* FASTCALL GetHead(int idx) { ASSERT((idx==0)||(idx==1)); return disk.head[idx]; }
										// wbhɑΉgbN擾

	// f[^
	disk_t disk;
										// fBXNf[^
};

//===========================================================================
//
//	FDI
//
//===========================================================================
class FDI
{
public:
	// f[^`
	typedef struct {
		FDD *fdd;						// FDD
		int disks;						// fBXN
		FDIDisk *first;					// ŏ̃fBXN
		FDIDisk *disk;					// ݂̃fBXN
	} fdi_t;

public:
	FDI(FDD *fdd);
										// RXgN^
	virtual ~FDI();
										// fXgN^

	// fBA
	BOOL FASTCALL Open(const Filepath& path, int media);
										// I[v
	DWORD FASTCALL GetID() const;
										// ID擾
	BOOL FASTCALL IsMulti() const;
										// }`fBXNC[W
	FDIDisk* GetDisk() const			{ return fdi.disk; }
										// ݂̃fBXN擾
	int FASTCALL GetDisks() const		{ return fdi.disks; }
										// fBXN擾
	int FASTCALL GetMedia() const;
										// }`fBXNCfbNX擾
	void FASTCALL GetName(char *buf, int index = -1) const;
										// fBXN擾
	void FASTCALL GetPath(Filepath& path) const;
										// pX擾
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver, BOOL *ready, int *media, Filepath& path);
										// [h
	void FASTCALL Adjust();
										// ()

	// fBA
	BOOL FASTCALL IsReady() const;
										// fBAZbgĂ邩
	BOOL FASTCALL IsWriteP() const;
										// CgveNg
	BOOL FASTCALL IsReadOnly() const;
										// Read OnlyfBXNC[W
	void FASTCALL WriteP(BOOL flag);
										// ݋֎~Zbg
	BOOL FASTCALL Flush();
										// obt@tbV

	// ANZX
	void FASTCALL Seek(int c);
										// V[N
	int FASTCALL ReadID(DWORD *buf, BOOL mfm, int hd);
										// [hID
	int FASTCALL ReadSector(BYTE *buf, int *len, BOOL mfm, const DWORD *chrn, int hd);
										// [hZN^
	int FASTCALL WriteSector(const BYTE *buf, int *len, BOOL mfm, const DWORD *chrn, int hd, BOOL deleted);
										// CgZN^
	int FASTCALL ReadDiag(BYTE *buf, int *len, BOOL mfm, const DWORD *chrn, int hd);
										// [h_CAO
	int FASTCALL WriteID(const BYTE *buf, DWORD d, int sc, BOOL mfm, int hd, int gpl);
										// CgID

	// ]Ǘ
	DWORD FASTCALL GetRotationPos() const;
										// ]ʒu擾
	DWORD FASTCALL GetRotationTime() const;
										// ]Ԏ擾
	DWORD FASTCALL GetSearch() const;
										// Ԏ擾
	BOOL FASTCALL IsHD() const;
										// hCuHDԎ擾

private:
	// hCu
	FDD* FASTCALL GetFDD() const		{ return fdi.fdd; }

	// fBXN
	void FASTCALL AddDisk(FDIDisk *disk);
										// fBXNǉ
	void FASTCALL ClrDisk();
										// fBXNS폜
	FDIDisk* GetFirst() const			{ return fdi.first; }
										// ŏ̃fBXN擾
	FDIDisk* FASTCALL Search(int index) const;
										// fBXNT[`

	// f[^
	fdi_t fdi;
										// FDIf[^
};

//===========================================================================
//
//	FDIgbN(2HD)
//
//===========================================================================
class FDITrack2HD : public FDITrack
{
public:
	// {t@NV
	FDITrack2HD(FDIDisk *disk, int track);
										// RXgN^
	BOOL FASTCALL Load(const Filepath& path, DWORD offset);
										// [h
};

//===========================================================================
//
//	FDIfBXN(2HD)
//
//===========================================================================
class FDIDisk2HD : public FDIDisk
{
public:
	FDIDisk2HD(int index, FDI *fdi);
										// RXgN^
	virtual ~FDIDisk2HD();
										// fXgN^
	BOOL FASTCALL Open(const Filepath& path, DWORD offset = 0);
										// I[v
	void FASTCALL Seek(int c);
										// V[N
	BOOL FASTCALL Create(const Filepath& path, const option_t *opt);
										// VKfBXN쐬
	BOOL FASTCALL Flush();
										// obt@tbV
};

//===========================================================================
//
//	FDIgbN(DIM)
//
//===========================================================================
class FDITrackDIM : public FDITrack
{
public:
	// {t@NV
	FDITrackDIM(FDIDisk *disk, int track, int type);
										// RXgN^
	BOOL FASTCALL Load(const Filepath& path, DWORD offset, BOOL load);
										// [h
	BOOL FASTCALL IsDIMMFM() const		{ return dim_mfm; }
										// DIM MFMtO擾
	int FASTCALL GetDIMSectors() const	{ return dim_secs; }
										// DIM ZN^擾
	int FASTCALL GetDIMN() const		{ return dim_n; }
										// DIM OX擾

private:
	BOOL dim_mfm;
										// DIM MFMtO
	int dim_secs;
										// DIM ZN^
	int dim_n;
										// DIM OX
	int dim_type;
										// DIM ^Cv
};

//===========================================================================
//
//	FDIfBXN(DIM)
//
//===========================================================================
class FDIDiskDIM : public FDIDisk
{
public:
	FDIDiskDIM(int index, FDI *fdi);
										// RXgN^
	virtual ~FDIDiskDIM();
										// fXgN^
	BOOL FASTCALL Open(const Filepath& path, DWORD offset = 0);
										// I[v
	void FASTCALL Seek(int c);
										// V[N
	BOOL FASTCALL Create(const Filepath& path, const option_t *opt);
										// VKfBXN쐬
	BOOL FASTCALL Flush();
										// obt@tbV

private:
	BOOL FASTCALL GetDIMMap(int track) const;
										// gbN}bv擾
	DWORD FASTCALL GetDIMOffset(int track) const;
										// gbNItZbg擾
	BOOL FASTCALL Save();
										// 폜O̕ۑ
	BYTE dim_hdr[0x100];
										// DIMwb_
	BOOL dim_load;
										// wb_mFtO
};

//===========================================================================
//
//	FDIgbN(D68)
//
//===========================================================================
class FDITrackD68 : public FDITrack
{
public:
	// {t@NV
	FDITrackD68(FDIDisk *disk, int track, BOOL hd);
										// RXgN^
	BOOL FASTCALL Load(const Filepath& path, DWORD offset);
										// [h
	BOOL FASTCALL Save(const Filepath& path, DWORD offset);
										// Z[u
	BOOL FASTCALL Save(Fileio *fio, DWORD offset);
										// Z[u
	int FASTCALL WriteID(const BYTE *buf, DWORD d, int sc, BOOL mfm, int gpl);
										// CgID
	void FASTCALL ForceFormat()			{ d68_format = TRUE; }
										// tH[}bg
	BOOL FASTCALL IsFormated() const	{ return d68_format; }
										// tH[}bgύXĂ邩
	DWORD FASTCALL GetD68Length() const;
										// D68`ł̒擾

private:
	BOOL d68_format;
										// tH[}bgύXtO
	static const int Gap3Table[];
										// GAP3e[u
};

//===========================================================================
//
//	FDIfBXN(D68)
//
//===========================================================================
class FDIDiskD68 : public FDIDisk
{
public:
	FDIDiskD68(int index, FDI *fdi);
										// RXgN^
	virtual ~FDIDiskD68();
										// fXgN^
	BOOL FASTCALL Open(const Filepath& path, DWORD offset = 0);
										// I[v
	void FASTCALL Seek(int c);
										// V[N
	void FASTCALL AdjustOffset();
										// ItZbgXV
	static int FASTCALL CheckDisks(const Filepath& path, DWORD *offbuf);
										// D68wb_`FbN
	BOOL FASTCALL Create(const Filepath& path, const option_t *opt);
										// VKfBXN쐬
	BOOL FASTCALL Flush();
										// obt@tbV

private:
	DWORD FASTCALL GetD68Offset(int track) const;
										// gbNItZbg擾
	BOOL FASTCALL Save();
										// 폜O̕ۑ
	BYTE d68_hdr[0x2b0];
										// D68wb_
	BOOL d68_load;
										// wb_mFtO
};

//===========================================================================
//
//	FDIgbN(BAD)
//
//===========================================================================
class FDITrackBAD : public FDITrack
{
public:
	// {t@NV
	FDITrackBAD(FDIDisk *disk, int track);
										// RXgN^
	BOOL FASTCALL Load(const Filepath& path, DWORD offset);
										// [h
	BOOL FASTCALL Save(const Filepath& path, DWORD offset);
										// Z[u

private:
	int bad_secs;
										// ZN^
};

//===========================================================================
//
//	FDIfBXN(BAD)
//
//===========================================================================
class FDIDiskBAD : public FDIDisk
{
public:
	FDIDiskBAD(int index, FDI *fdi);
										// RXgN^
	virtual ~FDIDiskBAD();
										// fXgN^
	BOOL FASTCALL Open(const Filepath& path, DWORD offset = 0);
										// I[v
	void FASTCALL Seek(int c);
										// V[N
	BOOL FASTCALL Flush();
										// obt@tbV
};

//===========================================================================
//
//	FDIgbN(2DD)
//
//===========================================================================
class FDITrack2DD : public FDITrack
{
public:
	// {t@NV
	FDITrack2DD(FDIDisk *disk, int track);
										// RXgN^
	BOOL FASTCALL Load(const Filepath& path, DWORD offset);
										// [h
};

//===========================================================================
//
//	FDIfBXN(2DD)
//
//===========================================================================
class FDIDisk2DD : public FDIDisk
{
public:
	FDIDisk2DD(int index, FDI *fdi);
										// RXgN^
	virtual ~FDIDisk2DD();
										// fXgN^
	BOOL FASTCALL Open(const Filepath& path, DWORD offset = 0);
										// I[v
	void FASTCALL Seek(int c);
										// V[N
	BOOL FASTCALL Create(const Filepath& path, const option_t *opt);
										// VKfBXN쐬
	BOOL FASTCALL Flush();
										// obt@tbV
};

//===========================================================================
//
//	FDIgbN(2HQ)
//
//===========================================================================
class FDITrack2HQ : public FDITrack
{
public:
	// {t@NV
	FDITrack2HQ(FDIDisk *disk, int track);
										// RXgN^
	BOOL FASTCALL Load(const Filepath& path, DWORD offset);
										// [h
};

//===========================================================================
//
//	FDIfBXN(2HQ)
//
//===========================================================================
class FDIDisk2HQ : public FDIDisk
{
public:
	FDIDisk2HQ(int index, FDI *fdi);
										// RXgN^
	virtual ~FDIDisk2HQ();
										// fXgN^
	BOOL FASTCALL Open(const Filepath& path, DWORD offset = 0);
										// I[v
	void FASTCALL Seek(int c);
										// V[N
	BOOL FASTCALL Create(const Filepath& path, const option_t *opt);
										// VKfBXN쐬
	BOOL FASTCALL Flush();
										// obt@tbV
};

#endif	// fdi_h
