//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2005 ohD(ytanaka@ipc-tokai.or.jp)
//	[ t@CI/O ]
//
//---------------------------------------------------------------------------

#if !defined(fileio_h)
#define fileio_h

//===========================================================================
//
//	t@CI/O
//
//===========================================================================
class Fileio
{
public:
	enum OpenMode {
		ReadOnly,						// ǂݍ݂̂
		WriteOnly,						// ݂̂
		ReadWrite,						// ǂݏ
		Append							// Ayh
	};

public:
	Fileio();
										// RXgN^
	virtual ~Fileio();
										// fXgN^
	BOOL FASTCALL Load(const Filepath& path, void *buffer, int size);
										// ROM,RAM[h
	BOOL FASTCALL Save(const Filepath& path, void *buffer, int size);
										// RAMZ[u

#if defined(_WIN32)
	BOOL FASTCALL Open(LPCTSTR fname, OpenMode mode);
										// I[v
#endif	// _WIN32
	BOOL FASTCALL Open(const Filepath& path, OpenMode mode);
										// I[v
	BOOL FASTCALL Seek(long offset);
										// V[N
	BOOL FASTCALL Read(void *buffer, int size);
										// ǂݍ
	BOOL FASTCALL Write(const void *buffer, int size);
										// 
	DWORD FASTCALL GetFileSize() const;
										// t@CTCY擾
	DWORD FASTCALL GetFilePos() const;
										// t@Cʒu擾
	void FASTCALL Close();
										// N[Y
	BOOL FASTCALL IsValid() const		{ return (BOOL)(handle != -1); }
										// L`FbN
	int FASTCALL GetHandle() const		{ return handle; }
										// nh擾

private:
	int handle;							// t@Cnh
};

#endif	// fileio_h
