//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ t@CpX ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "filepath.h"
#include "fileio.h"

//===========================================================================
//
//	t@CpX
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
Filepath::Filepath()
{
	// NA
	Clear();

	// XVȂ
	m_bUpdate = FALSE;
}

//---------------------------------------------------------------------------
//
//	fXgN^
//
//---------------------------------------------------------------------------
Filepath::~Filepath()
{
}

//---------------------------------------------------------------------------
//
//	Zq
//
//---------------------------------------------------------------------------
Filepath& Filepath::operator=(const Filepath& path)
{
	// pXݒ(Split)
	SetPath(path.GetPath());

	// tyэXV擾
	m_bUpdate = FALSE;
	if (path.IsUpdate()) {
		m_bUpdate = TRUE;
		path.GetUpdateTime(&m_SavedTime, &m_CurrentTime);
	}

	return *this;
}

//---------------------------------------------------------------------------
//
//	NA
//
//---------------------------------------------------------------------------
void FASTCALL Filepath::Clear()
{
	ASSERT(this);

	// pXъeNA
	m_szPath[0] = _T('\0');
	m_szDrive[0] = _T('\0');
	m_szDir[0] = _T('\0');
	m_szFile[0] = _T('\0');
	m_szExt[0] = _T('\0');
}

//---------------------------------------------------------------------------
//
//	t@Cݒ(VXe)
//
//---------------------------------------------------------------------------
void FASTCALL Filepath::SysFile(SysFileType sys)
{
	int nFile;

	ASSERT(this);

	// LXg
	nFile = (int)sys;

	// t@CRs[
	_tcscpy(m_szPath, SystemFile[nFile]);

	// 
	Split();

	// x[XfBNgݒ
	SetBaseDir();
}

//---------------------------------------------------------------------------
//
//	t@Cݒ([U)
//
//---------------------------------------------------------------------------
void FASTCALL Filepath::SetPath(LPCTSTR lpszPath)
{
	ASSERT(this);
	ASSERT(lpszPath);
	ASSERT(_tcslen(lpszPath) < _MAX_PATH);

	// pXRs[
	_tcscpy(m_szPath, lpszPath);

	// 
	Split();

	// hCu̓fBNgĂOK
	if (_tcslen(m_szPath) > 0) {
		if (_tcslen(m_szDrive) == 0) {
			if (_tcslen(m_szDir) == 0) {
				// JgfBNgݒ
				SetCurDir();
			}
		}
	}
}

//---------------------------------------------------------------------------
//
//	pX
//
//---------------------------------------------------------------------------
void FASTCALL Filepath::Split()
{
	ASSERT(this);

	// p[c
	m_szDrive[0] = _T('\0');
	m_szDir[0] = _T('\0');
	m_szFile[0] = _T('\0');
	m_szExt[0] = _T('\0');

	// 
	_tsplitpath(m_szPath, m_szDrive, m_szDir, m_szFile, m_szExt);
}

//---------------------------------------------------------------------------
//
//	pX
//
//---------------------------------------------------------------------------
void FASTCALL Filepath::Make()
{
	ASSERT(this);

	// 
	_tmakepath(m_szPath, m_szDrive, m_szDir, m_szFile, m_szExt);
}

//---------------------------------------------------------------------------
//
//	x[XfBNgݒ
//
//---------------------------------------------------------------------------
void FASTCALL Filepath::SetBaseDir()
{
	TCHAR szModule[_MAX_PATH];

	ASSERT(this);

	// W[̃pX𓾂
	::GetModuleFileName(NULL, szModule, _MAX_PATH);

	// (t@CƊgq͏܂Ȃ)
	_tsplitpath(szModule, m_szDrive, m_szDir, NULL, NULL);

	// 
	Make();
}

//---------------------------------------------------------------------------
//
//	x[Xt@Cݒ
//
//---------------------------------------------------------------------------
void FASTCALL Filepath::SetBaseFile()
{
	TCHAR szModule[_MAX_PATH];

	ASSERT(this);
	ASSERT(_tcslen(m_szPath) > 0);

	// W[̃pX𓾂
	::GetModuleFileName(NULL, szModule, _MAX_PATH);

	// (gq͏܂Ȃ)
	_tsplitpath(szModule, m_szDrive, m_szDir, m_szFile, NULL);

	// 
	Make();
}

//---------------------------------------------------------------------------
//
//	JgfBNgݒ
//
//---------------------------------------------------------------------------
void FASTCALL Filepath::SetCurDir()
{
	TCHAR szCurDir[_MAX_PATH];

	ASSERT(this);
	ASSERT(_tcslen(m_szPath) > 0);

	// JgfBNg擾
	::GetCurrentDirectory(_MAX_PATH, szCurDir);

	// (t@CƊgq͖)
	_tsplitpath(szCurDir, m_szDrive, m_szDir, NULL, NULL);

	// 
	Make();
}

//---------------------------------------------------------------------------
//
//	NAĂ邩
//
//---------------------------------------------------------------------------
BOOL FASTCALL Filepath::IsClear() const
{
	// Clear()̋t
	if ((m_szPath[0] == _T('\0')) &&
		(m_szDrive[0] == _T('\0')) &&
		(m_szDir[0] == _T('\0')) &&
		(m_szFile[0] == _T('\0')) &&
		(m_szExt[0] == _T('\0'))) {
		// mɁANAĂ
		return TRUE;
	}

	// NAĂȂ
	return FALSE;
}

//---------------------------------------------------------------------------
//
//	V[g擾
//	Ԃ|C^͈ꎞIȂ́BRs[邱
//	FDIDiskdisk.nameƂ̊֌WŁA͍ő59+I[Ƃ邱
//
//---------------------------------------------------------------------------
const char* FASTCALL Filepath::GetShort() const
{
	char *lpszFile;
	char *lpszExt;

	ASSERT(this);

	// TCHAR񂩂char֕ϊ
	lpszFile = T2A((LPTSTR)&m_szFile[0]);
	lpszExt = T2A((LPTSTR)&m_szExt[0]);

	// Œobt@֍
	strcpy(ShortName, lpszFile);
	strcat(ShortName, lpszExt);

	// strlenŒׂƂAő59ɂȂ悤ɍ׍H
	ShortName[59] = '\0';

	// const charƂĕԂ
	return (const char*)ShortName;
}

//---------------------------------------------------------------------------
//
//	t@C{gq擾
//	Ԃ|C^͈ꎞIȂ́BRs[邱
//
//---------------------------------------------------------------------------
LPCTSTR FASTCALL Filepath::GetFileExt() const
{
	ASSERT(this);

	// Œobt@֍
	_tcscpy(FileExt, m_szFile);
	_tcscat(FileExt, m_szExt);

	// LPCTSTRƂĕԂ
	return (LPCTSTR)FileExt;
}

//---------------------------------------------------------------------------
//
//	pXr
//
//---------------------------------------------------------------------------
BOOL FASTCALL Filepath::CmpPath(const Filepath& path) const
{
	// pXSvĂTRUE
	if (_tcscmp(path.GetPath(), GetPath()) == 0) {
		return TRUE;
	}

	return FALSE;
}

//---------------------------------------------------------------------------
//
//	ftHgfBNg
//
//---------------------------------------------------------------------------
void FASTCALL Filepath::ClearDefaultDir()
{
	DefaultDir[0] = _T('\0');
}

//---------------------------------------------------------------------------
//
//	ftHgfBNgݒ
//
//---------------------------------------------------------------------------
void FASTCALL Filepath::SetDefaultDir(LPCTSTR lpszPath)
{
	TCHAR szDrive[_MAX_DRIVE];
	TCHAR szDir[_MAX_DIR];

	ASSERT(lpszPath);

	// ^ꂽpXAhCuƃfBNg𐶐
	_tsplitpath(lpszPath, szDrive, szDir, NULL, NULL);

	// hCuƃfBNgRs[
	_tcscpy(DefaultDir, szDrive);
	_tcscat(DefaultDir, szDir);
}

//---------------------------------------------------------------------------
//
//	ftHgfBNg擾
//
//---------------------------------------------------------------------------
LPCTSTR FASTCALL Filepath::GetDefaultDir()
{
	return (LPCTSTR)DefaultDir;
}

//---------------------------------------------------------------------------
//
//	Z[u
//
//---------------------------------------------------------------------------
BOOL FASTCALL Filepath::Save(Fileio *fio, int /*ver*/)
{
	TCHAR szPath[_MAX_PATH];
	CFile file;
	FILETIME ft;

	ASSERT(this);
	ASSERT(fio);

	// [NAāAS~̂
	memset(szPath, 0, sizeof(szPath));
	_tcscpy(szPath, m_szPath);

	// t@CpXۑ
	if (!fio->Write(szPath, sizeof(szPath))) {
		return FALSE;
	}

	// t@Ct擾(2038N邽߁AWin32擾)
	memset(&ft, 0, sizeof(ft));
	if (file.Open(szPath, CFile::modeRead)) {
		::GetFileTime((HANDLE)file.m_hFile, NULL, NULL, &ft);
		file.Close();
	}

	// ŏIݓtۑ
	if (!fio->Write(&ft, sizeof(ft))) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
BOOL FASTCALL Filepath::Load(Fileio *fio, int /*ver*/)
{
	TCHAR szPath[_MAX_PATH];
	CFile file;

	ASSERT(this);
	ASSERT(fio);

	// tpXǂݍ
	if (!fio->Read(szPath, sizeof(szPath))) {
		return FALSE;
	}

	// Zbg
	SetPath(szPath);

	// ŏIݓtǂݍ
	if (!fio->Read(&m_SavedTime, sizeof(m_SavedTime))) {
		return FALSE;
	}

	// t@Ct擾(2038N邽߁AWin32擾)
	if (!file.Open(szPath, CFile::modeRead)) {
		// t@C݂ȂĂAG[Ƃ͂Ȃ
		return TRUE;
	}
	if (!::GetFileTime((HANDLE)file.m_hFile, NULL, NULL, &m_CurrentTime)) {
		return FALSE;
	}
	file.Close();

	// ft̕VꍇAXVtOUp
	if (::CompareFileTime(&m_CurrentTime, &m_SavedTime) <= 0) {
		m_bUpdate = FALSE;
	}
	else {
		m_bUpdate = TRUE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	Z[uɍXVꂽ
//
//---------------------------------------------------------------------------
BOOL FASTCALL Filepath::IsUpdate() const
{
	ASSERT(this);

	return m_bUpdate;
}

//---------------------------------------------------------------------------
//
//	Z[uԏ擾
//
//---------------------------------------------------------------------------
void FASTCALL Filepath::GetUpdateTime(FILETIME *pSaved, FILETIME *pCurrent) const
{
	ASSERT(this);
	ASSERT(m_bUpdate);

	// ԏn
	*pSaved = m_SavedTime;
	*pCurrent = m_CurrentTime;
}

//---------------------------------------------------------------------------
//
//	VXet@Ce[u
//
//---------------------------------------------------------------------------
LPCTSTR Filepath::SystemFile[] = {
	_T("IPLROM.DAT"),
	_T("IPLROMXV.DAT"),
	_T("IPLROMCO.DAT"),
	_T("IPLROM30.DAT"),
	_T("ROM30.DAT"),
	_T("CGROM.DAT"),
	_T("CGROM.TMP"),
	_T("SCSIINROM.DAT"),
	_T("SCSIEXROM.DAT"),
	_T("SRAM.DAT")
};

//---------------------------------------------------------------------------
//
//	V[g
//
//---------------------------------------------------------------------------
char Filepath::ShortName[_MAX_FNAME + _MAX_DIR];

//---------------------------------------------------------------------------
//
//	t@C{gq
//
//---------------------------------------------------------------------------
TCHAR Filepath::FileExt[_MAX_FNAME + _MAX_DIR];

//---------------------------------------------------------------------------
//
//	ftHgfBNg
//
//---------------------------------------------------------------------------
TCHAR Filepath::DefaultDir[_MAX_PATH];

#endif	// WIN32
