//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ t@CpX ]
//
//---------------------------------------------------------------------------

#if !defined(filepath_h)
#define filepath_h

#if defined(_WIN32)

//---------------------------------------------------------------------------
//
//	萔`
//
//---------------------------------------------------------------------------
#define FILEPATH_MAX		_MAX_PATH

//===========================================================================
//
//	t@CpX
//	Zqpӂ邱
//
//===========================================================================
class Filepath
{
public:
	// VXet@C
	enum SysFileType {
		IPL,							// IPL(version 1.00)
		IPLXVI,							// IPL(version 1.10)
		IPLCompact,						// IPL(version 1.20)
		IPL030,							// IPL(version 1.30)㔼
		ROM030,							// IPL(version 1.30)O
		CG,								// CG
		CGTMP,							// CG(Win)
		SCSIInt,						// SCSI()
		SCSIExt,						// SCSI(Ot)
		SRAM							// SRAM
	};

public:
	Filepath();
										// RXgN^
	virtual ~Filepath();
										// fXgN^
	Filepath& operator=(const Filepath& path);
										// 

	void FASTCALL Clear();
										// NA
	void FASTCALL SysFile(SysFileType sys);
										// t@Cݒ(VXe)
	void FASTCALL SetPath(LPCTSTR lpszPath);
										// t@Cݒ([U)
	void FASTCALL SetBaseDir();
										// x[XfBNgݒ
	void FASTCALL SetBaseFile();
										// x[XfBNg{t@Cݒ

	BOOL FASTCALL IsClear() const;
										// NAĂ邩
	LPCTSTR FASTCALL GetPath() const	{ return m_szPath; }
										// pX擾
	const char* FASTCALL GetShort() const;
										// V[g擾(const char*)
	LPCTSTR FASTCALL GetFileExt() const;
										// V[g擾(LPCTSTR)
	BOOL FASTCALL CmpPath(const Filepath& path) const;
										// pXr

	static void FASTCALL ClearDefaultDir();
										// ftHfBNg
	static void FASTCALL SetDefaultDir(LPCTSTR lpszPath);
										// ftHgfBNgɐݒ
	static LPCTSTR FASTCALL GetDefaultDir();
										// ftHgfBNg擾

	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h

private:
	void FASTCALL Split();
										// pX
	void FASTCALL Make();
										// pX
	void FASTCALL SetCurDir();
										// JgfBNgݒ
	BOOL FASTCALL IsUpdate() const;
										// Z[u̍XV肩
	void FASTCALL GetUpdateTime(FILETIME *pSaved, FILETIME *pCurrent ) const;
										// Z[u̎ԏ擾
	TCHAR m_szPath[_MAX_PATH];
										// t@CpX
	TCHAR m_szDrive[_MAX_DRIVE];
										// hCu
	TCHAR m_szDir[_MAX_DIR];
										// fBNg
	TCHAR m_szFile[_MAX_FNAME];
										// t@C
	TCHAR m_szExt[_MAX_EXT];
										// gq
	BOOL m_bUpdate;
										// Z[u̍XV
	FILETIME m_SavedTime;
										// Z[u̓t
	FILETIME m_CurrentTime;
										// ݂̓t
	static LPCTSTR SystemFile[];
										// VXet@C
	static char ShortName[_MAX_FNAME + _MAX_DIR];
										// V[g(char)
	static TCHAR FileExt[_MAX_FNAME + _MAX_DIR];
										// V[g(TCHAR)
	static TCHAR DefaultDir[_MAX_PATH];
										// ftHgfBNg
};

#endif	// _WIN32
#endif	// filepath_h
