//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ OtBbNVRAM ]
//
//---------------------------------------------------------------------------

#if !defined(gvram_h)
#define gvram_h

#include "device.h"
#include "crtc.h"

//===========================================================================
//
//	OtBbNVRAMnh
//
//===========================================================================
class GVRAMHandler
{
public:
	GVRAMHandler(Render *rend, BYTE *mem, CPU *p);
										// RXgN^
	virtual DWORD FASTCALL ReadByte(DWORD addr) = 0;
										// oCgǂݍ
	virtual DWORD FASTCALL ReadWord(DWORD addr) = 0;
										// [hǂݍ
	virtual void FASTCALL WriteByte(DWORD addr, DWORD data) = 0;
										// oCg
	virtual void FASTCALL WriteWord(DWORD addr, DWORD data) = 0;
										// [h
	virtual DWORD FASTCALL ReadOnly(DWORD addr) const = 0;
										// ǂݍ݂̂

protected:
	Render *render;
										// _
	BYTE *gvram;
										// OtBbNVRAM
	CPU *cpu;
										// CPU
};

//===========================================================================
//
//	OtBbNVRAMnh(1024)
//
//===========================================================================
class GVRAM1024 : public GVRAMHandler
{
public:
	GVRAM1024(Render *render, BYTE *gvram, CPU *p);
										// RXgN^
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂
};

//===========================================================================
//
//	OtBbNVRAMnh(16F)
//
//===========================================================================
class GVRAM16 : public GVRAMHandler
{
public:
	GVRAM16(Render *render, BYTE *gvram, CPU *p);
										// RXgN^
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂
};

//===========================================================================
//
//	OtBbNVRAMnh(256F)
//
//===========================================================================
class GVRAM256 : public GVRAMHandler
{
public:
	GVRAM256(Render *render, BYTE *gvram, CPU *p);
										// RXgN^
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂
};

//===========================================================================
//
//	OtBbNVRAMnh()
//
//===========================================================================
class GVRAMNDef : public GVRAMHandler
{
public:
	GVRAMNDef(Render *render, BYTE *gvram, CPU *p);
										// RXgN^
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂
};

//===========================================================================
//
//	OtBbNVRAMnh(65536F)
//
//===========================================================================
class GVRAM64K : public GVRAMHandler
{
public:
	GVRAM64K(Render *render, BYTE *gvram, CPU *p);
										// RXgN^
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂
};

//===========================================================================
//
//	OtBbNVRAM
//
//===========================================================================
class GVRAM : public MemDevice
{
public:
	// [N`
	typedef struct {
		BOOL mem;						// 512KBPtO
		DWORD siz;						// 1024~1024tO
		DWORD col;						// 16, 256, `, 65536
		int type;						// nh^Cv(0`4)
		DWORD mask[4];					// NA }XN
		BOOL plane[4];					// NA v[
	} gvram_t;

public:
	// {t@NV
	GVRAM(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp
#if !defined(NDEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// NDEBUG

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL SetType(DWORD type);
										// GVRAM^Cvݒ
	void FASTCALL FastSet(DWORD mask);
										// NAݒ
	void FASTCALL FastClr(const CRTC::crtc_t *p);
										// NA
	const BYTE* FASTCALL GetGVRAM() const;
										// GVRAM擾

private:
	void FASTCALL FastClr768(const CRTC::crtc_t *p);
										// NA 1024x1024 512/768
	void FASTCALL FastClr256(const CRTC::crtc_t *p);
										// NA 1024x1024 256
	void FASTCALL FastClr512(const CRTC::crtc_t *p);
										// NA 512x512
	Render *render;
										// _
	BYTE *gvram;
										// OtBbNVRAM
	GVRAMHandler *handler;
										// nh(Jg)
	GVRAM1024 *hand1024;
										// nh(1024)
	GVRAM16 *hand16;
										// nh(16F)
	GVRAM256 *hand256;
										// nh(256F)
	GVRAMNDef *handNDef;
										// nh()
	GVRAM64K *hand64K;
										// nh(64KF)
	gvram_t gvdata;
										// [N
	DWORD gvcount;
										// GVRAMANZXJEg(version2.04ȍ~)
};

#endif	// gvram_h
