//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ I/ORg[(IOSC-2) ]
//
//---------------------------------------------------------------------------

#include "os.h"
#include "xm6.h"
#include "cpu.h"
#include "vm.h"
#include "log.h"
#include "fileio.h"
#include "schedule.h"
#include "printer.h"
#include "iosc.h"

//===========================================================================
//
//	IOSC
//
//===========================================================================
//#define IOSC_LOG

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
IOSC::IOSC(VM *p) : MemDevice(p)
{
	// foCXID
	dev.id = MAKEID('I', 'O', 'S', 'C');
	dev.desc = "I/O Ctrl (IOSC-2)";

	// JnAhXAIAhX
	memdev.first = 0xe9c000;
	memdev.last = 0xe9dfff;

	// ̑
	printer = NULL;
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL IOSC::Init()
{
	ASSERT(this);

	// {NX
	if (!MemDevice::Init()) {
		return FALSE;
	}

	// v^擾
	printer = (Printer*)vm->SearchDevice(MAKEID('P', 'R', 'N', ' '));
	ASSERT(printer);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL IOSC::Cleanup()
{
	ASSERT(this);

	// {NX
	MemDevice::Cleanup();
}

//---------------------------------------------------------------------------
//
//	Zbg
//
//---------------------------------------------------------------------------
void FASTCALL IOSC::Reset()
{
	LOG0(Log::Normal, "Zbg");

	// [N
	iosc.prt_int = FALSE;
	iosc.prt_en = FALSE;
	iosc.fdd_int = FALSE;
	iosc.fdd_en = FALSE;
	iosc.fdc_int = FALSE;
	iosc.fdc_en = FALSE;
	iosc.hdc_int = FALSE;
	iosc.hdc_en = FALSE;
	iosc.vbase = 0;

	// ṽxN^Ȃ
	iosc.vector = -1;
}

//---------------------------------------------------------------------------
//
//	Z[u
//
//---------------------------------------------------------------------------
BOOL FASTCALL IOSC::Save(Fileio *fio, int /*ver*/)
{
	size_t sz;

	ASSERT(this);
	ASSERT(fio);
	LOG0(Log::Normal, "Z[u");

	// TCYZ[u
	sz = sizeof(iosc_t);
	if (!fio->Write(&sz, sizeof(sz))) {
		return FALSE;
	}

	// ̂Z[u
	if (!fio->Write(&iosc, sizeof(iosc))) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
BOOL FASTCALL IOSC::Load(Fileio *fio, int /*ver*/)
{
	size_t sz;

	ASSERT(this);
	ASSERT(fio);
	LOG0(Log::Normal, "[h");

	// TCY[hAƍ
	if (!fio->Read(&sz, sizeof(sz))) {
		return FALSE;
	}
	if (sz != sizeof(iosc_t)) {
		return FALSE;
	}

	// ̂[h
	if (!fio->Read(&iosc, sizeof(iosc))) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL IOSC::ApplyCfg(const Config* /*config*/)
{
	ASSERT(this);
	LOG0(Log::Normal, "ݒKp");
}

//---------------------------------------------------------------------------
//
//	oCgǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL IOSC::ReadByte(DWORD addr)
{
	DWORD data;

	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));

	// 16oCgPʂŃ[v
	addr &= 0x0f;

	// AhX̂݃fR[hĂ
	if ((addr & 1) != 0) {

		// EFCg
		scheduler->Wait(2);

		// $E9C001 荞݃Xe[^X
		if (addr == 1) {
			data = 0;
			if (iosc.fdc_int) {
				data |= 0x80;
			}
			if (iosc.fdd_int) {
				data |= 0x40;
			}
			if (iosc.hdc_int) {
				data |= 0x10;
			}
			if (iosc.hdc_en) {
				data |= 0x08;
			}
			if (iosc.fdc_en) {
				data |= 0x04;
			}
			if (iosc.fdd_en) {
				data |= 0x02;
			}
			if (iosc.prt_en) {
				data |= 0x01;
			}

			// v^READY̕\
			if (printer->IsReady()) {
				data |= 0x20;
			}

			// v^荞݂͂̎_ō~낷
			if (iosc.prt_int) {
				iosc.prt_int = FALSE;
				IntChk();
			}
			return data;
		}

		// $E9C003 荞݃xN^
		if (addr == 3) {
			return 0xff;
		}

		LOG1(Log::Warning, "WX^ǂݍ $%06X", memdev.first + addr);
		return 0xff;
	}

	// oXG[͔Ȃ
	return 0xff;
}

//---------------------------------------------------------------------------
//
//	[hǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL IOSC::ReadWord(DWORD addr)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));
	ASSERT((addr & 1) == 0);

	return (0xff00 | ReadByte(addr + 1));
}

//---------------------------------------------------------------------------
//
//	oCg
//
//---------------------------------------------------------------------------
void FASTCALL IOSC::WriteByte(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));
	ASSERT(data < 0x100);

	// 16oCgPʂŃ[v
	addr &= 0x0f;

	// AhX̂݃fR[hĂ
	if ((addr & 1) != 0) {

		// EFCg
		scheduler->Wait(2);

		// $E9C001 荞݃}XN
		if (addr == 1) {
			if (data & 0x01) {
				iosc.prt_en = TRUE;
			}
			else {
				iosc.prt_en = FALSE;
			}
			if (data & 0x02) {
				iosc.fdd_en = TRUE;
			}
			else {
				iosc.fdd_en = FALSE;
			}
			if (data & 0x04) {
				iosc.fdc_en = TRUE;
			}
			else {
				iosc.fdc_en = FALSE;
			}
			if (data & 0x08) {
				iosc.hdc_en = TRUE;
			}
			else {
				iosc.hdc_en = FALSE;
			}

			// 荞݃`FbN(FORMULA 68K)
			IntChk();
			return;
		}

		// $E9C003 荞݃xN^
		if (addr == 3) {
			data &= 0xfc;
			iosc.vbase &= 0x03;
			iosc.vbase |= data;

			LOG1(Log::Detail, "荞݃xN^x[X $%02X", iosc.vbase);
			return;
		}

		// `
		LOG2(Log::Warning, "WX^ $%06X <- $%02X",
										memdev.first + addr, data);
		return;
	}
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
void FASTCALL IOSC::WriteWord(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));
	ASSERT((addr & 1) == 0);
	ASSERT(data < 0x10000);

	WriteByte(addr + 1, (BYTE)data);
}

//---------------------------------------------------------------------------
//
//	ǂݍ݂̂
//
//---------------------------------------------------------------------------
DWORD FASTCALL IOSC::ReadOnly(DWORD addr) const
{
	DWORD data;

	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));

	// 16oCgPʂŃ[v
	addr &= 0x0f;

	// AhX̂݃fR[hĂ
	if ((addr & 1) != 0) {

		// $E9C001 荞݃Xe[^X
		if (addr == 1) {
			data = 0;
			if (iosc.fdc_int) {
				data |= 0x80;
			}
			if (iosc.fdd_int) {
				data |= 0x40;
			}
			if (iosc.prt_int) {
				data |= 0x20;
			}
			if (iosc.hdc_int) {
				data |= 0x10;
			}
			if (iosc.hdc_en) {
				data |= 0x08;
			}
			if (iosc.fdc_en) {
				data |= 0x04;
			}
			if (iosc.fdd_en) {
				data |= 0x02;
			}
			if (iosc.prt_en) {
				data |= 0x01;
			}
			return data;
		}

		// $E9C003 荞݃xN^
		if (addr == 3) {
			return 0xff;
		}

		// `AhX
		return 0xff;
	}

	// AhX
	return 0xff;
}

//---------------------------------------------------------------------------
//
//	f[^擾
//
//---------------------------------------------------------------------------
void FASTCALL IOSC::GetIOSC(iosc_t *buffer) const
{
	ASSERT(this);
	ASSERT(buffer);

	// [NRs[
	*buffer = iosc;
}

//---------------------------------------------------------------------------
//
//	荞݃`FbN
//
//---------------------------------------------------------------------------
void FASTCALL IOSC::IntChk()
{
	int v;

	ASSERT(this);

	// 荞ݖ
	v = -1;

	// v^荞
	if (iosc.prt_int && iosc.prt_en) {
		v = iosc.vbase + 3;
	}

	// HDC荞
	if (iosc.hdc_int && iosc.hdc_en) {
		v = iosc.vbase + 2;
	}

	// FDD荞
	if (iosc.fdd_int && iosc.fdd_en) {
		v = iosc.vbase + 1;
	}

	// FDC荞
	if (iosc.fdc_int && iosc.fdc_en) {
		v = iosc.vbase;
	}

	// v荞݂Ȃꍇ
	if (v < 0) {
		// 荞ݗvłȂ΁AOK
		if (iosc.vector < 0) {
			return;
		}

		// 炩̊荞݂vĂ̂ŁA荞݃LZ
#if defined(IOSC_LOG)
		LOG1(Log::Normal, "荞݃LZ xN^$%02X", iosc.vector);
#endif	// IOSC_LOG
		cpu->IntCancel(1);
		iosc.vector = -1;
		return;
	}

	// ɗvĂxN^Ɠł΁AOK
	if (iosc.vector == v) {
		return;
	}

	// Ⴄ̂ŁAvȂxLZ
	if (iosc.vector >= 0) {
#if defined(IOSC_LOG)
		LOG1(Log::Normal, "荞݃LZ xN^$%02X", iosc.vector);
#endif	// IOSC_LOG
		cpu->IntCancel(1);
		iosc.vector = -1;
	}

	// 荞ݗv
#if defined(IOSC_LOG)
	LOG1(Log::Normal, "荞ݗv xN^$%02X", v);
#endif	// IOSC_LOG
	cpu->Interrupt(1, (BYTE)v);

	// L
	iosc.vector = v;
}

//---------------------------------------------------------------------------
//
//	荞݉
//
//---------------------------------------------------------------------------
void FASTCALL IOSC::IntAck()
{
	ASSERT(this);

	// ZbgɁACPU犄荞݂Ԉēꍇ
	// ܂͑̃foCX
	if (iosc.vector < 0) {
#if defined(IOSC_LOG)
		LOG0(Log::Warning, "vĂȂ荞");
#endif	// IOSC_LOG
		return;
	}

#if defined(IOSC_LOG)
	LOG1(Log::Normal, "荞ACK xN^$%02X", iosc.vector);
#endif	// IOSC_LOG

	// 荞݂Ȃ
	iosc.vector = -1;
}

//---------------------------------------------------------------------------
//
//	FDC荞
//
//---------------------------------------------------------------------------
void FASTCALL IOSC::IntFDC(BOOL flag)
{
	ASSERT(this);

	iosc.fdc_int = flag;

	// 荞݃`FbN
	IntChk();
}

//---------------------------------------------------------------------------
//
//	FDD荞
//
//---------------------------------------------------------------------------
void FASTCALL IOSC::IntFDD(BOOL flag)
{
	ASSERT(this);

	iosc.fdd_int = flag;

	// 荞݃`FbN
	IntChk();
}

//---------------------------------------------------------------------------
//
//	HDC荞
//
//---------------------------------------------------------------------------
void FASTCALL IOSC::IntHDC(BOOL flag)
{
	ASSERT(this);

	iosc.hdc_int = flag;

	// 荞݃`FbN
	IntChk();
}

//---------------------------------------------------------------------------
//
//	v^荞
//
//---------------------------------------------------------------------------
void FASTCALL IOSC::IntPRT(BOOL flag)
{
	ASSERT(this);

	iosc.prt_int = flag;

	// 荞݃`FbN
	IntChk();
}
