//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2004 ohD(ytanaka@ipc-tokai.or.jp)
//	[ I/ORg[(IOSC-2) ]
//
//---------------------------------------------------------------------------

#if !defined(iosc_h)
#define iosc_h

#include "device.h"

//===========================================================================
//
//	I/ORg[
//
//===========================================================================
class IOSC : public MemDevice
{
public:
	// f[^`
	typedef struct {
		BOOL prt_int;					// v^荞ݗv
		BOOL prt_en;					// v^荞݋
		BOOL fdd_int;					// FDD荞ݗv
		BOOL fdd_en;					// FDD荞݋
		BOOL fdc_int;					// FDC荞ݗv
		BOOL fdc_en;					// FDC荞݋
		BOOL hdc_int;					// HDD荞ݗv
		BOOL hdc_en;					// HDD荞݋
		DWORD vbase;					// xN^x[X
		int vector;						// v̊荞݃xN^
	} iosc_t;

public:
	// {t@NV
	IOSC(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL GetIOSC(iosc_t *buffer) const;
										// f[^擾
	DWORD FASTCALL GetVector() const	{ return iosc.vbase; }
										// xN^x[X擾
	void FASTCALL IntAck();
										// 荞݉
	void FASTCALL IntFDC(BOOL flag);
										// FDC荞
	void FASTCALL IntFDD(BOOL flag);
										// FDD荞
	void FASTCALL IntHDC(BOOL flag);
										// HDC荞
	void FASTCALL IntPRT(BOOL flag);
										// v^荞

private:
	void FASTCALL IntChk();
										// 荞݃`FbN
	iosc_t iosc;
										// f[^
	Printer *printer;
										// v^
};

#endif	// iosc_h
