//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2004 ohD(ytanaka@ipc-tokai.or.jp)
//	[ L[{[h ]
//
//---------------------------------------------------------------------------

#if !defined(keyboard_h)
#define keyboard_h

#include "device.h"
#include "event.h"
#include "sync.h"

//===========================================================================
//
//	L[{[h
//
//===========================================================================
class Keyboard : public Device
{
public:
	// f[^`
	typedef struct {
		BOOL connect;					// ڑtO
		BOOL status[0x80];				// Xe[^X
		DWORD rep_code;					// s[gR[h
		DWORD rep_count;				// s[gJE^
		DWORD rep_start;				// s[g(husP)
		DWORD rep_next;					// s[g(husP)
		BOOL send_en;					// L[f[^M
		BOOL send_wait;					// L[f[^M~
		DWORD msctrl;					// }EXM
		BOOL tv_mode;					// X68000er[h
		BOOL tv_ctrl;					// R}hɂerRg[
		BOOL opt2_ctrl;					// OPT2ɂerRg[
		DWORD bright;					// L[邳
		DWORD led;						// L[LED(1œ_)
		DWORD cmdbuf[0x10];				// R}hobt@
		DWORD cmdread;					// R}h[h|C^
		DWORD cmdwrite;					// R}hCg|C^
		DWORD cmdnum;					// R}h
	} keyboard_t;

public:
	// {t@NV
	Keyboard(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// OAPI
	void FASTCALL Connect(BOOL connect);
										// ڑ
	BOOL FASTCALL IsConnect() const		{ return keyboard.connect; }
										// ڑ`FbN
	BOOL FASTCALL Callback(Event *ev);
										// CxgR[obN
	void FASTCALL MakeKey(DWORD code);
										// CN
	void FASTCALL BreakKey(DWORD code);
										// u[N
	void FASTCALL Command(DWORD data);
										// R}h
	BOOL FASTCALL GetCommand(DWORD& data);
										// R}h擾
	void FASTCALL ClrCommand();
										// R}hNA
	void FASTCALL SendWait(BOOL flag);
										// L[f[^MEFCg
	BOOL FASTCALL IsSendWait() const	{ return keyboard.send_wait; }
										// L[f[^MEFCg擾
	void FASTCALL GetKeyboard(keyboard_t *buffer) const;
										// f[^擾

private:
	MFP *mfp;
										// MFP
	Mouse *mouse;
										// }EX
	keyboard_t keyboard;
										// f[^
	Event event;
										// Cxg
	Sync *sync;
										// R}hSync
};

#endif	// keyboard_h
