//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ O ]
//
//---------------------------------------------------------------------------

#include "os.h"
#include "xm6.h"
#include "sync.h"
#include "log.h"
#include "device.h"
#include "vm.h"
#include "cpu.h"
#include "schedule.h"

//===========================================================================
//
//	O
//
//===========================================================================
//#define LOG_WIN32

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
Log::Log()
{
	// Ǘ[NNA
	logtop = 0;
	lognum = 0;
	memset(logdata, 0, sizeof(logdata));
	logcount = 1;

	// foCXȂ
	cpu = NULL;
	scheduler = NULL;
	sync = NULL;
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL Log::Init(VM *vm)
{
	ASSERT(this);
	ASSERT(vm);

	// CPU擾
	ASSERT(!cpu);
	cpu = (CPU *)vm->SearchDevice(MAKEID('C', 'P', 'U', ' '));
	ASSERT(cpu);

	// XPW[擾
	ASSERT(!scheduler);
	scheduler = (Scheduler *)vm->SearchDevice(MAKEID('S', 'C', 'H', 'E'));
	ASSERT(scheduler);

	// IuWFNg쐬
	ASSERT(!sync);
	sync = new Sync;
	ASSERT(sync);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL Log::Cleanup()
{
	ASSERT(this);

	// f[^SăNA(Init̂)
	if (sync) {
		Clear();
	}

	// IuWFNg폜
	if (sync) {
		delete sync;
		sync = NULL;
	}
}

//---------------------------------------------------------------------------
//
//	Zbg
//
//---------------------------------------------------------------------------
void FASTCALL Log::Reset()
{
	ASSERT(this);
	ASSERT_DIAG();

	// f[^SăNA
	Clear();
}

#if !defined(NDEBUG)
//---------------------------------------------------------------------------
//
//	ff
//
//---------------------------------------------------------------------------
void FASTCALL Log::AssertDiag() const
{
	ASSERT(this);
	ASSERT(cpu);
	ASSERT(cpu->GetID() == MAKEID('C', 'P', 'U', ' '));
	ASSERT(scheduler);
	ASSERT(scheduler->GetID() == MAKEID('S', 'C', 'H', 'E'));
	ASSERT(sync);
	ASSERT((logtop >= 0) && (logtop < LogMax));
	ASSERT((lognum >= 0) && (lognum <= LogMax));
	ASSERT(logcount >= 1);
}
#endif	// NDEBUG

//---------------------------------------------------------------------------
//
//	NA
//
//---------------------------------------------------------------------------
void FASTCALL Log::Clear()
{
	int i;
	int index;

	ASSERT(this);

	// bN
	sync->Lock();

	index = logtop;
	for (i=0; i<lognum; i++) {
		// f[^
		if (logdata[index]) {
			// |C^
			delete[] logdata[index]->string;

			// f[^{̂
			delete logdata[index];

			// NULL
			logdata[index] = NULL;
		}

		// CfbNXړ
		index++;
		index &= (LogMax - 1);
	}

	// Ǘ[NNA
	logtop = 0;
	lognum = 0;
	logcount = 1;

	// AbN
	sync->Unlock();
}

//---------------------------------------------------------------------------
//
//	tH[}bg(...)
//
//---------------------------------------------------------------------------
void Log::Format(loglevel level, const Device *device, char *format, ...)
{
	char buffer[0x200];
	va_list args;
	va_start(args, format);

	ASSERT(this);
	ASSERT(device);
	ASSERT_DIAG();

	// tH[}bg
	vsprintf(buffer, format, args);

	// ϒI
	va_end(args);

	// bZ[Wǉ
	AddString(device->GetID(), level, buffer);
}

//---------------------------------------------------------------------------
//
//	tH[}bg(va)
//
//---------------------------------------------------------------------------
void Log::vFormat(loglevel level, const Device *device, char *format, va_list args)
{
	char buffer[0x200];

	ASSERT(this);
	ASSERT(device);
	ASSERT_DIAG();

	// tH[}bg
	vsprintf(buffer, format, args);

	// bZ[Wǉ
	AddString(device->GetID(), level, buffer);
}

//---------------------------------------------------------------------------
//
//	f[^ǉ
//
//---------------------------------------------------------------------------
void FASTCALL Log::AddString(DWORD id, loglevel level, char *string)
{
	int index;

	ASSERT(this);
	ASSERT(string);
	ASSERT_DIAG();

	// bN
	sync->Lock();

	// ǉʒu߂
	if (lognum < LogMax) {
		ASSERT(logtop == 0);
		index = lognum;
		ASSERT(logdata[index] == NULL);
		lognum++;
	}
	else {
		ASSERT(lognum == LogMax);
		index = logtop;
		logtop++;
		logtop &= (LogMax - 1);
	}

	// ɑ݂Ή
	if (logdata[index]) {
		delete[] logdata[index]->string;
		delete logdata[index];
	}

	// \̂zu
	logdata[index] = new logdata_t;
	logdata[index]->number = logcount++;
	logdata[index]->time = 0;
	logdata[index]->time = scheduler->GetTotalTime();
	logdata[index]->pc = cpu->GetPC();
	logdata[index]->id = id;
	logdata[index]->level = level;

	// 񏈗
	logdata[index]->string = new char[strlen(string) + 1];
	strcpy(logdata[index]->string, string);

#if defined(LOG_WIN32)
	// Win32bZ[WƂďo
	OutputDebugString(string);
	OutputDebugString(_T("\n"));
#endif	// LOG_WIN32

	// AbN
	sync->Unlock();

	// OAIɈxNA(16ڈƂ)
	if (logcount >= 0x60000000) {
		Clear();
	}
}

//---------------------------------------------------------------------------
//
//	f[^擾
//
//---------------------------------------------------------------------------
int FASTCALL Log::GetNum() const
{
	ASSERT(this);
	ASSERT_DIAG();

	return lognum;
}

//---------------------------------------------------------------------------
//
//	OőL^擾
//
//---------------------------------------------------------------------------
int FASTCALL Log::GetMax() const
{
	ASSERT(this);
	ASSERT_DIAG();

	return LogMax;
}

//---------------------------------------------------------------------------
//
//	f[^擾
//
//---------------------------------------------------------------------------
BOOL FASTCALL Log::GetData(int index, logdata_t *ptr)
{
	char *string;

	ASSERT(this);
	ASSERT(index >= 0);
	ASSERT(ptr);
	ASSERT_DIAG();

	// bN
	sync->Lock();

	// ݃`FbN
	if (index >= lognum) {
		sync->Unlock();
		return FALSE;
	}

	// CfbNXZo
	index += logtop;
	index &= (LogMax - 1);

	// Rs[(|C^ȊO)
	ASSERT(logdata[index]);
	*ptr = *logdata[index];

	// Rs[(|C^)
	string = ptr->string;
	ptr->string = new char[strlen(string) + 1];
	strcpy(ptr->string, string);

	// AbN
	sync->Unlock();
	return TRUE;
}
