//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ O ]
//
//---------------------------------------------------------------------------

#if !defined(log_h)
#define log_h

//===========================================================================
//
//	O
//
//===========================================================================
class Log
{
public:
	enum loglevel {
		Detail,							// ڍ׃x
		Normal,							// ʏ탌x
		Warning							// xx
	};
	typedef struct {
		DWORD number;					// ʂԍ(ZbgŃNA)
		DWORD total;					// ʂԍ(ݐ)
		DWORD time;						// z
		DWORD id;						// foCXID
		DWORD pc;						// vOJE^
		loglevel level;					// x
		char *string;					// 
	} logdata_t;

public:
	// {t@NV
	Log();
										// RXgN^
	BOOL FASTCALL Init(VM *vm);
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
#if !defined(NDEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// NDEBUG

	// o
	void Format(loglevel level, const Device *dev, char *format, ...);
										// Oo(...)
	void vFormat(loglevel level, const Device *dev, char *format, va_list args);
										// Oo(va)
	void FASTCALL AddString(DWORD id, loglevel level, char *string);
										// Of[^ǉ

	// 擾
	int FASTCALL GetNum() const;
										// Oڐ擾
	int FASTCALL GetMax() const;
										// OőL^擾
	BOOL FASTCALL GetData(int index, logdata_t *ptr);
										// Of[^擾

private:
	enum {
		LogMax = 0x4000					// OőL^(2̔{ł邱)
	};

private:
	void FASTCALL Clear();
										// f[^NA
	int logtop;
										// 擪|C^(łÂ)
	int lognum;
										// OL^
	int logcount;
										// OJEg
	logdata_t *logdata[LogMax];
										// O|C^
	Sync *sync;
										// IuWFNg
	CPU *cpu;
										// CPU
	Scheduler *scheduler;
										// XPW[
};

//---------------------------------------------------------------------------
//
//	Oo̓}N
//
//---------------------------------------------------------------------------
#if !defined(NO_LOG)
class LogProxy {
public:
	// RXgN^
	LogProxy(const Device* device, Log* log)
	{
		m_device = device;
		m_log = log;
	}

	// Oo
	void operator()(enum Log::loglevel level, char* format, ...) const
	{
		va_list args;
		va_start(args, format);
		m_log->vFormat(level, m_device, format, args);
		va_end(args);
	}
private:
	const Device* m_device;
	Log* m_log;
};
#define LOG						LogProxy(this, GetLog())
#define LOG0(l, s)			  	GetLog()->Format(l, this, s)
#define LOG1(l, s, a)		  	GetLog()->Format(l, this, s, a)
#define LOG2(l, s, a, b)	  	GetLog()->Format(l, this, s, a, b)
#define LOG3(l, s, a, b, c)   	GetLog()->Format(l, this, s, a, b, c)
#define LOG4(l, s, a, b, c, d)	GetLog()->Format(l, this, s, a, b, c, d)
#else
#define LOG						LOG_NONE
#define LOG0(l, s)				((void)0)
#define LOG1(l, s, a)			((void)0)
#define LOG2(l, s, a, b)		((void)0)
#define LOG3(l, s, a, b, c)	  	((void)0)
#define LOG4(l, s, a, b, c, d)	((void)0)
static inline LOG_NONE(enum Log::loglevel level, char *format, ...) {}
#endif	// !NO_LOG

#endif	// log_h
