//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[  ]
//
//---------------------------------------------------------------------------

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "log.h"
#include "filepath.h"
#include "fileio.h"
#include "cpu.h"
#include "areaset.h"
#include "gvram.h"
#include "tvram.h"
#include "sram.h"
#include "config.h"
#include "core_asm.h"
#include "memory.h"

//---------------------------------------------------------------------------
//
//	X^eBbN [N
//
//---------------------------------------------------------------------------
static CPU *pCPU;

//---------------------------------------------------------------------------
//
//	oXG[Č(CGÂ)
//
//---------------------------------------------------------------------------
extern "C" {

//---------------------------------------------------------------------------
//
//	ǂݍ݃oXG[
//
//---------------------------------------------------------------------------
void ReadBusErr(DWORD addr)
{
	pCPU->BusErr(addr, TRUE);
}

//---------------------------------------------------------------------------
//
//	݃oXG[
//
//---------------------------------------------------------------------------
void WriteBusErr(DWORD addr)
{
	pCPU->BusErr(addr, FALSE);
}
}

//===========================================================================
//
//	
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
Memory::Memory(VM *p) : MemDevice(p)
{
	// foCXID
	dev.id = MAKEID('M', 'E', 'M', ' ');
	dev.desc = "Memory Ctrl (OHM2)";

	// JnAhXAIAhX
	memdev.first = 0;
	memdev.last = 0xffffff;

	// RAM/ROMobt@
	mem.ram = NULL;
	mem.ipl = NULL;
	mem.cg = NULL;
	mem.scsi = NULL;

	// RAM2MB
	mem.size = 2;
	mem.config = 0;
	mem.length = 0;

	// ^Cv͖[h
	mem.type = None;
	mem.now = None;

	// IuWFNg
	areaset = NULL;
	sram = NULL;

	// ̑
	memset(mem.table, 0, sizeof(mem.table));
	mem.memsw = TRUE;

	// static[N
	::pCPU = NULL;
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL Memory::Init()
{
	ASSERT(this);

	// {NX
	if (!MemDevice::Init()) {
		return FALSE;
	}

	// C
	mem.length = mem.size * 0x100000;
	try {
		mem.ram = new BYTE[ mem.length ];
	}
	catch (...) {
		return FALSE;
	}
	if (!mem.ram) {
		return FALSE;
	}

	// C[NA
	memset(mem.ram, 0x00, mem.length);

	// IPL ROM
	try {
		mem.ipl = new BYTE[ 0x20000 ];
	}
	catch (...) {
		return FALSE;
	}
	if (!mem.ipl) {
		return FALSE;
	}

	// CG ROM
	try {
		mem.cg = new BYTE[ 0xc0000 ];
	}
	catch (...) {
		return FALSE;
	}
	if (!mem.cg) {
		return FALSE;
	}

	// SCSI ROM
	try {
		mem.scsi = new BYTE[ 0x20000 ];
	}
	catch (...) {
		return FALSE;
	}
	if (!mem.scsi) {
		return FALSE;
	}

	// SASIROM͕K{Ȃ̂ŁAɃ[h
	if (!LoadROM(SASI)) {
		// IPLROM.DAT, CGROM.DAT݂Ȃp^[
		return FALSE;
	}

	// ROM΁AXVICompact030̏ŁAɌ̂D悷
	if (LoadROM(XVI)) {
		mem.now = XVI;
	}
	if (mem.type == None) {
		if (LoadROM(Compact)) {
			mem.now = Compact;
		}
	}
	if (mem.type == None) {
		if (LoadROM(X68030)) {
			mem.now = X68030;
		}
	}

	// XVI,Compact,030݂Ȃ΁AēxSASIǂ
	if (mem.type == None) {
		LoadROM(SASI);
		mem.now = SASI;
	}

	// [WGAݒ
	::s68000context.u_fetch = u_pgr;
	::s68000context.s_fetch = s_pgr;
	::s68000context.u_readbyte = u_rbr;
	::s68000context.s_readbyte = s_rbr;
	::s68000context.u_readword = u_rwr;
	::s68000context.s_readword = s_rwr;
	::s68000context.u_writebyte = u_wbr;
	::s68000context.s_writebyte = s_wbr;
	::s68000context.u_writeword = u_wwr;
	::s68000context.s_writeword = s_wwr;

	// GAZbg擾
	areaset = (AreaSet*)vm->SearchDevice(MAKEID('A', 'R', 'E', 'A'));
	ASSERT(areaset);

	// SRAM擾
	sram = (SRAM*)vm->SearchDevice(MAKEID('S', 'R', 'A', 'M'));
	ASSERT(sram);

	// static[N
	::pCPU = cpu;

	// e[uݒ
	InitTable();

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	ROM[h
//
//---------------------------------------------------------------------------
BOOL FASTCALL Memory::LoadROM(memtype target)
{
	Filepath path;
	Fileio fio;
	int i;
	BYTE data;
	BYTE *ptr;
	BOOL scsi_req;
	int scsi_size;

	ASSERT(this);

	// UׂĂROMGAANone
	memset(mem.ipl, 0xff, 0x20000);
	memset(mem.cg, 0xff, 0xc0000);
	memset(mem.scsi, 0xff, 0x20000);
	mem.type = None;

	// IPL
	switch (target) {
		case SASI:
		case SCSIInt:
		case SCSIExt:
			path.SysFile(Filepath::IPL);
			break;
		case XVI:
			path.SysFile(Filepath::IPLXVI);
			break;
		case Compact:
			path.SysFile(Filepath::IPLCompact);
			break;
		case X68030:
			path.SysFile(Filepath::IPL030);
			break;
		default:
			ASSERT(FALSE);
			return FALSE;
	}
	if (!fio.Load(path, mem.ipl, 0x20000)) {
		return FALSE;
	}

	// IPLoCgXbv
	ptr = mem.ipl;
	for (i=0; i<0x10000; i++) {
		data = ptr[0];
		ptr[0] = ptr[1];
		ptr[1] = data;
		ptr += 2;
	}

	// CG
	path.SysFile(Filepath::CG);
	if (!fio.Load(path, mem.cg, 0xc0000)) {
		// t@CȂ΁ACGTMPŃgC
		path.SysFile(Filepath::CGTMP);
		if (!fio.Load(path, mem.cg, 0xc0000)) {
			return FALSE;
		}
	}

	// CGoCgXbv
	ptr = mem.cg;
	for (i=0; i<0x60000; i++) {
		data = ptr[0];
		ptr[0] = ptr[1];
		ptr[1] = data;
		ptr += 2;
	}

	// SCSI
	scsi_req = FALSE;
	switch (target) {
		// 
		case SCSIInt:
		case XVI:
		case Compact:
			path.SysFile(Filepath::SCSIInt);
			scsi_req = TRUE;
			break;
		case X68030:
			path.SysFile(Filepath::ROM030);
			scsi_req = TRUE;
			break;
		// Ot
		case SCSIExt:
			path.SysFile(Filepath::SCSIExt);
			scsi_req = TRUE;
			break;
		// SASI(ROMKvȂ)
		case SASI:
			break;
		// ̑(蓾Ȃ)
		default:
			ASSERT(FALSE);
			break;
	}
	if (scsi_req) {
		// X68030̂ROM30.DAT(0x20000oCg)Ȃ0x2000oCgŃgC
		if (target == X68030) {
			scsi_size = 0x20000;
		}
		else {
			scsi_size = 0x2000;
		}

		// Ƀ|C^ݒ
		ptr = mem.scsi;

		// [h
		if (!fio.Load(path, mem.scsi, scsi_size)) {
			// SCSIExt0x1fe0oCg(WinX68kłƌ݊Ƃ)
			if (target != SCSIExt) {
				return FALSE;
			}

			// 0x1fe0oCgōăgC
			scsi_size = 0x1fe0;
			ptr = &mem.scsi[0x20];
			if (!fio.Load(path, &mem.scsi[0x0020], scsi_size)) {
				return FALSE;
			}
		}

		// SCSIoCgXbv
		for (i=0; i<scsi_size; i+=2) {
			data = ptr[0];
			ptr[0] = ptr[1];
			ptr[1] = data;
			ptr += 2;
		}
	}

	// ^[QbgJgɃZbgāA
	mem.type = target;
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	e[u쐬
//	fR[_Ɉˑ
//
//---------------------------------------------------------------------------
void FASTCALL Memory::InitTable()
{
#if defined(_WIN32)
#pragma pack(push, 1)
#endif	// _WIN32
	MemDevice* devarray[0x40];
#if defined(_WIN32)
#pragma pack(pop)
#endif	// _WIN32

	MemDevice *mdev;
	BYTE *table;
	DWORD ptr;
	int i;

	ASSERT(this);

	// |C^
	mdev = this;
	i = 0;

	// Memoryȍ~̃foCXāA|C^zɗƂ
	while (mdev) {
		devarray[i] = mdev;

		// 
		i++;
		mdev = (MemDevice*)mdev->GetNextDevice();
	}

	// AZu[`ĂяoAe[un
	MemInitDecode(this, devarray);

	// AZu[`ŏoe[utɖ߂(ACgɒ)
	table = MemDecodeTable;
	for (i=0; i<0x180; i++) {
		// 4oCgƂDWORDl荞݁A|C^ɃLXg
		ptr = *(DWORD*)table;
		mem.table[i] = (MemDevice*)ptr;

		// 
		table += 4;
	}
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL Memory::Cleanup()
{
	ASSERT(this);

	// 
	if (mem.ram) {
		delete[] mem.ram;
		mem.ram = NULL;
	}
	if (mem.ipl) {
		delete[] mem.ipl;
		mem.ipl = NULL;
	}
	if (mem.cg) {
		delete[] mem.cg;
		mem.cg = NULL;
	}
	if (mem.scsi) {
		delete[] mem.scsi;
		mem.scsi = NULL;
	}

	// {NX
	MemDevice::Cleanup();
}

//---------------------------------------------------------------------------
//
//	Zbg
//
//---------------------------------------------------------------------------
void FASTCALL Memory::Reset()
{
	int size;

	ASSERT(this);
	LOG0(Log::Normal, "Zbg");

	// ^CvvĂ邩
	if (mem.type != mem.now) {
		if (LoadROM(mem.type)) {
			// ROM݂ĂB[hł
			mem.now = mem.type;
		}
		else {
			// ROM݂ȂBSASI^CvƂāAݒSASIɖ߂
			LoadROM(SASI);
			mem.now = SASI;
			mem.type = SASI;
		}

		// ReLXg蒼(CPU::Reset͊Ă邽߁AKFALSE)
		MakeContext(FALSE);
	}

	// TCYvĂ邩
	if (mem.size == ((mem.config + 1) * 2)) {
		// vĂ̂ŁAXCb`XV`FbN
		if (mem.memsw) {
			// $ED0008 : CRAMTCY
			size = mem.size << 4;
			sram->SetMemSw(0x08, 0x00);
			sram->SetMemSw(0x09, size);
			sram->SetMemSw(0x0a, 0x00);
			sram->SetMemSw(0x0b, 0x00);
		}
		return;
	}

	// ύX
	mem.size = (mem.config + 1) * 2;

	// Ċm
	ASSERT(mem.ram);
	delete[] mem.ram;
	mem.ram = NULL;
	mem.length = mem.size * 0x100000;
	try {
		mem.ram = new BYTE[ mem.length ];
	}
	catch (...) {
		// s̏ꍇ2MBɌŒ
		mem.config = 0;
		mem.size = 2;
		mem.length = mem.size * 0x100000;
		mem.ram = new BYTE[ mem.length ];
	}
	if (!mem.ram) {
		// s̏ꍇ2MBɌŒ
		mem.config = 0;
		mem.size = 2;
		mem.length = mem.size * 0x100000;
		mem.ram = new BYTE[ mem.length ];
	}

	// mۂłĂꍇ̂
	if (mem.ram) {
		memset(mem.ram, 0x00, mem.length);

		// ReLXg蒼(CPU::Reset͊Ă邽߁AKFALSE)
		MakeContext(FALSE);
	}

	// XCb`XV
	if (mem.memsw) {
		// $ED0008 : CRAMTCY
		size = mem.size << 4;
		sram->SetMemSw(0x08, 0x00);
		sram->SetMemSw(0x09, size);
		sram->SetMemSw(0x0a, 0x00);
		sram->SetMemSw(0x0b, 0x00);
	}
}

//---------------------------------------------------------------------------
//
//	Z[u
//
//---------------------------------------------------------------------------
BOOL FASTCALL Memory::Save(Fileio *fio, int /*ver*/)
{
	ASSERT(this);
	LOG0(Log::Normal, "Z[u");

	// ^Cv
	if (!fio->Write(&mem.now, sizeof(mem.now))) {
		return FALSE;
	}

	// SCSI ROM̓e (X68030ȊO)
	if (mem.now != X68030) {
		if (!fio->Write(mem.scsi, 0x2000)) {
			return FALSE;
		}
	}

	// mem.size
	if (!fio->Write(&mem.size, sizeof(mem.size))) {
		return FALSE;
	}

	// 
	if (!fio->Write(mem.ram, mem.length)) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
BOOL FASTCALL Memory::Load(Fileio *fio, int /*ver*/)
{
	int size;
	BOOL context;

	ASSERT(this);
	LOG0(Log::Normal, "[h");

	// ReLXg蒼Ȃ
	context = FALSE;

	// ^Cvǂ
	if (!fio->Read(&mem.type, sizeof(mem.type))) {
		return FALSE;
	}

	// ^Cv݂̂̂ƈĂ
	if (mem.type != mem.now) {
		// ROMǂݒ
		if (!LoadROM(mem.type)) {
			// Z[uɑ݂ĂROMAȂȂĂ
			LoadROM(mem.now);
			return FALSE;
		}

		// ROM̓ǂݒɐ
		mem.now = mem.type;
		context = TRUE;
	}

	// SCSI ROM̓eǂ (X68030ȊO)
	if (mem.type != X68030) {
		if (!fio->Read(mem.scsi, 0x2000)) {
			return FALSE;
		}
	}

	// mem.sizeǂ
	if (!fio->Read(&size, sizeof(size))) {
		return FALSE;
	}

	// mem.sizeƈvĂȂ
	if (mem.size != size) {
		// ύX
		mem.size = size;

		// Ċm
		delete[] mem.ram;
		mem.ram = NULL;
		mem.length = mem.size * 0x100000;
		try {
			mem.ram = new BYTE[ mem.length ];
		}
		catch (...) {
			mem.ram = NULL;
		}
		if (!mem.ram) {
			// s̏ꍇ2MBɌŒ
			mem.config = 0;
			mem.size = 2;
			mem.length = mem.size * 0x100000;
			mem.ram = new BYTE[ mem.length ];

			// [hs
			return FALSE;
		}

		// ReLXgč쐬Kv
		context = TRUE;
	}

	// ǂ
	if (!fio->Read(mem.ram, mem.length)) {
		return FALSE;
	}

	// Kvł΁AReLXg蒼
	if (context) {
		MakeContext(FALSE);
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL Memory::ApplyCfg(const Config *config)
{
	ASSERT(this);
	ASSERT(config);
	LOG0(Log::Normal, "ݒKp");

	// (ROM[h͎񃊃Zbg)
	mem.type = (memtype)config->mem_type;

	// RAMTCY(mۂ͎񃊃Zbg)
	mem.config = config->ram_size;
	ASSERT((mem.config >= 0) && (mem.config <= 5));

	// XCb`XV
	mem.memsw = config->ram_sramsync;
}

//---------------------------------------------------------------------------
//
//	oCgǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL Memory::ReadByte(DWORD addr)
{
	DWORD index;

	ASSERT(this);
	ASSERT(addr <= 0xffffff);
	ASSERT(mem.now != None);

	// CRAM
	if (addr < mem.length) {
		return (DWORD)mem.ram[addr ^ 1];
	}

	// IPL
	if (addr >= 0xfe0000) {
		addr &= 0x1ffff;
		addr ^= 1;
		return (DWORD)mem.ipl[addr];
	}

	// IPLC[W or SCSI
	if (addr >= 0xfc0000) {
		// IPLC[W
		if ((mem.now == SASI) || (mem.now == SCSIExt)) {
			// IPLC[W
			addr &= 0x1ffff;
			addr ^= 1;
			return (DWORD)mem.ipl[addr];
		}
		// SCSI(͈̓`FbN)
		if (addr < 0xfc2000) {
			// SCSI
			addr &= 0x1fff;
			addr ^= 1;
			return (DWORD)mem.scsi[addr];
		}
		// X68030 IPLO
		if (mem.now == X68030) {
			// X68030 IPLO
			addr &= 0x1ffff;
			addr ^= 1;
			return (DWORD)mem.scsi[addr];
		}
		// SCSIfŁAROM͈͊O
		return 0xff;
	}

	// CG
	if (addr >= 0xf00000) {
		addr &= 0xfffff;
		addr ^= 1;
		return (DWORD)mem.cg[addr];
	}

	// SCSIOt
	if (mem.now == SCSIExt) {
		if ((addr >= 0xea0020) && (addr <= 0xea1fff)) {
			addr &= 0x1fff;
			addr ^= 1;
			return (DWORD)mem.scsi[addr];
		}
	}

	// foCXfBXpb`
	if (addr >= 0xc00000) {
		index = addr - 0xc00000;
		index >>= 13;
		ASSERT(index < 0x180);
		if (mem.table[index] != (MemDevice*)this) {
			return mem.table[index]->ReadByte(addr);
		}
	}

	LOG1(Log::Warning, "`oCgǂݍ $%06X", addr);
	cpu->BusErr(addr, TRUE);
	return 0xff;
}

//---------------------------------------------------------------------------
//
//	[hǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL Memory::ReadWord(DWORD addr)
{
	DWORD data;
	DWORD index;
	WORD *ptr;

	ASSERT(this);
	ASSERT(addr <= 0xffffff);
	ASSERT(mem.now != None);

	// CPȔꍇ͋ۏ؂Ă邪ADMAC̏ꍇ̓`FbNKv
	if (addr & 1) {
		// UCPU֓n(CPUoRDMA)
		cpu->AddrErr(addr, TRUE);
		return 0xffff;
	}

	// CRAM
	if (addr < mem.length) {
		ptr = (WORD*)(&mem.ram[addr]);
		data = (DWORD)*ptr;
		return data;
	}

	// IPL
	if (addr >= 0xfe0000) {
		addr &= 0x1ffff;
		ptr = (WORD*)(&mem.ipl[addr]);
		data = (DWORD)*ptr;
		return data;
	}

	// IPLC[W or SCSI
	if (addr >= 0xfc0000) {
		// IPLC[W
		if ((mem.now == SASI) || (mem.now == SCSIExt)) {
			// IPLC[W
			addr &= 0x1ffff;
			ptr = (WORD*)(&mem.ipl[addr]);
			data = (DWORD)*ptr;
			return data;
		}
		// SCSI(͈̓`FbN)
		if (addr < 0xfc2000) {
			// SCSI
			addr &= 0x1fff;
			ptr = (WORD*)(&mem.scsi[addr]);
			data = (DWORD)*ptr;
			return data;
		}
		// X68030 IPLO
		if (mem.now == X68030) {
			// X68030 IPLO
			addr &= 0x1ffff;
			ptr = (WORD*)(&mem.scsi[addr]);
			data = (DWORD)*ptr;
			return data;
		}
		// SCSIfŁAROM͈͊O
		return 0xffff;
	}

	// CG
	if (addr >= 0xf00000) {
		addr &= 0xfffff;
		ptr = (WORD*)(&mem.cg[addr]);
		data = (DWORD)*ptr;
		return data;
	}

	// SCSIOt
	if (mem.now == SCSIExt) {
		if ((addr >= 0xea0020) && (addr <= 0xea1fff)) {
			addr &= 0x1fff;
			ptr = (WORD*)(&mem.scsi[addr]);
			data = (DWORD)*ptr;
			return data;
		}
	}

	// foCXfBXpb`
	if (addr >= 0xc00000) {
		index = addr - 0xc00000;
		index >>= 13;
		ASSERT(index < 0x180);
		if (mem.table[index] != (MemDevice*)this) {
			return mem.table[index]->ReadWord(addr);
		}
	}

	// oXG[
	LOG1(Log::Warning, "`[hǂݍ $%06X", addr);
	cpu->BusErr(addr, TRUE);
	return 0xffff;
}

//---------------------------------------------------------------------------
//
//	oCg
//
//---------------------------------------------------------------------------
void FASTCALL Memory::WriteByte(DWORD addr, DWORD data)
{
	DWORD index;

	ASSERT(this);
	ASSERT(addr <= 0xffffff);
	ASSERT(data < 0x100);
	ASSERT(mem.now != None);

	// CRAM
	if (addr < mem.length) {
		mem.ram[addr ^ 1] = (BYTE)data;
		return;
	}

	// IPL,SCSI,CG
	if (addr >= 0xf00000) {
		return;
	}

	// foCXfBXpb`
	if (addr >= 0xc00000) {
		index = addr - 0xc00000;
		index >>= 13;
		ASSERT(index < 0x180);
		if (mem.table[index] != (MemDevice*)this) {
			mem.table[index]->WriteByte(addr, data);
			return;
		}
	}

	// oXG[
	cpu->BusErr(addr, FALSE);
	LOG2(Log::Warning, "`oCg $%06X <- $%02X", addr, data);
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
void FASTCALL Memory::WriteWord(DWORD addr, DWORD data)
{
	WORD *ptr;
	DWORD index;

	ASSERT(this);
	ASSERT(addr <= 0xffffff);
	ASSERT(data < 0x10000);
	ASSERT(mem.now != None);

	// CPȔꍇ͋ۏ؂Ă邪ADMAC̏ꍇ̓`FbNKv
	if (addr & 1) {
		// UCPU֓n(CPUoRDMA)
		cpu->AddrErr(addr, FALSE);
		return;
	}

	// CRAM
	if (addr < mem.length) {
		ptr = (WORD*)(&mem.ram[addr]);
		*ptr = (WORD)data;
		return;
	}

	// IPL,SCSI,CG
	if (addr >= 0xf00000) {
		return;
	}

	// foCXfBXpb`
	if (addr >= 0xc00000) {
		index = addr - 0xc00000;
		index >>= 13;
		ASSERT(index < 0x180);
		if (mem.table[index] != (MemDevice*)this) {
			mem.table[index]->WriteWord(addr, data);
			return;
		}
	}

	// oXG[
	cpu->BusErr(addr, FALSE);
	LOG2(Log::Warning, "`[h $%06X <- $%04X", addr, data);
}

//---------------------------------------------------------------------------
//
//	ǂݍ݂̂
//
//---------------------------------------------------------------------------
DWORD FASTCALL Memory::ReadOnly(DWORD addr) const
{
	DWORD index;

	ASSERT(this);
	ASSERT(addr <= 0xffffff);
	ASSERT(mem.now != None);

	// CRAM
	if (addr < mem.length) {
		return (DWORD)mem.ram[addr ^ 1];
	}

	// IPL
	if (addr >= 0xfe0000) {
		addr &= 0x1ffff;
		addr ^= 1;
		return (DWORD)mem.ipl[addr];
	}

	// IPLC[W or SCSI
	if (addr >= 0xfc0000) {
		// IPLC[W
		if ((mem.now == SASI) || (mem.now == SCSIExt)) {
			// IPLC[W
			addr &= 0x1ffff;
			addr ^= 1;
			return (DWORD)mem.ipl[addr];
		}
		// SCSI(͈̓`FbN)
		if (addr < 0xfc2000) {
			// SCSI
			addr &= 0x1fff;
			addr ^= 1;
			return (DWORD)mem.scsi[addr];
		}
		// X68030 IPLO
		if (mem.now == X68030) {
			// X68030 IPLO
			addr &= 0x1ffff;
			addr ^= 1;
			return (DWORD)mem.scsi[addr];
		}
		// SCSIfŁAROM͈͊O
		return 0xff;
	}

	// CG
	if (addr >= 0xf00000) {
		addr &= 0xfffff;
		addr ^= 1;
		return (DWORD)mem.cg[addr];
	}

	// SCSIOt
	if (mem.now == SCSIExt) {
		if ((addr >= 0xea0020) && (addr <= 0xea1fff)) {
			addr &= 0x1fff;
			addr ^= 1;
			return (DWORD)mem.scsi[addr];
		}
	}

	// foCXfBXpb`
	if (addr >= 0xc00000) {
		index = addr - 0xc00000;
		index >>= 13;
		ASSERT(index < 0x180);
		if (mem.table[index] != (MemDevice*)this) {
			return mem.table[index]->ReadOnly(addr);
		}
	}

	// }bvĂȂ
	return 0xff;
}

//---------------------------------------------------------------------------
//
//	ReLXg쐬
//
//---------------------------------------------------------------------------
void FASTCALL Memory::MakeContext(BOOL reset)
{
	int index;
	int area;
	GVRAM *gvram;
	TVRAM *tvram;

	ASSERT(this);

	// Zbg
	if (reset) {
		// GAZbgZbg(CPU::ResetMakeContextĂ΂邽)
		ASSERT(areaset);
		areaset->Reset();

		// ZbgpReLXg($FF00000`A$0000000`Ɍ)
		s_pgr[0].lowaddr = 0;
		s_pgr[0].highaddr = 0xffff;
		s_pgr[0].offset = ((DWORD)mem.ipl) + 0x10000;
		u_pgr[0].lowaddr = 0;
		u_pgr[0].highaddr = 0xffff;
		u_pgr[0].offset = ((DWORD)mem.ipl) + 0x10000;

		// vOI
		TerminateProgramRegion(1, s_pgr);
		TerminateProgramRegion(1, u_pgr);

		// f[^͑SĖ
		TerminateDataRegion(0, u_rbr);
		TerminateDataRegion(0, s_rbr);
		TerminateDataRegion(0, u_rwr);
		TerminateDataRegion(0, s_rwr);
		TerminateDataRegion(0, u_wbr);
		TerminateDataRegion(0, s_wbr);
		TerminateDataRegion(0, u_wwr);
		TerminateDataRegion(0, s_wwr);
		return;
	}

	// ʏReLXg - vO(User)
	index = 0;
	area = areaset->GetArea();
	u_pgr[index].lowaddr = (area + 1) << 13;
	u_pgr[index].highaddr = mem.length - 1;
	u_pgr[index].offset = (DWORD)mem.ram;
	index++;
	TerminateProgramRegion(index, u_pgr);

	// ʏReLXg - vO(Super)
	index = 0;
	s_pgr[index].lowaddr = 0;
	s_pgr[index].highaddr = mem.length - 1;
	s_pgr[index].offset = (DWORD)mem.ram;
	index++;

	// IPL
	s_pgr[index].lowaddr = 0xfe0000;
	s_pgr[index].highaddr = 0xffffff;
	s_pgr[index].offset = ((DWORD)mem.ipl) - 0xfe0000;
	index++;

	// SCSIOt
	if (mem.now == SCSIExt) {
		s_pgr[index].lowaddr = 0xea0000;
		s_pgr[index].highaddr = 0xea1fff;
		s_pgr[index].offset = ((DWORD)mem.scsi) - 0xea0000;
		index++;
	}

	// IPLC[W or SCSI
	if ((mem.now == SASI) || (mem.now == SCSIExt)) {
		// IPLC[W
		s_pgr[index].lowaddr = 0xfc0000;
		s_pgr[index].highaddr = 0xfdffff;
		s_pgr[index].offset = ((DWORD)mem.ipl) - 0xfc0000;
		index++;
	}
	else {
		// SCSI
		s_pgr[index].lowaddr = 0xfc0000;
		s_pgr[index].highaddr = 0xfc1fff;
		s_pgr[index].offset = ((DWORD)mem.scsi) - 0xfc0000;
		if (mem.now == X68030) {
			// X68030 IPLO
			s_pgr[index].lowaddr = 0xfc0000;
			s_pgr[index].highaddr = 0xfdffff;
			s_pgr[index].offset = ((DWORD)mem.scsi) - 0xfc0000;
		}
		index++;
	}

	// OtBbNVRAM
	gvram = (GVRAM*)vm->SearchDevice(MAKEID('G', 'V', 'R', 'M'));
	ASSERT(gvram);
	s_pgr[index].lowaddr = 0xc00000;
	s_pgr[index].highaddr = 0xdfffff;
	s_pgr[index].offset = ((DWORD)gvram->GetGVRAM()) - 0xc00000;
	index++;

	// eLXgVRAM
	tvram = (TVRAM*)vm->SearchDevice(MAKEID('T', 'V', 'R', 'M'));
	ASSERT(tvram);
	s_pgr[index].lowaddr = 0xe00000;
	s_pgr[index].highaddr = 0xe7ffff;
	s_pgr[index].offset = ((DWORD)tvram->GetTVRAM()) - 0xe00000;
	index++;

	// SRAM
	ASSERT(sram);
	s_pgr[index].lowaddr = 0xed0000;
	s_pgr[index].highaddr = 0xed0000 + (sram->GetSize() << 10) - 1;
	s_pgr[index].offset = ((DWORD)sram->GetSRAM()) - 0xed0000;
	index++;
	TerminateProgramRegion(index, s_pgr);

	// ʏReLXg - ǂݏo(User)
	index = 0;
	area = areaset->GetArea();

	// [UANZX\
	u_rbr[index].lowaddr = (area + 1) << 13;
	u_rbr[index].highaddr = mem.length - 1;
	u_rbr[index].memorycall = NULL;
	u_rbr[index].userdata = (void*)&mem.ram[(area + 1) << 13];
	index++;

	// X[poCU
	u_rbr[index].lowaddr = 0;
	u_rbr[index].highaddr = ((area + 1) << 13) - 1;
	u_rbr[index].memorycall = ::ReadErrC;
	u_rbr[index].userdata = NULL;
	index++;

	// Cԁ{X[p[oCUI/O
	u_rbr[index].lowaddr = (mem.size << 20);
	u_rbr[index].highaddr = 0xebffff;
	u_rbr[index].memorycall = ::ReadErrC;
	s_rbr[index].userdata = NULL;
	index++;

	// [UI/O($EC0000-$ECFFFF)
	u_rbr[index].lowaddr = 0xec0000;
	u_rbr[index].highaddr = 0xecffff;
	u_rbr[index].memorycall = ::ReadByteC;
	s_rbr[index].userdata = NULL;
	index++;

	// X[poCU(SRAM,CG,IPL,SCSI)
	u_rbr[index].lowaddr = 0xed0000;
	u_rbr[index].highaddr = 0xffffff;
	u_rbr[index].memorycall = ReadErrC;
	s_rbr[index].userdata = NULL;
	index++;
	TerminateDataRegion(index, u_rbr);

	// ֈڂ(ReadWord, User)
	memcpy(u_rwr, u_rbr, sizeof(u_rbr));
	u_rwr[index - 2].memorycall = ::ReadWordC;

	// ֈڂ(WriteByte, User)
	memcpy(u_wbr, u_rbr, sizeof(u_rbr));
	u_wbr[index - 2].memorycall = ::WriteByteC;
	u_wbr[index - 1].memorycall = ::WriteErrC;
	u_wbr[index - 3].memorycall = ::WriteErrC;
	u_wbr[index - 4].memorycall = ::WriteErrC;

	// ֈڂ(WriteWord, User)
	memcpy(u_wwr, u_wbr, sizeof(u_wbr));
	u_wwr[index - 2].memorycall = ::WriteWordC;

	// ʏReLXg - ǂݏo(Super)
	index = 0;
	s_rbr[index].lowaddr = 0;
	s_rbr[index].highaddr = mem.length - 1;
	s_rbr[index].memorycall = NULL;
	s_rbr[index].userdata = (void*)mem.ram;
	index++;

	// CG
	s_rbr[index].lowaddr = 0xf00000;
	s_rbr[index].highaddr = 0xfbffff;
	s_rbr[index].memorycall = NULL;
	s_rbr[index].userdata = (void*)mem.cg;
	index++;

	// IPL
	s_rbr[index].lowaddr = 0xfe0000;
	s_rbr[index].highaddr = 0xffffff;
	s_rbr[index].memorycall = NULL;
	s_rbr[index].userdata = (void*)mem.ipl;
	index++;

	// SCSIOt
	if (mem.now == SCSIExt) {
		s_rbr[index].lowaddr = 0xea0020;
		s_rbr[index].highaddr = 0xea1fff;
		s_rbr[index].memorycall = NULL;
		s_rbr[index].userdata = (void*)(&mem.scsi[0x20]);
		index++;
	}

	// IPLC[W or SCSI
	if ((mem.now == SASI) || (mem.now == SCSIExt)) {
		// IPLC[W
		s_rbr[index].lowaddr = 0xfc0000;
		s_rbr[index].highaddr = 0xfdffff;
		s_rbr[index].memorycall = NULL;
		s_rbr[index].userdata = (void*)mem.ipl;
		index++;
	}
	else {
		// SCSI
		s_rbr[index].lowaddr = 0xfc0000;
		s_rbr[index].highaddr = 0xfc1fff;
		s_rbr[index].memorycall = NULL;
		s_rbr[index].userdata = (void*)mem.scsi;
		if (mem.now == X68030) {
			// X68030 IPLO
			s_rbr[index].lowaddr = 0xfc0000;
			s_rbr[index].highaddr = 0xfdffff;
			s_rbr[index].memorycall = NULL;
			s_rbr[index].userdata = (void*)mem.scsi;
		}
		index++;
	}

	// ȊO(OR[)
	s_rbr[index].lowaddr = (mem.size << 20);
	s_rbr[index].highaddr = 0xefffff;
	s_rbr[index].memorycall = ::ReadByteC;
	s_rbr[index].userdata = NULL;
	index++;
	TerminateDataRegion(index, s_rbr);

	// ֈڂ
	memcpy(s_rwr, s_rbr, sizeof(s_rbr));
	s_rwr[index - 1].memorycall = ::ReadWordC;

	// ʏReLXg - (Super)
	index = 0;
	s_wbr[index].lowaddr = 0;
	s_wbr[index].highaddr = mem.length - 1;
	s_wbr[index].memorycall = NULL;
	s_wbr[index].userdata = (void*)mem.ram;
	index++;

	// ȊO(OR[)
	s_wbr[index].lowaddr = (mem.size << 20);
	s_wbr[index].highaddr = 0xefffff;
	s_wbr[index].memorycall = ::WriteByteC;
	s_wbr[index].userdata = NULL;
	index++;
	TerminateDataRegion(index, s_wbr);

	// ֈڂ
	memcpy(s_wwr, s_wbr, sizeof(s_wbr));
	s_wwr[index - 1].memorycall = ::WriteWordC;

	// cpu->ReleaseYꂸ
	cpu->Release();
}

//---------------------------------------------------------------------------
//
//	vO[WI
//
//---------------------------------------------------------------------------
void FASTCALL Memory::TerminateProgramRegion(int index, STARSCREAM_PROGRAMREGION *spr)
{
	ASSERT(this);
	ASSERT((index >= 0) && (index < 10));
	ASSERT(spr);

	spr[index].lowaddr = (DWORD)-1;
	spr[index].highaddr = (DWORD)-1;
	spr[index].offset = 0;
}

//---------------------------------------------------------------------------
//
//	f[^[WI
//
//---------------------------------------------------------------------------
void FASTCALL Memory::TerminateDataRegion(int index, STARSCREAM_DATAREGION *sdr)
{
	ASSERT(this);
	ASSERT((index >= 0) && (index < 10));
	ASSERT(sdr);

	sdr[index].lowaddr = (DWORD)-1;
	sdr[index].highaddr = (DWORD)-1;
	sdr[index].memorycall = NULL;
	sdr[index].userdata = NULL;
}

//---------------------------------------------------------------------------
//
//	IPL`FbN
//	IPLversion1.00(87/05/07)ł邩ۂ`FbN
//
//---------------------------------------------------------------------------
BOOL FASTCALL Memory::CheckIPL() const
{
	ASSERT(this);
	ASSERT(mem.now != None);

	// ݃`FbN
	if (!mem.ipl) {
		return FALSE;
	}

	// SASI,SCSIInt,SCSIExt^Cv`FbNΏ
	if ((mem.now != SASI) && (mem.now != SCSIInt) && (mem.now != SCSIExt)) {
		return TRUE;
	}

	// t(BCD)`FbN
	if (mem.ipl[0x1000a] != 0x87) {
		return FALSE;
	}
	if (mem.ipl[0x1000c] != 0x07) {
		return FALSE;
	}
	if (mem.ipl[0x1000d] != 0x05) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	CG`FbN
//	8x8hbgtHg(S@틤)Sum,XorŃ`FbN
//
//---------------------------------------------------------------------------
BOOL FASTCALL Memory::CheckCG() const
{
	BYTE add;
	BYTE eor;
	BYTE *ptr;
	int i;

	ASSERT(this);
	ASSERT(mem.now != None);

	// ݃`FbN
	if (!mem.cg) {
		return FALSE;
	}

	// ݒ
	add = 0;
	eor = 0;
	ptr = &mem.cg[0x3a800];

	// ADD, XOR[v
	for (i=0; i<0x1000; i++) {
		add = (BYTE)(add + *ptr);
		eor ^= *ptr;
		ptr++;
	}

	// `FbN(XVIł̎l)
	if ((add != 0xec) || (eor != 0x84)) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	SCSI`FbN
//	I["XM6"ʎqŃ`FbN
//
//---------------------------------------------------------------------------
BOOL FASTCALL Memory::CheckSCSI() const
{
	Filepath path;
	Fileio fio;
	BYTE *buf;
	BOOL flag;

	ASSERT(this);

	// tO
	flag = TRUE;

	// obt@m
	try {
		buf = new BYTE[0x2000];
	}
	catch (...) {
		buf = NULL;
	}
	if (!buf) {
		return FALSE;
	}

	// SCSIIntŃgC
	path.SysFile(Filepath::SCSIInt);
	if (fio.Load(path, buf, 0x2000)) {
		// 0x1ff8"XM6 "
		if (*(DWORD*)&buf[0x1ff8] == 0x20364d58) {
			flag = FALSE;
		}
	}

	// SCSIExtŃgC(0x2000^Cv̂݃`FbN)
	path.SysFile(Filepath::SCSIExt);
	if (fio.Load(path, buf, 0x2000)) {
		// 0x1ff8"XM6 "
		if (*(DWORD*)&buf[0x1ff8] == 0x20364d58) {
			flag = FALSE;
		}
	}

	// 
	delete[] buf;

	return flag;
}

//---------------------------------------------------------------------------
//
//	CG擾
//
//---------------------------------------------------------------------------
const BYTE* FASTCALL Memory::GetCG() const
{
	ASSERT(this);
	ASSERT(mem.cg);

	return mem.cg;
}

//---------------------------------------------------------------------------
//
//	SCSI擾
//
//---------------------------------------------------------------------------
const BYTE* FASTCALL Memory::GetSCSI() const
{
	ASSERT(this);
	ASSERT(mem.scsi);

	return mem.scsi;
}
