//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[  ]
//
//---------------------------------------------------------------------------

#if !defined(memory_h)
#define memory_h

#include "device.h"
#include "starcpu.h"

//===========================================================================
//
//	O֐
//
//===========================================================================
#if defined(__cplusplus)
extern "C" {
#endif	// __cplusplus
void ReadBusErr(DWORD addr);
										// ǂݍ݃oXG[
void WriteBusErr(DWORD addr);
										// ݃oXG[
#if defined(__cplusplus)
}
#endif	// __cplusplus

//===========================================================================
//
//	
//
//===========================================================================
class Memory : public MemDevice
{
public:
	// (=VXe)
	enum memtype {
		None,							// [hĂȂ
		SASI,							// v1.00-SASI(/ACE/EXPERT/PRO)
		SCSIInt,						// v1.00-SCSI(SUPER)
		SCSIExt,						// v1.00-SCSIOt{[h(/ACE/EXPERT/PRO)
		XVI,							// v1.10-SCSI(XVI)
		Compact,						// v1.20-SCSI(Compact)
		X68030							// v1.50-SCSI(X68030)
	};

	// f[^`
	typedef struct {
		MemDevice* table[0x180];		// Wve[u
		int size;						// RAMTCY(2,4,6,8,10,12)
		int config;						// RAMݒl(0`5)
		DWORD length;					// RAMŏIoCg+1
		BYTE *ram;						// CRAM
		BYTE *ipl;						// IPL ROM (128KB)
		BYTE *cg;						// CG ROM(768KB)
		BYTE *scsi;						// SCSI ROM (8KB)
		memtype type;					// (Zbg)
		memtype now;					// (Jg)
		BOOL memsw;						// XCb`XV
	} memory_t;

public:
	// {t@NV
	Memory(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL MakeContext(BOOL reset);
										// ReLXg쐬
	BOOL FASTCALL CheckIPL() const;
										// IPL`FbN
	BOOL FASTCALL CheckCG() const;
										// CG`FbN
	BOOL FASTCALL CheckSCSI() const;
										// SCSI`FbN
	const BYTE* FASTCALL GetCG() const;
										// CG擾
	const BYTE* FASTCALL GetSCSI() const;
										// SCSI擾
	memtype FASTCALL GetMemType() const { return mem.now; }
										// ʎ擾

private:
	BOOL FASTCALL LoadROM(memtype target);
										// ROM[h
	void FASTCALL InitTable();
										// fR[he[u
	void FASTCALL TerminateProgramRegion(int index, STARSCREAM_PROGRAMREGION *spr);
										// vO[WI
	void FASTCALL TerminateDataRegion(int index, STARSCREAM_DATAREGION *sdr);
										// f[^[WI
	AreaSet *areaset;
										// GAZbg
	SRAM *sram;
										// SRAM
	memory_t mem;
										// f[^

	// [W (StarscreamL)
	STARSCREAM_PROGRAMREGION u_pgr[10];
										// vO[W(User)
	STARSCREAM_PROGRAMREGION s_pgr[10];
										// vO[W(Super)
	STARSCREAM_DATAREGION u_rbr[10];
										// Read Byte[W(User)
	STARSCREAM_DATAREGION s_rbr[10];
										// Read Byte[W(Super)
	STARSCREAM_DATAREGION u_rwr[10];
										// Read Word[W(User)
	STARSCREAM_DATAREGION s_rwr[10];
										// Read Word[W(Super)
	STARSCREAM_DATAREGION u_wbr[10];
										// Write Byte[W(User)
	STARSCREAM_DATAREGION s_wbr[10];
										// Write Byte[W(Super)
	STARSCREAM_DATAREGION u_wwr[10];
										// Write Word[W(User)
	STARSCREAM_DATAREGION s_wwr[10];
										// Write Word[W(Super)
};

#endif	// memory_h
