//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2004 ohD(ytanaka@ipc-tokai.or.jp)
//	[ Mercury-Unit ]
//
//---------------------------------------------------------------------------

#if !defined(mercury_h)
#define mercury_h

#include "device.h"
#include "event.h"

//===========================================================================
//
//	Mercury-Unit
//
//===========================================================================
class Mercury : public MemDevice
{
public:
	// {t@NV
	Mercury(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp
#if !defined(NDEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// NDEBUG

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂
};

#endif	// mercury_h
