//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2004 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFP(MC68901) ]
//
//---------------------------------------------------------------------------

#if !defined(mfp_h)
#define mfp_h

#include "device.h"
#include "event.h"

//===========================================================================
//
//	MFP
//
//===========================================================================
class MFP : public MemDevice
{
public:
	// f[^`
	typedef struct {
		// 荞
		BOOL ier[0x10];					// 荞݃Cl[uWX^
		BOOL ipr[0x10];					// 荞݃yfBOWX^
		BOOL isr[0x10];					// 荞݃CT[rXWX^
		BOOL imr[0x10];					// 荞݃}XNWX^
		BOOL ireq[0x10];				// 荞݃NGXgWX^
		DWORD vr;						// xN^WX^
		int iidx;						// 荞݃CfbNX

		// ^C}
		DWORD tcr[4];					// ^C}Rg[WX^
		DWORD tdr[4];					// ^C}f[^WX^
		DWORD tir[4];					// ^C}C^[iWX^
		DWORD tbr[2];					// ^C}obNAbvWX^
		DWORD sram;						// si, info.ram΍tO
		DWORD tecnt;					// CxgJEg[hJE^

		// GPIP
		DWORD gpdr;						// GPIPf[^WX^
		DWORD aer;						// ANeBuGbWWX^
		DWORD ddr;						// f[^WX^
		DWORD ber;						// obNAbvGbWWX^

		// USART
		DWORD scr;						// SYNCLN^WX^
		DWORD ucr;						// USARTRg[WX^
		DWORD rsr;						// V[oXe[^XWX^
		DWORD tsr;						// gX~b^Xe[^XWX^
		DWORD rur;						// V[o[UWX^
		DWORD tur;						// gX~b^[UWX^
		DWORD buffer[0x10];				// USART FIFOobt@
		int datacount;					// USART Lf[^
		int readpoint;					// USART MFPǂݎ|Cg
		int writepoint;					// USART L[{[h݃|Cg
	} mfp_t;

public:
	// {t@NV
	MFP(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL GetMFP(mfp_t *buffer) const;
										// f[^擾
	BOOL FASTCALL Callback(Event *ev);
										// CxgR[obN
	void FASTCALL IntAck();
										// 荞݉
	void FASTCALL EventCount(int channel, int value);
										// CxgJEg
	void FASTCALL SetGPIP(int num, int value);
										// GPIPݒ
	void FASTCALL KeyData(DWORD data);
										// L[f[^ݒ
	DWORD FASTCALL GetVR() const;
										// xN^WX^擾

private:
	// 荞݃Rg[
	void FASTCALL Interrupt(int level, BOOL enable);
										// 荞
	void FASTCALL IntCheck();
										// 荞ݗD揇ʃ`FbN
	void FASTCALL SetIER(int offset, DWORD data);
										// IERݒ
	DWORD FASTCALL GetIER(int offset) const;
										// IER擾
	void FASTCALL SetIPR(int offset, DWORD data);
										// IPRݒ
	DWORD FASTCALL GetIPR(int offset) const;
										// IPR擾
	void FASTCALL SetISR(int offset, DWORD data);
										// ISRݒ
	DWORD FASTCALL GetISR(int offset) const;
										// ISR擾
	void FASTCALL SetIMR(int offset, DWORD data);
										// IMRݒ
	DWORD FASTCALL GetIMR(int offset) const;
										// IMRݒ
	void FASTCALL SetVR(DWORD data);
										// VRݒ
	static const char* IntDesc[0x10];
										// 荞ݖ̃e[u

	// ^C}
	void FASTCALL SetTCR(int channel, DWORD data);
										// TCRݒ
	DWORD FASTCALL GetTCR(int channel) const;
										// TCR擾
	void FASTCALL SetTDR(int channel, DWORD data);
										// TDRݒ
	DWORD FASTCALL GetTIR(int channel) const;
										// TIR擾
	void FASTCALL Proceed(int channel);
										// ^C}i߂
	Event timer[4];
										// ^C}Cxg
	static const int TimerInt[4];
										// ^C}荞݃e[u
	static const DWORD TimerHus[8];
										// ^C}ԃe[u

	// GPIP
	void FASTCALL SetGPDR(DWORD data);
										// GPDRݒ
	void FASTCALL IntGPIP();
										// GPIP荞
	static const int GPIPInt[8];
										// GPIP荞݃e[u

	// USART
	void FASTCALL SetRSR(DWORD data);
										// RSRݒ
	void FASTCALL Receive();
										// USARTf[^M
	void FASTCALL SetTSR(DWORD data);
										// TSRݒ
	void FASTCALL Transmit(DWORD data);
										// USARTf[^M
	void FASTCALL USART();
										// USART
	Event usart;
										// USARTCxg
	Sync *sync;
										// USART Sync
	Keyboard *keyboard;
										// L[{[h
	mfp_t mfp;
										// f[^
};

#endif	// mfp_h
