//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2005 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MIDI(YM3802) ]
//
//---------------------------------------------------------------------------

#if !defined(midi_h)
#define midi_h

#include "device.h"
#include "event.h"

//===========================================================================
//
//	MIDI
//
//===========================================================================
class MIDI : public MemDevice
{
public:
	// 萔`
	enum {
		TransMax = 0x2000,				// Mobt@
		RecvMax = 0x2000				// Mobt@
	};

	// MIDIoCgf[^`
	typedef struct {
		DWORD data;						// f[^(8bit)
		DWORD vtime;					// z
	} mididata_t;

	// f[^`
	typedef struct {
		// Zbg
		BOOL reset;						// ZbgtO
		BOOL access;					// ANZXtO

		// {[hf[^A荞
		DWORD bid;						// {[hID(0:{[h)
		DWORD ilevel;					// 荞݃x
		int vector;						// 荞ݗvxN^

		// MCSWX^()
		DWORD wdr;						// ݃f[^WX^
		DWORD rgr;						// WX^O[vWX^

		// MCSWX^(荞)
		DWORD ivr;						// 荞݃xN^WX^
		DWORD isr;						// 荞݃T[rXWX^
		DWORD imr;						// 荞݃[hWX^
		DWORD ier;						// 荞݋WX^

		// MCSWX^(A^CbZ[W)
		DWORD dmr;						// A^CbZ[W[hWX^
		DWORD dcr;						// A^CbZ[WRg[WX^

		// MCSWX^(M)
		DWORD rrr;						// M[gWX^
		DWORD rmr;						// M[hWX^
		DWORD amr;						// AhXn^[hWX^
		DWORD adr;						// AhXn^foCXWX^
		DWORD asr;						// AhXn^Xe[^XWX^
		DWORD rsr;						// Mobt@Xe[^XWX^
		DWORD rcr;						// Mobt@Rg[WX^
		DWORD rcn;						// MJE^

		// MCSWX^(M)
		DWORD trr;						// M[gWX^
		DWORD tmr;						// M[hWX^
		BOOL tbs;						// MBUSYWX^
		DWORD tcr;						// MRg[WX^
		DWORD tcn;						// MJE^

		// MCSWX^(FSK)
		DWORD fsr;						// FSKXe[^XWX^
		DWORD fcr;						// FSKRg[WX^

		// MCSWX^(JE^)
		DWORD ccr;						// NbNRg[WX^
		DWORD cdr;						// NbNf[^WX^
		DWORD ctr;						// NbN^C}WX^
		DWORD srr;						// R[fBOJE^WX^
		DWORD scr;						// NbNԃWX^
		DWORD sct;						// NbNԃJE^
		DWORD spr;						// vCobNJE^WX^
		DWORD str;						// vCobN^C}WX^
		DWORD gtr;						// ėp^C}WX^
		DWORD mtr;						// MIDINbN^C}WX^

		// MCSWX^(GPIO)
		DWORD edr;						// O|[gfBNVWX^
		DWORD eor;						// O|[gOutputWX^
		DWORD eir;						// O|[gInputWX^

		// ʏobt@
		DWORD normbuf[16];				// ʏobt@
		DWORD normread;					// ʏobt@Read
		DWORD normwrite;				// ʏobt@Write
		DWORD normnum;					// ʏobt@
		DWORD normtotal;				// ʏobt@g[^

		// A^CMobt@
		DWORD rtbuf[4];					// A^CMobt@
		DWORD rtread;					// A^CMobt@Read
		DWORD rtwrite;					// A^CMobt@Write
		DWORD rtnum;					// A^CMobt@
		DWORD rttotal;					// A^CMobt@g[^

		// ʃobt@
		DWORD stdbuf[0x80];				// ʃobt@
		DWORD stdread;					// ʃobt@Read
		DWORD stdwrite;					// ʃobt@Write
		DWORD stdnum;					// ʃobt@
		DWORD stdtotal;					// ʃobt@g[^

		// A^CMobt@
		DWORD rrbuf[4];					// A^CMobt@
		DWORD rrread;					// A^CMobt@Read
		DWORD rrwrite;					// A^CMobt@Write
		DWORD rrnum;					// A^CMobt@
		DWORD rrtotal;					// A^CMobt@g[^

		// Mobt@(foCXƂ̎󂯓np)
		mididata_t *transbuf;			// Mobt@
		DWORD transread;				// Mobt@Read
		DWORD transwrite;				// Mobt@Write
		DWORD transnum;					// Mobt@

		// Mobt@(foCXƂ̎󂯓np)
		mididata_t *recvbuf;			// Mobt@
		DWORD recvread;					// Mobt@Read
		DWORD recvwrite;				// Mobt@Write
		DWORD recvnum;					// Mobt@
	} midi_t;

public:
	// {t@NV
	MIDI(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp
#if !defined(NDEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// NDEBUG

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	BOOL FASTCALL IsActive() const;
										// MIDIANeBu`FbN
	BOOL FASTCALL Callback(Event *ev);
										// CxgR[obN
	void FASTCALL IntAck(int level);
										// 荞ACK
	void FASTCALL GetMIDI(midi_t *buffer) const;
										// f[^擾
	DWORD FASTCALL GetExCount(int index) const;
										// GNXN[VuJEg擾

	// M(MIDI OUT)
	DWORD FASTCALL GetTransNum() const;
										// Mobt@擾
	const mididata_t* FASTCALL GetTransData(DWORD proceed);
										// Mobt@f[^擾
	void FASTCALL DelTransData(DWORD number);
										// Mobt@폜
	void FASTCALL ClrTransData();
										// Mobt@NA

	// M(MIDI IN)
	void FASTCALL SetRecvData(const BYTE *ptr, DWORD length);
										// Mf[^ݒ
	void FASTCALL SetRecvDelay(int delay);
										// MfBCݒ

	// Zbg
	BOOL FASTCALL IsReset() const		{ return midi.reset; }
										// ZbgtO擾
	void FASTCALL ClrReset()			{ midi.reset = FALSE; }
										// ZbgtONA

private:
	void FASTCALL Receive();
										// MR[obN
	void FASTCALL Transmit();
										// MR[obN
	void FASTCALL Clock();
										// MIDINbNo
	void FASTCALL General();
										// ėp^C}R[obN

	void FASTCALL InsertTrans(DWORD data);
										// Mobt@֑}
	void FASTCALL InsertRecv(DWORD data);
										// Mobt@֑}
	void FASTCALL InsertNorm(DWORD data);
										// ʏobt@֑}
	void FASTCALL InsertRT(DWORD data);
										// A^CMobt@֑}
	void FASTCALL InsertStd(DWORD data);
										// ʃobt@֑}
	void FASTCALL InsertRR(DWORD data);
										// A^CMobt@֑}

	void FASTCALL ResetReg();
										// WX^Zbg
	DWORD FASTCALL ReadReg(DWORD reg);
										// WX^ǂݏo
	void FASTCALL WriteReg(DWORD reg, DWORD data);
										// WX^
	DWORD FASTCALL ReadRegRO(DWORD reg) const;
										// WX^ǂݏo(ReadOnly)

	void FASTCALL SetICR(DWORD data);
										// ICRݒ
	void FASTCALL SetIOR(DWORD data);
										// IORݒ
	void FASTCALL SetIMR(DWORD data);
										// IMRݒ
	void FASTCALL SetIER(DWORD data);
										// IERݒ
	void FASTCALL SetDMR(DWORD data);
										// DMRݒ
	void FASTCALL SetDCR(DWORD data);
										// DCRݒ
	DWORD FASTCALL GetDSR() const;
										// DSR擾
	void FASTCALL SetDNR(DWORD data);
										// DNRݒ
	void FASTCALL SetRRR(DWORD data);
										// RRRݒ
	void FASTCALL SetRMR(DWORD data);
										// RMRݒ
	void FASTCALL SetAMR(DWORD data);
										// AMRݒ
	void FASTCALL SetADR(DWORD data);
										// ADRݒ
	DWORD FASTCALL GetRSR() const;
										// RSR擾
	void FASTCALL SetRCR(DWORD data);
										// RCRݒ
	DWORD FASTCALL GetRDR();
										// RDR擾(XV)
	DWORD FASTCALL GetRDRRO() const;
										// RDR擾(Read Only)
	void FASTCALL SetTRR(DWORD data);
										// TRRݒ
	void FASTCALL SetTMR(DWORD data);
										// TMRݒ
	DWORD FASTCALL GetTSR() const;
										// TSR擾
	void FASTCALL SetTCR(DWORD data);
										// TCRݒ
	void FASTCALL SetTDR(DWORD data);
										// TDRݒ
	DWORD FASTCALL GetFSR() const;
										// FSR擾
	void FASTCALL SetFCR(DWORD data);
										// FCRݒ
	void FASTCALL SetCCR(DWORD data);
										// CCRݒ
	void FASTCALL SetCDR(DWORD data);
										// CDRݒ
	DWORD FASTCALL GetSRR() const;
										// SRR擾
	void FASTCALL SetSCR(DWORD data);
										// SCRݒ
	void FASTCALL SetSPR(DWORD data, BOOL high);
										// SPRݒ
	void FASTCALL SetGTR(DWORD data, BOOL high);
										// GTRݒ
	void FASTCALL SetMTR(DWORD data, BOOL high);
										// MTRݒ
	void FASTCALL SetEDR(DWORD data);
										// EDRݒ
	void FASTCALL SetEOR(DWORD data);
										// EORݒ
	DWORD FASTCALL GetEIR() const;
										// EIR擾

	void FASTCALL CheckRR();
										// A^CbZ[WMobt@`FbN
	void FASTCALL Interrupt(int type, BOOL flag);
										// 荞ݔ
	void FASTCALL IntCheck();
										// 荞݃`FbN
	Event event[3];
										// Cxg
	midi_t midi;
										// f[^
	Sync *sync;
										// f[^Sync
	DWORD recvdelay;
										// Mxꎞ(hus)
	DWORD ex_cnt[4];
										// GNXN[VuJEg
};

#endif	// midi_h
