//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2005 ohD(ytanaka@ipc-tokai.or.jp)
//	[ }EX ]
//
//---------------------------------------------------------------------------

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "schedule.h"
#include "scc.h"
#include "log.h"
#include "fileio.h"
#include "config.h"
#include "mouse.h"

//===========================================================================
//
//	}EX
//
//===========================================================================
//#define MOUSE_LOG

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
Mouse::Mouse(VM *p) : Device(p)
{
	// foCXID
	dev.id = MAKEID('M', 'O', 'U', 'S');
	dev.desc = "Mouse";
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL Mouse::Init()
{
	Scheduler *scheduler;

	ASSERT(this);

	// {NX
	if (!Device::Init()) {
		return FALSE;
	}

	// SCC擾
	scc = (SCC*)vm->SearchDevice(MAKEID('S', 'C', 'C', ' '));
	ASSERT(scc);

	// XPW[擾
	scheduler = (Scheduler*)vm->SearchDevice(MAKEID('S', 'C', 'H', 'E'));
	ASSERT(scheduler);

	// Cxgݒ
	event.SetDevice(this);
	event.SetDesc("Latency 725us");
	event.SetUser(0);
	event.SetTime(0);
	scheduler->AddEvent(&event);

	// }EX{205/256AE]ȂA{̐ڑ
	mouse.mul = 205;
	mouse.rev = FALSE;
	mouse.port = 1;

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL Mouse::Cleanup()
{
	ASSERT(this);

	// {NX
	Device::Cleanup();
}

//---------------------------------------------------------------------------
//
//	Zbg
//
//---------------------------------------------------------------------------
void FASTCALL Mouse::Reset()
{
	ASSERT(this);
	LOG0(Log::Normal, "Zbg");

	// MSCTRLM'L'ɐݒ
	mouse.msctrl = FALSE;

	// ZbgtOグ
	mouse.reset = TRUE;
}

//---------------------------------------------------------------------------
//
//	Z[u
//
//---------------------------------------------------------------------------
BOOL FASTCALL Mouse::Save(Fileio *fio, int ver)
{
	size_t sz;

	ASSERT(this);
	LOG0(Log::Normal, "Z[u");

	// TCYZ[u
	sz = sizeof(mouse_t);
	if (!fio->Write(&sz, sizeof(sz))) {
		return FALSE;
	}
	if (!fio->Write(&mouse, sizeof(mouse))) {
		return FALSE;
	}

	// CxgZ[u
	if (!event.Save(fio, ver)) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
BOOL FASTCALL Mouse::Load(Fileio *fio, int ver)
{
	size_t sz;

	ASSERT(this);
	LOG0(Log::Normal, "[h");

	// {̂[h
	if (!fio->Read(&sz, sizeof(sz))) {
		return FALSE;
	}
	if (sz != sizeof(mouse_t)) {
		return FALSE;
	}
	if (!fio->Read(&mouse, sizeof(mouse_t))) {
		return FALSE;
	}

	// Cxg[h
	if (!event.Load(fio, ver)) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL Mouse::ApplyCfg(const Config *config)
{
	ASSERT(this);
	ASSERT(config);
	LOG0(Log::Normal, "ݒKp");

	// 䗦
	if (mouse.mul != config->mouse_speed) {
		// WZbg
		mouse.mul = config->mouse_speed;
		mouse.reset = TRUE;
	}

	// ]tO
	mouse.rev = config->mouse_swap;

	// |[g
	mouse.port = config->mouse_port;
	if (mouse.port == 0) {
		// ڑȂȂ̂ŁACxg~߂
		mouse.reset = TRUE;
		event.SetTime(0);
	}
}

//---------------------------------------------------------------------------
//
//	f[^擾
//
//---------------------------------------------------------------------------
void FASTCALL Mouse::GetMouse(mouse_t *buffer)
{
	ASSERT(this);
	ASSERT(buffer);

	// [NRs[
	*buffer = mouse;
}

//---------------------------------------------------------------------------
//
//	CxgR[obN
//
//---------------------------------------------------------------------------
BOOL FASTCALL Mouse::Callback(Event* /*ev*/)
{
	DWORD status;
	int dx;
	int dy;

	ASSERT(this);
	ASSERT(scc);

	// Xe[^X쐬
	status = 0;

	// {^쐬
	if (mouse.left) {
		status |= 0x01;
	}
	if (mouse.right) {
		status |= 0x02;
	}

	// X쐬
	dx = mouse.x - mouse.px;
	dx *= mouse.mul;
	dx >>= 8;
	if (dx > 0x7f) {
		dx = 0x7f;
		status |= 0x10;
	}
	if (dx < -0x80) {
		dx = -0x80;
		status |= 0x20;
	}

	// Y쐬
	dy = mouse.y - mouse.py;
	dy *= mouse.mul;
	dy >>= 8;
	if (dy > 0x7f) {
		dy = 0x7f;
		status |= 0x40;
	}
	if (dy < -0x80) {
		dy = -0x80;
		status |= 0x80;
	}

	// SCCMĂȂΉȂ
	if (!scc->IsRxEnable(1)) {
		return FALSE;
	}

	// Mbps4800łȂ΁At[~OG[
	if (!scc->IsBaudRate(1, 4800)) {
#if defined(MOUSE_LOG)
		LOG0(Log::Normal, "SCC{[[gG[");
#endif	// MOUSE_LOG
		scc->FramingErr(1);
		return FALSE;
	}

	// f[^8bitłȂ΁At[~OG[
	if (scc->GetRxBit(1) != 8) {
#if defined(MOUSE_LOG)
		LOG0(Log::Normal, "SCCf[^rbgG[");
#endif	// MOUSE_LOG
		scc->FramingErr(1);
		return FALSE;
	}

	// Xgbvrbg2bitłȂ΁At[~OG[
	if (scc->GetStopBit(1) != 3) {
#if defined(MOUSE_LOG)
		LOG0(Log::Normal, "SCCXgbvrbgG[");
#endif	// MOUSE_LOG
		scc->FramingErr(1);
		return FALSE;
	}

	// peBȂłȂ΁ApeBG[
	if (scc->GetParity(1) != 0) {
#if defined(MOUSE_LOG)
		LOG0(Log::Normal, "SCCpeBG[");
#endif	// MOUSE_LOG
		scc->ParityErr(1);
		return FALSE;
	}

	// SCC̎Mobt@Ƀf[^Ȃ瑗MȂ
	if (!scc->IsRxBufEmpty(1)) {
#if defined(MOUSE_LOG)
		LOG0(Log::Normal, "SCCMobt@Ƀf[^");
#endif	// MOUSE_LOG
		return FALSE;
	}

	// f[^M(3oCg)
#if defined(MOUSE_LOG)
	LOG3(Log::Normal, "f[^o St:$%02X X:$%02X Y:$%02X", status, dx & 0xff, dy & 0xff);
#endif	// MOUSE_LOG
	scc->Send(1, status);
	scc->Send(1, dx);
	scc->Send(1, dy);

	// Of[^XV
	mouse.px = mouse.x;
	mouse.py = mouse.y;

	return FALSE;
}

//---------------------------------------------------------------------------
//
//	MSCTRL
//
//---------------------------------------------------------------------------
void FASTCALL Mouse::MSCtrl(BOOL flag, int port)
{
	ASSERT(this);
	ASSERT((port == 1) || (port == 2));

#if defined(MOUSE_LOG)
	LOG2(Log::Normal, "PORT=%d MSCTRL=%d", port, flag);
#endif	// MOUSE_LOG

	// |[gvȂΉȂ
	if (port != mouse.port) {
		return;
	}

	// 'H''L'ւ̗ŃCxg
	if (flag) {
		mouse.msctrl = TRUE;
		return;
	}

	// O'H'`FbN
	if (!mouse.msctrl) {
		return;
	}

	// L
	mouse.msctrl = FALSE;

	// CxgȂ疳
	if (event.GetTime() != 0) {
		return;
	}

	// Cxg(725us)
	event.SetTime(725 * 2);
}

//---------------------------------------------------------------------------
//
//	}EXf[^ݒ
//
//---------------------------------------------------------------------------
void FASTCALL Mouse::SetMouse(int x, int y, BOOL left, BOOL right)
{
	ASSERT(this);

	// f[^L
	mouse.x = x;
	mouse.y = y;
	if (mouse.rev) {
		mouse.left = right;
		mouse.right = left;
	}
	else {
		mouse.left = left;
		mouse.right = right;
	}

	// ZbgtO΍WZbg
	if (mouse.reset) {
		mouse.reset = FALSE;
		mouse.px = x;
		mouse.py = y;
	}
}

//---------------------------------------------------------------------------
//
//	}EXf[^Zbg
//
//---------------------------------------------------------------------------
void FASTCALL Mouse::ResetMouse()
{
	ASSERT(this);

	mouse.reset = TRUE;
}
