//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2003 ohD(ytanaka@ipc-tokai.or.jp)
//	[ }EX ]
//
//---------------------------------------------------------------------------

#if !defined(mouse_h)
#define mouse_h

#include "device.h"
#include "event.h"

//===========================================================================
//
//	}EX
//
//===========================================================================
class Mouse : public Device
{
public:
	// f[^`
	typedef struct {
		BOOL msctrl;					// MSCTRLM
		BOOL reset;						// ZbgtO
		BOOL left;						// {^
		BOOL right;						// E{^
		int x;							// xW
		int y;							// yW
		int px;							// OxW
		int py;							// OyW
		int mul;						// }EX{(256ŕW)
		BOOL rev;						// E]tO
		int port;						// ڑ|[g
	} mouse_t;

public:
	// {t@NV
	Mouse(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// OAPI
	void FASTCALL GetMouse(mouse_t *buffer);
										// f[^擾
	BOOL FASTCALL Callback(Event *ev);
										// CxgR[obN
	void FASTCALL MSCtrl(BOOL flag, int port = 1);
										// MSCTRL
	void FASTCALL SetMouse(int x, int y, BOOL left, BOOL right);
										// }EXf[^w
	void FASTCALL ResetMouse();
										// }EXf[^Zbg

private:
	mouse_t mouse;
										// f[^
	Event event;
										// Cxg
	SCC *scc;
										// SCC
};

#endif	// mouse_h
