//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ OPM(YM2151) ]
//
//---------------------------------------------------------------------------

#if !defined(opmif_h)
#define opmif_h

#include "device.h"
#include "event.h"
#include "opm.h"

//===========================================================================
//
//	OPM
//
//===========================================================================
class OPMIF : public MemDevice
{
public:
	// f[^`
	typedef struct {
		DWORD reg[0x100];				// WX^
		DWORD key[8];					// L[
		DWORD addr;						// ZNgAhX
		BOOL busy;						// BUSYtO
		BOOL enable[2];					// ^C}Cl[u
		BOOL action[2];					// ^C}
		BOOL interrupt[2];				// ^C}荞
		DWORD time[2];					// ^C}
		BOOL started;					// JntO
	} opm_t;

	// obt@Ǘ`
	typedef struct {
		DWORD max;						// ő吔
		DWORD num;						// Lf[^
		DWORD read;						// ǂݎ|Cg
		DWORD write;					// ݃|Cg
		DWORD samples;					// Tv
		DWORD rate;						// [g
		DWORD under;					// A_[
		DWORD over;						// I[o[
		BOOL sound;						// FML
	} opmbuf_t;

public:
	// {t@NV
	OPMIF(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp
#if !defined(NDEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// NDEBUG

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL GetOPM(opm_t *buffer);
										// f[^擾
	BOOL FASTCALL Callback(Event *ev);
										// CxgR[obN
	void FASTCALL Output(DWORD addr, DWORD data);
										// WX^o
	void FASTCALL SetEngine(FM::OPM *p);
										// GWw
	void FASTCALL InitBuf(DWORD rate);
										// obt@
	DWORD FASTCALL ProcessBuf();
										// obt@
	void FASTCALL GetBuf(DWORD *buf, int samples);
										// obt@擾
	void FASTCALL GetBufInfo(opmbuf_t *buffer);
										// obt@𓾂
	void FASTCALL EnableFM(BOOL flag)	{ bufinfo.sound = flag; }
										// FML
	void FASTCALL ClrStarted()			{ opm.started = FALSE; }
										// X^[gtO~낷
	BOOL FASTCALL IsStarted() const		{ return opm.started; }
										// X^[gtO擾
	void FASTCALL SetChMask(int ch, BOOL mask);
										// `l}XNݒ
	BOOL FASTCALL GetChMask(int ch);
										// `l}XN擾

private:
	void FASTCALL CalcTimerA();
										// ^C}AZo
	void FASTCALL CalcTimerB();
										// ^C}BZo
	void FASTCALL CtrlTimer(DWORD data);
										// ^C}
	void FASTCALL CtrlCT(DWORD data);
										// CT
	MFP *mfp;
										// MFP
	ADPCM *adpcm;
										// ADPCM
	FDD *fdd;
										// FDD
	opm_t opm;
										// OPMf[^
	opmbuf_t bufinfo;
										// obt@
	Event event[2];
										// ^C}[Cxg
	BOOL chmask[8];
										// `l}XN
	FM::OPM *engine;
										// GW
	enum {
		BufMax = 0x10000				// obt@TCY
	};
	DWORD *opmbuf;
										// obt@
};

#endif	// opmif_h
