//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ PPI(i8255A) ]
//
//---------------------------------------------------------------------------

#if !defined(ppi_h)
#define ppi_h

#include "device.h"

//===========================================================================
//
//	PPI
//
//===========================================================================
class PPI : public MemDevice
{
public:
	// 萔`
	enum {
		PortMax = 2,					// |[gő吔
		AxisMax = 4,					// ő吔
		ButtonMax = 8					// {^ő吔
	};

	// WCXeBbNf[^`
	typedef struct {
		DWORD axis[AxisMax];				// 
		BOOL button[ButtonMax];				// {^
	} joyinfo_t;

	// f[^`
	typedef struct {
		DWORD portc;					// |[gC
		int type[PortMax];				// WCXeBbN^Cv
		DWORD ctl[PortMax];				// WCXeBbNRg[
		joyinfo_t info[PortMax];		// WCXeBbN
	} ppi_t;

public:
	// {t@NV
	PPI(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp
#if defined(_DEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// _DEBUG

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL GetPPI(ppi_t *buffer);
										// f[^擾
	void FASTCALL SetJoyInfo(int port, const joyinfo_t *info);
										// WCXeBbNݒ
	const joyinfo_t* FASTCALL GetJoyInfo(int port) const;
										// WCXeBbN擾
	JoyDevice* FASTCALL CreateJoy(int port, int type);
										// WCXeBbNfoCX쐬

private:
	void FASTCALL SetPortC(DWORD data);
										// |[gCZbg
	ADPCM *adpcm;
										// ADPCM
	JoyDevice *joy[PortMax];
										// WCXeBbN
	ppi_t ppi;
										// f[^
};

//===========================================================================
//
//	WCXeBbNfoCX
//
//===========================================================================
class JoyDevice
{
public:
	// {t@NV
	JoyDevice(PPI *parent, int no);
										// RXgN^
	virtual ~JoyDevice();
										// fXgN^
	DWORD FASTCALL GetID() const		{ return id; }
										// ID擾
	DWORD FASTCALL GetType() const		{ return type; }
										// ^Cv擾
	virtual void FASTCALL Reset();
										// Zbg
	virtual BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	virtual BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h

	// ANZX
	virtual DWORD FASTCALL ReadPort(DWORD ctl);
										// |[gǂݎ
	virtual DWORD FASTCALL ReadOnly(DWORD ctl) const;
										// |[gǂݎ(Read Only)
	virtual void FASTCALL Control(DWORD ctl);
										// Rg[

	// LbV
	void FASTCALL Notify()				{ changed = TRUE; }
										// e|[gύXʒm
	virtual void FASTCALL MakeData();
										// f[^쐬

	// vpeB
	int FASTCALL GetAxes() const		{ return axes; }
										// 擾
	const char* FASTCALL GetAxisDesc(int axis) const;
										// \擾
	int FASTCALL GetButtons() const		{ return buttons; }
										// {^擾
	const char* FASTCALL GetButtonDesc(int button) const;
										// {^\擾
	BOOL FASTCALL IsAnalog() const		{ return analog; }
										// AiOEfW^擾
	int FASTCALL GetDatas() const		{ return datas; }
										// f[^擾

protected:
	DWORD type;
										// ^Cv
	DWORD id;
										// ID
	PPI *ppi;
										// PPI
	int port;
										// |[gԍ
	int axes;
										// 
	const char **axis_desc;
										// \
	int buttons;
										// {^
	const char **button_desc;
										// {^\
	BOOL analog;
										// (AiOEfW^)
	DWORD *data;
										// f[^
	int datas;
										// f[^
	BOOL changed;
										// WCXeBbNύXʒm
};

//===========================================================================
//
//	WCXeBbN(ATARIW)
//
//===========================================================================
class JoyAtari : public JoyDevice
{
public:
	JoyAtari(PPI *parent, int no);
										// RXgN^

protected:
	DWORD FASTCALL ReadOnly(DWORD ctl) const;
										// |[gǂݎ(Read Only)
	void FASTCALL MakeData();
										// f[^쐬

private:
	static const char* AxisDescTable[];
										// \e[u
	static const char* ButtonDescTable[];
										// {^\e[u
};

//===========================================================================
//
//	WCXeBbN(ATARIW+START/SELECT)
//
//===========================================================================
class JoyASS : public JoyDevice
{
public:
	JoyASS(PPI *parent, int no);
										// RXgN^

protected:
	DWORD FASTCALL ReadOnly(DWORD ctl) const;
										// |[gǂݎ(Read Only)
	void FASTCALL MakeData();
										// f[^쐬

private:
	static const char* AxisDescTable[];
										// \e[u
	static const char* ButtonDescTable[];
										// {^\e[u
};

//===========================================================================
//
//	WCXeBbN(TCo[XeBbNEAiO)
//
//===========================================================================
class JoyCyberA : public JoyDevice
{
public:
	JoyCyberA(PPI *parent, int no);
										// RXgN^

protected:
	void FASTCALL Reset();
										// Zbg
	DWORD FASTCALL ReadPort(DWORD ctl);
										// |[gǂݎ
	DWORD FASTCALL ReadOnly(DWORD ctl) const;
										// |[gǂݎ(Read Only)
	void FASTCALL Control(DWORD ctl);
										// Rg[
	void FASTCALL MakeData();
										// f[^쐬
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h

private:
	DWORD seq;
										// V[PX
	DWORD ctrl;
										// ÕRg[(0 or 1)
	DWORD hus;
										// p
	Scheduler *scheduler;
										// XPW[
	static const char* AxisDescTable[];
										// \e[u
	static const char* ButtonDescTable[];
										// {^\e[u
};

//===========================================================================
//
//	WCXeBbN(TCo[XeBbNEfW^)
//
//===========================================================================
class JoyCyberD : public JoyDevice
{
public:
	JoyCyberD(PPI *parent, int no);
										// RXgN^

protected:
	DWORD FASTCALL ReadOnly(DWORD ctl) const;
										// |[gǂݎ(Read Only)
	void FASTCALL MakeData();
										// f[^쐬

private:
	static const char* AxisDescTable[];
										// \e[u
	static const char* ButtonDescTable[];
										// {^\e[u
};

//===========================================================================
//
//	WCXeBbN(MD3{^)
//
//===========================================================================
class JoyMd3 : public JoyDevice
{
public:
	JoyMd3(PPI *parent, int no);
										// RXgN^

protected:
	DWORD FASTCALL ReadOnly(DWORD ctl) const;
										// |[gǂݎ(Read Only)
	void FASTCALL MakeData();
										// f[^쐬

private:
	static const char* AxisDescTable[];
										// \e[u
	static const char* ButtonDescTable[];
										// {^\e[u
};

//===========================================================================
//
//	WCXeBbN(MD6{^)
//
//===========================================================================
class JoyMd6 : public JoyDevice
{
public:
	JoyMd6(PPI *parent, int no);
										// RXgN^

protected:
	void FASTCALL Reset();
										// Zbg
	DWORD FASTCALL ReadOnly(DWORD ctl) const;
										// |[gǂݎ(Read Only)
	void FASTCALL Control(DWORD ctl);
										// Rg[
	void FASTCALL MakeData();
										// f[^쐬
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h

private:
	DWORD seq;
										// V[PX
	DWORD ctrl;
										// ÕRg[(0 or 1)
	DWORD hus;
										// p
	Scheduler *scheduler;
										// XPW[
	static const char* AxisDescTable[];
										// \e[u
	static const char* ButtonDescTable[];
										// {^\e[u
};

//===========================================================================
//
//	WCXeBbN(CPSF-SFC)
//
//===========================================================================
class JoyCpsf : public JoyDevice
{
public:
	JoyCpsf(PPI *parent, int no);
										// RXgN^

protected:
	DWORD FASTCALL ReadOnly(DWORD ctl) const;
										// |[gǂݎ(Read Only)
	void FASTCALL MakeData();
										// f[^쐬

private:
	static const char* AxisDescTable[];
										// \e[u
	static const char* ButtonDescTable[];
										// {^\e[u
};

//===========================================================================
//
//	WCXeBbN(CPSF-MD)
//
//===========================================================================
class JoyCpsfMd : public JoyDevice
{
public:
	JoyCpsfMd(PPI *parent, int no);
										// RXgN^

protected:
	DWORD FASTCALL ReadOnly(DWORD ctl) const;
										// |[gǂݎ(Read Only)
	void FASTCALL MakeData();
										// f[^쐬

private:
	static const char* AxisDescTable[];
										// \e[u
	static const char* ButtonDescTable[];
										// {^\e[u
};

//===========================================================================
//
//	WCXeBbN(}WJpbh)
//
//===========================================================================
class JoyMagical : public JoyDevice
{
public:
	JoyMagical(PPI *parent, int no);
										// RXgN^

protected:
	DWORD FASTCALL ReadOnly(DWORD ctl) const;
										// |[gǂݎ(Read Only)
	void FASTCALL MakeData();
										// f[^쐬

private:
	static const char* AxisDescTable[];
										// \e[u
	static const char* ButtonDescTable[];
										// {^\e[u
};

//===========================================================================
//
//	WCXeBbN(XPD-1LR)
//
//===========================================================================
class JoyLR : public JoyDevice
{
public:
	JoyLR(PPI *parent, int no);
										// RXgN^

protected:
	DWORD FASTCALL ReadOnly(DWORD ctl) const;
										// |[gǂݎ(Read Only)
	void FASTCALL MakeData();
										// f[^쐬

private:
	static const char* AxisDescTable[];
										// \e[u
	static const char* ButtonDescTable[];
										// {^\e[u
};

//===========================================================================
//
//	WCXeBbN(pbNhppbh)
//
//===========================================================================
class JoyPacl : public JoyDevice
{
public:
	JoyPacl(PPI *parent, int no);
										// RXgN^

protected:
	DWORD FASTCALL ReadOnly(DWORD ctl) const;
										// |[gǂݎ(Read Only)
	void FASTCALL MakeData();
										// f[^쐬

private:
	static const char* ButtonDescTable[];
										// {^\e[u
};

//===========================================================================
//
//	WCXeBbN(BM68pRg[)
//
//===========================================================================
class JoyBM : public JoyDevice
{
public:
	JoyBM(PPI *parent, int no);
										// RXgN^

protected:
	DWORD FASTCALL ReadOnly(DWORD ctl) const;
										// |[gǂݎ(Read Only)
	void FASTCALL MakeData();
										// f[^쐬

private:
	static const char* ButtonDescTable[];
										// {^\e[u
};

#endif	// ppi_h
