//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ v^ ]
//
//---------------------------------------------------------------------------

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "cpu.h"
#include "log.h"
#include "iosc.h"
#include "sync.h"
#include "fileio.h"
#include "printer.h"

//===========================================================================
//
//	v^
//
//===========================================================================
//#define PRINTER_LOG

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
Printer::Printer(VM *p) : MemDevice(p)
{
	// foCXID
	dev.id = MAKEID('P', 'R', 'N', ' ');
	dev.desc = "Printer";

	// JnAhXAIAhX
	memdev.first = 0xe8c000;
	memdev.last = 0xe8dfff;

	// ̑
	iosc = NULL;
	sync = NULL;
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL Printer::Init()
{
	ASSERT(this);

	// {NX
	if (!MemDevice::Init()) {
		return FALSE;
	}

	// IOSC擾
	iosc = (IOSC*)vm->SearchDevice(MAKEID('I', 'O', 'S', 'C'));
	ASSERT(iosc);

	// Sync쐬
	sync = new Sync;

	// ڑȂ
	printer.connect = FALSE;

	// obt@NA
	sync->Lock();
	printer.read = 0;
	printer.write = 0;
	printer.num = 0;
	sync->Unlock();

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL Printer::Cleanup()
{
	ASSERT(this);

	// Sync폜
	if (sync) {
		delete sync;
		sync = NULL;
	}

	// {NX
	MemDevice::Cleanup();
}

//---------------------------------------------------------------------------
//
//	Zbg
//
//---------------------------------------------------------------------------
void FASTCALL Printer::Reset()
{
	ASSERT(this);

	LOG0(Log::Normal, "Zbg");

	// Xg[u(_)
	printer.strobe = FALSE;

	// fB(_)
	if (printer.connect) {
		// ڑĂREADY
		printer.ready = TRUE;
	}
	else {
		// ڑȂBUSY
		printer.ready = FALSE;
	}

	// 荞ݖ
	iosc->IntPRT(FALSE);
}

//---------------------------------------------------------------------------
//
//	Z[u
//
//---------------------------------------------------------------------------
BOOL FASTCALL Printer::Save(Fileio *fio, int /* ver */)
{
	size_t sz;

	ASSERT(this);
	ASSERT(fio);
	LOG0(Log::Normal, "Z[u");

	// TCYZ[u
	sz = sizeof(printer_t);
	if (!fio->Write(&sz, (int)sizeof(sz))) {
		return FALSE;
	}

	// ̂Z[u
	if (!fio->Write(&printer, (int)sz)) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
BOOL FASTCALL Printer::Load(Fileio *fio, int /* ver */)
{
	size_t sz;

	ASSERT(this);
	ASSERT(fio);
	LOG0(Log::Normal, "[h");

	// TCY[hAƍ
	if (!fio->Read(&sz, sizeof(sz))) {
		return FALSE;
	}
	if (sz != sizeof(printer_t)) {
		return FALSE;
	}

	// ̂[h
	if (!fio->Read(&printer, (int)sz)) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL Printer::ApplyCfg(const Config* /*config*/)
{
	ASSERT(this);
	LOG0(Log::Normal, "ݒKp");

	// ݒύXAR|[lgConnect()Ă΂̂ŁAREADYς
}

//---------------------------------------------------------------------------
//
//	oCgǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL Printer::ReadByte(DWORD /*addr*/)
{
	ASSERT(this);

	// 0xff(Write Onlŷ)
	return 0xff;
}

//---------------------------------------------------------------------------
//
//	[hǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL Printer::ReadWord(DWORD /*addr*/)
{
	ASSERT(this);

	// 0xff(Write Onlŷ)
	return 0xff;
}

//---------------------------------------------------------------------------
//
//	oCg
//
//---------------------------------------------------------------------------
void FASTCALL Printer::WriteByte(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));

	ASSERT(printer.num <= BufMax);
	ASSERT(printer.read < BufMax);
	ASSERT(printer.write < BufMax);

	// 4oCgPʂŃ[v(\zBWriteOnly|[ĝߕs)
	addr &= 0x03;

	// fR[h
	switch (addr) {
		// $E8C001 o̓f[^
		case 1:
			printer.data = (BYTE)data;
			break;

		// $E8C003 Xg[u
		case 3:
			// Xg[u0(TRUE)1(FALSE)ւ̕ωŌ͂
			if ((data & 1) == 0) {
#if defined(PRINTER_LOG)
				LOG0(Log::Normal, "Xg[u 0(TRUE)");
#endif	// PRINTER_LOG
				printer.strobe = TRUE;
				break;
			}

			// Xg[uTRUEłȂ΁A܂
			if (!printer.strobe) {
				break;
			}

			// Xg[uFALSE
			printer.strobe = FALSE;
#if defined(PRINTER_LOG)
			LOG0(Log::Normal, "Xg[u 1(FALSE)");
#endif	// PRINTER_LOG

			// ڑĂȂ΁A܂
			if (!printer.connect) {
				break;
			}

			// Ńf[^b`
#if defined(PRINTER_LOG)
			LOG1(Log::Normal, "f[^m $%02X", printer.data);
#endif	// PRINTER_LOG

			sync->Lock();
			// f[^}
			printer.buf[printer.write] = printer.data;
			printer.write = (printer.write + 1) & (BufMax - 1);
			printer.num++;

			// EFCg䂪邽߁Aobt@͈Ȃ͂
			if (printer.num > BufMax) {
				ASSERT(FALSE);
				LOG0(Log::Warning, "o̓obt@I[o[t[");
				printer.num = BufMax;
			}
			sync->Unlock();

			// READY𗎂Ƃ
			printer.ready = FALSE;

			// 荞ݖ
			iosc->IntPRT(FALSE);
			break;
	}
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
void FASTCALL Printer::WriteWord(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));
	ASSERT((addr & 1) == 0);

	WriteByte(addr + 1, (BYTE)data);
}

//---------------------------------------------------------------------------
//
//	ǂݍ݂̂
//
//---------------------------------------------------------------------------
DWORD FASTCALL Printer::ReadOnly(DWORD /*addr*/) const
{
	ASSERT(this);

	// 0xff(Write Onlŷ)
	return 0xff;
}

//---------------------------------------------------------------------------
//
//	H-Syncʒm
//
//---------------------------------------------------------------------------
void FASTCALL Printer::HSync()
{
	ASSERT(this);

	// fBFALSE(f[^])łȂΊ֌WȂ
	if (printer.ready) {
		return;
	}

	// ڑĂȂ
	if (!printer.connect) {
		// printer.readyFALSÊ܂
		return;
	}

	// obt@tȂA܂ň΂
	if (printer.num == BufMax) {
#if defined(PRINTER_LOG)
	LOG0(Log::Normal, "obt@t̂߃EFCg");
#endif	// PRINTER_LOG
		return;
	}

#if defined(PRINTER_LOG)
	LOG0(Log::Normal, "f[^MAREADY");
#endif	// PRINTER_LOG

	// fB
	printer.ready = TRUE;

	// 荞ݐݒ
	iosc->IntPRT(TRUE);
}

//---------------------------------------------------------------------------
//
//	f[^擾
//
//---------------------------------------------------------------------------
void FASTCALL Printer::GetPrinter(printer_t *buffer) const
{
	ASSERT(this);
	ASSERT(buffer);

	// [NRs[
	*buffer = printer;
}

//---------------------------------------------------------------------------
//
//	ڑ
//
//---------------------------------------------------------------------------
void FASTCALL Printer::Connect(BOOL flag)
{
	ASSERT(this);
	ASSERT(printer.num <= BufMax);
	ASSERT(printer.read < BufMax);
	ASSERT(printer.write < BufMax);

	// vĂΉȂ
	if (printer.connect == flag) {
		return;
	}

	// ݒ
	printer.connect = flag;
#if defined(PRINTER_LOG)
	if (printer.connect) {
		LOG0(Log::Normal, "v^ڑ");
	}
	else {
		LOG0(Log::Normal, "v^ؒf");
	}
#endif	// PRINTER_LOG

	// FALSEɂȂAfB낷
	if (!printer.connect) {
		printer.ready = FALSE;
		iosc->IntPRT(FALSE);
		return;
	}

	// TRUEɂȂAHSYNCŃfBグ
	sync->Lock();
	printer.read = 0;
	printer.write = 0;
	printer.num = 0;
	sync->Unlock();
}

//---------------------------------------------------------------------------
//
//	擪f[^擾
//
//---------------------------------------------------------------------------
BOOL FASTCALL Printer::GetData(BYTE *ptr)
{
	ASSERT(this);
	ASSERT(ptr);
	ASSERT(printer.num <= BufMax);
	ASSERT(printer.read < BufMax);
	ASSERT(printer.write < BufMax);

	// bN
	sync->Lock();

	// f[^ȂFALSE
	if (printer.num == 0) {
		sync->Unlock();
		return FALSE;
	}

	// f[^擾
	*ptr = printer.buf[printer.read];

	// 
	printer.read = (printer.read + 1) & (BufMax - 1);
	printer.num--;

	// AbN
	sync->Unlock();
	return TRUE;
}
