//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2004 ohD(ytanaka@ipc-tokai.or.jp)
//	[ v^ ]
//
//---------------------------------------------------------------------------

#if !defined(printer_h)
#define printer_h

#include "device.h"

//===========================================================================
//
//	v^
//
//===========================================================================
class Printer : public MemDevice
{
public:
	// 萔l
	enum {
		BufMax = 0x1000				// obt@TCY(2̔{)
	};

	// f[^`
	typedef struct {
		BOOL connect;					// ڑ
		BOOL strobe;					// Xg[u
		BOOL ready;						// fB
		BYTE data;						// ݃f[^
		BYTE buf[BufMax];				// obt@f[^
		DWORD read;						// obt@ǂݍ݈ʒu
		DWORD write;					// obt@݈ʒu
		DWORD num;						// obt@L
	} printer_t;

public:
	// {t@NV
	Printer(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	BOOL FASTCALL IsReady() const		{ return printer.ready; }
										// fB擾
	void FASTCALL HSync();
										// H-Syncʒm
	void FASTCALL GetPrinter(printer_t *buffer) const;
										// f[^擾
	void FASTCALL Connect(BOOL flag);
										// v^ڑ
	BOOL FASTCALL GetData(BYTE *ptr);
										// 擪f[^擾

private:
	IOSC *iosc;
										// IOSC
	Sync *sync;
										// IuWFNg
	printer_t printer;
										// f[^
};

#endif	// printer_h
