//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001,2002 ohD(ytanaka@ipc-tokai.or.jp)
//	[ _ ]
//
//---------------------------------------------------------------------------

#if !defined(render_h)
#define render_h

#include "device.h"
#include "vc.h"

//===========================================================================
//
//	_
//
//===========================================================================
class Render : public Device
{
public:
	// f[^`
	typedef struct {
		// S̐
		BOOL act;						// Ă邩
		BOOL enable;					// 
		int count;						// XPW[AgJE^
		BOOL ready;						// `揀łĂ邩
		int first;						// X^
		int last;						// \IX^

		// CRTC
		BOOL crtc;						// CRTCύXtO
		int width;						// Xhbg(256`)
		int h_mul;						// X{(1,2)
		int height;						// Yhbg(256`)
		int v_mul;						// Y{(0,1,2)
		BOOL lowres;					// 15kHztO

		// VC
		BOOL vc;						// VCύXtO

		// 
		BOOL mix[1024];					// tO(C)
		DWORD *mixbuf;					// obt@
		DWORD *mixptr[8];				// |C^
		DWORD mixshift[8];				// |C^YVtg
		DWORD *mixx[8];					// |C^XXN[|C^
		DWORD *mixy[8];					// |C^YXN[|C^
		DWORD mixand[8];				// |C^̃XN[ANDl
		int mixmap[3];					// }bv
		int mixtype;					// ^Cv
		int mixpage;					// OtBbNy[W
		int mixwidth;					// obt@
		int mixheight;					// obt@
		int mixlen;						// (x)

		// `
		BOOL draw[1024];				// `tO(C)
		BOOL *drawflag;					// `tO(16dot)

		// RgXg
		BOOL contrast;					// RgXgύXtO
		int contlevel;					// RgXg

		// pbg
		BOOL palette;					// pbgύXtO
		BOOL palmod[0x200];				// pbgύXtO
		DWORD *palbuf;					// pbgobt@
		DWORD *palptr;					// pbg|C^
		const WORD *palvc;				// pbgVC|C^
		DWORD paldata[0x200];			// pbgf[^
		BYTE pal64k[0x200];				// pbgf[^ό`

		// eLXgVRAM
		BOOL texten;					// eLXg\tO
		BOOL textpal[1024];				// eLXgpbgtO
		BOOL textmod[1024];				// eLXgXVtO(C)
		BOOL *textflag;					// eLXgXVtO(32dot)
		BYTE *textbuf;					// eLXgobt@(pbgO)
		DWORD *textout;					// eLXgobt@(pbg)
		const BYTE *texttv;				// eLXgTVRAM|C^
		DWORD textx;					// eLXgXN[X
		DWORD texty;					// eLXgXN[Y

		// OtBbNVRAM
		int grptype;					// OtBbN^Cv(0`4)
		BOOL grpen[4];					// OtBbNubN\tO
		BOOL grppal[2048];				// OtBbNpbgtO
		BOOL grpmod[2048];				// OtBbNXVtO(C)
		BOOL *grpflag;					// OtBbNXVtO(16dot)
		DWORD *grpbuf[4];				// OtBbNubNobt@
		const BYTE* grpgv;				// OtBbNGVRAM|C^
		DWORD grpx[4];					// OtBbNubNXN[X
		DWORD grpy[4];					// OtBbNubNXN[Y

		// PCG
		BOOL pcgready[256 * 16];		// PCGOKtO
		DWORD pcguse[256 * 16];			// PCGgpJEg
		DWORD pcgpal[16];				// PCGpbggpJEg
		DWORD *pcgbuf;					// PCGobt@
		const BYTE* sprmem;				// XvCg

		// XvCg
		DWORD **spptr;					// XvCg|C^obt@
		DWORD spreg[0x200];				// XvCgWX^ۑ
		BOOL spuse[128];				// XvCggptO

		// BG
		DWORD bgreg[2][64 * 64];		// BGWX^{ύXtO($10000)
		BOOL bgall[2][64];				// BGύXtO(ubNP)
		BOOL bgdisp[2];					// BG\tO
		BOOL bgarea[2];					// BG\GA
		BOOL bgsize;					// BG\TCY(16dot=TRUE)
		DWORD **bgptr[2];				// BG|C^+f[^
		BOOL bgmod[2][1024];			// BGXVtO
		DWORD bgx[2];					// BGXN[(X)
		DWORD bgy[2];					// BGXN[(Y)

		// BG/XvCg
		BOOL bgspflag;					// BG/XvCg\tO
		BOOL bgspdisp;					// BG/XvCgCPU/VideotO
		BOOL bgspmod[512];				// BG/XvCgXVtO
		DWORD *bgspbuf;					// BG/XvCgobt@
		DWORD zero;						// XN[_~[(0)
	} render_t;

public:
	// {t@NV
	Render(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// OAPI(Rg[)
	void FASTCALL EnableAct(BOOL enable){ render.enable = enable; }
										// 
	BOOL FASTCALL IsActive() const		{ return render.act; }
										// ANeBu
	BOOL FASTCALL IsReady() const		{ return (BOOL)(render.count > 0); }
										// `惌fB󋵎擾
	void FASTCALL Complete()			{ render.count = 0; }
										// `抮
	void FASTCALL StartFrame();
										// t[Jn(V-DISP)
	void FASTCALL EndFrame();
										// t[I(V-BLANK)
	void FASTCALL HSync(int raster)		{ render.last = raster; if (render.act) Process(); }
										// (raster܂ŏI)
	void FASTCALL SetMixBuf(DWORD *buf, int width, int height);
										// obt@w
	render_t* FASTCALL GetWorkAddr() 	{ return &render; }
										// [NAhX擾

	// OAPI()
	void FASTCALL SetCRTC();
										// CRTCZbg
	void FASTCALL SetVC();
										// VCZbg
	void FASTCALL SetContrast(int cont);
										// RgXgݒ
	int FASTCALL GetContrast() const;
										// RgXg擾
	void FASTCALL SetPalette(int index);
										// pbgݒ
	const DWORD* FASTCALL GetPalette() const;
										// pbgobt@擾
	void FASTCALL TextMem(DWORD addr);
										// eLXgVRAMύX
	void FASTCALL TextScrl(DWORD x, DWORD y);
										// eLXgXN[ύX
	void FASTCALL TextCopy(DWORD src, DWORD dst, DWORD plane);
										// X^Rs[
	void FASTCALL GrpMem(DWORD addr, DWORD block);
										// OtBbNVRAMύX
	void FASTCALL GrpAll(DWORD line, DWORD block);
										// OtBbNVRAMύX
	void FASTCALL GrpScrl(int block, DWORD x, DWORD y);
										// OtBbNXN[ύX
	void FASTCALL SpriteReg(DWORD addr, DWORD data);
										// XvCgWX^ύX
	void FASTCALL BGScrl(int page, DWORD x, DWORD y);
										// BGXN[ύX
	void FASTCALL BGCtrl(int index, BOOL flag);
										// BGRg[ύX
	void FASTCALL BGMem(DWORD addr, WORD data);
										// BGύX
	void FASTCALL PCGMem(DWORD addr);
										// PCGύX

	const DWORD* FASTCALL GetTextBuf() const;
										// eLXgobt@擾
	const DWORD* FASTCALL GetGrpBuf(int index) const;
										// OtBbNobt@擾
	const DWORD* FASTCALL GetPCGBuf() const;
										// PCGobt@擾
	const DWORD* FASTCALL GetBGSpBuf() const;
										// BG/XvCgobt@擾
	const DWORD* FASTCALL GetMixBuf() const;
										// obt@擾

private:
	void FASTCALL Process();
										// _O
	void FASTCALL Video();
										// VC
	void FASTCALL SetupGrp(int first);
										// OtBbNZbgAbv
	void FASTCALL Contrast();
										// RgXg
	void FASTCALL Palette();
										// pbg
	void FASTCALL MakePalette();
										// pbg쐬
	DWORD FASTCALL ConvPalette(int color, int ratio);
										// Fϊ
	void FASTCALL Text(int raster);
										// eLXg
	void FASTCALL Grp(int block, int raster);
										// OtBbN
	void FASTCALL SpriteReset();
										// XvCgZbg
	void FASTCALL BGSprite(int raster);
										// BG/XvCg
	void FASTCALL BG(int page, int raster, DWORD *buf);
										// BG
	void FASTCALL BGBlock(int page, int y);
										// BG(ubN)
	void FASTCALL Mix(int offset);
										// 
	void FASTCALL MixGrp(int y, DWORD *buf);
										// (OtBbN)
	CRTC *crtc;
										// CRTC
	VC *vc;
										// VC
	Sprite *sprite;
										// XvCg
	render_t render;
										// f[^
	BOOL cmov;
										// CMOVLbV
};

#endif	// render_h
