//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001,2002 ohD(ytanaka@ipc-tokai.or.jp)
//	[ _(CC) ]
//
//---------------------------------------------------------------------------

#if !defined(renderin_h)
#define renderin_h

#include "render.h"

//---------------------------------------------------------------------------
//
//	pbgݒ
//
//---------------------------------------------------------------------------
inline void FASTCALL Render::SetPalette(int index)
{
	// VC̎_Ŕr`FbNs
	render.palmod[index] = TRUE;
	render.palette = TRUE;
}

//---------------------------------------------------------------------------
//
//	eLXgVRAMύX
//
//---------------------------------------------------------------------------
inline void FASTCALL Render::TextMem(DWORD addr)
{
	// eLXgVRAM̎_Ŕr`FbNs
	addr &= 0x1ffff;
	addr >>= 2;
	render.textflag[addr] = TRUE;
	addr >>= 5;
	render.textmod[addr] = TRUE;
}

//---------------------------------------------------------------------------
//
//	OtBbNVRAMύX
//
//---------------------------------------------------------------------------
inline void FASTCALL Render::GrpMem(DWORD addr, DWORD block)
{
	// OtBbNVRAM̎_Ŕr`FbNs
	ASSERT(addr <= 0x7ffff);
	ASSERT(block <= 3);

	// 16dottO(16dotPʁA(512/16)5124 = 0x10000)
	addr >>= 5;
	block <<= 14;
	render.grpflag[addr | block] = TRUE;
	// CtO(CPʁA512x4 = 2048)
	addr >>= 5;
	block >>= 5;
	render.grpmod[addr | block] = TRUE;
}

//---------------------------------------------------------------------------
//
//	OtBbNVRAMύX(S)
//
//---------------------------------------------------------------------------
inline void FASTCALL Render::GrpAll(DWORD line, DWORD block)
{
	ASSERT(line <= 0x1ff);
	ASSERT(block <= 3);

	render.grppal[(block << 9) | line] = TRUE;
}

#endif	// renderin_h
