//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ RTC(RP5C15) ]
//
//---------------------------------------------------------------------------

#if !defined(rtc_h)
#define rtc_h

#include "device.h"
#include "event.h"

//===========================================================================
//
//	RTC
//
//===========================================================================
class RTC : public MemDevice
{
public:
	typedef struct {
		DWORD sec;						// b
		DWORD min;						// 
		DWORD hour;						// 
		DWORD week;						// T̗j
		DWORD day;						// 
		DWORD month;					// 
		DWORD year;						// N
		BOOL carry;						// bL[

		BOOL timer_en;					// ^C}[싖
		BOOL alarm_en;					// A[싖
		DWORD bank;						// oNԍ
		DWORD test;						// TESTWX^
		BOOL alarm_1hz;					// 1HzpXo͐
		BOOL alarm_16hz;				// 16HzpXo͐
		BOOL under_reset;				// bA_[Zbg
		BOOL alarm_reset;				// A[Zbg

		DWORD clkout;					// CLKOUTWX^
		BOOL adjust;					// AWXg

		DWORD alarm_min;				// 
		DWORD alarm_hour;				// 
		DWORD alarm_week;				// T̗j
		DWORD alarm_day;				// 

		BOOL fullhour;					// 24ԃtO
		DWORD leap;						// [NJE^

		BOOL signal_1hz;				// 1HzVOi(500msɕω)
		BOOL signal_16hz;				// 16HzVOi(31.25msɕω)
		DWORD signal_count;				// 16HzJE^(0`15)
		DWORD signal_blink;				// _ŃVOi(781.25msɕω)
		BOOL alarm;						// A[M
		BOOL alarmout;					// ALARM OUT
	} rtc_t;

public:
	// {t@NV
	RTC(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL GetRTC(rtc_t *buffer);
										// f[^擾
	BOOL FASTCALL Callback(Event *ev);
										// CxgR[obN
	BOOL FASTCALL GetTimerLED() const;
										// ^C}[LED擾
	BOOL FASTCALL GetAlarmOut() const;
										// ALARMM擾
	BOOL FASTCALL GetBlink(int drive) const;
										// FDDp_ŐM擾
	void FASTCALL Adjust(BOOL alarm);
										// ݎݒ

private:
	void FASTCALL AlarmOut();
										// ALARMMo
	void FASTCALL SecUp();
										// bAbv
	void FASTCALL MinUp();
										// Abv
	void FASTCALL AlarmCheck();
										// A[`FbN
	MFP *mfp;
										// MFP
	rtc_t rtc;
										// f[^
	Event event;
										// Cxg
	static const DWORD DayTable[];
										// te[u
};

#endif	// rtc_h
