//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ SASI ]
//
//---------------------------------------------------------------------------

#if !defined(sasi_h)
#define sasi_h

#include "device.h"
#include "event.h"
#include "disk.h"

//===========================================================================
//
//	SASI
//
//===========================================================================
class SASI : public MemDevice
{
public:
	// ő吔
	enum {
		SASIMax = 16,					// őSASIfBXN(LUN܂)
		SCSIMax = 6						// őSCSIn[hfBXN
	};

	// tF[Y`
	enum phase_t {
		busfree,						// oXt[tF[Y
		selection,						// ZNVtF[Y
		command,						// R}htF[Y
		execute,						// stF[Y
		read,							// ǂݍ݃tF[Y
		write,							// ݃tF[Y
		status,							// Xe[^XtF[Y
		message							// bZ[WtF[Y
	};

	// f[^`
	typedef struct {
		// SASIRg[
		phase_t phase;					// tF[Y
		BOOL sel;						// SelectM
		BOOL msg;						// MessageM
		BOOL cd;						// Command/DataM
		BOOL io;						// Input/OutputM
		BOOL bsy;						// BusyM
		BOOL req;						// RequestM
		DWORD ctrl;						// ZNgꂽRg[
		DWORD cmd[10];					// R}hf[^
		DWORD status;					// Xe[^Xf[^
		DWORD message;					// bZ[Wf[^
		BYTE buffer[0x800];				// ]obt@
		DWORD blocks;					// ]ubN
		DWORD next;						// ̃R[h
		DWORD offset;					// ]ItZbg
		DWORD length;					// ]c蒷

		// fBXN
		Disk *disk[SASIMax];			// fBXN
		Disk *current;					// fBXN(Jg)
		SCSIMO *mo;						// fBXN(MO)

		// RtBO
		int sasi_drives;				// hCu(SASI)
		BOOL memsw;						// XCb`XV
		BOOL parity;					// peBt
		int sxsi_drives;				// hCu(SxSI)
		BOOL mo_first;					// MODtO(SxSI)
		int scsi_type;					// SCSI^Cv

		// MOp[^
		BOOL writep;					// MO݋֎~tO
	} sasi_t;

public:
	// {t@NV
	SASI(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// MOANZX
	BOOL FASTCALL Open(const Filepath& path);
										// MO I[v
	void FASTCALL Eject(BOOL force);
										// MO CWFNg
	void FASTCALL WriteP(BOOL writep);
										// MO ݋֎~
	BOOL FASTCALL IsWriteP() const;
										// MO ݋֎~`FbN
	BOOL FASTCALL IsReadOnly() const;
										// MO ReadOnly`FbN
	BOOL FASTCALL IsLocked() const;
										// MO Lock`FbN
	BOOL FASTCALL IsReady() const;
										// MO Ready`FbN
	BOOL FASTCALL IsValid() const;
										// MO L`FbN
	void FASTCALL GetPath(Filepath &path) const;
										// MO pX擾

	// OAPI
	void FASTCALL GetSASI(sasi_t *buffer) const;
										// f[^擾
	BOOL FASTCALL Callback(Event *ev);
										// CxgR[obN
	void FASTCALL Construct();
										// fBXNč\z
	BOOL FASTCALL IsBusy() const;
										// HD BUSY擾
	DWORD FASTCALL GetBusyDevice() const;
										// BUSYfoCX擾

private:
	DWORD FASTCALL ReadData();
										// f[^ǂݏo
	void FASTCALL WriteData(DWORD data);
										// f[^

	// tF[Y
	void FASTCALL BusFree();
										// oXt[tF[Y
	void FASTCALL Selection(DWORD data);
										// ZNVtF[Y
	void FASTCALL Command();
										// R}htF[Y
	void FASTCALL Execute();
										// stF[Y
	void FASTCALL Status();
										// Xe[^XtF[Y
	void FASTCALL Message();
										// bZ[WtF[Y
	void FASTCALL Error();
										// ʃG[

	// R}h
	void FASTCALL TestUnitReady();
										// TEST UNIT READYR}h
	void FASTCALL Rezero();
										// REZERO UNITR}h
	void FASTCALL RequestSense();
										// REQUEST SENSER}h
	void FASTCALL Format();
										// FORMATR}h
	void FASTCALL Reassign();
										// REASSIGN BLOCKSR}h
	void FASTCALL Read6();
										// READ(6)R}h
	void FASTCALL Write6();
										// WRITE(6)R}h
	void FASTCALL Seek6();
										// SEEK(6)R}h
	void FASTCALL Assign();
										// ASSIGNR}h
	void FASTCALL Inquiry();
										// INQUIRYR}h
	void FASTCALL ModeSense();
										// MODE SENSER}h
	void FASTCALL StartStop();
										// START STOP UNITR}h
	void FASTCALL Removal();
										// PREVENT/ALLOW MEDIUM REMOVALR}h
	void FASTCALL ReadCapacity();
										// READ CAPACITYR}h
	void FASTCALL Read10();
										// READ(10)R}h
	void FASTCALL Write10();
										// WRITE(10)R}h
	void FASTCALL Seek10();
										// SEEK(10)R}h
	void FASTCALL Verify();
										// VERIFYR}h
	void FASTCALL Specify();
										// SPECIFYR}h

	// [NGA
	sasi_t sasi;
										// f[^
	Event event;
										// Cxg
	Filepath sasihd[SASIMax];
										// SASI-HDt@CpX
	Filepath scsihd[SCSIMax];
										// SCSI-HDt@CpX
	Filepath scsimo;
										// SCSI-MOt@CpX
	DMAC *dmac;
										// DMAC
	IOSC *iosc;
										// IOSC
	SRAM *sram;
										// SRAM
	SCSI *scsi;
										// SCSI
	BOOL sxsicpu;
										// SxSI CPU]tO
	BOOL cache_wb;
										// LbV[h
};

#endif	// sasi_h
