//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2003 ohD(ytanaka@ipc-tokai.or.jp)
//	[ SCC(Z8530) ]
//
//---------------------------------------------------------------------------

#if !defined(scc_h)
#define scc_h

#include "device.h"
#include "event.h"

//===========================================================================
//
//	SCC
//
//===========================================================================
class SCC : public MemDevice
{
public:
	// 荞݃^Cv
	enum itype_t {
		rxi,							// M荞
		rsi,							// XyVRxRfBV荞
		txi,							// M荞
		exti							// OXe[^Xω荞
	};

	// `l`
	typedef struct {
		// O[o
		DWORD index;					// `lԍ(0 or 1)

		// RR0
		BOOL ba;						// Break/Abort
		BOOL tu;						// TxA_[
		BOOL cts;						// CTS
		BOOL sync;						// SYNC
		BOOL dcd;						// DCD
		BOOL zc;						// [JEg

		// WR0
		DWORD reg;						// ANZXWX^I
		BOOL ph;						// |CgnC(ʃWX^I)
		BOOL txpend;					// M荞݃yfBO
		BOOL rxno;						// Mf[^Ȃ

		// RR1
		BOOL framing;					// t[~OG[
		BOOL overrun;					// I[o[G[
		BOOL parerr;					// peBG[
		BOOL txsent;					// M

		// WR1
		BOOL extie;						// OXe[^X荞݋
		BOOL txie;						// M荞݋
		BOOL parsp;						// peBG[S-Rx荞݂ɂ
		DWORD rxim;						// M荞݃[h

		// RR3
		BOOL rxip;						// M荞݃yfBO
		BOOL rsip;						// XyVRx荞݃yfBO
		BOOL txip;						// M荞݃yfBO
		BOOL extip;						// OXe[^Xω荞݃yfBO

		// WR3
		DWORD rxbit;					// MLN^rbg(5-8)
		BOOL aen;						// I[g[hCl[u
		BOOL rxen;						// MCl[u

		// WR4
		DWORD clkm;						// NbN[h
		DWORD stopbit;					// Xgbvrbg
		DWORD parity;					// peB[h

		// WR5
		BOOL dtr;						// DTRM
		DWORD txbit;					// MLN^rbg(5-8)
		BOOL brk;						// u[No
		BOOL txen;						// MCl[u
		BOOL rts;						// RTSM

		// WR8
		DWORD tdr;						// Mf[^WX^
		BOOL tdf;						// Mf[^L

		// WR12, WR13
		DWORD tc;						// {[[gݒl

		// WR14
		BOOL loopback;					// [vobN[h
		BOOL aecho;						// I[gGR[[h
		BOOL dtrreq;					// DTRML
		BOOL brgsrc;					// {[[gWFl[^NbN
		BOOL brgen;						// {[[gWFl[^Cl[u

		// WR15
		BOOL baie;						// Break/Abort荞݃Cl[u
		BOOL tuie;						// TxA_[荞݃Cl[u
		BOOL ctsie;						// CTS荞݃Cl[u
		BOOL syncie;					// SYNC荞݃Cl[u
		BOOL dcdie;						// DCD荞݃Cl[u
		BOOL zcie;						// [JEg荞݃Cl[u

		// ʐMx
		DWORD baudrate;					// {[[g
		DWORD cps;						// LN^/sec
		DWORD speed;					// x(husP)

		// MFIFO
		DWORD rxfifo;					// MFIFOL
		DWORD rxdata[3];				// MFIFOf[^

		// Mobt@
		BYTE rxbuf[0x1000];				// Mf[^
		DWORD rxnum;					// Mf[^
		DWORD rxread;					// Mǂݍ݃|C^
		DWORD rxwrite;					// M݃|C^
		DWORD rxtotal;					// Mg[^

		// Mobt@
		BYTE txbuf[0x1000];				// Mf[^
		DWORD txnum;					// Mf[^
		DWORD txread;					// Mǂݍ݃|C^
		DWORD txwrite;					// M݃|C^
		DWORD txtotal;					// Txg[^
		BOOL txwait;					// TxEFCgtO
	} ch_t;

	// f[^`
	typedef struct {
		// `l
		ch_t ch[2];						// `lf[^

		// RR2
		DWORD request;					// 荞݃xN^(v)

		// WR2
		DWORD vbase;					// 荞݃xN^(x[X)

		// WR9
		BOOL shsl;						// xN^ω[hb4-b6/b3-b1
		BOOL mie;						// 荞݃Cl[u
		BOOL dlc;						// ʃ`F[֎~
		BOOL nv;						// 荞݃xN^o̓Cl[u
		BOOL vis;						// 荞݃xN^ω[h

		int ireq;						// v̊荞݃^Cv
		int vector;						// ṽxN^
	} scc_t;

public:
	// {t@NV
	SCC(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL GetSCC(scc_t *buffer) const;
										// f[^擾
	const SCC::scc_t* FASTCALL GetWork() const;
										// [N擾 
	DWORD FASTCALL GetVector(int type) const;
										// xN^擾
	BOOL FASTCALL Callback(Event *ev);
										// CxgR[obN
	void FASTCALL IntAck();
										// 荞݉

	// MAPI(SCC֑M)
	void FASTCALL Send(int channel, DWORD data);
										// f[^M
	void FASTCALL ParityErr(int channel);
										// peBG[̐
	void FASTCALL FramingErr(int channel);
										// t[~OG[̐
	void FASTCALL SetBreak(int channel, BOOL flag);
										// u[NԂ̒ʒm
	BOOL FASTCALL IsRxEnable(int channel) const;
										// M`FbN
	BOOL FASTCALL IsBaudRate(int channel, DWORD baudrate) const;
										// {[[g`FbN
	DWORD FASTCALL GetRxBit(int channel) const;
										// Mf[^rbg擾
	DWORD FASTCALL GetStopBit(int channel) const;
										// Xgbvrbg擾
	DWORD FASTCALL GetParity(int channel) const;
										// peB擾
	BOOL FASTCALL IsRxBufEmpty(int channel) const;
										// Mobt@̋󂫃`FbN

	// MAPI(SCCM)
	DWORD FASTCALL Receive(int channel);
										// f[^M
	BOOL FASTCALL IsTxEmpty(int channel);
										// Mobt@GveB`FbN
	BOOL FASTCALL IsTxFull(int channel);
										// Mobt@t`FbN
	void FASTCALL WaitTx(int channel, BOOL wait);
										// MubN

	// n[ht[
	void FASTCALL SetCTS(int channel, BOOL flag);
										// CTSZbg
	void FASTCALL SetDCD(int channel, BOOL flag);
										// DCDZbg
	BOOL FASTCALL GetRTS(int channel);
										// RTS擾
	BOOL FASTCALL GetDTR(int channel);
										// DTR擾
	BOOL FASTCALL GetBreak(int channel);
										// u[N擾

private:
	void FASTCALL ResetCh(ch_t *p);
										// `lZbg
	DWORD FASTCALL ReadSCC(ch_t *p, DWORD reg);
										// `lǂݏo
	DWORD FASTCALL ReadRR0(const ch_t *p) const;
										// RR0ǂݏo
	DWORD FASTCALL ReadRR1(const ch_t *p) const;
										// RR1ǂݏo
	DWORD FASTCALL ReadRR2(ch_t *p);
										// RR2ǂݏo
	DWORD FASTCALL ReadRR3(const ch_t *p) const;
										// RR3ǂݏo
	DWORD FASTCALL ReadRR8(ch_t *p);
										// RR8ǂݏo
	DWORD FASTCALL ReadRR15(const ch_t *p) const;
										// RR15ǂݏo
	DWORD FASTCALL ROSCC(const ch_t *p, DWORD reg) const;
										// ǂݏô
	void FASTCALL WriteSCC(ch_t *p, DWORD reg, DWORD data);
										// `l
	void FASTCALL WriteWR0(ch_t *p, DWORD data);
										// WR0
	void FASTCALL WriteWR1(ch_t *p, DWORD data);
										// WR1
	void FASTCALL WriteWR3(ch_t *p, DWORD data);
										// WR3
	void FASTCALL WriteWR4(ch_t *p, DWORD data);
										// WR4
	void FASTCALL WriteWR5(ch_t *p, DWORD data);
										// WR5
	void FASTCALL WriteWR8(ch_t *p, DWORD data);
										// WR8
	void FASTCALL WriteWR9(DWORD data);
										// WR9
	void FASTCALL WriteWR10(ch_t *p, DWORD data);
										// WR10
	void FASTCALL WriteWR11(ch_t *p, DWORD data);
										// WR11
	void FASTCALL WriteWR12(ch_t *p, DWORD data);
										// WR12
	void FASTCALL WriteWR13(ch_t *p, DWORD data);
										// WR13
	void FASTCALL WriteWR14(ch_t *p, DWORD data);
										// WR14
	void FASTCALL WriteWR15(ch_t *p, DWORD data);
										// WR15
	void FASTCALL ResetSCC(ch_t *p);
										// Zbg
	void FASTCALL ClockSCC(ch_t *p);
										// {[[gČvZ
	void FASTCALL IntSCC(ch_t *p, itype_t type, BOOL flag);
										// 荞݃NGXg
	void FASTCALL IntCheck();
										// 荞݃`FbN
	void FASTCALL EventRx(ch_t *p);
										// Cxg(M)
	void FASTCALL EventTx(ch_t *p);
										// Cxg(M)
	Mouse *mouse;
										// }EX
	scc_t scc;
										// f[^
	Event event[2];
										// Cxg
	BOOL clkup;
										// 7.5MHz[h
};

#endif	// scc_h
