//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ XPW[ ]
//
//---------------------------------------------------------------------------

#if !defined(scheduler_h)
#define scheduler_h

#include "device.h"
#include "starcpu.h"

//---------------------------------------------------------------------------
//
//	EFCg(Starscreamp)
//
//---------------------------------------------------------------------------
#define SCHEDULER_FASTWAIT
#if defined(SCHEDULER_FASTWAIT)
extern "C" {
extern DWORD s68000iocycle;
										// __io_cycle_counter(Starscream)
}
#endif	// SCHEDULER_FASTWAIT

//===========================================================================
//
//	XPW[
//
//===========================================================================
class Scheduler : public Device
{
public:
	// u[N|Cg`
	typedef struct{
		BOOL use;						// gptO
		DWORD addr;						// AhX
		BOOL enable;					// LtO
		DWORD time;						// ~̎
		DWORD count;					// ~
	} breakpoint_t;

	// XPW[`
	typedef struct {
		// 
		DWORD total;					// g[^s
		DWORD one;						// 1̎s
		DWORD sound;					// TEhXV

		// CPU
		int clock;						// CPUNbN(0`5)
		DWORD speed;					// CPUx(clockɂ茈܂)
		int cycle;						// CPUTCN
		DWORD time;						// CPUTCNp

		// u[N|Cg
		BOOL brk;						// u[N
		BOOL check;						// Lȃu[N|Cg

		// Cxg
		Event *first;					// ŏ̃Cxg
		BOOL exec;						// Cxgs
	} scheduler_t;

	// `
	enum {
		BreakMax = 8					// u[N|Cg
	};

public:
	// {t@NV
	Scheduler(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp
#if defined(_DEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// _DEBUG

	// OAPI
	void FASTCALL GetScheduler(scheduler_t *buffer) const;
										// f[^擾
	DWORD FASTCALL Exec(DWORD hus);
										// s
	DWORD FASTCALL Trace(DWORD hus);
										// g[X
	void FASTCALL Break()				{ sch.brk = TRUE; }
										// s~
#ifdef SCHEDULER_FASTWAIT
	void FASTCALL Wait(DWORD cycle)		{ sch.cycle += cycle; if (::s68000iocycle != (DWORD)-1) ::s68000iocycle -= cycle; }
										// CPUEFCg(ׂăCC)
#else
	void FASTCALL Wait(DWORD cycle)		{ ::s68000wait(cycle); sch.cycle += cycle; }
										// CPUEFCg
#endif	// SCHEDULER_FASTWAIT

	// ꑀ(DMAC)
	int FASTCALL GetCPUCycle() const	{ return sch.cycle; }
										// EFCg擾
	void FASTCALL SetCPUCycle(int cycle) { sch.cycle = cycle; }
										// EFCgݒ

	// ԏ
	DWORD FASTCALL GetTotalTime() const	{ return (GetPassedTime() + sch.total); }
										// g[^sԂ擾
	DWORD FASTCALL GetOneTime() const	{ return sch.one; }
										// sԂ擾
	DWORD FASTCALL GetPassedTime() const;
										// oߎԂ擾
	DWORD FASTCALL GetCPUSpeed() const	{ return sch.speed; }
										// CPUx擾
	void FASTCALL SetCPUSpeed(DWORD speed);
										// CPUxݒ
	DWORD FASTCALL GetSoundTime() const	{ return sch.sound; }
										// TEhԂ擾
	void FASTCALL SetSoundTime(DWORD hus) { sch.sound = hus; }
										// TEhԂݒ

	// u[N|Cg
	void FASTCALL SetBreak(DWORD addr, BOOL enable = TRUE);
										// u[N|Cgݒ
	void FASTCALL DelBreak(DWORD addr);
										// u[N|Cg폜
	void FASTCALL GetBreak(int index, breakpoint_t *buf) const;
										// u[N|Cg擾
	void FASTCALL EnableBreak(int index, BOOL enable = TRUE);
										// u[N|CgLE
	void FASTCALL ClearBreak(int index);
										// u[N񐔃NA
	void FASTCALL AddrBreak(int index, DWORD addr);
										// u[NAhXύX
	int FASTCALL IsBreak(DWORD addr, BOOL any = FALSE) const;
										// u[NAhX`FbN

	// Cxg
	void FASTCALL AddEvent(Event *event);
										// Cxgǉ
	void FASTCALL DelEvent(Event *event);
										// Cxg폜
	BOOL FASTCALL HasEvent(Event *event) const;
										// CxgL`FbN
	Event* FASTCALL GetFirstEvent()	const { return sch.first; }
										// ŏ̃Cxg擾
	int FASTCALL GetEventNum() const;
										// Cxǧ擾

	// OtO
	BOOL dma_active;
										// DMACI[gNGXgL

private:
	DWORD FASTCALL GetMinRemain(DWORD hus);
										// ŒZ̃Cxg𓾂
	void FASTCALL ExecEvent(DWORD hus);
										// Cxgs
	void FASTCALL OnBreak(DWORD addr);
										// u[N|CgKp

	// f[^
	breakpoint_t breakp[BreakMax];
										// u[N|Cg
	scheduler_t sch;
										// XPW[

	// foCX
	CPU *cpu;
										// CPU
	DMAC *dmac;
										// DMAC

	// e[u
	static const DWORD ClockTable[];
										// NbNe[u
	static int CycleTable[0x1000];
										// (hus)TCN
};

#endif	// scheduler_h
