//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ SCSI(MB89352) ]
//
//---------------------------------------------------------------------------

#if !defined(scsi_h)
#define scsi_h

#include "device.h"
#include "event.h"
#include "disk.h"

//===========================================================================
//
//	SCSI
//
//===========================================================================
class SCSI : public MemDevice
{
public:
	// ő吔
	enum {
		DeviceMax = 8,					// őSCSIfoCX
		HDMax = 5						// őSCSI HD
	};

	// tF[Y`
	enum phase_t {
		busfree,						// oXt[tF[Y
		arbitration,					// A[rg[VtF[Y
		selection,						// ZNVtF[Y
		reselection,					// ZNVtF[Y
		command,						// R}htF[Y
		execute,						// stF[Y
		msgin,							// bZ[WCtF[Y
		msgout,							// bZ[WAEgtF[Y
		datain,							// f[^CtF[Y
		dataout,						// f[^AEgtF[Y
		status							// Xe[^XtF[Y
	};

	// f[^`
	typedef struct {
		// S
		int type;						// SCSI^Cv(0:Ȃ 1:Ot 2:)
		phase_t phase;					// tF[Y
		int id;							// JgID(0-7)

		// 荞
		int vector;						// vxN^(-1ŗvȂ)
		int ilevel;						// 荞݃x

		// M
		BOOL bsy;						// BusyM
		BOOL sel;						// SelectM
		BOOL atn;						// AttentionM
		BOOL msg;						// MessageM
		BOOL cd;						// Command/DataM
		BOOL io;						// Input/OutputM
		BOOL req;						// RequestM
		BOOL ack;						// AckM
		BOOL rst;						// ResetM

		// WX^
		DWORD bdid;						// BDIDWX^(rbg\)
		DWORD sctl;						// SCTLWX^
		DWORD scmd;						// SCMDWX^
		DWORD ints;						// INTSWX^
		DWORD sdgc;						// SDGCWX^
		DWORD pctl;						// PCTLWX^
		DWORD mbc;						// MBCWX^
		DWORD temp;						// TEMPWX^
		DWORD tc;						// TCH,TCM,TCLWX^

		// R}h
		DWORD cmd[10];					// R}hf[^
		DWORD status;					// Xe[^Xf[^
		DWORD message;					// bZ[Wf[^

		// ]
		BOOL trans;						// ]tO
		BYTE buffer[0x800];				// ]obt@
		DWORD blocks;					// ]ubN
		DWORD next;						// ̃R[h
		DWORD offset;					// ]ItZbg
		DWORD length;					// ]c蒷

		// RtBO
		int scsi_drives;				// SCSIhCu
		BOOL memsw;						// XCb`XV
		BOOL mo_first;					// MODtO(SxSI)

		// fBXN
		Disk *disk[DeviceMax];			// foCX
		Disk *hd[HDMax];				// HD
		SCSIMO *mo;						// MO
		SCSICD *cdrom;					// CD-ROM
	} scsi_t;

public:
	// {t@NV
	SCSI(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp
#if !defined(NDEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// NDEBUG

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL GetSCSI(scsi_t *buffer) const;
										// f[^擾
	BOOL FASTCALL Callback(Event *ev);
										// CxgR[obN
	void FASTCALL IntAck(int level);
										// 荞ACK
	int FASTCALL GetSCSIID() const;
										// SCSI-ID擾
	BOOL FASTCALL IsBusy() const;
										// BUSY
	DWORD FASTCALL GetBusyDevice() const;
										// BUSYfoCX擾

	// MO/CDANZX
	BOOL FASTCALL Open(const Filepath& path, BOOL mo = TRUE);
										// MO/CD I[v
	void FASTCALL Eject(BOOL force, BOOL mo = TRUE);
										// MO/CD CWFNg
	void FASTCALL WriteP(BOOL writep);
										// MO ݋֎~
	BOOL FASTCALL IsWriteP() const;
										// MO ݋֎~`FbN
	BOOL FASTCALL IsReadOnly() const;
										// MO ReadOnly`FbN
	BOOL FASTCALL IsLocked(BOOL mo = TRUE) const;
										// MO/CD Lock`FbN
	BOOL FASTCALL IsReady(BOOL mo = TRUE) const;
										// MO/CD Ready`FbN
	BOOL FASTCALL IsValid(BOOL mo = TRUE) const;
										// MO/CD L`FbN
	void FASTCALL GetPath(Filepath &path, BOOL mo = TRUE) const;
										// MO/CD pX擾

	// CD-DA
	void FASTCALL GetBuf(DWORD *buffer, int samples, DWORD rate);
										// CD-DAobt@擾

private:
	// WX^
	void FASTCALL ResetReg();
										// WX^Zbg
	void FASTCALL ResetCtrl();
										// ]Zbg
	void FASTCALL ResetBus(BOOL reset);
										// oXZbg
	void FASTCALL SetBDID(DWORD data);
										// BDIDݒ
	void FASTCALL SetSCTL(DWORD data);
										// SCTLݒ
	void FASTCALL SetSCMD(DWORD data);
										// SCMDݒ
	void FASTCALL SetINTS(DWORD data);
										// INTSݒ
	DWORD FASTCALL GetPSNS() const;
										// PSNS擾
	void FASTCALL SetSDGC(DWORD data);
										// SDGCݒ
	DWORD FASTCALL GetSSTS() const;
										// SSTS擾
	DWORD FASTCALL GetSERR() const;
										// SERR擾
	void FASTCALL SetPCTL(DWORD data);
										// PCTLݒ
	DWORD FASTCALL GetDREG();
										// DREG擾
	void FASTCALL SetDREG(DWORD data);
										// DREGݒ
	void FASTCALL SetTEMP(DWORD data);
										// TEMPݒ
	void FASTCALL SetTCH(DWORD data);
										// TCHݒ
	void FASTCALL SetTCM(DWORD data);
										// TCMݒ
	void FASTCALL SetTCL(DWORD data);
										// TCLݒ

	// SPCR}h
	void FASTCALL BusRelease();
										// oX[X
	void FASTCALL Select();
										// ZNV/ZNV
	void FASTCALL ResetATN();
										// ATNC=0
	void FASTCALL SetATN();
										// ATNC=1
	void FASTCALL Transfer();
										// ]
	void FASTCALL TransPause();
										// ]f
	void FASTCALL TransComplete();
										// ]
	void FASTCALL ResetACKREQ();
										// ACK/REQC=0
	void FASTCALL SetACKREQ();
										// ACK/REQC=1

	// f[^]
	void FASTCALL Xfer(DWORD *reg);
										// f[^]
	void FASTCALL XferNext();
										// f[^]p
	BOOL FASTCALL XferIn();
										// f[^]IN
	BOOL FASTCALL XferOut(BOOL cont);
										// f[^]OUT
	BOOL FASTCALL XferMsg(DWORD msg);
										// f[^]MSG

	// tF[Y
	void FASTCALL BusFree();
										// oXt[tF[Y
	void FASTCALL Arbitration();
										// A[rg[VtF[Y
	void FASTCALL Selection();
										// ZNVtF[Y
	void FASTCALL SelectTime();
										// ZNVtF[Y(Ԑݒ)
	void FASTCALL Command();
										// R}htF[Y
	void FASTCALL Execute();
										// stF[Y
	void FASTCALL MsgIn();
										// bZ[WCtF[Y
	void FASTCALL MsgOut();
										// bZ[WAEgtF[Y
	void FASTCALL DataIn();
										// f[^CtF[Y
	void FASTCALL DataOut();
										// f[^AEgtF[Y
	void FASTCALL Status();
										// Xe[^XtF[Y

	// 荞
	void FASTCALL Interrupt(int type, BOOL flag);
										// 荞ݗv
	void FASTCALL IntCheck();
										// 荞݃`FbN

	// SCSIR}h
	void FASTCALL Error();
										// ʃG[

	// SCSIR}h
	void FASTCALL TestUnitReady();
										// TEST UNIT READYR}h
	void FASTCALL Rezero();
										// REZERO UNITR}h
	void FASTCALL RequestSense();
										// REQUEST SENSER}h
	void FASTCALL Format();
										// FORMAT UNITR}h
	void FASTCALL Reassign();
										// REASSIGN BLOCKSR}h
	void FASTCALL Read6();
										// READ(6)R}h
	void FASTCALL Write6();
										// WRITE(6)R}h
	void FASTCALL Seek6();
										// SEEK(6)R}h
	void FASTCALL Inquiry();
										// INQUIRYR}h
	void FASTCALL ModeSelect();
										// MODE SELECTR}h
	void FASTCALL ModeSense();
										// MODE SENSER}h
	void FASTCALL StartStop();
										// START STOP UNITR}h
	void FASTCALL SendDiag();
										// SEND DIAGNOSTICR}h
	void FASTCALL Removal();
										// PREVENT/ALLOW MEDIUM REMOVALR}h
	void FASTCALL ReadCapacity();
										// READ CAPACITYR}h
	void FASTCALL Read10();
										// READ(10)R}h
	void FASTCALL Write10();
										// WRITE(10)R}h
	void FASTCALL Seek10();
										// SEEK(10)R}h
	void FASTCALL Verify();
										// VERIFYR}h
	void FASTCALL ReadToc();
										// READ TOCR}h
	void FASTCALL PlayAudio10();
										// PLAY AUDIO(10)R}h
	void FASTCALL PlayAudioMSF();
										// PLAY AUDIO MSFR}h
	void FASTCALL PlayAudioTrack();
										// PLAY AUDIO TRACK INDEXR}h

	// CD-ROMECD-DA
	Event cdda;
										// t[Cxg

	// hCuEt@CpX
	void FASTCALL Construct();
										// hCu\z
	Filepath scsihd[DeviceMax];
										// SCSI-HDt@CpX

	// ̑
	scsi_t scsi;
										// f[^
	BYTE verifybuf[0x800];
										// xt@Cobt@
	Event event;
										// Cxg
	BOOL cache_wb;
										// LbV[h
	Memory *memory;
										// 
	SRAM *sram;
										// SRAM
};

#endif	// scsi_h
