//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2004 ohD(ytanaka@ipc-tokai.or.jp)
//	[ XvCg(CYNTHIA) ]
//
//---------------------------------------------------------------------------

#if !defined(sprite_h)
#define sprite_h

#include "device.h"

//===========================================================================
//
//	XvCg
//
//===========================================================================
class Sprite : public MemDevice
{
public:
	// f[^`
	typedef struct {
		BOOL connect;					// ANZX\tO
		BOOL disp;						// \(EFCg)tO
		BYTE *mem;						// XvCg
		BYTE *pcg;						// XvCgPCGGA

		BOOL bg_on[2];					// BG\ON
		DWORD bg_area[2];				// BGf[^GA
		DWORD bg_scrlx[2];				// BGXN[X
		DWORD bg_scrly[2];				// BGXN[Y
		BOOL bg_size;					// BGTCY

		DWORD h_total;					// g[^
		DWORD h_disp;					// \
		DWORD v_disp;					// \
		BOOL lowres;					// 15kHz[h
		DWORD h_res;					// 𑜓x
		DWORD v_res;					// 𑜓x
	} sprite_t;

public:
	// {t@NV
	Sprite(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL Connect(BOOL con)		{ spr.connect = con; }
										// ڑ
	BOOL FASTCALL IsConnect() const		{ return spr.connect; }
										// ڑ󋵎擾
	BOOL FASTCALL IsDisplay() const		{ return spr.disp; }
										// \󋵎擾
	void FASTCALL GetSprite(sprite_t *buffer) const;
										// f[^擾
	const BYTE* FASTCALL GetMem() const;
										// GA擾
	const BYTE* FASTCALL GetPCG() const;
										// PCGGA擾 

private:
	void FASTCALL Control(DWORD addr, DWORD ctrl);
										// Rg[
	sprite_t spr;
										// f[^
	Render *render;
										// _
	BYTE *sprite;
										// XvCgRAM(64KB)
};

#endif	// sprite_h
