//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ X^eBbNRAM ]
//
//---------------------------------------------------------------------------

#if !defined(sram_h)
#define sram_h

#include "device.h"
#include "filepath.h"

//===========================================================================
//
//	X^eBbNRAM
//
//===========================================================================
class SRAM : public MemDevice
{
public:
	// {t@NV
	SRAM(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp
#if !defined(NDEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// NDEBUG

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	const BYTE* FASTCALL GetSRAM() const;
										// SRAMGA擾
	int FASTCALL GetSize() const;
										// SRAMTCY擾
	void FASTCALL WriteEnable(BOOL enable);
										// ݋
	void FASTCALL SetMemSw(DWORD offset, DWORD data);
										// XCb`Zbg
	DWORD FASTCALL GetMemSw(DWORD offset) const;
										// XCb`擾
	void FASTCALL UpdateBoot();
										// NJE^XV

private:
	Filepath sram_path;
										// SRAMt@CpX
	int sram_size;
										// SRAMTCY(16,32,48,64)
	BYTE sram[0x10000];
										// SRAM (64KB)
	BOOL write_en;
										// ݋tO
	BOOL mem_sync;
										// CRAMTCYtO
	BOOL changed;
										// ύXtO
};

#endif	// sram_h
