//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2004 ohD(ytanaka@ipc-tokai.or.jp)
//	[ IuWFNg ]
//
//---------------------------------------------------------------------------

#include "os.h"
#include "xm6.h"
#include "sync.h"

#if defined(_WIN32)

//===========================================================================
//
//	IuWFNg
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
Sync::Sync()
{
	// NeBJZNV쐬
	csect = new CCriticalSection;
}

//---------------------------------------------------------------------------
//
//	fXgN^
//
//---------------------------------------------------------------------------
Sync::~Sync()
{
	// bN
	Lock();

	// NeBJZNV폜
	ASSERT(csect);
	delete csect;
	csect = NULL;
}

//---------------------------------------------------------------------------
//
//	bN
//
//---------------------------------------------------------------------------
void FASTCALL Sync::Lock()
{
	ASSERT(csect);

	csect->Lock();
}

//---------------------------------------------------------------------------
//
//	AbN
//
//---------------------------------------------------------------------------
void FASTCALL Sync::Unlock()
{
	ASSERT(csect);

	csect->Unlock();
}

#endif	// _WIN32
