//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ VXe|[g ]
//
//---------------------------------------------------------------------------

#if !defined(sysport_h)
#define sysport_h

#include "device.h"

//===========================================================================
//
//	VXe|[g
//
//===========================================================================
class SysPort : public MemDevice
{
public:
	// f[^`
	typedef struct {
		DWORD contrast;					// RgXg
		DWORD scope_3d;					// 3DXR[v
		DWORD image_unit;				// C[Wjbg
		DWORD power_count;				// dJE^
		DWORD ver_count;				// o[WǗJE^
	} sysport_t;

public:
	// {t@NV
	SysPort(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp
#if !defined(NDEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// NDEBUG

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

private:
	DWORD FASTCALL GetVR();
										// o[WWX^ǂݏo
	sysport_t sysport;
										// [N
	Memory *memory;
										// 
	SRAM *sram;
										// X^eBbNRAM
	Keyboard *keyboard;
										// L[{[h
	CRTC *crtc;
										// CRTC
	Render *render;
										// _
};

#endif	// sysport_h
